/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.viewmodel;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModel;
import com.google.android.gms.tasks.Task;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.text.Text;
import com.google.mlkit.vision.text.TextRecognizer;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Objects;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nashid.verify.sdk.data.repository.IdCardRepository;
import nashid.verify.sdk.data.repository.PassportRepository;
import nashid.verify.sdk.ui.NfcActivity;
import nashid.verify.sdk.ui.SkipNfcLiveNessActivity;
import nashid.verify.sdk.utils.ArtifactType;
import nashid.verify.sdk.utils.SdkConfig;
import nashid.verify.sdk.utils.Utility;
import nashid.verify.sdk.utils.helpers.DocumentImages;
import nashid.verify.sdk.utils.helpers.FaceDetectionUtil;
import nashid.verify.sdk.viewmodel.CameraXLiveData;
import nashid.verify.sdk.viewmodel.CameraXLiveViewModel;
import nashid.verify.sdk.viewmodel.ScanDocumentViewModel;
import nashid.verify.sdkNew.R;
import okhttp3.MultipartBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u00014B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0006\u0010\u001e\u001a\u00020\u0019J\b\u0010\u001f\u001a\u00020\u0019H\u0002J\b\u0010 \u001a\u00020\u0019H\u0014J\b\u0010!\u001a\u00020\u0019H\u0002J\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0010\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020#H\u0002J\u000e\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)J\u0016\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020-J\u001a\u0010.\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010/\u001a\u000200H\u0002J\u001a\u00101\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010/\u001a\u000200H\u0002J\u0012\u00102\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0012\u00103\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lnashid/verify/sdk/viewmodel/CameraXLiveViewModel;", "Landroidx/lifecycle/ViewModel;", "cameraXLiveData", "Lnashid/verify/sdk/viewmodel/CameraXLiveData;", "textRecognizer", "Lcom/google/mlkit/vision/text/TextRecognizer;", "app", "Landroid/app/Application;", "idCardRepository", "Lnashid/verify/sdk/data/repository/IdCardRepository;", "passportRepository", "Lnashid/verify/sdk/data/repository/PassportRepository;", "scanDocumentViewModel", "Lnashid/verify/sdk/viewmodel/ScanDocumentViewModel;", "(Lnashid/verify/sdk/viewmodel/CameraXLiveData;Lcom/google/mlkit/vision/text/TextRecognizer;Landroid/app/Application;Lnashid/verify/sdk/data/repository/IdCardRepository;Lnashid/verify/sdk/data/repository/PassportRepository;Lnashid/verify/sdk/viewmodel/ScanDocumentViewModel;)V", "cameraProviderLiveData", "Landroidx/lifecycle/MutableLiveData;", "Landroidx/camera/lifecycle/ProcessCameraProvider;", "getCameraXLiveData", "()Lnashid/verify/sdk/viewmodel/CameraXLiveData;", "processCameraProvider", "Landroidx/lifecycle/LiveData;", "getProcessCameraProvider", "()Landroidx/lifecycle/LiveData;", "detectAndCropFace", "", "bitmap", "Landroid/graphics/Bitmap;", "listener", "Lnashid/verify/sdk/viewmodel/CameraXLiveViewModel$OnImageProcessedListener;", "handleAnimationCompleted", "observeScanDocumentViewModel", "onCleared", "openLiveNessScreen", "printCurrentTimeInLogs", "", "processTextFromBitmap", "readTextFromString", "text", "scannedIdFrontViewCompleted", "byteArray", "", "setSelectedDoc", "selectedDoc", "resources", "Landroid/content/res/Resources;", "uploadArtifact", "artifactType", "Lnashid/verify/sdk/utils/ArtifactType;", "uploadArtifactForIdCard", "uploadArtifactForPassport", "uploadFaceArtifact", "OnImageProcessedListener", "VerifySDK_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCameraXLiveViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraXLiveViewModel.kt\nnashid/verify/sdk/viewmodel/CameraXLiveViewModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,264:1\n731#2,9:265\n37#3,2:274\n*S KotlinDebug\n*F\n+ 1 CameraXLiveViewModel.kt\nnashid/verify/sdk/viewmodel/CameraXLiveViewModel\n*L\n87#1:265,9\n87#1:274,2\n*E\n"})
public final class CameraXLiveViewModel
extends ViewModel {
    @NotNull
    private final CameraXLiveData cameraXLiveData;
    @NotNull
    private final TextRecognizer textRecognizer;
    @NotNull
    private final Application app;
    @NotNull
    private final IdCardRepository idCardRepository;
    @NotNull
    private final PassportRepository passportRepository;
    @NotNull
    private final ScanDocumentViewModel scanDocumentViewModel;
    @Nullable
    private MutableLiveData<ProcessCameraProvider> cameraProviderLiveData;
    public static final int $stable = 8;

    public CameraXLiveViewModel(@NotNull CameraXLiveData cameraXLiveData, @NotNull TextRecognizer textRecognizer, @NotNull Application app, @NotNull IdCardRepository idCardRepository, @NotNull PassportRepository passportRepository, @NotNull ScanDocumentViewModel scanDocumentViewModel) {
        Intrinsics.checkNotNullParameter((Object)cameraXLiveData, (String)"cameraXLiveData");
        Intrinsics.checkNotNullParameter((Object)textRecognizer, (String)"textRecognizer");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)idCardRepository, (String)"idCardRepository");
        Intrinsics.checkNotNullParameter((Object)passportRepository, (String)"passportRepository");
        Intrinsics.checkNotNullParameter((Object)((Object)scanDocumentViewModel), (String)"scanDocumentViewModel");
        this.cameraXLiveData = cameraXLiveData;
        this.textRecognizer = textRecognizer;
        this.app = app;
        this.idCardRepository = idCardRepository;
        this.passportRepository = passportRepository;
        this.scanDocumentViewModel = scanDocumentViewModel;
        this.observeScanDocumentViewModel();
    }

    @NotNull
    public final CameraXLiveData getCameraXLiveData() {
        return this.cameraXLiveData;
    }

    private final void observeScanDocumentViewModel() {
        Function1 function1 = observeScanDocumentViewModel.1.INSTANCE;
        this.scanDocumentViewModel.getResult().observeForever(new Observer(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void onChanged(Object value) {
                this.function.invoke(value);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof Observer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
    }

    public final void setSelectedDoc(@NotNull String selectedDoc, @NotNull Resources resources) {
        Intrinsics.checkNotNullParameter((Object)selectedDoc, (String)"selectedDoc");
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        this.cameraXLiveData.setSelectedDoc(selectedDoc);
        if (StringsKt.equals((String)selectedDoc, (String)resources.getString(R.string.e_passport), (boolean)true)) {
            String string2 = resources.getString(R.string.scan_passport_top_text);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            this.cameraXLiveData.setStatusText(string2);
            String string3 = resources.getString(R.string.scan_passport_bottom);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
            this.cameraXLiveData.setBottomText(string3);
        } else {
            String string4 = resources.getString(R.string.scan_id_top_text);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
            this.cameraXLiveData.setStatusText(string4);
            String string5 = resources.getString(R.string.scan_id_bottom);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getString(...)");
            this.cameraXLiveData.setBottomText(string5);
        }
    }

    public final void processTextFromBitmap(@Nullable Bitmap bitmap) {
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkNotNull((Object)bitmap2);
        this.textRecognizer.process(InputImage.fromBitmap((Bitmap)bitmap2, (int)0)).addOnSuccessListener(arg_0 -> CameraXLiveViewModel.processTextFromBitmap$lambda$0((Function1)new Function1<Text, Unit>(this){
            final /* synthetic */ CameraXLiveViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Text textResult) {
                Intrinsics.checkNotNullParameter((Object)textResult, (String)"textResult");
                List list = textResult.getTextBlocks();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTextBlocks(...)");
                List blocks = list;
                CameraXLiveViewModel.access$getPassportRepository$p(this.this$0).readPassportData(blocks);
                String string2 = textResult.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                String text = string2;
                CameraXLiveViewModel.access$readTextFromString(this.this$0, text);
            }
        }, arg_0)).addOnFailureListener(arg_0 -> CameraXLiveViewModel.processTextFromBitmap$lambda$1(this, arg_0)).addOnCompleteListener(arg_0 -> CameraXLiveViewModel.processTextFromBitmap$lambda$2(this, arg_0));
    }

    private final void readTextFromString(String text) {
        try {
            List list;
            CharSequence charSequence = text;
            Regex regex = new Regex("\n");
            int n = 0;
            List $this$dropLastWhile$iv = regex.split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] textAll = thisCollection$iv.toArray(new String[0]);
            if (StringsKt.equals((String)((String)Objects.requireNonNull(this.cameraXLiveData.getSelectedDoc().getValue())), (String)this.app.getString(R.string.e_passport), (boolean)true)) {
                this.passportRepository.readAllDetailOfPassport();
            } else if (Intrinsics.areEqual((Object)this.cameraXLiveData.getIsFrontView().getValue(), (Object)false)) {
                this.idCardRepository.readIdCardFrontView(text);
            } else {
                this.idCardRepository.readIdCardBackView(textAll);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.cameraXLiveData.setIsSuccess(false);
        }
    }

    @NotNull
    public final String printCurrentTimeInLogs() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        String currentTime = sdf.format(new Date());
        Intrinsics.checkNotNull((Object)currentTime);
        return currentTime;
    }

    public final void handleAnimationCompleted() {
        this.cameraXLiveData.setCTimer(true);
        Utility.Companion.getInstance().setSelectedDoc((String)this.cameraXLiveData.getSelectedDoc().getValue());
        byte[] byArray = Utility.Companion.getInstance().getScannedImage();
        Bitmap fullBitmap = BitmapFactory.decodeByteArray((byte[])Utility.Companion.getInstance().getScannedImage(), (int)0, (int)(byArray != null ? byArray.length : 0));
        if (StringsKt.equals((String)Utility.Companion.getInstance().getSelectedDoc(), (String)this.app.getResources().getString(R.string.e_passport), (boolean)true)) {
            this.uploadArtifactForPassport(fullBitmap);
        } else {
            byte[] byArray2 = Utility.Companion.getInstance().getScannedIdFrontView();
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])Utility.Companion.getInstance().getScannedIdFrontView(), (int)0, (int)(byArray2 != null ? byArray2.length : 0));
            this.uploadArtifactForIdCard(bitmap, ArtifactType.BACKSIDE_IMAGE);
        }
        if (fullBitmap != null) {
            this.detectAndCropFace(fullBitmap, new OnImageProcessedListener(this){
                final /* synthetic */ CameraXLiveViewModel this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onImageProcessed(@Nullable Bitmap croppedBitmap) {
                    DocumentImages.Companion.getInstance().setScanPhoto(croppedBitmap);
                    CameraXLiveViewModel.access$uploadFaceArtifact(this.this$0, croppedBitmap);
                    if (SdkConfig.INSTANCE.isNfcScanningEnabled()) {
                        Intent intent = new Intent((Context)CameraXLiveViewModel.access$getApp$p(this.this$0), NfcActivity.class);
                        intent.putExtra(CameraXLiveViewModel.access$getApp$p(this.this$0).getResources().getString(R.string.doc_key), (String)this.this$0.getCameraXLiveData().getSelectedDoc().getValue());
                        intent.setFlags(335577088);
                        CameraXLiveViewModel.access$getApp$p(this.this$0).startActivity(intent);
                    } else {
                        CameraXLiveViewModel.access$openLiveNessScreen(this.this$0);
                    }
                }
            });
        }
    }

    private final void openLiveNessScreen() {
        this.cameraXLiveData.setUnbindCameraProvider(true);
        Utility.Companion.getInstance().setSelectedDoc((String)this.cameraXLiveData.getSelectedDoc().getValue());
        Intent intent = new Intent((Context)this.app, SkipNfcLiveNessActivity.class);
        intent.putExtra(this.app.getResources().getString(R.string.doc_key), (String)this.cameraXLiveData.getSelectedDoc().getValue());
        intent.setFlags(0x10008000);
        this.app.startActivity(intent);
    }

    private final void detectAndCropFace(Bitmap bitmap, OnImageProcessedListener listener) {
        Bitmap failureBitmap = BitmapFactory.decodeResource((Resources)this.app.getResources(), (int)R.drawable.face_not_found);
        Bitmap detectedIdFace = FaceDetectionUtil.Companion.cropFaceFromIDCard(bitmap);
        if (detectedIdFace != null) {
            OnImageProcessedListener onImageProcessedListener = listener;
            if (onImageProcessedListener != null) {
                onImageProcessedListener.onImageProcessed(detectedIdFace);
            }
        } else {
            OnImageProcessedListener onImageProcessedListener = listener;
            if (onImageProcessedListener != null) {
                onImageProcessedListener.onImageProcessed(failureBitmap);
            }
            Log.d((String)"FaceDetector", (String)"No faces detected");
        }
    }

    @NotNull
    public final LiveData<ProcessCameraProvider> getProcessCameraProvider() {
        if (this.cameraProviderLiveData == null) {
            this.cameraProviderLiveData = new MutableLiveData();
            ListenableFuture cameraProviderFuture = ProcessCameraProvider.Companion.getInstance((Context)this.app);
            cameraProviderFuture.addListener(() -> CameraXLiveViewModel._get_processCameraProvider_$lambda$4(this, cameraProviderFuture), ContextCompat.getMainExecutor((Context)((Context)this.app)));
        }
        MutableLiveData<ProcessCameraProvider> mutableLiveData = this.cameraProviderLiveData;
        Intrinsics.checkNotNull(mutableLiveData);
        return (LiveData)mutableLiveData;
    }

    private final void uploadFaceArtifact(Bitmap bitmap) {
        block0: {
            Bitmap bitmap2 = bitmap;
            if (bitmap2 == null) break block0;
            Bitmap it = bitmap2;
            boolean bl = false;
            this.uploadArtifact(it, ArtifactType.OCR_FACE_IMAGE);
        }
    }

    private final void uploadArtifact(Bitmap bitmap, ArtifactType artifactType) {
        Utility utility = Utility.Companion.getInstance();
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkNotNull((Object)bitmap2);
        File file = utility.bitmapToFile(bitmap2, (Context)this.app);
        MultipartBody.Part filePart = Utility.Companion.getInstance().createMultipartBody(file);
        String string2 = SdkConfig.INSTANCE.getRegisterToken();
        Intrinsics.checkNotNull((Object)string2);
        this.scanDocumentViewModel.uploadArtifact(string2, Utility.Companion.getInstance().getAppKey(), filePart, artifactType.getType());
    }

    private final void uploadArtifactForIdCard(Bitmap bitmap, ArtifactType artifactType) {
        block0: {
            Bitmap bitmap2 = bitmap;
            if (bitmap2 == null) break block0;
            Bitmap it = bitmap2;
            boolean bl = false;
            this.uploadArtifact(it, artifactType);
        }
    }

    private final void uploadArtifactForPassport(Bitmap bitmap) {
        block0: {
            Bitmap bitmap2 = bitmap;
            if (bitmap2 == null) break block0;
            Bitmap it = bitmap2;
            boolean bl = false;
            this.uploadArtifact(it, ArtifactType.FRONTSIDE_IMAGE);
        }
    }

    public final void scannedIdFrontViewCompleted(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        Bitmap fullBitmap = BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length);
        this.uploadArtifactForIdCard(fullBitmap, ArtifactType.FRONTSIDE_IMAGE);
    }

    protected void onCleared() {
        super.onCleared();
        this.cameraXLiveData.resetState();
    }

    private static final void processTextFromBitmap$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void processTextFromBitmap$lambda$1(CameraXLiveViewModel this$0, Exception it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.cameraXLiveData.setIsSuccess(false);
    }

    private static final void processTextFromBitmap$lambda$2(CameraXLiveViewModel this$0, Task it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (Intrinsics.areEqual((Object)this$0.cameraXLiveData.getIsSuccess().getValue(), (Object)false)) {
            this$0.cameraXLiveData.setCloseImageProxy(true);
        }
    }

    private static final void _get_processCameraProvider_$lambda$4(CameraXLiveViewModel this$0, ListenableFuture $cameraProviderFuture) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$cameraProviderFuture, (String)"$cameraProviderFuture");
        try {
            MutableLiveData<ProcessCameraProvider> mutableLiveData = this$0.cameraProviderLiveData;
            Intrinsics.checkNotNull(mutableLiveData);
            mutableLiveData.setValue($cameraProviderFuture.get());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static final /* synthetic */ PassportRepository access$getPassportRepository$p(CameraXLiveViewModel $this) {
        return $this.passportRepository;
    }

    public static final /* synthetic */ void access$readTextFromString(CameraXLiveViewModel $this, String text) {
        $this.readTextFromString(text);
    }

    public static final /* synthetic */ void access$uploadFaceArtifact(CameraXLiveViewModel $this, Bitmap bitmap) {
        $this.uploadFaceArtifact(bitmap);
    }

    public static final /* synthetic */ Application access$getApp$p(CameraXLiveViewModel $this) {
        return $this.app;
    }

    public static final /* synthetic */ void access$openLiveNessScreen(CameraXLiveViewModel $this) {
        $this.openLiveNessScreen();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lnashid/verify/sdk/viewmodel/CameraXLiveViewModel$OnImageProcessedListener;", "", "onImageProcessed", "", "croppedBitmap", "Landroid/graphics/Bitmap;", "VerifySDK_release"})
    public static interface OnImageProcessedListener {
        public void onImageProcessed(@Nullable Bitmap var1);
    }
}

