/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.viewmodel;

import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModel;
import java.io.File;
import java.util.Objects;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nashid.verify.sdk.VerifySDKManager;
import nashid.verify.sdk.data.repository.SkipLiveNessRepository;
import nashid.verify.sdk.model.Artifacts;
import nashid.verify.sdk.model.DocumentVerification;
import nashid.verify.sdk.model.MainData;
import nashid.verify.sdk.model.VerificationMetadata;
import nashid.verify.sdk.utils.ArtifactType;
import nashid.verify.sdk.utils.OtherConstant;
import nashid.verify.sdk.utils.SdkConfig;
import nashid.verify.sdk.utils.Utility;
import nashid.verify.sdk.utils.helpers.ScanDocumentResult;
import nashid.verify.sdk.viewmodel.ScanDocumentViewModel;
import nashid.verify.sdk.viewmodel.SkipNfcLiveNessLiveData;
import nashid.verify.sdkNew.R;
import okhttp3.MultipartBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000b\u001a\u00020\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\rH\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u001e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000fJ\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\u0018\u0010\u0019\u001a\u00020\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lnashid/verify/sdk/viewmodel/SkipNfcLiveNessViewModel;", "Landroidx/lifecycle/ViewModel;", "skipNfcLiveNessLiveData", "Lnashid/verify/sdk/viewmodel/SkipNfcLiveNessLiveData;", "skipLiveNessRepository", "Lnashid/verify/sdk/data/repository/SkipLiveNessRepository;", "context", "Landroid/app/Application;", "scanDocumentViewModel", "Lnashid/verify/sdk/viewmodel/ScanDocumentViewModel;", "(Lnashid/verify/sdk/viewmodel/SkipNfcLiveNessLiveData;Lnashid/verify/sdk/data/repository/SkipLiveNessRepository;Landroid/app/Application;Lnashid/verify/sdk/viewmodel/ScanDocumentViewModel;)V", "getLiveNessData", "handleInternetConnectionData", "", "isInternetAvailable", "", "observeScanDocumentViewModel", "prepareResultData", "Lnashid/verify/sdk/model/DocumentVerification;", "latitude", "", "longitude", "isShowStartScanning", "submitVerification", "verification", "uploadArtifact", "bitmap", "Landroid/graphics/Bitmap;", "artifactType", "Lnashid/verify/sdk/utils/ArtifactType;", "validateJustCompletion", "VerifySDK_release"})
@StabilityInferred(parameters=0)
public final class SkipNfcLiveNessViewModel
extends ViewModel {
    @NotNull
    private final SkipNfcLiveNessLiveData skipNfcLiveNessLiveData;
    @NotNull
    private final SkipLiveNessRepository skipLiveNessRepository;
    @NotNull
    private final Application context;
    @NotNull
    private final ScanDocumentViewModel scanDocumentViewModel;
    public static final int $stable = 8;

    public SkipNfcLiveNessViewModel(@NotNull SkipNfcLiveNessLiveData skipNfcLiveNessLiveData, @NotNull SkipLiveNessRepository skipLiveNessRepository, @NotNull Application context, @NotNull ScanDocumentViewModel scanDocumentViewModel) {
        Intrinsics.checkNotNullParameter((Object)skipNfcLiveNessLiveData, (String)"skipNfcLiveNessLiveData");
        Intrinsics.checkNotNullParameter((Object)skipLiveNessRepository, (String)"skipLiveNessRepository");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)scanDocumentViewModel), (String)"scanDocumentViewModel");
        this.skipNfcLiveNessLiveData = skipNfcLiveNessLiveData;
        this.skipLiveNessRepository = skipLiveNessRepository;
        this.context = context;
        this.scanDocumentViewModel = scanDocumentViewModel;
        this.observeScanDocumentViewModel();
    }

    private final void observeScanDocumentViewModel() {
        Function1 function1 = (Function1)new Function1<ScanDocumentResult, Unit>(this){
            final /* synthetic */ SkipNfcLiveNessViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(ScanDocumentResult result2) {
                if (result2 instanceof ScanDocumentResult.FileKeyResult) {
                    Utility.Companion.getInstance().saveFileKeyAndContinue(((ScanDocumentResult.FileKeyResult)result2).getFileKey(), ((ScanDocumentResult.FileKeyResult)result2).getArtifactType());
                    if (Intrinsics.areEqual((Object)((ScanDocumentResult.FileKeyResult)result2).getArtifactType(), (Object)ArtifactType.LIVENESS_IMAGE.getType())) {
                        SkipNfcLiveNessViewModel.access$getSkipLiveNessRepository$p(this.this$0).callToComparison();
                    }
                }
                if (result2 instanceof ScanDocumentResult.Error) {
                    SkipNfcLiveNessViewModel.access$getSkipLiveNessRepository$p(this.this$0).callToComparison();
                }
            }
        };
        this.scanDocumentViewModel.getResult().observeForever(new Observer(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void onChanged(Object value) {
                this.function.invoke(value);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof Observer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
    }

    public final void handleInternetConnectionData(boolean isInternetAvailable) {
        this.skipNfcLiveNessLiveData.setInternetConnection(isInternetAvailable);
        if (!isInternetAvailable) {
            this.skipNfcLiveNessLiveData.setInternetConnection(false);
        } else {
            this.skipNfcLiveNessLiveData.setIsApiCalled(true);
            if (!SdkConfig.INSTANCE.isFaceMatchingEnabled()) {
                this.skipLiveNessRepository.callToComparison();
            } else {
                this.skipNfcLiveNessLiveData.setIsLiveness(true);
            }
        }
    }

    @NotNull
    public final SkipNfcLiveNessLiveData getLiveNessData() {
        return this.skipNfcLiveNessLiveData;
    }

    public final void uploadArtifact(@Nullable Bitmap bitmap, @NotNull ArtifactType artifactType) {
        Intrinsics.checkNotNullParameter((Object)((Object)artifactType), (String)"artifactType");
        Utility utility = Utility.Companion.getInstance();
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkNotNull((Object)bitmap2);
        File file = utility.bitmapToFile(bitmap2, (Context)this.context);
        MultipartBody.Part filePart = Utility.Companion.getInstance().createMultipartBody(file);
        String string2 = SdkConfig.INSTANCE.getRegisterToken();
        Intrinsics.checkNotNull((Object)string2);
        this.scanDocumentViewModel.uploadArtifact(string2, Utility.Companion.getInstance().getAppKey(), filePart, artifactType.getType());
    }

    private final void submitVerification(DocumentVerification verification) {
        VerifySDKManager.Companion.getInstance().submitVerification(verification);
    }

    public final void validateJustCompletion() {
        this.skipLiveNessRepository.callToComparison();
    }

    public final void submitVerification(double latitude, double longitude, boolean isShowStartScanning) {
        DocumentVerification documentVerification = this.prepareResultData(latitude, longitude, isShowStartScanning);
        this.submitVerification(documentVerification);
    }

    private final DocumentVerification prepareResultData(double latitude, double longitude, boolean isShowStartScanning) {
        boolean isFlowCompleted = true;
        if (isShowStartScanning) {
            this.skipNfcLiveNessLiveData.setIsLiveness(false);
            isFlowCompleted = false;
        }
        int documentType = StringsKt.equals((String)((String)Objects.requireNonNull(this.skipNfcLiveNessLiveData.getSelectedDoc().getValue())), (String)this.context.getString(R.string.e_passport), (boolean)true) ? 2 : 1;
        boolean isNFCEnabled = SdkConfig.INSTANCE.isNfcScanningEnabled() && !OtherConstant.Companion.getInstance().getSkipNFC();
        MainData data = this.skipLiveNessRepository.createData(isNFCEnabled, documentType, (Boolean)this.skipNfcLiveNessLiveData.getIsLiveness().getValue());
        VerificationMetadata metaData = this.skipLiveNessRepository.createMetaData(latitude, longitude);
        Artifacts artifacts = this.skipLiveNessRepository.handleArtifacts();
        return new DocumentVerification(metaData, documentType, data, artifacts, isFlowCompleted ? 1 : 2);
    }

    public static final /* synthetic */ SkipLiveNessRepository access$getSkipLiveNessRepository$p(SkipNfcLiveNessViewModel $this) {
        return $this.skipLiveNessRepository;
    }
}

