package nashid.verify.sdk.utils

import android.content.Context
import android.graphics.Bitmap
import android.os.Build
import android.view.View
import nashid.verify.sdk.utils.Constants.APP_KEY_PRODUCTION
import nashid.verify.sdk.utils.Constants.APP_KEY_STAGING
import nashid.verify.sdkNew.BuildConfig
import okhttp3.MediaType.Companion.toMediaTypeOrNull
import okhttp3.MultipartBody
import okhttp3.RequestBody.Companion.asRequestBody
import java.io.File
import java.net.InetAddress
import java.net.NetworkInterface
import java.text.SimpleDateFormat
import java.util.Calendar
import java.util.Collections
import java.util.Date
import java.util.Locale

internal class Utility private constructor() {
    var name: String? = null
    var passportNumber: String? = null
    var dateOfBirth: String? = null
    var expiryDate: String? = null
    var fullName: String? = null
    var gender: String = ""
    var nationality: String? = null
    var country: String? = null
    var documentType: String? = null
    var scannedImage: ByteArray? = null
    var scannedIdFrontView: ByteArray? = null

    var mrzLine1: String? = null
    var mrzLine2: String? = null
    var mrzLine3: String? = null

    var dgFile1: ByteArray? = null
    var dgFile2: ByteArray? = null
    var dgFile4: ByteArray? = null
    var dgFile6: ByteArray? = null
    var dgFile10: ByteArray? = null
    var dgFile11: ByteArray? = null
    var dgFile13: ByteArray? = null
    var livenessScannedImage: ByteArray? = null
    var nfcScannedImage: ByteArray? = null
    var matchPercentage: Int = 0
    var dateOfExpiration: String? = null
    var selectedDoc: String? = null
    var liveImage: ByteArray? = null

    private val artifactFileKeys:
        MutableMap<ArtifactType, String> = mutableMapOf()
    private val artifacts =
        listOf(
            ArtifactType.FRONTSIDE_IMAGE,
            ArtifactType.BACKSIDE_IMAGE,
            ArtifactType.OCR_FACE_IMAGE,
            ArtifactType.NFC_IMAGE,
            ArtifactType.LIVENESS_IMAGE,
            ArtifactType.LIVENESS_IMAGE_WITHOUT_BG,
        )

    fun cleanup() {
        name = null
        passportNumber = null
        dateOfBirth = null
        expiryDate = null
        fullName = null
        gender = ""
        nationality = null
        country = null
        scannedImage = null
        scannedIdFrontView = null
        documentType = null
        dgFile1 = null
        dgFile2 = null
        dgFile4 = null
        dgFile6 = null
        dgFile10 = null
        dgFile11 = null
        dgFile13 = null
        livenessScannedImage = null
        nfcScannedImage = null
        matchPercentage = 0
        dateOfExpiration = null
        selectedDoc = null
        liveImage = null
    }

    fun setVisibility(
        view1: View?,
        view2: View?,
        isVisible: Boolean,
    ) {
        val visibility = if (isVisible) View.VISIBLE else View.GONE
        view1?.visibility = visibility
        view2?.visibility = visibility
    }

    fun bitmapToFile(
        bitmap: Bitmap,
        context: Context,
    ): File {
        val file = File(context.cacheDir, "upload_image_${System.currentTimeMillis()}.jpg")
        file.outputStream().use { outputStream ->
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, outputStream)
            outputStream.flush()
        }
        return file
    }

    fun createMultipartBody(file: File): MultipartBody.Part {
        val requestFile = file.asRequestBody("multipart/form-data".toMediaTypeOrNull())
        return MultipartBody.Part.createFormData("file", file.name, requestFile)
    }

    fun getAppKey(): String {
        return if (BuildConfig.BUILD_TYPE.equals("release", ignoreCase = true)) APP_KEY_PRODUCTION else APP_KEY_STAGING
    }

    fun getCurrentFormattedDateTime(): String? {
        val calendar = Calendar.getInstance()
        val date = calendar.time
        val sdf = SimpleDateFormat("yyyy-mm-dd hh:mm:ss", Locale.ENGLISH)
        return sdf.format(date)
    }

    fun getDeviceIdentifier(): String {
        return "${Build.BRAND}_${Build.MODEL}"
    }

    fun getDeviceType(): String {
        return Build.MODEL
    }

    fun getSystemVersion(): String {
        return Build.VERSION.RELEASE
    }

    fun getSystemName(): String {
        return "Android"
    }

    fun getDeviceIPAddresses(): Pair<String?, String?> {
        var ipv4: String? = null
        var ipv6: String? = null

        try {
            val interfaces = Collections.list(NetworkInterface.getNetworkInterfaces())
            for (networkInterface in interfaces) {
                val addresses = Collections.list(networkInterface.inetAddresses)
                for (address in addresses) {
                    if (!address.isLoopbackAddress) {
                        val hostAddress = address.hostAddress
                        if (address is InetAddress) {
                            if (hostAddress != null) {
                                if (hostAddress.indexOf(':') < 0) {
                                    ipv4 = hostAddress
                                } else {
                                    ipv6 = hostAddress
                                }
                            }
                        }
                    }
                }
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }

        return Pair(ipv4, ipv6)
    }

    fun getFormattedDate(dateStr: String): String? {
        val inputFormat = SimpleDateFormat("yyMMdd", Locale.getDefault())
        val date: Date? = inputFormat.parse(dateStr)
        val outputFormat = SimpleDateFormat("yyyy-MM-dd", Locale.getDefault())
        return date?.let { outputFormat.format(it) }
    }

    fun saveFileKeyAndContinue(
        fileKey: String,
        artifactType: String,
    ) {
        val mappedArtifactType = artifacts.find { it.type == artifactType }
        if (mappedArtifactType != null) {
            artifactFileKeys[mappedArtifactType] = fileKey
        } else {
            println("Invalid artifact type: $artifactType")
        }
    }

    fun getFileKeyForArtifact(artifactType: ArtifactType): String? {
        return artifactFileKeys[artifactType]
    }

    companion object {
        @Volatile
        private var ourInstance: Utility? = null

        fun getInstance(): Utility {
            return ourInstance ?: synchronized(this) {
                ourInstance ?: Utility().also { ourInstance = it }
            }
        }
    }
}
