/*
 * Decompiled with CFR 0.152.
 */
package icc;

import colorspace.ColorSpace;
import colorspace.ColorSpaceException;
import icc.ICCProfileException;
import icc.ICCProfileInvalidException;
import icc.RestrictedICCProfile;
import icc.tags.ICCCurveType;
import icc.tags.ICCTagTable;
import icc.tags.ICCXYZType;
import icc.types.ICCDateTime;
import icc.types.ICCProfileHeader;
import icc.types.ICCProfileVersion;
import icc.types.XYZNumber;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.ParameterList;

public abstract class ICCProfile {
    private static final String eol = System.getProperty("line.separator");
    public static final int GRAY = 0;
    public static final int RED = 0;
    public static final int GREEN = 1;
    public static final int BLUE = 2;
    public static final int boolean_size = 1;
    public static final int byte_size = 1;
    public static final int char_size = 2;
    public static final int short_size = 2;
    public static final int int_size = 4;
    public static final int float_size = 4;
    public static final int long_size = 8;
    public static final int double_size = 8;
    public static final int BITS_PER_BYTE = 8;
    public static final int BITS_PER_SHORT = 16;
    public static final int BITS_PER_INT = 32;
    public static final int BITS_PER_LONG = 64;
    public static final int BYTES_PER_SHORT = 2;
    public static final int BYTES_PER_INT = 4;
    public static final int BYTES_PER_LONG = 8;
    public static final int kdwProfileSignature = ICCProfile.getInt(new String("acsp").getBytes(), 0);
    public static final int kdwProfileSigReverse = ICCProfile.getInt(new String("psca").getBytes(), 0);
    public static final int kdwInputProfile = ICCProfile.getInt(new String("scnr").getBytes(), 0);
    public static final int kdwDisplayProfile = ICCProfile.getInt(new String("mntr").getBytes(), 0);
    public static final int kdwRGBData = ICCProfile.getInt(new String("RGB ").getBytes(), 0);
    public static final int kdwGrayData = ICCProfile.getInt(new String("GRAY").getBytes(), 0);
    public static final int kdwXYZData = ICCProfile.getInt(new String("XYZ ").getBytes(), 0);
    public static final int kMonochromeInput = 0;
    public static final int kThreeCompInput = 1;
    public static final int kdwGrayTRCTag = ICCProfile.getInt(new String("kTRC").getBytes(), 0);
    public static final int kdwRedColorantTag = ICCProfile.getInt(new String("rXYZ").getBytes(), 0);
    public static final int kdwGreenColorantTag = ICCProfile.getInt(new String("gXYZ").getBytes(), 0);
    public static final int kdwBlueColorantTag = ICCProfile.getInt(new String("bXYZ").getBytes(), 0);
    public static final int kdwRedTRCTag = ICCProfile.getInt(new String("rTRC").getBytes(), 0);
    public static final int kdwGreenTRCTag = ICCProfile.getInt(new String("gTRC").getBytes(), 0);
    public static final int kdwBlueTRCTag = ICCProfile.getInt(new String("bTRC").getBytes(), 0);
    public static final int kdwCopyrightTag = ICCProfile.getInt(new String("cprt").getBytes(), 0);
    public static final int kdwMediaWhiteTag = ICCProfile.getInt(new String("wtpt").getBytes(), 0);
    public static final int kdwProfileDescTag = ICCProfile.getInt(new String("desc").getBytes(), 0);
    private ICCProfileHeader header = null;
    private ICCTagTable tags = null;
    private byte[] profile = null;
    private byte[] data = null;
    private ParameterList pl = null;

    public static int getIntFromString(String string) {
        byte[] byArray = string.getBytes();
        return ICCProfile.getInt(byArray, 0);
    }

    public static XYZNumber getXYZNumber(byte[] byArray, int n) {
        int n2 = ICCProfile.getInt(byArray, n);
        int n3 = ICCProfile.getInt(byArray, n + 4);
        int n4 = ICCProfile.getInt(byArray, n + 8);
        return new XYZNumber(n2, n3, n4);
    }

    public static ICCProfileVersion getICCProfileVersion(byte[] byArray, int n) {
        byte by = byArray[n];
        byte by2 = byArray[n + 1];
        byte by3 = byArray[n + 2];
        byte by4 = byArray[n + 3];
        return new ICCProfileVersion(by, by2, by3, by4);
    }

    public static ICCDateTime getICCDateTime(byte[] byArray, int n) {
        short s = ICCProfile.getShort(byArray, n);
        short s2 = ICCProfile.getShort(byArray, n + 2);
        short s3 = ICCProfile.getShort(byArray, n + 4);
        short s4 = ICCProfile.getShort(byArray, n + 6);
        short s5 = ICCProfile.getShort(byArray, n + 8);
        short s6 = ICCProfile.getShort(byArray, n + 10);
        return new ICCDateTime(s, s2, s3, s4, s5, s6);
    }

    public static String getString(byte[] byArray, int n, int n2, boolean bl) {
        byte[] byArray2 = new byte[n2];
        int n3 = bl ? -1 : 1;
        int n4 = bl ? n + n2 - 1 : n;
        int n5 = n4;
        for (int i = 0; i < n2; ++i) {
            byArray2[i] = byArray[n5];
            n5 += n3;
        }
        return new String(byArray2);
    }

    public static short getShort(byte[] byArray, int n, boolean bl) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        return (short)(bl ? n3 << 8 | n2 : n2 << 8 | n3);
    }

    public static short getShort(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        return (short)(n2 << 8 | n3);
    }

    public static byte[] setInt(int n) {
        return ICCProfile.setInt(n, new byte[4]);
    }

    public static byte[] setInt(int n, byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[4];
        }
        for (int i = 0; i < 4; ++i) {
            byArray[i] = (byte)(n & 0xFF);
            n >>= 8;
        }
        return byArray;
    }

    public static byte[] setLong(long l) {
        return ICCProfile.setLong(l, new byte[4]);
    }

    public static byte[] setLong(long l, byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[8];
        }
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return byArray;
    }

    public static int getInt(byte[] byArray, int n, boolean bl) {
        int n2 = ICCProfile.getShort(byArray, n, bl) & 0xFFFF;
        int n3 = ICCProfile.getShort(byArray, n + 2, bl) & 0xFFFF;
        return bl ? n3 << 16 | n2 : n2 << 16 | n3;
    }

    public static int getInt(byte[] byArray, int n) {
        int n2 = ICCProfile.getShort(byArray, n) & 0xFFFF;
        int n3 = ICCProfile.getShort(byArray, n + 2) & 0xFFFF;
        return n2 << 16 | n3;
    }

    public static long getLong(byte[] byArray, int n) {
        long l = ICCProfile.getInt(byArray, n) & 0xFFFFFFFF;
        long l2 = ICCProfile.getInt(byArray, n + 4) & 0xFFFFFFFF;
        return l << 32 | l2;
    }

    private int getProfileSize() {
        return this.header.dwProfileSize;
    }

    private int getCMMTypeSignature() {
        return this.header.dwCMMTypeSignature;
    }

    private int getProfileClass() {
        return this.header.dwProfileClass;
    }

    private int getColorSpaceType() {
        return this.header.dwColorSpaceType;
    }

    private int getPCSType() {
        return this.header.dwPCSType;
    }

    private int getProfileSignature() {
        return this.header.dwProfileSignature;
    }

    private int getPlatformSignature() {
        return this.header.dwPlatformSignature;
    }

    private int getCMMFlags() {
        return this.header.dwCMMFlags;
    }

    private int getDeviceManufacturer() {
        return this.header.dwDeviceManufacturer;
    }

    private int getDeviceModel() {
        return this.header.dwDeviceModel;
    }

    private int getDeviceAttributes1() {
        return this.header.dwDeviceAttributes1;
    }

    private int getDeviceAttributesReserved() {
        return this.header.dwDeviceAttributesReserved;
    }

    private int getRenderingIntent() {
        return this.header.dwRenderingIntent;
    }

    private int getCreatorSig() {
        return this.header.dwCreatorSig;
    }

    private ICCProfileVersion getProfileVersion() {
        return this.header.profileVersion;
    }

    private void setProfileSignature(int n) {
        this.header.dwProfileSignature = n;
    }

    private void setProfileSize(int n) {
        this.header.dwProfileSize = n;
    }

    private void setCMMTypeSignature(int n) {
        this.header.dwCMMTypeSignature = n;
    }

    private void setProfileClass(int n) {
        this.header.dwProfileClass = n;
    }

    private void setColorSpaceType(int n) {
        this.header.dwColorSpaceType = n;
    }

    private void setPCSIlluminant(XYZNumber xYZNumber) {
        this.header.PCSIlluminant = xYZNumber;
    }

    private void setPCSType(int n) {
        this.header.dwPCSType = n;
    }

    private void setPlatformSignature(int n) {
        this.header.dwPlatformSignature = n;
    }

    private void setCMMFlags(int n) {
        this.header.dwCMMFlags = n;
    }

    private void setDeviceManufacturer(int n) {
        this.header.dwDeviceManufacturer = n;
    }

    private void setDeviceModel(int n) {
        this.header.dwDeviceModel = n;
    }

    private void setDeviceAttributes1(int n) {
        this.header.dwDeviceAttributes1 = n;
    }

    private void setDeviceAttributesReserved(int n) {
        this.header.dwDeviceAttributesReserved = n;
    }

    private void setRenderingIntent(int n) {
        this.header.dwRenderingIntent = n;
    }

    private void setCreatorSig(int n) {
        this.header.dwCreatorSig = n;
    }

    private void setProfileVersion(ICCProfileVersion iCCProfileVersion) {
        this.header.profileVersion = iCCProfileVersion;
    }

    private void setDateTime(ICCDateTime iCCDateTime) {
        this.header.dateTime = iCCDateTime;
    }

    private ICCProfile() throws ICCProfileException {
        throw new ICCProfileException("illegal to invoke empty constructor");
    }

    protected ICCProfile(ColorSpace colorSpace) throws ColorSpaceException, ICCProfileInvalidException {
        this.pl = colorSpace.pl;
        this.profile = colorSpace.getICCProfile();
        this.initProfile(this.profile);
    }

    private void initProfile(byte[] byArray) throws ICCProfileInvalidException {
        this.header = new ICCProfileHeader(byArray);
        this.tags = ICCTagTable.createInstance(byArray);
        if (this.getProfileClass() == kdwDisplayProfile) {
            String string = "NOTE!! Technically, this profile is a Display profile, not an Input Profile, and thus is not a valid Restricted ICC profile. However, it is quite possible that this profile is usable as a Restricted ICC profile, so this code will ignore this state and proceed with processing.";
            FacilityManager.getMsgLogger().printmsg(2, string);
        }
        if (this.getProfileSignature() != kdwProfileSignature || this.getProfileClass() != kdwInputProfile && this.getProfileClass() != kdwDisplayProfile || this.getPCSType() != kdwXYZData) {
            throw new ICCProfileInvalidException();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ICCProfile:");
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(eol).append(this.header);
        stringBuffer2.append(eol).append(eol).append(this.tags);
        stringBuffer.append(ColorSpace.indent("  ", stringBuffer2));
        return stringBuffer.append("]").toString();
    }

    public static String toHexString(byte by) {
        String string = (by >= 0 && by < 16 ? "0" : "") + Integer.toHexString(by);
        if (string.length() > 2) {
            string = string.substring(string.length() - 2);
        }
        return string;
    }

    public static String toHexString(short s) {
        String string = s >= 0 && s < 16 ? "000" + Integer.toHexString(s) : (s >= 0 && s < 256 ? "00" + Integer.toHexString(s) : (s >= 0 && s < 4096 ? "0" + Integer.toHexString(s) : "" + Integer.toHexString(s)));
        if (string.length() > 4) {
            string = string.substring(string.length() - 4);
        }
        return string;
    }

    public static String toHexString(int n) {
        String string = n >= 0 && n < 16 ? "0000000" + Integer.toHexString(n) : (n >= 0 && n < 256 ? "000000" + Integer.toHexString(n) : (n >= 0 && n < 4096 ? "00000" + Integer.toHexString(n) : (n >= 0 && n < 65536 ? "0000" + Integer.toHexString(n) : (n >= 0 && n < 0x100000 ? "000" + Integer.toHexString(n) : (n >= 0 && n < 0x1000000 ? "00" + Integer.toHexString(n) : (n >= 0 && n < 0x10000000 ? "0" + Integer.toHexString(n) : "" + Integer.toHexString(n)))))));
        if (string.length() > 8) {
            string = string.substring(string.length() - 8);
        }
        return string;
    }

    public static String toString(byte[] byArray) {
        int n;
        byte by;
        int n2;
        byte[] byArray2;
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = null;
        StringBuffer stringBuffer3 = null;
        StringBuffer stringBuffer4 = null;
        int n4 = 16;
        int n5 = byArray.length / n4;
        int n6 = byArray.length % n4;
        byte[] byArray3 = new byte[8];
        int n7 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            stringBuffer3 = new StringBuffer();
            stringBuffer4 = new StringBuffer();
            for (n7 = 0; n7 < 8; ++n7) {
                byArray3[n7] = 0;
            }
            byArray2 = Integer.toHexString(n3 * 16).getBytes();
            n2 = byArray3.length - byArray2.length;
            for (by = 0; by < byArray2.length; ++by) {
                byArray3[n2] = byArray2[by];
                ++n2;
            }
            stringBuffer2 = new StringBuffer(new String(byArray3));
            for (n = 0; n < n4; ++n) {
                by = byArray[n7++];
                stringBuffer3.append(ICCProfile.toHexString(by)).append(n7 % 2 == 0 ? " " : "");
                if (Character.isJavaIdentifierStart((char)by)) {
                    stringBuffer4.append((char)by);
                    continue;
                }
                stringBuffer4.append(".");
            }
            stringBuffer.append(stringBuffer2).append(" :  ").append(stringBuffer3).append(":  ").append(stringBuffer4).append(eol);
        }
        stringBuffer3 = new StringBuffer();
        stringBuffer4 = new StringBuffer();
        for (n7 = 0; n7 < 8; ++n7) {
            byArray3[n7] = 0;
        }
        byArray2 = Integer.toHexString(n3 * 16).getBytes();
        n2 = byArray3.length - byArray2.length;
        for (by = 0; by < byArray2.length; ++by) {
            byArray3[n2] = byArray2[by];
            ++n2;
        }
        stringBuffer2 = new StringBuffer(new String(byArray3));
        for (n = 0; n < n6; ++n) {
            by = byArray[n7++];
            stringBuffer3.append(ICCProfile.toHexString(by)).append(n7 % 2 == 0 ? " " : "");
            if (Character.isJavaIdentifierStart((char)by)) {
                stringBuffer4.append((char)by);
                continue;
            }
            stringBuffer4.append(".");
        }
        for (n = n6; n < 16; ++n) {
            stringBuffer3.append("  ").append(n % 2 == 0 ? " " : "");
        }
        stringBuffer.append(stringBuffer2).append(" :  ").append(stringBuffer3).append(":  ").append(stringBuffer4).append(eol);
        return stringBuffer.toString();
    }

    public ICCProfileHeader getHeader() {
        return this.header;
    }

    public ICCTagTable getTagTable() {
        return this.tags;
    }

    public RestrictedICCProfile parse() throws ICCProfileInvalidException {
        ICCCurveType iCCCurveType = (ICCCurveType)this.tags.get(new Integer(kdwGrayTRCTag));
        if (iCCCurveType != null) {
            return RestrictedICCProfile.createInstance(iCCCurveType);
        }
        ICCCurveType iCCCurveType2 = (ICCCurveType)this.tags.get(new Integer(kdwRedTRCTag));
        if (iCCCurveType2 != null) {
            ICCCurveType iCCCurveType3 = (ICCCurveType)this.tags.get(new Integer(kdwGreenTRCTag));
            ICCCurveType iCCCurveType4 = (ICCCurveType)this.tags.get(new Integer(kdwBlueTRCTag));
            ICCXYZType iCCXYZType = (ICCXYZType)this.tags.get(new Integer(kdwRedColorantTag));
            ICCXYZType iCCXYZType2 = (ICCXYZType)this.tags.get(new Integer(kdwGreenColorantTag));
            ICCXYZType iCCXYZType3 = (ICCXYZType)this.tags.get(new Integer(kdwBlueColorantTag));
            return RestrictedICCProfile.createInstance(iCCCurveType2, iCCCurveType3, iCCCurveType4, iCCXYZType, iCCXYZType2, iCCXYZType3);
        }
        throw new ICCProfileInvalidException("curve data not found in profile");
    }

    public void write(RandomAccessFile randomAccessFile) throws IOException {
        this.getHeader().write(randomAccessFile);
        this.getTagTable().write(randomAccessFile);
    }

    private static class BoxType
    extends Hashtable {
        private static Hashtable map = new Hashtable();

        private BoxType() {
        }

        public static void put(int n, String string) {
            map.put(new Integer(n), string);
        }

        public static String get(int n) {
            return (String)map.get(new Integer(n));
        }

        public static String colorSpecMethod(int n) {
            switch (n) {
                case 2: {
                    return "Restricted ICC Profile";
                }
                case 1: {
                    return "Enumerated Color Space";
                }
            }
            return "Undefined Color Spec Method";
        }

        static {
            BoxType.put(1651532643, "BITS_PER_COMPONENT_BOX");
            BoxType.put(1919251299, "CAPTURE_RESOLUTION_BOX");
            BoxType.put(1667523942, "CHANNEL_DEFINITION_BOX");
            BoxType.put(1668246642, "COLOUR_SPECIFICATION_BOX");
            BoxType.put(1668112752, "COMPONENT_MAPPING_BOX");
            BoxType.put(1785737827, "CONTIGUOUS_CODESTREAM_BOX");
            BoxType.put(1919251300, "DEFAULT_DISPLAY_RESOLUTION_BOX");
            BoxType.put(1718909296, "FILE_TYPE_BOX");
            BoxType.put(1768449138, "IMAGE_HEADER_BOX");
            BoxType.put(1685074537, "INTELLECTUAL_PROPERTY_BOX");
            BoxType.put(1785737832, "JP2_HEADER_BOX");
            BoxType.put(1783636000, "JP2_SIGNATURE_BOX");
            BoxType.put(1885564018, "PALETTE_BOX");
            BoxType.put(1919251232, "RESOLUTION_BOX");
            BoxType.put(1970433056, "URL_BOX");
            BoxType.put(1970628964, "UUID_BOX");
            BoxType.put(1969843814, "UUID_INFO_BOX");
            BoxType.put(1969451892, "UUID_LIST_BOX");
            BoxType.put(2020437024, "XML_BOX");
        }
    }
}

