/*
 * Decompiled with CFR 0.152.
 */
package icc;

import colorspace.ColorSpace;
import colorspace.ColorSpaceException;
import colorspace.ColorSpaceMapper;
import icc.ICCMatrixBasedInputProfile;
import icc.ICCMonochromeInputProfile;
import icc.ICCProfile;
import icc.ICCProfileException;
import icc.RestrictedICCProfile;
import icc.lut.MatrixBasedTransformException;
import icc.lut.MatrixBasedTransformTosRGB;
import icc.lut.MonochromeTransformException;
import icc.lut.MonochromeTransformTosRGB;
import java.io.IOException;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkFloat;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.util.FacilityManager;

public class ICCProfiler
extends ColorSpaceMapper {
    public static final char OPT_PREFIX = 'I';
    protected static final String eol = System.getProperty("line.separator");
    private static final int GRAY = 0;
    private static final int RED = 0;
    private static final int GREEN = 1;
    private static final int BLUE = 2;
    RestrictedICCProfile ricc = null;
    ICCProfile icc = null;
    private DataBlkInt[] tempInt;
    private DataBlkFloat[] tempFloat;
    private Object xform = null;
    private RestrictedICCProfile iccp = null;

    public static BlkImgDataSrc createInstance(BlkImgDataSrc blkImgDataSrc, ColorSpace colorSpace) throws IOException, ICCProfileException, ColorSpaceException {
        return new ICCProfiler(blkImgDataSrc, colorSpace);
    }

    protected ICCProfiler(BlkImgDataSrc blkImgDataSrc, ColorSpace colorSpace) throws ColorSpaceException, IOException, ICCProfileException, IllegalArgumentException {
        super(blkImgDataSrc, colorSpace);
        this.initialize();
        this.iccp = this.getICCProfile(colorSpace);
        this.xform = this.ncomps == 1 ? new MonochromeTransformTosRGB(this.iccp, this.maxValueArray[0], this.shiftValueArray[0]) : new MatrixBasedTransformTosRGB(this.iccp, this.maxValueArray, this.shiftValueArray);
    }

    private void initialize() {
        this.tempInt = new DataBlkInt[this.ncomps];
        this.tempFloat = new DataBlkFloat[this.ncomps];
        for (int i = 0; i < this.ncomps; ++i) {
            this.tempInt[i] = new DataBlkInt();
            this.tempFloat[i] = new DataBlkFloat();
        }
    }

    private RestrictedICCProfile getICCProfile(ColorSpace colorSpace) throws ColorSpaceException, ICCProfileException, IllegalArgumentException {
        switch (this.ncomps) {
            case 1: {
                this.icc = ICCMonochromeInputProfile.createInstance(colorSpace);
                this.ricc = this.icc.parse();
                if (this.ricc.getType() == 0) break;
                throw new IllegalArgumentException("wrong ICCProfile type for image");
            }
            case 3: {
                this.icc = ICCMatrixBasedInputProfile.createInstance(colorSpace);
                this.ricc = this.icc.parse();
                if (this.ricc.getType() == 1) break;
                throw new IllegalArgumentException("wrong ICCProfile type for image");
            }
            default: {
                throw new IllegalArgumentException("illegal number of components (" + this.ncomps + ") in image");
            }
        }
        return this.ricc;
    }

    public DataBlk getCompData(DataBlk dataBlk, int n) {
        try {
            if (this.ncomps != 1 && this.ncomps != 3) {
                String string = "ICCProfiler: icc profile _not_ applied to " + this.ncomps + " component image";
                FacilityManager.getMsgLogger().printmsg(2, string);
                return this.src.getCompData(dataBlk, n);
            }
            int n2 = dataBlk.getDataType();
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            block11: for (int i = 0; i < this.ncomps; ++i) {
                int n7 = this.src.getFixedPoint(i);
                int n8 = this.shiftValueArray[i];
                int n9 = this.maxValueArray[i];
                int n10 = -1;
                int n11 = -1;
                switch (n2) {
                    case 3: {
                        int n12;
                        ICCProfiler.copyGeometry(this.workInt[i], dataBlk);
                        ICCProfiler.copyGeometry(this.tempInt[i], dataBlk);
                        ICCProfiler.copyGeometry(this.inInt[i], dataBlk);
                        ICCProfiler.setInternalBuffer(dataBlk);
                        this.workDataInt[i] = (int[])this.workInt[i].getData();
                        this.inInt[i] = (DataBlkInt)this.src.getInternCompData(this.inInt[i], i);
                        this.dataInt[i] = this.inInt[i].getDataInt();
                        for (n12 = 0; n12 < dataBlk.h; ++n12) {
                            n5 = this.inInt[i].offset + n12 * this.inInt[i].scanw;
                            n6 = n5 + this.inInt[i].w;
                            n3 = dataBlk.offset + n12 * dataBlk.scanw;
                            n4 = n3 + dataBlk.w;
                            n10 = n3;
                            n11 = n5;
                            while (n11 < n6) {
                                int n13 = (this.dataInt[i][n11] >> n7) + n8;
                                this.workDataInt[i][n10] = n13 < 0 ? 0 : (n13 > n9 ? n9 : n13);
                                ++n11;
                                ++n10;
                            }
                        }
                        continue block11;
                    }
                    case 4: {
                        int n12;
                        ICCProfiler.copyGeometry(this.workFloat[i], dataBlk);
                        ICCProfiler.copyGeometry(this.tempFloat[i], dataBlk);
                        ICCProfiler.copyGeometry(this.inFloat[i], dataBlk);
                        ICCProfiler.setInternalBuffer(dataBlk);
                        this.workDataFloat[i] = (float[])this.workFloat[i].getData();
                        this.inFloat[i] = (DataBlkFloat)this.src.getInternCompData(this.inFloat[i], i);
                        this.dataFloat[i] = this.inFloat[i].getDataFloat();
                        for (n12 = 0; n12 < dataBlk.h; ++n12) {
                            n5 = this.inFloat[i].offset + n12 * this.inFloat[i].scanw;
                            n6 = n5 + this.inFloat[i].w;
                            n3 = dataBlk.offset + n12 * dataBlk.scanw;
                            n4 = n3 + dataBlk.w;
                            n10 = n3;
                            n11 = n5;
                            while (n11 < n6) {
                                float f = this.dataFloat[i][n11] / (float)(1 << n7) + (float)n8;
                                this.workDataFloat[i][n10] = f < 0.0f ? 0.0f : (f > (float)n9 ? (float)n9 : f);
                                ++n11;
                                ++n10;
                            }
                        }
                        continue block11;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid source datablock type");
                    }
                }
            }
            switch (n2) {
                case 3: {
                    if (this.ncomps == 1) {
                        ((MonochromeTransformTosRGB)this.xform).apply(this.workInt[n], this.tempInt[n]);
                    } else {
                        ((MatrixBasedTransformTosRGB)this.xform).apply(this.workInt, this.tempInt);
                    }
                    dataBlk.progressive = this.inInt[n].progressive;
                    dataBlk.setData(this.tempInt[n].getData());
                    break;
                }
                case 4: {
                    if (this.ncomps == 1) {
                        ((MonochromeTransformTosRGB)this.xform).apply(this.workFloat[n], this.tempFloat[n]);
                    } else {
                        ((MatrixBasedTransformTosRGB)this.xform).apply(this.workFloat, this.tempFloat);
                    }
                    dataBlk.progressive = this.inFloat[n].progressive;
                    dataBlk.setData(this.tempFloat[n].getData());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid source datablock type");
                }
            }
            dataBlk.offset = 0;
            dataBlk.scanw = dataBlk.w;
        }
        catch (MatrixBasedTransformException matrixBasedTransformException) {
            FacilityManager.getMsgLogger().printmsg(3, "matrix transform problem:\n" + matrixBasedTransformException.getMessage());
            if (this.pl.getParameter("debug").equals("on")) {
                matrixBasedTransformException.printStackTrace();
            } else {
                FacilityManager.getMsgLogger().printmsg(3, "Use '-debug' option for more details");
            }
            return null;
        }
        catch (MonochromeTransformException monochromeTransformException) {
            FacilityManager.getMsgLogger().printmsg(3, "monochrome transform problem:\n" + monochromeTransformException.getMessage());
            if (this.pl.getParameter("debug").equals("on")) {
                monochromeTransformException.printStackTrace();
            } else {
                FacilityManager.getMsgLogger().printmsg(3, "Use '-debug' option for more details");
            }
            return null;
        }
        return dataBlk;
    }

    public DataBlk getInternCompData(DataBlk dataBlk, int n) {
        return this.getCompData(dataBlk, n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ICCProfiler:");
        StringBuffer stringBuffer2 = new StringBuffer();
        if (this.icc != null) {
            stringBuffer2.append(eol).append(ColorSpace.indent("  ", this.icc.toString()));
        }
        if (this.xform != null) {
            stringBuffer2.append(eol).append(ColorSpace.indent("  ", this.xform.toString()));
        }
        stringBuffer.append(ColorSpace.indent("  ", stringBuffer2));
        return stringBuffer.append("]").toString();
    }
}

