/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.writer;

import jj2000.j2k.codestream.CBlkCoordInfo;
import jj2000.j2k.codestream.PrecInfo;
import jj2000.j2k.codestream.writer.BitOutputBuffer;
import jj2000.j2k.codestream.writer.TagTreeEncoder;
import jj2000.j2k.encoder.EncoderSpecs;
import jj2000.j2k.entropy.encoder.CBlkRateDistStats;
import jj2000.j2k.entropy.encoder.CodedCBlkDataSrcEnc;
import jj2000.j2k.image.Coord;
import jj2000.j2k.util.ArrayUtil;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.wavelet.analysis.SubbandAn;

public class PktEncoder {
    public static final char OPT_PREFIX = 'P';
    private static final String[][] pinfo = new String[][]{{"Psop", "[<tile idx>] on|off[ [<tile idx>] on|off ...]", "Specifies whether start of packet (SOP) markers should be used. 'on' enables, 'off' disables it.", "off"}, {"Peph", "[<tile idx>] on|off[ [<tile  idx>] on|off ...]", "Specifies whether end of packet header (EPH) markers should be  used. 'on' enables, 'off' disables it.", "off"}};
    private static final int INIT_LBLOCK = 3;
    private CodedCBlkDataSrcEnc infoSrc;
    private EncoderSpecs encSpec;
    private TagTreeEncoder[][][][][] ttIncl;
    private TagTreeEncoder[][][][][] ttMaxBP;
    private int[][][][][] lblock;
    private int[][][][][] prevtIdxs;
    private int[][][][][] bak_lblock;
    private int[][][][][] bak_prevtIdxs;
    private byte[] lbbuf;
    private int lblen;
    private boolean saved;
    private boolean roiInPkt = false;
    private int roiLen = 0;
    private PrecInfo[][][][] ppinfo;
    private boolean packetWritable;

    public PktEncoder(CodedCBlkDataSrcEnc codedCBlkDataSrcEnc, EncoderSpecs encoderSpecs, Coord[][][] coordArray, ParameterList parameterList) {
        this.infoSrc = codedCBlkDataSrcEnc;
        this.encSpec = encoderSpecs;
        parameterList.checkList('P', ParameterList.toNameArray(pinfo));
        int n = codedCBlkDataSrcEnc.getNumComps();
        int n2 = codedCBlkDataSrcEnc.getNumTiles();
        this.ttIncl = new TagTreeEncoder[n2][n][][][];
        this.ttMaxBP = new TagTreeEncoder[n2][n][][][];
        this.lblock = new int[n2][n][][][];
        this.prevtIdxs = new int[n2][n][][][];
        this.ppinfo = new PrecInfo[n2][n][][];
        Object var12_7 = null;
        Object var14_8 = null;
        codedCBlkDataSrcEnc.setTile(0, 0);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                SubbandAn subbandAn = codedCBlkDataSrcEnc.getAnSubbandTree(i, j);
                int n3 = subbandAn.resLvl;
                this.lblock[i][j] = new int[n3 + 1][][];
                this.ttIncl[i][j] = new TagTreeEncoder[n3 + 1][][];
                this.ttMaxBP[i][j] = new TagTreeEncoder[n3 + 1][][];
                this.prevtIdxs[i][j] = new int[n3 + 1][][];
                this.ppinfo[i][j] = new PrecInfo[n3 + 1][];
                for (int k = 0; k <= n3; ++k) {
                    int n4 = k == 0 ? 0 : 1;
                    int n5 = k == 0 ? 1 : 4;
                    int n6 = coordArray[i][j][k].x * coordArray[i][j][k].y;
                    this.ttIncl[i][j][k] = new TagTreeEncoder[n6][n5];
                    this.ttMaxBP[i][j][k] = new TagTreeEncoder[n6][n5];
                    this.prevtIdxs[i][j][k] = new int[n5][];
                    this.lblock[i][j][k] = new int[n5][];
                    this.ppinfo[i][j][k] = new PrecInfo[n6];
                    this.fillPrecInfo(i, j, k);
                    for (int i2 = n4; i2 < n5; ++i2) {
                        SubbandAn subbandAn2 = (SubbandAn)subbandAn.getSubbandByIdx(k, i2);
                        int n7 = subbandAn2.numCb.x * subbandAn2.numCb.y;
                        this.lblock[i][j][k][i2] = new int[n7];
                        ArrayUtil.intArraySet(this.lblock[i][j][k][i2], 3);
                        this.prevtIdxs[i][j][k][i2] = new int[n7];
                        ArrayUtil.intArraySet(this.prevtIdxs[i][j][k][i2], -1);
                    }
                }
            }
            if (i == n2 - 1) continue;
            codedCBlkDataSrcEnc.nextTile();
        }
    }

    private void fillPrecInfo(int n, int n2, int n3) {
        if (this.ppinfo[n][n2][n3].length == 0) {
            return;
        }
        Coord coord = this.infoSrc.getTile(null);
        Coord coord2 = this.infoSrc.getNumTiles(null);
        int n4 = this.infoSrc.getImgULX();
        int n5 = this.infoSrc.getImgULY();
        int n6 = n4 + this.infoSrc.getImgWidth();
        int n7 = n5 + this.infoSrc.getImgHeight();
        int n8 = this.infoSrc.getTilePartULX();
        int n9 = this.infoSrc.getTilePartULY();
        int n10 = this.infoSrc.getNomTileWidth();
        int n11 = this.infoSrc.getNomTileHeight();
        int n12 = coord.x == 0 ? n4 : n8 + coord.x * n10;
        int n13 = coord.y == 0 ? n5 : n9 + coord.y * n11;
        int n14 = coord.x != coord2.x - 1 ? n8 + (coord.x + 1) * n10 : n6;
        int n15 = coord.y != coord2.y - 1 ? n9 + (coord.y + 1) * n11 : n7;
        int n16 = this.infoSrc.getCompSubsX(n2);
        int n17 = this.infoSrc.getCompSubsY(n2);
        int n18 = (int)Math.ceil((double)n12 / (double)n16);
        int n19 = (int)Math.ceil((double)n13 / (double)n17);
        int n20 = (int)Math.ceil((double)n14 / (double)n16);
        int n21 = (int)Math.ceil((double)n15 / (double)n17);
        int n22 = this.infoSrc.getAnSubbandTree((int)n, (int)n2).resLvl - n3;
        int n23 = (int)Math.ceil((double)n18 / (double)(1 << n22));
        int n24 = (int)Math.ceil((double)n19 / (double)(1 << n22));
        int n25 = (int)Math.ceil((double)n20 / (double)(1 << n22));
        int n26 = (int)Math.ceil((double)n21 / (double)(1 << n22));
        int n27 = this.infoSrc.getCbULX();
        int n28 = this.infoSrc.getCbULY();
        double d = this.encSpec.pss.getPPX(n, n2, n3);
        double d2 = this.encSpec.pss.getPPY(n, n2, n3);
        int n29 = (int)(d / 2.0);
        int n30 = (int)(d2 / 2.0);
        int n31 = this.ppinfo[n][n2][n3].length;
        int n32 = 0;
        int n33 = (int)Math.floor((double)(n24 - n28) / d2);
        int n34 = (int)Math.floor((double)(n26 - 1 - n28) / d2);
        int n35 = (int)Math.floor((double)(n23 - n27) / d);
        int n36 = (int)Math.floor((double)(n25 - 1 - n27) / d);
        SubbandAn subbandAn = this.infoSrc.getAnSubbandTree(n, n2);
        SubbandAn subbandAn2 = null;
        int n37 = (int)d << n22;
        int n38 = (int)d2 << n22;
        for (int i = n33; i <= n34; ++i) {
            int n39 = n35;
            while (n39 <= n36) {
                CBlkCoordInfo cBlkCoordInfo;
                int n40;
                int n41;
                int n42;
                int n43;
                int n44;
                int n45;
                int n46;
                int n47;
                int n48;
                int n49;
                int n50;
                int n51;
                int n52;
                int n53;
                int n54;
                int n55;
                int n56;
                int n57;
                int n58;
                int n59;
                int n60 = n39 == n35 && (n23 - n27) % (n16 * (int)d) != 0 ? n12 : n27 + n39 * n16 * ((int)d << n22);
                int n61 = i == n33 && (n24 - n28) % (n17 * (int)d2) != 0 ? n13 : n28 + i * n17 * ((int)d2 << n22);
                this.ppinfo[n][n2][n3][n32] = new PrecInfo(n3, (int)((double)n27 + (double)n39 * d), (int)((double)n28 + (double)i * d2), (int)d, (int)d2, n60, n61, n37, n38);
                if (n3 == 0) {
                    n59 = n27;
                    n58 = n28;
                    n57 = n59 + n39 * (int)d;
                    n56 = n57 + (int)d;
                    n55 = n58 + i * (int)d2;
                    n54 = n55 + (int)d2;
                    subbandAn2 = (SubbandAn)subbandAn.getSubbandByIdx(0, 0);
                    n53 = n57 < subbandAn2.ulcx ? subbandAn2.ulcx : n57;
                    n52 = n56 > subbandAn2.ulcx + subbandAn2.w ? subbandAn2.ulcx + subbandAn2.w : n56;
                    n51 = n55 < subbandAn2.ulcy ? subbandAn2.ulcy : n55;
                    n50 = n54 > subbandAn2.ulcy + subbandAn2.h ? subbandAn2.ulcy + subbandAn2.h : n54;
                    n49 = subbandAn2.nomCBlkW;
                    n48 = subbandAn2.nomCBlkH;
                    n47 = (int)Math.floor((double)(subbandAn2.ulcy - n58) / (double)n48);
                    n46 = (int)Math.floor((double)(n51 - n58) / (double)n48);
                    n45 = (int)Math.floor((double)(n50 - 1 - n58) / (double)n48);
                    n44 = (int)Math.floor((double)(subbandAn2.ulcx - n59) / (double)n49);
                    n43 = (int)Math.floor((double)(n53 - n59) / (double)n49);
                    n42 = (int)Math.floor((double)(n52 - 1 - n59) / (double)n49);
                    if (n52 - n53 <= 0 || n50 - n51 <= 0) {
                        this.ppinfo[n][n2][n3][n32].nblk[0] = 0;
                        this.ttIncl[n][n2][n3][n32][0] = new TagTreeEncoder(0, 0);
                        this.ttMaxBP[n][n2][n3][n32][0] = new TagTreeEncoder(0, 0);
                    } else {
                        this.ttIncl[n][n2][n3][n32][0] = new TagTreeEncoder(n45 - n46 + 1, n42 - n43 + 1);
                        this.ttMaxBP[n][n2][n3][n32][0] = new TagTreeEncoder(n45 - n46 + 1, n42 - n43 + 1);
                        this.ppinfo[n][n2][n3][n32].cblk[0] = new CBlkCoordInfo[n45 - n46 + 1][n42 - n43 + 1];
                        this.ppinfo[n][n2][n3][n32].nblk[0] = (n45 - n46 + 1) * (n42 - n43 + 1);
                        for (n41 = n46; n41 <= n45; ++n41) {
                            for (n40 = n43; n40 <= n42; ++n40) {
                                this.ppinfo[n][n2][n3][n32].cblk[0][n41 - n46][n40 - n43] = cBlkCoordInfo = new CBlkCoordInfo(n41 - n47, n40 - n44);
                            }
                        }
                    }
                } else {
                    n59 = 0;
                    n58 = n28;
                    n57 = n59 + n39 * n29;
                    n56 = n57 + n29;
                    n55 = n58 + i * n30;
                    n54 = n55 + n30;
                    subbandAn2 = (SubbandAn)subbandAn.getSubbandByIdx(n3, 1);
                    n53 = n57 < subbandAn2.ulcx ? subbandAn2.ulcx : n57;
                    n52 = n56 > subbandAn2.ulcx + subbandAn2.w ? subbandAn2.ulcx + subbandAn2.w : n56;
                    n51 = n55 < subbandAn2.ulcy ? subbandAn2.ulcy : n55;
                    n50 = n54 > subbandAn2.ulcy + subbandAn2.h ? subbandAn2.ulcy + subbandAn2.h : n54;
                    n49 = subbandAn2.nomCBlkW;
                    n48 = subbandAn2.nomCBlkH;
                    n47 = (int)Math.floor((double)(subbandAn2.ulcy - n58) / (double)n48);
                    n46 = (int)Math.floor((double)(n51 - n58) / (double)n48);
                    n45 = (int)Math.floor((double)(n50 - 1 - n58) / (double)n48);
                    n44 = (int)Math.floor((double)(subbandAn2.ulcx - n59) / (double)n49);
                    n43 = (int)Math.floor((double)(n53 - n59) / (double)n49);
                    n42 = (int)Math.floor((double)(n52 - 1 - n59) / (double)n49);
                    if (n52 - n53 <= 0 || n50 - n51 <= 0) {
                        this.ppinfo[n][n2][n3][n32].nblk[1] = 0;
                        this.ttIncl[n][n2][n3][n32][1] = new TagTreeEncoder(0, 0);
                        this.ttMaxBP[n][n2][n3][n32][1] = new TagTreeEncoder(0, 0);
                    } else {
                        this.ttIncl[n][n2][n3][n32][1] = new TagTreeEncoder(n45 - n46 + 1, n42 - n43 + 1);
                        this.ttMaxBP[n][n2][n3][n32][1] = new TagTreeEncoder(n45 - n46 + 1, n42 - n43 + 1);
                        this.ppinfo[n][n2][n3][n32].cblk[1] = new CBlkCoordInfo[n45 - n46 + 1][n42 - n43 + 1];
                        this.ppinfo[n][n2][n3][n32].nblk[1] = (n45 - n46 + 1) * (n42 - n43 + 1);
                        for (n41 = n46; n41 <= n45; ++n41) {
                            for (n40 = n43; n40 <= n42; ++n40) {
                                this.ppinfo[n][n2][n3][n32].cblk[1][n41 - n46][n40 - n43] = cBlkCoordInfo = new CBlkCoordInfo(n41 - n47, n40 - n44);
                            }
                        }
                    }
                    n59 = n27;
                    n58 = 0;
                    n57 = n59 + n39 * n29;
                    n56 = n57 + n29;
                    n55 = n58 + i * n30;
                    n54 = n55 + n30;
                    subbandAn2 = (SubbandAn)subbandAn.getSubbandByIdx(n3, 2);
                    n53 = n57 < subbandAn2.ulcx ? subbandAn2.ulcx : n57;
                    n52 = n56 > subbandAn2.ulcx + subbandAn2.w ? subbandAn2.ulcx + subbandAn2.w : n56;
                    n51 = n55 < subbandAn2.ulcy ? subbandAn2.ulcy : n55;
                    n50 = n54 > subbandAn2.ulcy + subbandAn2.h ? subbandAn2.ulcy + subbandAn2.h : n54;
                    n49 = subbandAn2.nomCBlkW;
                    n48 = subbandAn2.nomCBlkH;
                    n47 = (int)Math.floor((double)(subbandAn2.ulcy - n58) / (double)n48);
                    n46 = (int)Math.floor((double)(n51 - n58) / (double)n48);
                    n45 = (int)Math.floor((double)(n50 - 1 - n58) / (double)n48);
                    n44 = (int)Math.floor((double)(subbandAn2.ulcx - n59) / (double)n49);
                    n43 = (int)Math.floor((double)(n53 - n59) / (double)n49);
                    n42 = (int)Math.floor((double)(n52 - 1 - n59) / (double)n49);
                    if (n52 - n53 <= 0 || n50 - n51 <= 0) {
                        this.ppinfo[n][n2][n3][n32].nblk[2] = 0;
                        this.ttIncl[n][n2][n3][n32][2] = new TagTreeEncoder(0, 0);
                        this.ttMaxBP[n][n2][n3][n32][2] = new TagTreeEncoder(0, 0);
                    } else {
                        this.ttIncl[n][n2][n3][n32][2] = new TagTreeEncoder(n45 - n46 + 1, n42 - n43 + 1);
                        this.ttMaxBP[n][n2][n3][n32][2] = new TagTreeEncoder(n45 - n46 + 1, n42 - n43 + 1);
                        this.ppinfo[n][n2][n3][n32].cblk[2] = new CBlkCoordInfo[n45 - n46 + 1][n42 - n43 + 1];
                        this.ppinfo[n][n2][n3][n32].nblk[2] = (n45 - n46 + 1) * (n42 - n43 + 1);
                        for (n41 = n46; n41 <= n45; ++n41) {
                            for (n40 = n43; n40 <= n42; ++n40) {
                                this.ppinfo[n][n2][n3][n32].cblk[2][n41 - n46][n40 - n43] = cBlkCoordInfo = new CBlkCoordInfo(n41 - n47, n40 - n44);
                            }
                        }
                    }
                    n59 = 0;
                    n58 = 0;
                    n57 = n59 + n39 * n29;
                    n56 = n57 + n29;
                    n55 = n58 + i * n30;
                    n54 = n55 + n30;
                    subbandAn2 = (SubbandAn)subbandAn.getSubbandByIdx(n3, 3);
                    n53 = n57 < subbandAn2.ulcx ? subbandAn2.ulcx : n57;
                    n52 = n56 > subbandAn2.ulcx + subbandAn2.w ? subbandAn2.ulcx + subbandAn2.w : n56;
                    n51 = n55 < subbandAn2.ulcy ? subbandAn2.ulcy : n55;
                    n50 = n54 > subbandAn2.ulcy + subbandAn2.h ? subbandAn2.ulcy + subbandAn2.h : n54;
                    n49 = subbandAn2.nomCBlkW;
                    n48 = subbandAn2.nomCBlkH;
                    n47 = (int)Math.floor((double)(subbandAn2.ulcy - n58) / (double)n48);
                    n46 = (int)Math.floor((double)(n51 - n58) / (double)n48);
                    n45 = (int)Math.floor((double)(n50 - 1 - n58) / (double)n48);
                    n44 = (int)Math.floor((double)(subbandAn2.ulcx - n59) / (double)n49);
                    n43 = (int)Math.floor((double)(n53 - n59) / (double)n49);
                    n42 = (int)Math.floor((double)(n52 - 1 - n59) / (double)n49);
                    if (n52 - n53 <= 0 || n50 - n51 <= 0) {
                        this.ppinfo[n][n2][n3][n32].nblk[3] = 0;
                        this.ttIncl[n][n2][n3][n32][3] = new TagTreeEncoder(0, 0);
                        this.ttMaxBP[n][n2][n3][n32][3] = new TagTreeEncoder(0, 0);
                    } else {
                        this.ttIncl[n][n2][n3][n32][3] = new TagTreeEncoder(n45 - n46 + 1, n42 - n43 + 1);
                        this.ttMaxBP[n][n2][n3][n32][3] = new TagTreeEncoder(n45 - n46 + 1, n42 - n43 + 1);
                        this.ppinfo[n][n2][n3][n32].cblk[3] = new CBlkCoordInfo[n45 - n46 + 1][n42 - n43 + 1];
                        this.ppinfo[n][n2][n3][n32].nblk[3] = (n45 - n46 + 1) * (n42 - n43 + 1);
                        for (n41 = n46; n41 <= n45; ++n41) {
                            for (n40 = n43; n40 <= n42; ++n40) {
                                this.ppinfo[n][n2][n3][n32].cblk[3][n41 - n46][n40 - n43] = cBlkCoordInfo = new CBlkCoordInfo(n41 - n47, n40 - n44);
                            }
                        }
                    }
                }
                ++n39;
                ++n32;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BitOutputBuffer encodePacket(int n, int n2, int n3, int n4, CBlkRateDistStats[][] cBlkRateDistStatsArray, int[][] nArray, BitOutputBuffer bitOutputBuffer, byte[] byArray, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int[] nArray2;
        CBlkRateDistStats[] cBlkRateDistStatsArray2;
        int[] nArray3;
        SubbandAn subbandAn;
        int n12;
        int n13 = n3 == 0 ? 0 : 1;
        int n14 = n3 == 0 ? 1 : 4;
        Coord coord = null;
        SubbandAn subbandAn2 = this.infoSrc.getAnSubbandTree(n4, n2);
        this.roiInPkt = false;
        this.roiLen = 0;
        if (n5 >= this.ppinfo[n4][n2][n3].length) {
            this.packetWritable = false;
            return bitOutputBuffer;
        }
        PrecInfo precInfo = this.ppinfo[n4][n2][n3][n5];
        boolean bl = true;
        for (n12 = n13; n12 < n14; ++n12) {
            if (precInfo.nblk[n12] == 0) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.packetWritable = true;
            if (bitOutputBuffer == null) {
                bitOutputBuffer = new BitOutputBuffer();
            } else {
                bitOutputBuffer.reset();
            }
            if (byArray == null) {
                byArray = new byte[1];
                this.lbbuf = byArray;
            }
            bitOutputBuffer.writeBit(0);
            this.lblen = 0;
            return bitOutputBuffer;
        }
        if (bitOutputBuffer == null) {
            bitOutputBuffer = new BitOutputBuffer();
        } else {
            bitOutputBuffer.reset();
        }
        this.lbbuf = null;
        this.lblen = 0;
        bitOutputBuffer.writeBit(1);
        for (n12 = n13; n12 < n14; ++n12) {
            subbandAn = (SubbandAn)subbandAn2.getSubbandByIdx(n3, n12);
            if (precInfo.nblk[n12] == 0) continue;
            TagTreeEncoder tagTreeEncoder = this.ttIncl[n4][n2][n3][n5][n12];
            TagTreeEncoder tagTreeEncoder2 = this.ttMaxBP[n4][n2][n3][n5][n12];
            nArray3 = this.prevtIdxs[n4][n2][n3][n12];
            cBlkRateDistStatsArray2 = cBlkRateDistStatsArray[n12];
            nArray2 = nArray[n12];
            n11 = precInfo.cblk[n12] == null ? 0 : precInfo.cblk[n12].length;
            for (n10 = 0; n10 < n11; ++n10) {
                n9 = precInfo.cblk[n12][n10] == null ? 0 : precInfo.cblk[n12][n10].length;
                for (n8 = 0; n8 < n9; ++n8) {
                    coord = precInfo.cblk[n12][n10][n8].idx;
                    n7 = coord.x + coord.y * subbandAn.numCb.x;
                    if (nArray2[n7] > nArray3[n7] && nArray3[n7] < 0) {
                        tagTreeEncoder.setValue(n10, n8, n - 1);
                    }
                    if (n != 1) continue;
                    tagTreeEncoder2.setValue(n10, n8, cBlkRateDistStatsArray2[n7].skipMSBP);
                }
            }
            for (n10 = 0; n10 < precInfo.cblk[n12].length; ++n10) {
                for (n8 = 0; n8 < precInfo.cblk[n12][n10].length; ++n8) {
                    int n15;
                    int n16;
                    int n17;
                    int n18;
                    int n19;
                    block39: {
                        block38: {
                            coord = precInfo.cblk[n12][n10][n8].idx;
                            n7 = coord.x + coord.y * subbandAn.numCb.x;
                            if (nArray2[n7] <= nArray3[n7]) break block38;
                            if (nArray3[n7] < 0) {
                                tagTreeEncoder.encode(n10, n8, n, bitOutputBuffer);
                                int n20 = cBlkRateDistStatsArray2[n7].skipMSBP + 1;
                                for (n19 = 1; n19 <= n20; ++n19) {
                                    tagTreeEncoder2.encode(n10, n8, n19, bitOutputBuffer);
                                }
                                this.lblen += cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray2[n7]]];
                            } else {
                                bitOutputBuffer.writeBit(1);
                                this.lblen += cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray2[n7]]] - cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]]];
                            }
                            n18 = nArray3[n7] < 0 ? cBlkRateDistStatsArray2[n7].truncIdxs[nArray2[n7]] : cBlkRateDistStatsArray2[n7].truncIdxs[nArray2[n7]] - cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]] - 1;
                            switch (n18) {
                                case 0: {
                                    bitOutputBuffer.writeBit(0);
                                    break block39;
                                }
                                case 1: {
                                    bitOutputBuffer.writeBits(2, 2);
                                    break block39;
                                }
                                case 2: 
                                case 3: 
                                case 4: {
                                    bitOutputBuffer.writeBits(0xC | n18 - 2, 4);
                                    break block39;
                                }
                                default: {
                                    if (n18 <= 35) {
                                        bitOutputBuffer.writeBits(0x1E0 | n18 - 5, 9);
                                    } else {
                                        if (n18 > 163) throw new ArithmeticException("Maximum number of truncation points exceeded");
                                        bitOutputBuffer.writeBits(0xFF80 | n18 - 36, 16);
                                    }
                                    break block39;
                                }
                            }
                        }
                        if (nArray3[n7] >= 0) {
                            bitOutputBuffer.writeBit(0);
                            continue;
                        }
                        tagTreeEncoder.encode(n10, n8, n, bitOutputBuffer);
                        continue;
                    }
                    n18 = 1;
                    int n21 = cBlkRateDistStatsArray2[n7].truncIdxs[nArray2[n7]];
                    n6 = nArray3[n7] < 0 ? 0 : cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]]];
                    n19 = nArray3[n7] < 0 ? 0 : cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]] + 1;
                    int n22 = 0;
                    while (n19 < n21) {
                        if (cBlkRateDistStatsArray2[n7].isTermPass != null && cBlkRateDistStatsArray2[n7].isTermPass[n19]) {
                            n6 = cBlkRateDistStatsArray2[n7].truncRates[n19] - n6;
                            n17 = this.lblock[n4][n2][n3][n12][n7] + MathUtil.log2(n18);
                            n22 = (n6 > 0 ? MathUtil.log2(n6) : 0) + 1;
                            for (n16 = n17; n16 < n22; ++n16) {
                                int[] nArray4 = this.lblock[n4][n2][n3][n12];
                                int n23 = n7;
                                nArray4[n23] = nArray4[n23] + 1;
                                bitOutputBuffer.writeBit(1);
                            }
                            n18 = 0;
                            n6 = cBlkRateDistStatsArray2[n7].truncRates[n19];
                        }
                        ++n19;
                        ++n18;
                    }
                    n6 = cBlkRateDistStatsArray2[n7].truncRates[n19] - n6;
                    n17 = this.lblock[n4][n2][n3][n12][n7] + MathUtil.log2(n18);
                    n22 = (n6 > 0 ? MathUtil.log2(n6) : 0) + 1;
                    for (n16 = n17; n16 < n22; ++n16) {
                        int[] nArray5 = this.lblock[n4][n2][n3][n12];
                        int n24 = n7;
                        nArray5[n24] = nArray5[n24] + 1;
                        bitOutputBuffer.writeBit(1);
                    }
                    bitOutputBuffer.writeBit(0);
                    n18 = 1;
                    n21 = cBlkRateDistStatsArray2[n7].truncIdxs[nArray2[n7]];
                    n6 = nArray3[n7] < 0 ? 0 : cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]]];
                    int n25 = n19 = nArray3[n7] < 0 ? 0 : cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]] + 1;
                    while (n19 < n21) {
                        if (cBlkRateDistStatsArray2[n7].isTermPass != null && cBlkRateDistStatsArray2[n7].isTermPass[n19]) {
                            n6 = cBlkRateDistStatsArray2[n7].truncRates[n19] - n6;
                            n15 = MathUtil.log2(n18) + this.lblock[n4][n2][n3][n12][n7];
                            bitOutputBuffer.writeBits(n6, n15);
                            n18 = 0;
                            n6 = cBlkRateDistStatsArray2[n7].truncRates[n19];
                        }
                        ++n19;
                        ++n18;
                    }
                    n6 = cBlkRateDistStatsArray2[n7].truncRates[n19] - n6;
                    n15 = MathUtil.log2(n18) + this.lblock[n4][n2][n3][n12][n7];
                    bitOutputBuffer.writeBits(n6, n15);
                }
            }
        }
        if (byArray == null || byArray.length < this.lblen) {
            byArray = new byte[this.lblen];
        }
        this.lbbuf = byArray;
        this.lblen = 0;
        for (n12 = n13; n12 < n14; ++n12) {
            subbandAn = (SubbandAn)subbandAn2.getSubbandByIdx(n3, n12);
            nArray3 = this.prevtIdxs[n4][n2][n3][n12];
            cBlkRateDistStatsArray2 = cBlkRateDistStatsArray[n12];
            nArray2 = nArray[n12];
            int n26 = nArray3.length;
            n11 = precInfo.cblk[n12] == null ? 0 : precInfo.cblk[n12].length;
            for (n10 = 0; n10 < n11; ++n10) {
                n9 = precInfo.cblk[n12][n10] == null ? 0 : precInfo.cblk[n12][n10].length;
                for (n8 = 0; n8 < n9; ++n8) {
                    coord = precInfo.cblk[n12][n10][n8].idx;
                    n7 = coord.x + coord.y * subbandAn.numCb.x;
                    if (nArray2[n7] <= nArray3[n7]) continue;
                    if (nArray3[n7] < 0) {
                        n6 = cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray2[n7]]];
                        System.arraycopy(cBlkRateDistStatsArray2[n7].data, 0, this.lbbuf, this.lblen, n6);
                    } else {
                        n6 = cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray2[n7]]] - cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]]];
                        System.arraycopy(cBlkRateDistStatsArray2[n7].data, cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]]], this.lbbuf, this.lblen, n6);
                    }
                    this.lblen += n6;
                    if (cBlkRateDistStatsArray2[n7].nROIcoeff != 0 && (nArray3[n7] == -1 || cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]] <= cBlkRateDistStatsArray2[n7].nROIcp - 1)) {
                        this.roiInPkt = true;
                        this.roiLen = this.lblen;
                    }
                    nArray3[n7] = nArray2[n7];
                }
            }
        }
        this.packetWritable = true;
        if (bitOutputBuffer.getLength() != 0) return bitOutputBuffer;
        throw new Error("You have found a bug in PktEncoder, method: encodePacket");
    }

    public byte[] getLastBodyBuf() {
        if (this.lbbuf == null) {
            throw new IllegalArgumentException();
        }
        return this.lbbuf;
    }

    public int getLastBodyLen() {
        return this.lblen;
    }

    public void save() {
        int n;
        int n2;
        if (this.bak_lblock == null) {
            this.bak_lblock = new int[this.ttIncl.length][][][][];
            this.bak_prevtIdxs = new int[this.ttIncl.length][][][][];
            for (int i = this.ttIncl.length - 1; i >= 0; --i) {
                this.bak_lblock[i] = new int[this.ttIncl[i].length][][][];
                this.bak_prevtIdxs[i] = new int[this.ttIncl[i].length][][][];
                for (int j = this.ttIncl[i].length - 1; j >= 0; --j) {
                    this.bak_lblock[i][j] = new int[this.lblock[i][j].length][][];
                    this.bak_prevtIdxs[i][j] = new int[this.ttIncl[i][j].length][][];
                    for (int k = this.lblock[i][j].length - 1; k >= 0; --k) {
                        this.bak_lblock[i][j][k] = new int[this.lblock[i][j][k].length][];
                        this.bak_prevtIdxs[i][j][k] = new int[this.prevtIdxs[i][j][k].length][];
                        n2 = k == 0 ? 0 : 1;
                        n = k == 0 ? 1 : 4;
                        for (int i2 = n2; i2 < n; ++i2) {
                            this.bak_lblock[i][j][k][i2] = new int[this.lblock[i][j][k][i2].length];
                            this.bak_prevtIdxs[i][j][k][i2] = new int[this.prevtIdxs[i][j][k][i2].length];
                        }
                    }
                }
            }
        }
        for (int i = this.ttIncl.length - 1; i >= 0; --i) {
            for (int j = this.ttIncl[i].length - 1; j >= 0; --j) {
                int[][][] nArray = this.lblock[i][j];
                int[][][] nArray2 = this.bak_lblock[i][j];
                TagTreeEncoder[][][] tagTreeEncoderArray = this.ttIncl[i][j];
                TagTreeEncoder[][][] tagTreeEncoderArray2 = this.ttMaxBP[i][j];
                for (int k = nArray.length - 1; k >= 0; --k) {
                    int n3;
                    TagTreeEncoder[][] tagTreeEncoderArray3 = tagTreeEncoderArray[k];
                    TagTreeEncoder[][] tagTreeEncoderArray4 = tagTreeEncoderArray2[k];
                    int[][] nArray3 = this.prevtIdxs[i][j][k];
                    int[][] nArray4 = this.bak_prevtIdxs[i][j][k];
                    n2 = k == 0 ? 0 : 1;
                    n = k == 0 ? 1 : 4;
                    for (n3 = n2; n3 < n; ++n3) {
                        System.arraycopy(nArray[k][n3], 0, nArray2[k][n3], 0, nArray[k][n3].length);
                        System.arraycopy(nArray3[n3], 0, nArray4[n3], 0, nArray3[n3].length);
                    }
                    for (n3 = this.ppinfo[i][j][k].length - 1; n3 >= 0; --n3) {
                        if (n3 >= tagTreeEncoderArray3.length) continue;
                        for (int i3 = n2; i3 < n; ++i3) {
                            tagTreeEncoderArray3[n3][i3].save();
                            tagTreeEncoderArray4[n3][i3].save();
                        }
                    }
                }
            }
        }
        this.saved = true;
    }

    public void restore() {
        if (!this.saved) {
            throw new IllegalArgumentException();
        }
        this.lbbuf = null;
        for (int i = this.ttIncl.length - 1; i >= 0; --i) {
            for (int j = this.ttIncl[i].length - 1; j >= 0; --j) {
                int[][][] nArray = this.lblock[i][j];
                int[][][] nArray2 = this.bak_lblock[i][j];
                TagTreeEncoder[][][] tagTreeEncoderArray = this.ttIncl[i][j];
                TagTreeEncoder[][][] tagTreeEncoderArray2 = this.ttMaxBP[i][j];
                for (int k = nArray.length - 1; k >= 0; --k) {
                    int n;
                    TagTreeEncoder[][] tagTreeEncoderArray3 = tagTreeEncoderArray[k];
                    TagTreeEncoder[][] tagTreeEncoderArray4 = tagTreeEncoderArray2[k];
                    int[][] nArray3 = this.prevtIdxs[i][j][k];
                    int[][] nArray4 = this.bak_prevtIdxs[i][j][k];
                    int n2 = k == 0 ? 0 : 1;
                    int n3 = k == 0 ? 1 : 4;
                    for (n = n2; n < n3; ++n) {
                        System.arraycopy(nArray2[k][n], 0, nArray[k][n], 0, nArray[k][n].length);
                        System.arraycopy(nArray4[n], 0, nArray3[n], 0, nArray3[n].length);
                    }
                    for (n = this.ppinfo[i][j][k].length - 1; n >= 0; --n) {
                        if (n >= tagTreeEncoderArray3.length) continue;
                        for (int i2 = n2; i2 < n3; ++i2) {
                            tagTreeEncoderArray3[n][i2].restore();
                            tagTreeEncoderArray4[n][i2].restore();
                        }
                    }
                }
            }
        }
    }

    public void reset() {
        this.saved = false;
        this.lbbuf = null;
        for (int i = this.ttIncl.length - 1; i >= 0; --i) {
            for (int j = this.ttIncl[i].length - 1; j >= 0; --j) {
                int[][][] nArray = this.lblock[i][j];
                TagTreeEncoder[][][] tagTreeEncoderArray = this.ttIncl[i][j];
                TagTreeEncoder[][][] tagTreeEncoderArray2 = this.ttMaxBP[i][j];
                for (int k = nArray.length - 1; k >= 0; --k) {
                    int n;
                    TagTreeEncoder[][] tagTreeEncoderArray3 = tagTreeEncoderArray[k];
                    TagTreeEncoder[][] tagTreeEncoderArray4 = tagTreeEncoderArray2[k];
                    int[][] nArray2 = this.prevtIdxs[i][j][k];
                    int n2 = k == 0 ? 0 : 1;
                    int n3 = k == 0 ? 1 : 4;
                    for (n = n2; n < n3; ++n) {
                        ArrayUtil.intArraySet(nArray2[n], -1);
                        ArrayUtil.intArraySet(nArray[k][n], 3);
                    }
                    for (n = this.ppinfo[i][j][k].length - 1; n >= 0; --n) {
                        if (n >= tagTreeEncoderArray3.length) continue;
                        for (int i2 = n2; i2 < n3; ++i2) {
                            tagTreeEncoderArray3[n][i2].reset();
                            tagTreeEncoderArray4[n][i2].reset();
                        }
                    }
                }
            }
        }
    }

    public boolean isPacketWritable() {
        return this.packetWritable;
    }

    public boolean isROIinPkt() {
        return this.roiInPkt;
    }

    public int getROILen() {
        return this.roiLen;
    }

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    public PrecInfo getPrecInfo(int n, int n2, int n3, int n4) {
        return this.ppinfo[n][n2][n3][n4];
    }
}

