/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image.input;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import jj2000.j2k.JJ2KExceptionHandler;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.input.ImgReader;

public class ImgReaderPPM
extends ImgReader {
    public static int DC_OFFSET = 128;
    private RandomAccessFile in;
    private int offset;
    private int rb;
    private int[][] barr = new int[3][];
    private DataBlkInt dbi = new DataBlkInt();
    private byte[] buf;
    private DataBlkInt intBlk;

    public ImgReaderPPM(File file) throws IOException {
        this(new RandomAccessFile(file, "r"));
    }

    public ImgReaderPPM(String string) throws IOException {
        this(new RandomAccessFile(string, "r"));
    }

    private ImgReaderPPM(RandomAccessFile randomAccessFile) throws EOFException, IOException {
        this.in = randomAccessFile;
        this.confirmFileType();
        this.skipCommentAndWhiteSpace();
        this.w = this.readHeaderInt();
        this.skipCommentAndWhiteSpace();
        this.h = this.readHeaderInt();
        this.skipCommentAndWhiteSpace();
        this.readHeaderInt();
        this.nc = 3;
        this.rb = 8;
    }

    public void close() throws IOException {
        this.in.close();
        this.in = null;
        this.barr[0] = null;
        this.barr[1] = null;
        this.barr[2] = null;
        this.buf = null;
    }

    public int getNomRangeBits(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException();
        }
        return this.rb;
    }

    public int getFixedPoint(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException();
        }
        return 0;
    }

    public final DataBlk getInternCompData(DataBlk dataBlk, int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException();
        }
        if (dataBlk.getDataType() != 3) {
            if (this.intBlk == null) {
                this.intBlk = new DataBlkInt(dataBlk.ulx, dataBlk.uly, dataBlk.w, dataBlk.h);
            } else {
                this.intBlk.ulx = dataBlk.ulx;
                this.intBlk.uly = dataBlk.uly;
                this.intBlk.w = dataBlk.w;
                this.intBlk.h = dataBlk.h;
            }
            dataBlk = this.intBlk;
        }
        if (this.barr[n] == null || this.dbi.ulx > dataBlk.ulx || this.dbi.uly > dataBlk.uly || this.dbi.ulx + this.dbi.w < dataBlk.ulx + dataBlk.w || this.dbi.uly + this.dbi.h < dataBlk.uly + dataBlk.h) {
            if (this.barr[n] == null || this.barr[n].length < dataBlk.w * dataBlk.h) {
                this.barr[n] = new int[dataBlk.w * dataBlk.h];
            }
            dataBlk.setData(this.barr[n]);
            int n2 = (n + 1) % 3;
            if (this.barr[n2] == null || this.barr[n2].length < dataBlk.w * dataBlk.h) {
                this.barr[n2] = new int[dataBlk.w * dataBlk.h];
            }
            if (this.barr[n2 = (n + 2) % 3] == null || this.barr[n2].length < dataBlk.w * dataBlk.h) {
                this.barr[n2] = new int[dataBlk.w * dataBlk.h];
            }
            this.dbi.ulx = dataBlk.ulx;
            this.dbi.uly = dataBlk.uly;
            this.dbi.w = dataBlk.w;
            this.dbi.h = dataBlk.h;
            if (this.buf == null || this.buf.length < 3 * dataBlk.w) {
                this.buf = new byte[3 * dataBlk.w];
            }
            int[] nArray = this.barr[0];
            int[] nArray2 = this.barr[1];
            int[] nArray3 = this.barr[2];
            try {
                int n3 = dataBlk.uly + dataBlk.h;
                for (n2 = dataBlk.uly; n2 < n3; ++n2) {
                    this.in.seek(this.offset + n2 * 3 * this.w + 3 * dataBlk.ulx);
                    this.in.read(this.buf, 0, 3 * dataBlk.w);
                    int n4 = (n2 - dataBlk.uly) * dataBlk.w + dataBlk.w - 1;
                    int n5 = 3 * dataBlk.w - 1;
                    while (n5 >= 0) {
                        nArray3[n4] = (this.buf[n5--] & 0xFF) - DC_OFFSET;
                        nArray2[n4] = (this.buf[n5--] & 0xFF) - DC_OFFSET;
                        nArray[n4] = (this.buf[n5--] & 0xFF) - DC_OFFSET;
                        --n4;
                    }
                }
            }
            catch (IOException iOException) {
                JJ2KExceptionHandler.handleException(iOException);
            }
            this.barr[0] = nArray;
            this.barr[1] = nArray2;
            this.barr[2] = nArray3;
            dataBlk.setData(this.barr[n]);
            dataBlk.offset = 0;
            dataBlk.scanw = dataBlk.w;
        } else {
            dataBlk.setData(this.barr[n]);
            dataBlk.offset = (dataBlk.ulx - this.dbi.ulx) * this.dbi.w + dataBlk.ulx - this.dbi.ulx;
            dataBlk.scanw = this.dbi.scanw;
        }
        dataBlk.progressive = false;
        return dataBlk;
    }

    public final DataBlk getCompData(DataBlk object, int n) {
        Object object2;
        if (((DataBlk)object).getDataType() != 3) {
            object2 = new DataBlkInt(((DataBlk)object).ulx, ((DataBlk)object).uly, ((DataBlk)object).w, ((DataBlk)object).h);
            object = object2;
        }
        object2 = (int[])((DataBlk)object).getData();
        int n2 = ((DataBlk)object).ulx;
        int n3 = ((DataBlk)object).uly;
        int n4 = ((DataBlk)object).w;
        int n5 = ((DataBlk)object).h;
        ((DataBlk)object).setData(null);
        this.getInternCompData((DataBlk)object, n);
        if (object2 == null) {
            object2 = new int[n4 * n5];
        }
        if (((DataBlk)object).offset == 0 && ((DataBlk)object).scanw == n4) {
            System.arraycopy(((DataBlk)object).getData(), 0, object2, 0, n4 * n5);
        } else {
            for (int i = n5 - 1; i >= 0; --i) {
                System.arraycopy(((DataBlk)object).getData(), ((DataBlk)object).offset + i * ((DataBlk)object).scanw, object2, i * n4, n4);
            }
        }
        ((DataBlk)object).setData(object2);
        ((DataBlk)object).offset = 0;
        ((DataBlk)object).scanw = ((DataBlk)object).w;
        return object;
    }

    private byte countedByteRead() throws IOException, EOFException {
        ++this.offset;
        return this.in.readByte();
    }

    private void confirmFileType() throws IOException, EOFException {
        byte[] byArray = new byte[]{80, 54};
        for (int i = 0; i < 2; ++i) {
            byte by = this.countedByteRead();
            if (by == byArray[i]) continue;
            if (i == 1 && by == 51) {
                throw new IllegalArgumentException("JJ2000 does not support ascii-PPM files. Use  raw-PPM file instead. ");
            }
            throw new IllegalArgumentException("Not a raw-PPM file");
        }
    }

    private void skipCommentAndWhiteSpace() throws IOException, EOFException {
        boolean bl = false;
        while (!bl) {
            byte by = this.countedByteRead();
            if (by == 35) {
                while (by != 10 && by != 13) {
                    by = this.countedByteRead();
                }
                continue;
            }
            if (by == 9 || by == 10 || by == 13 || by == 32) continue;
            bl = true;
        }
        --this.offset;
        this.in.seek(this.offset);
    }

    private int readHeaderInt() throws IOException, EOFException {
        int n = 0;
        byte by = 0;
        by = this.countedByteRead();
        while (by != 32 && by != 10 && by != 9 && by != 13) {
            n = n * 10 + by - 48;
            by = this.countedByteRead();
        }
        return n;
    }

    public boolean isOrigSigned(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException();
        }
        return false;
    }

    public String toString() {
        return "ImgReaderPPM: WxH = " + this.w + "x" + this.h + ", Component = 0,1,2" + "\nUnderlying RandomAccessFile:\n" + this.in.toString();
    }
}

