/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.helpers;

import android.app.Activity;
import android.content.Context;
import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\nH\u0016J$\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000eH\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lnashid/verify/sdk/utils/helpers/LocationHelper;", "Landroid/location/LocationListener;", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "locationCallback", "Lnashid/verify/sdk/utils/helpers/LocationHelper$LocationCallback;", "locationManager", "Landroid/location/LocationManager;", "getAddressFromLocation", "", "location", "Landroid/location/Location;", "getLastLocation", "", "callback", "onLocationChanged", "onProviderDisabled", "provider", "onProviderEnabled", "onStatusChanged", "status", "", "extras", "Landroid/os/Bundle;", "requestLocationPermissions", "requestLocationUpdatesWithTimeout", "Companion", "LocationCallback", "VerifySDK_release"})
@StabilityInferred(parameters=0)
public final class LocationHelper
implements LocationListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Activity activity;
    @NotNull
    private final LocationManager locationManager;
    @Nullable
    private LocationCallback locationCallback;
    public static final int $stable = 8;
    private static final long MIN_TIME_BW_UPDATES = 60000L;
    private static final float MIN_DISTANCE_CHANGE_FOR_UPDATES = 10.0f;
    private static final long LOCATION_TIMEOUT = 10000L;

    public LocationHelper(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.activity = activity;
        Object object = this.activity.getSystemService("location");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.location.LocationManager");
        this.locationManager = (LocationManager)object;
    }

    public final void getLastLocation(@NotNull LocationCallback callback) {
        block3: {
            Location location;
            block2: {
                Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
                this.locationCallback = callback;
                if (ContextCompat.checkSelfPermission((Context)((Context)this.activity), (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
                    this.requestLocationPermissions();
                    return;
                }
                location = this.locationManager.getLastKnownLocation("gps");
                if (location == null) {
                    location = this.locationManager.getLastKnownLocation("network");
                }
                if (location != null) break block2;
                this.requestLocationUpdatesWithTimeout(callback);
                break block3;
            }
            String address = this.getAddressFromLocation(location);
            LocationCallback locationCallback = this.locationCallback;
            if (locationCallback == null) break block3;
            locationCallback.onLocationResult(location, address);
        }
    }

    private final void requestLocationUpdatesWithTimeout(LocationCallback callback) {
        this.locationCallback = callback;
        if (ActivityCompat.checkSelfPermission((Context)((Context)this.activity), (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            this.requestLocationPermissions();
            return;
        }
        this.locationManager.requestLocationUpdates("gps", 60000L, 10.0f, (LocationListener)this);
        new Handler(Looper.getMainLooper()).postDelayed(() -> LocationHelper.requestLocationUpdatesWithTimeout$lambda$1(this), 10000L);
    }

    public void onLocationChanged(@NotNull Location location) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            LocationCallback locationCallback = this.locationCallback;
            if (locationCallback == null) break block0;
            LocationCallback it = locationCallback;
            boolean bl = false;
            String address = this.getAddressFromLocation(location);
            it.onLocationResult(location, address);
            this.locationManager.removeUpdates((LocationListener)this);
        }
    }

    public void onStatusChanged(@Nullable String provider, int status, @Nullable Bundle extras) {
    }

    public void onProviderEnabled(@NotNull String provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
    }

    public void onProviderDisabled(@NotNull String provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
    }

    private final void requestLocationPermissions() {
        String[] stringArray = new String[]{"android.permission.ACCESS_FINE_LOCATION"};
        ActivityCompat.requestPermissions((Activity)this.activity, (String[])stringArray, (int)1);
    }

    private final String getAddressFromLocation(Location location) {
        String string2;
        Geocoder geocoder = new Geocoder((Context)this.activity, Locale.getDefault());
        try {
            String string3;
            List addresses = geocoder.getFromLocation(location.getLatitude(), location.getLongitude(), 1);
            Collection collection = addresses;
            if (!(collection == null || collection.isEmpty())) {
                string3 = ((Address)addresses.get(0)).getAddressLine(0);
                if (string3 == null) {
                    string3 = "Unknown location";
                }
            } else {
                string3 = "Unknown location";
            }
            string2 = string3;
        }
        catch (IOException e) {
            e.printStackTrace();
            string2 = "Unknown location";
        }
        return string2;
    }

    private static final void requestLocationUpdatesWithTimeout$lambda$1(LocationHelper this$0) {
        block2: {
            Location location;
            block1: {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                this$0.locationManager.removeUpdates((LocationListener)this$0);
                Location lastKnownLocation = this$0.locationManager.getLastKnownLocation("gps");
                if (lastKnownLocation == null) {
                    lastKnownLocation = this$0.locationManager.getLastKnownLocation("network");
                }
                if (lastKnownLocation == null || this$0.locationCallback == null) break block1;
                String address = this$0.getAddressFromLocation(lastKnownLocation);
                LocationCallback locationCallback = this$0.locationCallback;
                if (locationCallback == null) break block2;
                locationCallback.onLocationResult(lastKnownLocation, address);
                break block2;
            }
            Location $this$requestLocationUpdatesWithTimeout_u24lambda_u241_u24lambda_u240 = location = new Location("default");
            boolean bl = false;
            $this$requestLocationUpdatesWithTimeout_u24lambda_u241_u24lambda_u240.setLatitude(0.0);
            $this$requestLocationUpdatesWithTimeout_u24lambda_u241_u24lambda_u240.setLongitude(0.0);
            Location defaultLocation = location;
            String address = this$0.getAddressFromLocation(defaultLocation);
            LocationCallback locationCallback = this$0.locationCallback;
            if (locationCallback == null) break block2;
            locationCallback.onLocationResult(defaultLocation, address);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lnashid/verify/sdk/utils/helpers/LocationHelper$Companion;", "", "()V", "LOCATION_TIMEOUT", "", "MIN_DISTANCE_CHANGE_FOR_UPDATES", "", "MIN_TIME_BW_UPDATES", "VerifySDK_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lnashid/verify/sdk/utils/helpers/LocationHelper$LocationCallback;", "", "onLocationResult", "", "location", "Landroid/location/Location;", "address", "", "VerifySDK_release"})
    public static interface LocationCallback {
        public void onLocationResult(@NotNull Location var1, @NotNull String var2);
    }
}

