/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.cert;

import org.ejbca.cvc.AccessRightEnum;
import org.ejbca.cvc.AuthorizationRoleEnum;

public class CVCAuthorizationTemplate {
    private final Role role;
    private final Permission accessRight;

    protected CVCAuthorizationTemplate(org.ejbca.cvc.CVCAuthorizationTemplate template) {
        this.role = CVCAuthorizationTemplate.toRole(template);
        this.accessRight = CVCAuthorizationTemplate.toPermission(template);
    }

    public CVCAuthorizationTemplate(Role role, Permission accessRight) {
        this.role = role;
        this.accessRight = accessRight;
    }

    public Role getRole() {
        return this.role;
    }

    public Permission getAccessRight() {
        return this.accessRight;
    }

    public String toString() {
        return this.role.toString() + this.accessRight.toString();
    }

    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        if (otherObj == this) {
            return true;
        }
        if (!this.getClass().equals(otherObj.getClass())) {
            return false;
        }
        CVCAuthorizationTemplate otherTemplate = (CVCAuthorizationTemplate)otherObj;
        return this.role == otherTemplate.role && this.accessRight == otherTemplate.accessRight;
    }

    public int hashCode() {
        return 2 * this.role.value + 3 * this.accessRight.value + 61;
    }

    static AccessRightEnum fromPermission(Permission permission) {
        try {
            switch (permission) {
                case READ_ACCESS_NONE: {
                    return AccessRightEnum.READ_ACCESS_NONE;
                }
                case READ_ACCESS_DG3: {
                    return AccessRightEnum.READ_ACCESS_DG3;
                }
                case READ_ACCESS_DG4: {
                    return AccessRightEnum.READ_ACCESS_DG4;
                }
                case READ_ACCESS_DG3_AND_DG4: {
                    return AccessRightEnum.READ_ACCESS_DG3_AND_DG4;
                }
            }
            throw new IllegalArgumentException("Error getting permission for " + (Object)((Object)permission));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error getting permission from AuthZ template", e);
        }
    }

    static AuthorizationRoleEnum fromRole(Role role) {
        try {
            switch (role) {
                case CVCA: {
                    return AuthorizationRoleEnum.CVCA;
                }
                case DV_D: {
                    return AuthorizationRoleEnum.DV_D;
                }
                case DV_F: {
                    return AuthorizationRoleEnum.DV_F;
                }
                case IS: {
                    return AuthorizationRoleEnum.IS;
                }
            }
            throw new IllegalArgumentException("Error getting role from AuthZ template " + (Object)((Object)role));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error getting role from AuthZ template", e);
        }
    }

    private static Role toRole(org.ejbca.cvc.CVCAuthorizationTemplate template) {
        try {
            AuthorizationRoleEnum role = template.getAuthorizationField().getRole();
            switch (role) {
                case CVCA: {
                    return Role.CVCA;
                }
                case DV_D: {
                    return Role.DV_D;
                }
                case DV_F: {
                    return Role.DV_F;
                }
                case IS: {
                    return Role.IS;
                }
            }
            throw new IllegalArgumentException("Unsupported role " + role);
        }
        catch (NoSuchFieldException nsfe) {
            throw new IllegalArgumentException("Error getting role from AuthZ template", nsfe);
        }
    }

    private static Permission toPermission(org.ejbca.cvc.CVCAuthorizationTemplate template) {
        try {
            AccessRightEnum accessRight = template.getAuthorizationField().getAccessRight();
            switch (accessRight) {
                case READ_ACCESS_NONE: {
                    return Permission.READ_ACCESS_NONE;
                }
                case READ_ACCESS_DG3: {
                    return Permission.READ_ACCESS_DG3;
                }
                case READ_ACCESS_DG4: {
                    return Permission.READ_ACCESS_DG4;
                }
                case READ_ACCESS_DG3_AND_DG4: {
                    return Permission.READ_ACCESS_DG3_AND_DG4;
                }
            }
            throw new IllegalArgumentException("Unsupported access right " + accessRight);
        }
        catch (NoSuchFieldException nsfe) {
            throw new IllegalArgumentException("Unsupported access right", nsfe);
        }
    }

    public static enum Role {
        CVCA(192),
        DV_D(128),
        DV_F(64),
        IS(0);

        private final byte value;

        private Role(int value) {
            this.value = (byte)value;
        }

        public byte getValue() {
            return this.value;
        }
    }

    public static enum Permission {
        READ_ACCESS_NONE(0),
        READ_ACCESS_DG3(1),
        READ_ACCESS_DG4(2),
        READ_ACCESS_DG3_AND_DG4(3);

        private final byte value;

        private Permission(int value) {
            this.value = (byte)value;
        }

        public boolean implies(Permission other) {
            switch (this) {
                case READ_ACCESS_NONE: {
                    return other == READ_ACCESS_NONE;
                }
                case READ_ACCESS_DG3: {
                    return other == READ_ACCESS_DG3;
                }
                case READ_ACCESS_DG4: {
                    return other == READ_ACCESS_DG4;
                }
                case READ_ACCESS_DG3_AND_DG4: {
                    return other == READ_ACCESS_DG3 || other == READ_ACCESS_DG4 || other == READ_ACCESS_DG3_AND_DG4;
                }
            }
            return false;
        }

        public byte getValue() {
            return this.value;
        }
    }
}

