/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.cert;

import java.io.Serializable;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.scuba.data.Country;

public class CVCPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = -4905647207367309688L;
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    private Country country;
    private final String mnemonic;
    private final String seqNumber;

    public CVCPrincipal(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name should be <Country (2F)><Mnemonic (9V)><SeqNum (5F)> formatted, found null");
        }
        if (name.length() < 7 || name.length() > 16) {
            throw new IllegalArgumentException("Name should be <Country (2F)><Mnemonic (9V)><SeqNum (5F)> formatted, found \"" + name + "\"");
        }
        final String alpha2Code = name.substring(0, 2).toUpperCase();
        try {
            this.country = Country.getInstance((String)alpha2Code);
        }
        catch (IllegalArgumentException iae) {
            LOGGER.log(Level.FINE, "Could not find country for " + alpha2Code, iae);
            this.country = new Country(){
                private static final long serialVersionUID = 345841304964161797L;

                public int valueOf() {
                    return -1;
                }

                public String getName() {
                    return "Unknown";
                }

                public String getNationality() {
                    return "Unknown";
                }

                public String toAlpha2Code() {
                    return alpha2Code;
                }

                public String toAlpha3Code() {
                    return "XXX";
                }
            };
        }
        this.mnemonic = name.substring(2, name.length() - 5);
        this.seqNumber = name.substring(name.length() - 5);
    }

    public CVCPrincipal(Country country, String mnemonic, String seqNumber) {
        if (mnemonic == null || mnemonic.length() > 9) {
            throw new IllegalArgumentException("Wrong length mnemonic");
        }
        if (seqNumber == null || seqNumber.length() != 5) {
            throw new IllegalArgumentException("Wrong length seqNumber");
        }
        this.country = country;
        this.mnemonic = mnemonic;
        this.seqNumber = seqNumber;
    }

    @Override
    public String getName() {
        return this.country.toAlpha2Code() + this.mnemonic + this.seqNumber;
    }

    @Override
    public String toString() {
        return this.country.toAlpha2Code() + "/" + this.mnemonic + "/" + this.seqNumber;
    }

    public Country getCountry() {
        return this.country;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public String getSeqNumber() {
        return this.seqNumber;
    }

    @Override
    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        if (otherObj == this) {
            return true;
        }
        if (!otherObj.getClass().equals(this.getClass())) {
            return false;
        }
        CVCPrincipal otherPrincipal = (CVCPrincipal)otherObj;
        return otherPrincipal.country.equals(this.country) && otherPrincipal.mnemonic.equals(this.mnemonic) && otherPrincipal.seqNumber.equals(this.seqNumber);
    }

    @Override
    public int hashCode() {
        return 2 * this.getName().hashCode() + 1231211;
    }
}

