/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class PositionInputStream
extends InputStream {
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    private static final long MARK_NOT_SET = -1L;
    private final InputStream carrier;
    private long position;
    private long markedPosition;

    public PositionInputStream(InputStream carrier) {
        this.carrier = carrier;
        this.position = 0L;
        this.markedPosition = -1L;
    }

    @Override
    public int read() throws IOException {
        int b = this.carrier.read();
        if (b >= 0) {
            ++this.position;
        }
        return b;
    }

    @Override
    public int read(byte[] dest) throws IOException {
        return this.read(dest, 0, dest.length);
    }

    @Override
    public int read(byte[] dest, int offset, int length) throws IOException {
        int bytesRead = this.carrier.read(dest, offset, length);
        this.position += (long)bytesRead;
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        long skippedBytes = this.carrier.skip(n);
        if (skippedBytes <= 0L) {
            LOGGER.warning("Carrier (" + this.carrier.getClass().getCanonicalName() + ")'s skip(" + n + ") only skipped " + skippedBytes + ", position = " + this.position);
        }
        this.position += skippedBytes;
        return skippedBytes;
    }

    @Override
    public void mark(int readLimit) {
        this.carrier.mark(readLimit);
        this.markedPosition = this.position;
    }

    @Override
    public void reset() throws IOException {
        this.carrier.reset();
        this.position = this.markedPosition;
    }

    @Override
    public boolean markSupported() {
        return this.carrier.markSupported();
    }

    public long getPosition() {
        return this.position;
    }
}

