/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.lds;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.AbstractImageInfo;
import net.sf.scuba.tlv.TLVInputStream;
import net.sf.scuba.tlv.TLVOutputStream;
import net.sf.scuba.tlv.TLVUtil;

public class DisplayedImageInfo
extends AbstractImageInfo {
    private static final long serialVersionUID = 3801320585294302721L;
    public static final int DISPLAYED_PORTRAIT_TAG = 24384;
    public static final int DISPLAYED_SIGNATURE_OR_MARK_TAG = 24387;
    private int displayedImageTag;

    public DisplayedImageInfo(int type, byte[] imageBytes) {
        super(type, DisplayedImageInfo.getMimeTypeFromType(type));
        this.displayedImageTag = DisplayedImageInfo.getDisplayedImageTagFromType(type);
        this.setImageBytes(imageBytes);
    }

    public DisplayedImageInfo(InputStream in) throws IOException {
        this.readObject(in);
    }

    @Override
    protected void readObject(InputStream inputStream) throws IOException {
        TLVInputStream tlvIn = inputStream instanceof TLVInputStream ? (TLVInputStream)inputStream : new TLVInputStream(inputStream);
        this.displayedImageTag = tlvIn.readTag();
        if (this.displayedImageTag != 24384 && this.displayedImageTag != 24387) {
            throw new IllegalArgumentException("Expected tag 0x5F40 or 0x5F43, found " + Integer.toHexString(this.displayedImageTag));
        }
        int type = DisplayedImageInfo.getTypeFromDisplayedImageTag(this.displayedImageTag);
        this.setType(type);
        this.setMimeType(DisplayedImageInfo.getMimeTypeFromType(type));
        long imageLength = tlvIn.readLength();
        this.readImage((InputStream)tlvIn, imageLength);
    }

    @Override
    protected void writeObject(OutputStream outputStream) throws IOException {
        TLVOutputStream tlvOut = outputStream instanceof TLVOutputStream ? (TLVOutputStream)outputStream : new TLVOutputStream(outputStream);
        tlvOut.writeTag(DisplayedImageInfo.getDisplayedImageTagFromType(this.getType()));
        this.writeImage((OutputStream)tlvOut);
        tlvOut.writeValueEnd();
    }

    int getDisplayedImageTag() {
        return this.displayedImageTag;
    }

    @Override
    public long getRecordLength() {
        long length = 0L;
        int imageLength = this.getImageLength();
        length += (long)TLVUtil.getTagLength((int)DisplayedImageInfo.getDisplayedImageTagFromType(this.getType()));
        length += (long)TLVUtil.getLengthLength((int)imageLength);
        return length += (long)imageLength;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.displayedImageTag;
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DisplayedImageInfo other = (DisplayedImageInfo)obj;
        return this.displayedImageTag == other.displayedImageTag;
    }

    private static String getMimeTypeFromType(int type) {
        switch (type) {
            case 0: {
                return "image/jpeg";
            }
            case 2: {
                return "image/x-wsq";
            }
            case 1: {
                return "image/jpeg";
            }
        }
        throw new NumberFormatException("Unknown type: " + Integer.toHexString(type));
    }

    private static int getDisplayedImageTagFromType(int type) {
        switch (type) {
            case 0: {
                return 24384;
            }
            case 1: {
                return 24387;
            }
        }
        throw new NumberFormatException("Unknown type: " + Integer.toHexString(type));
    }

    private static int getTypeFromDisplayedImageTag(int tag) {
        switch (tag) {
            case 24384: {
                return 0;
            }
            case 24387: {
                return 1;
            }
        }
        throw new NumberFormatException("Unknown tag: " + Integer.toHexString(tag));
    }
}

