/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.lds.icao;

import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.DataGroup;
import net.sf.scuba.tlv.TLVInputStream;
import net.sf.scuba.tlv.TLVOutputStream;
import net.sf.scuba.tlv.TLVUtil;
import net.sf.scuba.util.Hex;

public class DG11File
extends DataGroup {
    private static final long serialVersionUID = 8566312538928662937L;
    public static final int TAG_LIST_TAG = 92;
    public static final int FULL_NAME_TAG = 24334;
    public static final int OTHER_NAME_TAG = 24335;
    public static final int PERSONAL_NUMBER_TAG = 24336;
    public static final int FULL_DATE_OF_BIRTH_TAG = 24363;
    public static final int PLACE_OF_BIRTH_TAG = 24337;
    public static final int PERMANENT_ADDRESS_TAG = 24386;
    public static final int TELEPHONE_TAG = 24338;
    public static final int PROFESSION_TAG = 24339;
    public static final int TITLE_TAG = 24340;
    public static final int PERSONAL_SUMMARY_TAG = 24341;
    public static final int PROOF_OF_CITIZENSHIP_TAG = 24342;
    public static final int OTHER_VALID_TD_NUMBERS_TAG = 24343;
    public static final int CUSTODY_INFORMATION_TAG = 24344;
    public static final int CONTENT_SPECIFIC_CONSTRUCTED_TAG = 160;
    public static final int COUNT_TAG = 2;
    private static final String SDF = "yyyyMMdd";
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    private String nameOfHolder;
    private List<String> otherNames;
    private String personalNumber;
    private String fullDateOfBirth;
    private List<String> placeOfBirth;
    private List<String> permanentAddress;
    private String telephone;
    private String profession;
    private String title;
    private String personalSummary;
    private byte[] proofOfCitizenship;
    private List<String> otherValidTDNumbers;
    private String custodyInformation;
    private List<Integer> tagPresenceList;

    public DG11File(InputStream inputStream) throws IOException {
        super(107, inputStream);
    }

    public DG11File(String nameOfHolder, List<String> otherNames, String personalNumber, Date fullDateOfBirth, List<String> placeOfBirth, List<String> permanentAddress, String telephone, String profession, String title, String personalSummary, byte[] proofOfCitizenship, List<String> otherValidTDNumbers, String custodyInformation) {
        this(nameOfHolder, otherNames, personalNumber, new SimpleDateFormat(SDF).format(fullDateOfBirth), placeOfBirth, permanentAddress, telephone, profession, title, personalSummary, proofOfCitizenship, otherValidTDNumbers, custodyInformation);
    }

    public DG11File(String nameOfHolder, List<String> otherNames, String personalNumber, String fullDateOfBirth, List<String> placeOfBirth, List<String> permanentAddress, String telephone, String profession, String title, String personalSummary, byte[] proofOfCitizenship, List<String> otherValidTDNumbers, String custodyInformation) {
        super(107);
        this.nameOfHolder = nameOfHolder;
        this.otherNames = otherNames == null ? new ArrayList<String>() : new ArrayList<String>(otherNames);
        this.personalNumber = personalNumber;
        this.fullDateOfBirth = fullDateOfBirth;
        this.placeOfBirth = placeOfBirth == null ? new ArrayList<String>() : new ArrayList<String>(placeOfBirth);
        this.permanentAddress = permanentAddress;
        this.telephone = telephone;
        this.profession = profession;
        this.title = title;
        this.personalSummary = personalSummary;
        this.proofOfCitizenship = proofOfCitizenship;
        this.otherValidTDNumbers = otherValidTDNumbers == null ? new ArrayList<String>() : new ArrayList<String>(otherValidTDNumbers);
        this.custodyInformation = custodyInformation;
    }

    @Override
    public int getTag() {
        return 107;
    }

    public List<Integer> getTagPresenceList() {
        if (this.tagPresenceList != null) {
            return this.tagPresenceList;
        }
        this.tagPresenceList = new ArrayList<Integer>(12);
        if (this.nameOfHolder != null) {
            this.tagPresenceList.add(24334);
        }
        if (this.otherNames != null && !this.otherNames.isEmpty()) {
            this.tagPresenceList.add(24335);
        }
        if (this.personalNumber != null) {
            this.tagPresenceList.add(24336);
        }
        if (this.fullDateOfBirth != null) {
            this.tagPresenceList.add(24363);
        }
        if (this.placeOfBirth != null && !this.placeOfBirth.isEmpty()) {
            this.tagPresenceList.add(24337);
        }
        if (this.permanentAddress != null && !this.permanentAddress.isEmpty()) {
            this.tagPresenceList.add(24386);
        }
        if (this.telephone != null) {
            this.tagPresenceList.add(24338);
        }
        if (this.profession != null) {
            this.tagPresenceList.add(24339);
        }
        if (this.title != null) {
            this.tagPresenceList.add(24340);
        }
        if (this.personalSummary != null) {
            this.tagPresenceList.add(24341);
        }
        if (this.proofOfCitizenship != null) {
            this.tagPresenceList.add(24342);
        }
        if (this.otherValidTDNumbers != null && !this.otherValidTDNumbers.isEmpty()) {
            this.tagPresenceList.add(24343);
        }
        if (this.custodyInformation != null) {
            this.tagPresenceList.add(24344);
        }
        return this.tagPresenceList;
    }

    public String getNameOfHolder() {
        return this.nameOfHolder;
    }

    public List<String> getOtherNames() {
        return this.otherNames == null ? new ArrayList<String>() : new ArrayList<String>(this.otherNames);
    }

    public String getPersonalNumber() {
        return this.personalNumber;
    }

    public String getFullDateOfBirth() {
        return this.fullDateOfBirth;
    }

    public List<String> getPlaceOfBirth() {
        return this.placeOfBirth;
    }

    public List<String> getPermanentAddress() {
        return this.permanentAddress;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public String getProfession() {
        return this.profession;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPersonalSummary() {
        return this.personalSummary;
    }

    public byte[] getProofOfCitizenship() {
        return this.proofOfCitizenship;
    }

    public List<String> getOtherValidTDNumbers() {
        return this.otherValidTDNumbers;
    }

    public String getCustodyInformation() {
        return this.custodyInformation;
    }

    @Override
    public String toString() {
        return "DG11File [" + (this.nameOfHolder == null ? "" : this.nameOfHolder) + ", " + (this.otherNames == null || this.otherNames.isEmpty() ? "[]" : this.otherNames) + ", " + (this.personalNumber == null ? "" : this.personalNumber) + ", " + (this.fullDateOfBirth == null ? "" : this.fullDateOfBirth) + ", " + (this.placeOfBirth == null || this.placeOfBirth.isEmpty() ? "[]" : this.placeOfBirth.toString()) + ", " + (this.permanentAddress == null || this.permanentAddress.isEmpty() ? "[]" : this.permanentAddress.toString()) + ", " + (this.telephone == null ? "" : this.telephone) + ", " + (this.profession == null ? "" : this.profession) + ", " + (this.title == null ? "" : this.title) + ", " + (this.personalSummary == null ? "" : this.personalSummary) + ", " + (this.proofOfCitizenship == null ? "" : "image (" + this.proofOfCitizenship.length + ")") + ", " + (this.otherValidTDNumbers == null || this.otherValidTDNumbers.isEmpty() ? "[]" : this.otherValidTDNumbers.toString()) + ", " + (this.custodyInformation == null ? "" : this.custodyInformation) + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        DG11File other = (DG11File)obj;
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        return 13 * this.toString().hashCode() + 111;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readContent(InputStream inputStream) throws IOException {
        TLVInputStream tlvInputStream = inputStream instanceof TLVInputStream ? (TLVInputStream)inputStream : new TLVInputStream(inputStream);
        int tagListTag = tlvInputStream.readTag();
        if (tagListTag != 92) {
            throw new IllegalArgumentException("Expected tag list in DG11");
        }
        int tagListLength = tlvInputStream.readLength();
        int expectedTagCount = tagListLength / 2;
        try (ByteArrayInputStream tagListBytesInputStream = new ByteArrayInputStream(tlvInputStream.readValue());){
            int tag;
            ArrayList<Integer> tagList = new ArrayList<Integer>(expectedTagCount + 1);
            for (int tagListBytesRead = 0; tagListBytesRead < tagListLength; tagListBytesRead += TLVUtil.getTagLength((int)tag)) {
                TLVInputStream anotherTLVInputStream = new TLVInputStream((InputStream)tagListBytesInputStream);
                tag = anotherTLVInputStream.readTag();
                tagList.add(tag);
            }
            Iterator iterator = tagList.iterator();
            while (iterator.hasNext()) {
                int t = (Integer)iterator.next();
                this.readField(t, tlvInputStream);
            }
        }
    }

    @Override
    protected void writeContent(OutputStream out) throws IOException {
        TLVOutputStream tlvOut = out instanceof TLVOutputStream ? (TLVOutputStream)out : new TLVOutputStream(out);
        tlvOut.writeTag(92);
        DataOutputStream dataOut = new DataOutputStream((OutputStream)tlvOut);
        List<Integer> tags = this.getTagPresenceList();
        for (int tag : tags) {
            dataOut.writeShort(tag);
        }
        dataOut.flush();
        tlvOut.writeValueEnd();
        block16: for (int tag : tags) {
            switch (tag) {
                case 24334: {
                    tlvOut.writeTag(tag);
                    tlvOut.writeValue(this.nameOfHolder.trim().getBytes(StandardCharsets.UTF_8));
                    continue block16;
                }
                case 24335: {
                    if (this.otherNames == null) {
                        this.otherNames = new ArrayList<String>();
                    }
                    tlvOut.writeTag(160);
                    tlvOut.writeTag(2);
                    tlvOut.write(this.otherNames.size());
                    tlvOut.writeValueEnd();
                    for (String otherName : this.otherNames) {
                        tlvOut.writeTag(24335);
                        tlvOut.writeValue(otherName.trim().getBytes(StandardCharsets.UTF_8));
                    }
                    tlvOut.writeValueEnd();
                    continue block16;
                }
                case 24336: {
                    tlvOut.writeTag(tag);
                    tlvOut.writeValue(this.personalNumber.trim().getBytes(StandardCharsets.UTF_8));
                    continue block16;
                }
                case 24363: {
                    tlvOut.writeTag(tag);
                    String fullDateOfBirthString = this.fullDateOfBirth;
                    tlvOut.writeValue(fullDateOfBirthString.getBytes(StandardCharsets.UTF_8));
                    continue block16;
                }
                case 24337: {
                    tlvOut.writeTag(tag);
                    boolean isFirstOne = true;
                    for (String detail : this.placeOfBirth) {
                        if (detail == null) continue;
                        if (isFirstOne) {
                            isFirstOne = false;
                        } else {
                            tlvOut.write(60);
                        }
                        tlvOut.write(detail.trim().getBytes(StandardCharsets.UTF_8));
                    }
                    tlvOut.writeValueEnd();
                    continue block16;
                }
                case 24386: {
                    tlvOut.writeTag(tag);
                    boolean isFirstOne = true;
                    for (String detail : this.permanentAddress) {
                        if (detail == null) continue;
                        if (isFirstOne) {
                            isFirstOne = false;
                        } else {
                            tlvOut.write(60);
                        }
                        tlvOut.write(detail.trim().getBytes(StandardCharsets.UTF_8));
                    }
                    tlvOut.writeValueEnd();
                    continue block16;
                }
                case 24338: {
                    tlvOut.writeTag(tag);
                    tlvOut.writeValue(this.telephone.trim().replace(' ', '<').getBytes(StandardCharsets.UTF_8));
                    continue block16;
                }
                case 24339: {
                    tlvOut.writeTag(tag);
                    tlvOut.writeValue(this.profession.trim().replace(' ', '<').getBytes(StandardCharsets.UTF_8));
                    continue block16;
                }
                case 24340: {
                    tlvOut.writeTag(tag);
                    tlvOut.writeValue(this.title.trim().replace(' ', '<').getBytes(StandardCharsets.UTF_8));
                    continue block16;
                }
                case 24341: {
                    tlvOut.writeTag(tag);
                    tlvOut.writeValue(this.personalSummary.trim().replace(' ', '<').getBytes(StandardCharsets.UTF_8));
                    continue block16;
                }
                case 24342: {
                    tlvOut.writeTag(tag);
                    tlvOut.writeValue(this.proofOfCitizenship);
                    continue block16;
                }
                case 24343: {
                    tlvOut.writeTag(tag);
                    boolean isFirstOne = true;
                    for (String detail : this.otherValidTDNumbers) {
                        if (detail == null) continue;
                        if (isFirstOne) {
                            isFirstOne = false;
                        } else {
                            tlvOut.write(60);
                        }
                        tlvOut.write(detail.trim().replace(' ', '<').getBytes(StandardCharsets.UTF_8));
                    }
                    tlvOut.writeValueEnd();
                    continue block16;
                }
                case 24344: {
                    tlvOut.writeTag(tag);
                    tlvOut.writeValue(this.custodyInformation.trim().replace(' ', '<').getBytes(StandardCharsets.UTF_8));
                    continue block16;
                }
            }
            throw new IllegalStateException("Unknown tag in DG11: " + Integer.toHexString(tag));
        }
    }

    private void parseCustodyInformation(byte[] value) {
        String field = new String(value, StandardCharsets.UTF_8);
        this.custodyInformation = field.trim();
    }

    private void parseOtherValidTDNumbers(byte[] value) {
        String field = new String(value).trim();
        field = new String(value, StandardCharsets.UTF_8);
        this.otherValidTDNumbers = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(field, "<");
        while (st.hasMoreTokens()) {
            String number = st.nextToken().trim();
            this.otherValidTDNumbers.add(number);
        }
    }

    private void parseProofOfCitizenShip(byte[] value) {
        this.proofOfCitizenship = value;
    }

    private void parsePersonalSummary(byte[] value) {
        String field = new String(value, StandardCharsets.UTF_8);
        this.personalSummary = field.trim();
    }

    private void parseTitle(byte[] value) {
        String field = new String(value, StandardCharsets.UTF_8);
        this.title = field.trim();
    }

    private void parseProfession(byte[] value) {
        String field = new String(value);
        field = new String(value, StandardCharsets.UTF_8);
        this.profession = field.trim();
    }

    private void parseTelephone(byte[] value) {
        String field = new String(value);
        field = new String(value, StandardCharsets.UTF_8);
        this.telephone = field.replace("<", " ").trim();
    }

    private void parsePermanentAddress(byte[] value) {
        String field = new String(value);
        field = new String(value, StandardCharsets.UTF_8);
        StringTokenizer st = new StringTokenizer(field, "<");
        this.permanentAddress = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String line = st.nextToken().trim();
            this.permanentAddress.add(line);
        }
    }

    private void parsePlaceOfBirth(byte[] value) {
        String field = new String(value);
        field = new String(value, StandardCharsets.UTF_8);
        StringTokenizer st = new StringTokenizer(field, "<");
        this.placeOfBirth = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String line = st.nextToken().trim();
            this.placeOfBirth.add(line);
        }
    }

    private void parseFullDateOfBirth(byte[] value) {
        String field = null;
        if (value.length == 4) {
            field = Hex.bytesToHexString((byte[])value);
        } else {
            field = new String(value);
            field = new String(value, StandardCharsets.UTF_8);
        }
        this.fullDateOfBirth = field;
    }

    private synchronized void parseOtherName(byte[] value) {
        if (this.otherNames == null) {
            this.otherNames = new ArrayList<String>();
        }
        String field = new String(value, StandardCharsets.UTF_8);
        this.otherNames.add(field.trim());
    }

    private void parsePersonalNumber(byte[] value) {
        String field = new String(value);
        field = new String(value, StandardCharsets.UTF_8);
        this.personalNumber = field.trim();
    }

    private void parseNameOfHolder(byte[] value) {
        String field = new String(value);
        field = new String(value, StandardCharsets.UTF_8);
        this.nameOfHolder = field.trim();
    }

    private void readField(int expectedFieldTag, TLVInputStream tlvInputStream) throws IOException {
        int tag = tlvInputStream.readTag();
        if (tag == 160) {
            tlvInputStream.readLength();
            int countTag = tlvInputStream.readTag();
            if (countTag != 2) {
                throw new IllegalArgumentException("Expected " + Integer.toHexString(2) + ", found " + Integer.toHexString(countTag));
            }
            int countLength = tlvInputStream.readLength();
            if (countLength != 1) {
                throw new IllegalArgumentException("Expected length 1 count length, found " + countLength);
            }
            byte[] countValue = tlvInputStream.readValue();
            if (countValue == null || countValue.length != 1) {
                throw new IllegalArgumentException("Number of content specific fields should be encoded in single byte, found " + Arrays.toString(countValue));
            }
            int count = countValue[0] & 0xFF;
            for (int i = 0; i < count; ++i) {
                tag = tlvInputStream.readTag();
                if (tag != 24335) {
                    throw new IllegalArgumentException("Expected " + Integer.toHexString(24335) + ", found " + Integer.toHexString(tag));
                }
                tlvInputStream.readLength();
                byte[] value = tlvInputStream.readValue();
                this.parseOtherName(value);
            }
        } else {
            if (tag != expectedFieldTag) {
                throw new IllegalArgumentException("Expected " + Integer.toHexString(expectedFieldTag) + ", but found " + Integer.toHexString(tag));
            }
            tlvInputStream.readLength();
            byte[] value = tlvInputStream.readValue();
            switch (tag) {
                case 24334: {
                    this.parseNameOfHolder(value);
                    break;
                }
                case 24335: {
                    this.parseOtherName(value);
                    break;
                }
                case 24336: {
                    this.parsePersonalNumber(value);
                    break;
                }
                case 24363: {
                    this.parseFullDateOfBirth(value);
                    break;
                }
                case 24337: {
                    this.parsePlaceOfBirth(value);
                    break;
                }
                case 24386: {
                    this.parsePermanentAddress(value);
                    break;
                }
                case 24338: {
                    this.parseTelephone(value);
                    break;
                }
                case 24339: {
                    this.parseProfession(value);
                    break;
                }
                case 24340: {
                    this.parseTitle(value);
                    break;
                }
                case 24341: {
                    this.parsePersonalSummary(value);
                    break;
                }
                case 24342: {
                    this.parseProofOfCitizenShip(value);
                    break;
                }
                case 24343: {
                    this.parseOtherValidTDNumbers(value);
                    break;
                }
                case 24344: {
                    this.parseCustodyInformation(value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown field tag in DG11: " + Integer.toHexString(tag));
                }
            }
        }
    }
}

