/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.lds.icao;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.BiometricDataBlockDecoder;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.BiometricDataBlockEncoder;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.CBEFFInfo;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.ComplexCBEFFInfo;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.ISO781611Decoder;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.ISO781611Encoder;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.SimpleCBEFFInfo;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.StandardBiometricHeader;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.CBEFFDataGroup;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.iso19794.IrisInfo;

public class DG4File
extends CBEFFDataGroup<IrisInfo> {
    private static final long serialVersionUID = -1290365855823447586L;
    private static final ISO781611Decoder DECODER = new ISO781611Decoder(new BiometricDataBlockDecoder<IrisInfo>(){

        @Override
        public IrisInfo decode(InputStream inputStream, StandardBiometricHeader sbh, int index, int length) throws IOException {
            return new IrisInfo(sbh, inputStream);
        }
    });
    private static final ISO781611Encoder<IrisInfo> ENCODER = new ISO781611Encoder<IrisInfo>(new BiometricDataBlockEncoder<IrisInfo>(){

        @Override
        public void encode(IrisInfo info, OutputStream outputStream) throws IOException {
            info.writeObject(outputStream);
        }
    });
    private boolean shouldAddRandomDataIfEmpty;

    public DG4File(List<IrisInfo> irisInfos) {
        this(irisInfos, true);
    }

    public DG4File(List<IrisInfo> irisInfos, boolean shouldAddRandomDataIfEmpty) {
        super(118, irisInfos);
        this.shouldAddRandomDataIfEmpty = shouldAddRandomDataIfEmpty;
    }

    public DG4File(InputStream inputStream) throws IOException {
        super(118, inputStream);
    }

    @Override
    protected void readContent(InputStream inputStream) throws IOException {
        ComplexCBEFFInfo cbeffInfo = DECODER.decode(inputStream);
        List<CBEFFInfo> records = cbeffInfo.getSubRecords();
        for (CBEFFInfo record : records) {
            if (!(record instanceof SimpleCBEFFInfo)) {
                throw new IOException("Was expecting a SimpleCBEFFInfo, found " + record.getClass().getSimpleName());
            }
            Object bdb = ((SimpleCBEFFInfo)record).getBiometricDataBlock();
            if (!(bdb instanceof IrisInfo)) {
                throw new IOException("Was expecting an IrisInfo, found " + bdb.getClass().getSimpleName());
            }
            this.add((IrisInfo)bdb);
        }
    }

    @Override
    protected void writeContent(OutputStream outputStream) throws IOException {
        ComplexCBEFFInfo cbeffInfo = new ComplexCBEFFInfo();
        List irisInfos = this.getSubRecords();
        for (IrisInfo irisInfo : irisInfos) {
            SimpleCBEFFInfo<IrisInfo> simpleCBEFFInfo = new SimpleCBEFFInfo<IrisInfo>(irisInfo);
            cbeffInfo.add(simpleCBEFFInfo);
        }
        ENCODER.encode(cbeffInfo, outputStream);
        if (this.shouldAddRandomDataIfEmpty) {
            this.writeOptionalRandomData(outputStream);
        }
    }

    @Override
    public String toString() {
        return "DG4File [" + super.toString() + "]";
    }

    public List<IrisInfo> getIrisInfos() {
        return this.getSubRecords();
    }

    public void addIrisInfo(IrisInfo irisInfo) {
        this.add(irisInfo);
    }

    public void removeIrisInfo(int index) {
        this.remove(index);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.shouldAddRandomDataIfEmpty ? 1231 : 1237);
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DG4File other = (DG4File)obj;
        return this.shouldAddRandomDataIfEmpty == other.shouldAddRandomDataIfEmpty;
    }
}

