/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.lds.icao;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.AbstractLDSInfo;
import net.sf.scuba.data.Gender;

public class MRZInfo
extends AbstractLDSInfo {
    private static final long serialVersionUID = 7054965914471297804L;
    public static final int DOC_TYPE_UNSPECIFIED = 0;
    public static final int DOC_TYPE_ID1 = 1;
    public static final int DOC_TYPE_ID2 = 2;
    public static final int DOC_TYPE_ID3 = 3;
    private static final String MRZ_CHARS = "<0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    @Deprecated
    private int documentType;
    private String documentCode;
    private String issuingState;
    private String primaryIdentifier;
    private String secondaryIdentifier;
    private String nationality;
    private String documentNumber;
    private String dateOfBirth;
    private Gender gender;
    private String dateOfExpiry;
    private char documentNumberCheckDigit;
    private char dateOfBirthCheckDigit;
    private char dateOfExpiryCheckDigit;
    private char compositeCheckDigit;
    private String optionalData1;
    private String optionalData2;

    public MRZInfo(String documentCode, String issuingState, String primaryIdentifier, String secondaryIdentifier, String documentNumber, String nationality, String dateOfBirth, Gender gender, String dateOfExpiry, String personalNumber) {
        if (documentCode == null || documentCode.length() < 1 || documentCode.length() > 2 || !documentCode.startsWith("P") && !documentCode.startsWith("V")) {
            throw new IllegalArgumentException("Wrong document code: " + documentCode);
        }
        this.documentType = MRZInfo.getDocumentTypeFromDocumentCode(documentCode);
        this.documentCode = MRZInfo.trimFillerChars(documentCode);
        this.issuingState = issuingState;
        this.primaryIdentifier = primaryIdentifier;
        this.secondaryIdentifier = secondaryIdentifier;
        this.documentNumber = MRZInfo.trimFillerChars(documentNumber);
        this.nationality = nationality;
        this.dateOfBirth = dateOfBirth;
        this.gender = gender;
        this.dateOfExpiry = dateOfExpiry;
        if (personalNumber == null || MRZInfo.equalsModuloFillerChars(personalNumber, "")) {
            this.optionalData1 = "";
        } else if (personalNumber.length() == 15) {
            this.optionalData1 = personalNumber;
        } else if (personalNumber.length() <= 14) {
            this.optionalData1 = MRZInfo.mrzFormat(personalNumber, 14) + MRZInfo.checkDigit(personalNumber, true);
        } else {
            throw new IllegalArgumentException("Wrong personal number: " + personalNumber);
        }
        this.checkDigit();
    }

    public MRZInfo(String documentCode, String issuingState, String documentNumber, String optionalData1, String dateOfBirth, Gender gender, String dateOfExpiry, String nationality, String optionalData2, String primaryIdentifier, String secondaryIdentifier) {
        if (documentCode == null || documentCode.length() < 1 || documentCode.length() > 2 || !documentCode.startsWith("C") && !documentCode.startsWith("I") && !documentCode.startsWith("A")) {
            throw new IllegalArgumentException("Wrong document code: " + documentCode);
        }
        this.documentType = MRZInfo.getDocumentTypeFromDocumentCode(documentCode);
        this.documentCode = MRZInfo.trimFillerChars(documentCode);
        this.issuingState = issuingState;
        this.primaryIdentifier = primaryIdentifier;
        this.secondaryIdentifier = secondaryIdentifier;
        this.documentNumber = MRZInfo.trimFillerChars(documentNumber);
        this.nationality = nationality;
        this.dateOfBirth = dateOfBirth;
        this.gender = gender;
        this.dateOfExpiry = dateOfExpiry;
        if (optionalData1 == null || optionalData1.length() > 15) {
            throw new IllegalArgumentException("Wrong optional data 1: " + (optionalData1 == null ? "null" : "\"" + optionalData1 + "\""));
        }
        this.optionalData1 = optionalData1;
        this.optionalData2 = optionalData2;
        this.checkDigit();
    }

    public MRZInfo(InputStream inputStream, int length) {
        try {
            this.readObject(inputStream, length);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
    }

    public MRZInfo(String str) {
        if (str == null) {
            throw new IllegalArgumentException("Null string");
        }
        str = str.trim().replace("\n", "");
        try {
            this.readObject(new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8)), str.length());
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException("Exception", uee);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Exception", ioe);
        }
    }

    private void readObject(InputStream inputStream, int length) throws IOException {
        DataInputStream dataIn = new DataInputStream(inputStream);
        this.documentCode = this.readStringWithFillers(dataIn, 2);
        this.documentType = MRZInfo.getDocumentTypeFromDocumentCode(this.documentCode);
        switch (length) {
            case 88: {
                this.documentType = 3;
                break;
            }
            case 90: {
                this.documentType = 1;
                break;
            }
            default: {
                this.documentType = MRZInfo.getDocumentTypeFromDocumentCode(this.documentCode);
            }
        }
        if (this.documentType == 1) {
            this.issuingState = this.readCountry(dataIn);
            this.documentNumber = this.readString(dataIn, 9);
            this.documentNumberCheckDigit = (char)dataIn.readUnsignedByte();
            this.optionalData1 = this.readStringWithFillers(dataIn, 15);
            if (this.documentNumberCheckDigit == '<') {
                this.documentNumber = this.documentNumber + this.optionalData1.substring(0, this.optionalData1.length() - 1);
                this.documentNumberCheckDigit = this.optionalData1.charAt(this.optionalData1.length() - 1);
                this.optionalData1 = null;
            }
            this.documentNumber = MRZInfo.trimFillerChars(this.documentNumber);
            this.dateOfBirth = this.readDateOfBirth(dataIn);
            this.dateOfBirthCheckDigit = (char)dataIn.readUnsignedByte();
            this.gender = this.readGender(dataIn);
            this.dateOfExpiry = this.readDateOfExpiry(dataIn);
            this.dateOfExpiryCheckDigit = (char)dataIn.readUnsignedByte();
            this.nationality = this.readCountry(dataIn);
            this.optionalData2 = this.readString(dataIn, 11);
            this.compositeCheckDigit = (char)dataIn.readUnsignedByte();
            this.readNameIdentifiers(this.readString(dataIn, 30));
        } else {
            this.issuingState = this.readCountry(dataIn);
            this.readNameIdentifiers(this.readString(dataIn, 39));
            this.documentNumber = MRZInfo.trimFillerChars(this.readString(dataIn, 9));
            this.documentNumberCheckDigit = (char)dataIn.readUnsignedByte();
            this.nationality = this.readCountry(dataIn);
            this.dateOfBirth = this.readDateOfBirth(dataIn);
            this.dateOfBirthCheckDigit = (char)dataIn.readUnsignedByte();
            this.gender = this.readGender(dataIn);
            this.dateOfExpiry = this.readDateOfExpiry(dataIn);
            this.dateOfExpiryCheckDigit = (char)dataIn.readUnsignedByte();
            String personalNumber = this.readStringWithFillers(dataIn, 14);
            char personalNumberCheckDigit = (char)dataIn.readUnsignedByte();
            this.optionalData1 = MRZInfo.mrzFormat(personalNumber, 14) + personalNumberCheckDigit;
            this.compositeCheckDigit = (char)dataIn.readUnsignedByte();
        }
    }

    @Override
    public void writeObject(OutputStream outputStream) throws IOException {
        DataOutputStream dataOut = new DataOutputStream(outputStream);
        this.writeDocumentType(dataOut);
        if (this.documentType == 1) {
            this.writeIssuingState(dataOut);
            if (this.documentNumber.length() > 9 && MRZInfo.equalsModuloFillerChars(this.optionalData1, "")) {
                this.writeString(this.documentNumber.substring(0, 9), dataOut, 9);
                dataOut.write(60);
                this.writeString(this.documentNumber.substring(9) + this.documentNumberCheckDigit + "<", dataOut, 15);
            } else {
                this.writeString(this.documentNumber, dataOut, 9);
                dataOut.write(this.documentNumberCheckDigit);
                this.writeString(this.optionalData1, dataOut, 15);
            }
            this.writeDateOfBirth(dataOut);
            dataOut.write(this.dateOfBirthCheckDigit);
            this.writeGender(dataOut);
            this.writeDateOfExpiry(dataOut);
            dataOut.write(this.dateOfExpiryCheckDigit);
            this.writeNationality(dataOut);
            this.writeString(this.optionalData2, dataOut, 11);
            dataOut.write(this.compositeCheckDigit);
            this.writeName(dataOut, 30);
        } else {
            this.writeIssuingState(dataOut);
            this.writeName(dataOut, 39);
            this.writeString(this.documentNumber, dataOut, 9);
            dataOut.write(this.documentNumberCheckDigit);
            this.writeNationality(dataOut);
            this.writeDateOfBirth(dataOut);
            dataOut.write(this.dateOfBirthCheckDigit);
            this.writeGender(dataOut);
            this.writeDateOfExpiry(dataOut);
            dataOut.write(this.dateOfExpiryCheckDigit);
            this.writeString(this.optionalData1, dataOut, 15);
            dataOut.write(this.compositeCheckDigit);
        }
    }

    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        this.checkDigit();
    }

    public String getDateOfExpiry() {
        return this.dateOfExpiry;
    }

    public void setDateOfExpiry(String dateOfExpiry) {
        this.dateOfExpiry = dateOfExpiry;
        this.checkDigit();
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber.trim();
        this.checkDigit();
    }

    public int getDocumentType() {
        return this.documentType;
    }

    public String getDocumentCode() {
        return this.documentCode;
    }

    public void setDocumentCode(String documentCode) {
        this.documentCode = documentCode;
        this.documentType = MRZInfo.getDocumentTypeFromDocumentCode(documentCode);
        if (this.documentType == 1 && this.optionalData2 == null) {
            this.optionalData2 = "";
        }
    }

    public String getIssuingState() {
        return this.issuingState;
    }

    public void setIssuingState(String issuingState) {
        this.issuingState = issuingState;
        this.checkDigit();
    }

    public String getPrimaryIdentifier() {
        return this.primaryIdentifier;
    }

    public void setPrimaryIdentifier(String primaryIdentifier) {
        this.primaryIdentifier = primaryIdentifier.trim();
        this.checkDigit();
    }

    public String getSecondaryIdentifier() {
        return this.secondaryIdentifier;
    }

    public String[] getSecondaryIdentifierComponents() {
        return this.secondaryIdentifier.split(" |<");
    }

    public void setSecondaryIdentifierComponents(String[] secondaryIdentifiers) {
        if (secondaryIdentifiers == null) {
            this.secondaryIdentifier = null;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < secondaryIdentifiers.length; ++i) {
                stringBuilder.append(secondaryIdentifiers[i]);
                if (i >= secondaryIdentifiers.length - 1) continue;
                stringBuilder.append('<');
            }
        }
        this.checkDigit();
    }

    public void setSecondaryIdentifiers(String secondaryIdentifiers) {
        this.readSecondaryIdentifiers(secondaryIdentifiers.trim());
        this.checkDigit();
    }

    public String getNationality() {
        return this.nationality;
    }

    public void setNationality(String nationality) {
        this.nationality = nationality;
        this.checkDigit();
    }

    public String getPersonalNumber() {
        if (this.optionalData1 == null) {
            return null;
        }
        if (this.optionalData1.length() > 14) {
            return MRZInfo.trimFillerChars(this.optionalData1.substring(0, 14));
        }
        return MRZInfo.trimFillerChars(this.optionalData1);
    }

    public void setPersonalNumber(String personalNumber) {
        if (personalNumber == null || personalNumber.length() > 14) {
            throw new IllegalArgumentException("Wrong personal number");
        }
        this.optionalData1 = MRZInfo.mrzFormat(personalNumber, 14) + MRZInfo.checkDigit(personalNumber, true);
    }

    public String getOptionalData1() {
        return this.optionalData1;
    }

    public String getOptionalData2() {
        return this.optionalData2;
    }

    public void setOptionalData2(String optionalData2) {
        this.optionalData2 = MRZInfo.trimFillerChars(optionalData2);
        this.checkDigit();
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
        this.checkDigit();
    }

    public String toString() {
        String str = new String(this.getEncoded(), StandardCharsets.UTF_8);
        switch (str.length()) {
            case 90: {
                return str.substring(0, 30) + "\n" + str.substring(30, 60) + "\n" + str.substring(60, 90) + "\n";
            }
            case 88: {
                return str.substring(0, 44) + "\n" + str.substring(44, 88) + "\n";
            }
        }
        return str;
    }

    public int hashCode() {
        return 2 * this.toString().hashCode() + 53;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        MRZInfo other = (MRZInfo)obj;
        return (this.documentCode == null && other.documentCode == null || this.documentCode != null && this.documentCode.equals(other.documentCode)) && (this.issuingState == null && other.issuingState == null || this.issuingState != null && this.issuingState.equals(other.issuingState)) && (this.primaryIdentifier == null && other.primaryIdentifier == null || this.primaryIdentifier != null && this.primaryIdentifier.equals(other.primaryIdentifier)) && (this.secondaryIdentifier == null && other.secondaryIdentifier == null || MRZInfo.equalsModuloFillerChars(this.secondaryIdentifier, other.secondaryIdentifier)) && (this.nationality == null && other.nationality == null || this.nationality != null && this.nationality.equals(other.nationality)) && (this.documentNumber == null && other.documentNumber == null || this.documentNumber != null && this.documentNumber.equals(other.documentNumber)) && (this.optionalData1 == null && other.optionalData1 == null || this.optionalData1 != null && this.optionalData1.equals(other.optionalData1) || this.getPersonalNumber().equals(other.getPersonalNumber())) && (this.dateOfBirth == null && other.dateOfBirth == null || this.dateOfBirth != null && this.dateOfBirth.equals(other.dateOfBirth)) && (this.gender == null && other.gender == null || this.gender != null && this.gender.equals((Object)other.gender)) && (this.dateOfExpiry == null && other.dateOfExpiry == null || this.dateOfExpiry != null && this.dateOfExpiry.equals(other.dateOfExpiry)) && (this.optionalData2 == null && other.optionalData2 == null || this.optionalData2 != null && MRZInfo.equalsModuloFillerChars(this.optionalData2, other.optionalData2));
    }

    public static char checkDigit(String str) {
        return MRZInfo.checkDigit(str, false);
    }

    private void readNameIdentifiers(String mrzNameString) {
        int delimIndex = mrzNameString.indexOf("<<");
        if (delimIndex < 0) {
            this.primaryIdentifier = MRZInfo.trimFillerChars(mrzNameString);
            this.secondaryIdentifier = "";
            return;
        }
        this.primaryIdentifier = MRZInfo.trimFillerChars(mrzNameString.substring(0, delimIndex));
        String rest = mrzNameString.substring(mrzNameString.indexOf("<<") + 2);
        this.readSecondaryIdentifiers(rest);
    }

    private void readSecondaryIdentifiers(String secondaryIdentifier) {
        this.secondaryIdentifier = secondaryIdentifier;
    }

    private void writeString(String string2, DataOutputStream dataOutputStream, int width) throws IOException {
        dataOutputStream.write(MRZInfo.mrzFormat(string2, width).getBytes(StandardCharsets.UTF_8));
    }

    private void writeIssuingState(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(this.issuingState.getBytes(StandardCharsets.UTF_8));
    }

    private void writeDateOfExpiry(DataOutputStream dateOutputStream) throws IOException {
        dateOutputStream.write(this.dateOfExpiry.getBytes(StandardCharsets.UTF_8));
    }

    private void writeGender(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(MRZInfo.genderToString(this.gender).getBytes(StandardCharsets.UTF_8));
    }

    private void writeDateOfBirth(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(this.dateOfBirth.getBytes(StandardCharsets.UTF_8));
    }

    private void writeNationality(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(this.nationality.getBytes(StandardCharsets.UTF_8));
    }

    private void writeName(DataOutputStream dataOutputStream, int width) throws IOException {
        dataOutputStream.write(MRZInfo.nameToString(this.primaryIdentifier, this.secondaryIdentifier, width).getBytes(StandardCharsets.UTF_8));
    }

    private void writeDocumentType(DataOutputStream dataOutputStream) throws IOException {
        this.writeString(this.documentCode, dataOutputStream, 2);
    }

    private static String genderToString(Gender gender) {
        switch (gender) {
            case MALE: {
                return "M";
            }
            case FEMALE: {
                return "F";
            }
        }
        return "<";
    }

    private static String nameToString(String primaryIdentifier, String secondaryIdentifier, int width) {
        String[] primaryComponents = primaryIdentifier.split(" |<");
        String[] secondaryComponents = secondaryIdentifier == null || secondaryIdentifier.trim().isEmpty() ? new String[]{} : secondaryIdentifier.split(" |<");
        StringBuilder name = new StringBuilder();
        boolean isFirstPrimaryComponent = true;
        for (String primaryComponent : primaryComponents) {
            if (isFirstPrimaryComponent) {
                isFirstPrimaryComponent = false;
            } else {
                name.append('<');
            }
            name.append(primaryComponent);
        }
        if (secondaryIdentifier != null && !secondaryIdentifier.trim().isEmpty()) {
            name.append("<<");
            boolean isFirstSecondaryComponent = true;
            for (String secondaryComponent : secondaryComponents) {
                if (isFirstSecondaryComponent) {
                    isFirstSecondaryComponent = false;
                } else {
                    name.append('<');
                }
                name.append(secondaryComponent);
            }
        }
        return MRZInfo.mrzFormat(name.toString(), width);
    }

    private String readStringWithFillers(DataInputStream inputStream, int count) throws IOException {
        return MRZInfo.trimFillerChars(this.readString(inputStream, count));
    }

    private String readCountry(DataInputStream inputStream) throws IOException {
        return this.readString(inputStream, 3);
    }

    private Gender readGender(DataInputStream inputStream) throws IOException {
        String genderStr = this.readString(inputStream, 1);
        if ("M".equalsIgnoreCase(genderStr)) {
            return Gender.MALE;
        }
        if ("F".equalsIgnoreCase(genderStr)) {
            return Gender.FEMALE;
        }
        return Gender.UNKNOWN;
    }

    private String readDateOfBirth(DataInputStream inputStream) throws IOException, NumberFormatException {
        return this.readString(inputStream, 6);
    }

    private String readDateOfExpiry(DataInputStream inputStream) throws IOException {
        return this.readString(inputStream, 6);
    }

    private String readString(DataInputStream inputStream, int count) throws IOException {
        byte[] data = new byte[count];
        inputStream.readFully(data);
        return new String(data).trim();
    }

    private static String mrzFormat(String str, int width) {
        if (str == null) {
            return "";
        }
        if (str.length() > width) {
            throw new IllegalArgumentException("Argument too wide (" + str.length() + " > " + width + ")");
        }
        str = str.toUpperCase().trim();
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (MRZ_CHARS.indexOf(c) == -1) {
                result2.append('<');
                continue;
            }
            result2.append(c);
        }
        while (result2.length() < width) {
            result2.append("<");
        }
        return result2.toString();
    }

    public static boolean equalsModuloFillerChars(String str1, String str2) {
        if (str1 == str2) {
            return true;
        }
        if (str1 == null) {
            str1 = "";
        }
        if (str2 == null) {
            str2 = "";
        }
        int length = Math.max(str1.length(), str2.length());
        return MRZInfo.mrzFormat(str1, length).equals(MRZInfo.mrzFormat(str2, length));
    }

    private static int getDocumentTypeFromDocumentCode(String documentCode) {
        if (documentCode == null || documentCode.length() < 1 || documentCode.length() > 2) {
            throw new IllegalArgumentException("Was expecting 1 or 2 digit document code, got " + documentCode);
        }
        if (documentCode.startsWith("A") || documentCode.startsWith("C") || documentCode.startsWith("I")) {
            return 1;
        }
        if (documentCode.startsWith("V")) {
            return 1;
        }
        if (documentCode.startsWith("P")) {
            return 3;
        }
        return 0;
    }

    private static String trimFillerChars(String str) {
        byte[] chars = str.trim().getBytes();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != 60) continue;
            chars[i] = 32;
        }
        return new String(chars).trim();
    }

    private void checkDigit() {
        this.documentNumberCheckDigit = MRZInfo.checkDigit(this.documentNumber);
        this.dateOfBirthCheckDigit = MRZInfo.checkDigit(this.dateOfBirth);
        this.dateOfExpiryCheckDigit = MRZInfo.checkDigit(this.dateOfExpiry);
        if (this.optionalData1.length() < 15) {
            String personalNumber = MRZInfo.mrzFormat(this.optionalData1, 14);
            char personalNumberCheckDigit = MRZInfo.checkDigit(MRZInfo.mrzFormat(this.optionalData1, 14), true);
            this.optionalData1 = personalNumber + personalNumberCheckDigit;
        }
        this.compositeCheckDigit = MRZInfo.checkDigit(this.getComposite(this.documentType));
    }

    private String getComposite(int documentType) {
        StringBuilder composite = new StringBuilder();
        if (documentType == 1) {
            int documentNumberLength = this.documentNumber.length();
            if (documentNumberLength <= 9) {
                composite.append(MRZInfo.mrzFormat(this.documentNumber, 9));
                composite.append(this.documentNumberCheckDigit);
                composite.append(MRZInfo.mrzFormat(this.optionalData1, 15));
            } else {
                composite.append(this.documentNumber.substring(0, 9));
                composite.append("<");
                String documentNumberRemainder = this.documentNumber.substring(9);
                composite.append(documentNumberRemainder);
                composite.append(this.documentNumberCheckDigit);
                String optionalData1Remainder = MRZInfo.mrzFormat(this.optionalData1, 15).substring(documentNumberRemainder.length() + 1);
                composite.append(MRZInfo.mrzFormat(optionalData1Remainder, optionalData1Remainder.length()));
            }
            composite.append(this.dateOfBirth);
            composite.append(this.dateOfBirthCheckDigit);
            composite.append(this.dateOfExpiry);
            composite.append(this.dateOfExpiryCheckDigit);
            composite.append(MRZInfo.mrzFormat(this.optionalData2, 11));
        } else {
            composite.append(this.documentNumber);
            composite.append(this.documentNumberCheckDigit);
            composite.append(this.dateOfBirth);
            composite.append(this.dateOfBirthCheckDigit);
            composite.append(this.dateOfExpiry);
            composite.append(this.dateOfExpiryCheckDigit);
            composite.append(MRZInfo.mrzFormat(this.optionalData1, 15));
        }
        return composite.toString();
    }

    private static char checkDigit(String str, boolean preferFillerOverZero) {
        try {
            byte[] chars = str == null ? new byte[]{} : str.getBytes(StandardCharsets.UTF_8);
            int[] weights = new int[]{7, 3, 1};
            int result2 = 0;
            for (int i = 0; i < chars.length; ++i) {
                result2 = (result2 + weights[i % 3] * MRZInfo.decodeMRZDigit(chars[i])) % 10;
            }
            String checkDigitString = Integer.toString(result2);
            if (checkDigitString.length() != 1) {
                throw new IllegalStateException("Error in computing check digit.");
            }
            int checkDigit = checkDigitString.getBytes(StandardCharsets.UTF_8)[0];
            if (preferFillerOverZero && checkDigit == 48) {
                checkDigit = 60;
            }
            return (char)checkDigit;
        }
        catch (NumberFormatException nfe) {
            throw new IllegalStateException("Error in computing check digit", nfe);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error in computing check digit", e);
        }
    }

    private static int decodeMRZDigit(byte ch) {
        switch (ch) {
            case 48: 
            case 60: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 65: 
            case 97: {
                return 10;
            }
            case 66: 
            case 98: {
                return 11;
            }
            case 67: 
            case 99: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 69: 
            case 101: {
                return 14;
            }
            case 70: 
            case 102: {
                return 15;
            }
            case 71: 
            case 103: {
                return 16;
            }
            case 72: 
            case 104: {
                return 17;
            }
            case 73: 
            case 105: {
                return 18;
            }
            case 74: 
            case 106: {
                return 19;
            }
            case 75: 
            case 107: {
                return 20;
            }
            case 76: 
            case 108: {
                return 21;
            }
            case 77: 
            case 109: {
                return 22;
            }
            case 78: 
            case 110: {
                return 23;
            }
            case 79: 
            case 111: {
                return 24;
            }
            case 80: 
            case 112: {
                return 25;
            }
            case 81: 
            case 113: {
                return 26;
            }
            case 82: 
            case 114: {
                return 27;
            }
            case 83: 
            case 115: {
                return 28;
            }
            case 84: 
            case 116: {
                return 29;
            }
            case 85: 
            case 117: {
                return 30;
            }
            case 86: 
            case 118: {
                return 31;
            }
            case 87: 
            case 119: {
                return 32;
            }
            case 88: 
            case 120: {
                return 33;
            }
            case 89: 
            case 121: {
                return 34;
            }
            case 90: 
            case 122: {
                return 35;
            }
        }
        throw new NumberFormatException("Could not decode MRZ character " + ch + " ('" + (char)ch + "')");
    }
}

