/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.lds.iso19794;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.AbstractImageInfo;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.iso19794.FingerInfo;

public class FingerImageInfo
extends AbstractImageInfo {
    private static final long serialVersionUID = -6625447389275461027L;
    public static final int POSITION_UNKNOWN_FINGER = 0;
    public static final int POSITION_RIGHT_THUMB = 1;
    public static final int POSITION_RIGHT_INDEX_FINGER = 2;
    public static final int POSITION_RIGHT_MIDDLE_FINGER = 3;
    public static final int POSITION_RIGHT_RING_FINGER = 4;
    public static final int POSITION_RIGHT_LITTLE_FINGER = 5;
    public static final int POSITION_LEFT_THUMB = 6;
    public static final int POSITION_LEFT_INDEX_FINGER = 7;
    public static final int POSITION_LEFT_MIDDLE_FINGER = 8;
    public static final int POSITION_LEFT_RING_FINGER = 9;
    public static final int POSITION_LEFT_LITTLE_FINGER = 10;
    public static final int POSITION_PLAIN_RIGHT_FOUR_FINGERS = 13;
    public static final int POSITION_PLAIN_LEFT_FOUR_FINGERS = 14;
    public static final int POSITION_PLAIN_THUMBS = 15;
    public static final int POSITION_UNKNOWN_PALM = 20;
    public static final int POSITION_RIGHT_FULL_PALM = 21;
    public static final int POSITION_RIGHT_WRITER_S_PALM = 22;
    public static final int POSITION_LEFT_FULL_PALM = 23;
    public static final int POSITION_LEFT_WRITER_S_PALM = 24;
    public static final int POSITION_RIGHT_LOWER_PALM = 25;
    public static final int POSITION_RIGHT_UPPER_PALM = 26;
    public static final int POSITION_LEFT_LOWER_PALM = 27;
    public static final int POSITION_LEFT_UPPER_PALM = 28;
    public static final int POSITION_RIGHT_OTHER = 29;
    public static final int POSITION_LEFT_OTHER = 30;
    public static final int POSITION_RIGHT_INTERDIGITAL = 31;
    public static final int POSITION_RIGHT_THENAR = 32;
    public static final int POSITION_RIGHT_HYPOTHENAR = 33;
    public static final int POSITION_LEFT_INTERDIGITAL = 34;
    public static final int POSITION_LEFT_THENAR = 35;
    public static final int POSITION_LEFT_HYPOTHENAR = 36;
    public static final int IMPRESSION_TYPE_LIVE_SCAN_PLAIN = 0;
    public static final int IMPRESSION_TYPE_LIVE_SCAN_ROLLED = 1;
    public static final int IMPRESSION_TYPE_NON_LIVE_SCAN_PLAIN = 2;
    public static final int IMPRESSION_TYPE_NON_LIVE_SCAN_ROLLED = 3;
    public static final int IMPRESSION_TYPE_LATENT = 7;
    public static final int IMPRESSION_TYPE_SWIPE = 8;
    public static final int IMPRESSION_TYPE_LIVE_SCAN_CONTACTLESS = 9;
    private static final byte[] FORMAT_TYPE_VALUE = new byte[]{0, 9};
    private long recordLength;
    private int position;
    private int viewCount;
    private int viewNumber;
    private int quality;
    private int impressionType;
    private int compressionAlgorithm;

    public FingerImageInfo(int position, int viewCount, int viewNumber, int quality, int impressionType, int width, int height, InputStream imageBytes, int imageLength, int compressionAlgorithm) throws IOException {
        super(2, width, height, imageBytes, imageLength, FingerInfo.toMimeType(compressionAlgorithm));
        if (0 > quality || quality > 100) {
            throw new IllegalArgumentException("Quality needs to be a number between 0 and 100");
        }
        if (imageBytes == null) {
            throw new IllegalArgumentException("Null image");
        }
        this.position = position;
        this.viewCount = viewCount;
        this.viewNumber = viewNumber;
        this.quality = quality;
        this.impressionType = impressionType;
        this.compressionAlgorithm = compressionAlgorithm;
        this.recordLength = (long)imageLength + 14L;
    }

    public FingerImageInfo(InputStream inputStream, int compressionAlgorithm) throws IOException {
        super(2, FingerInfo.toMimeType(compressionAlgorithm));
        this.compressionAlgorithm = compressionAlgorithm;
        this.compressionAlgorithm = compressionAlgorithm;
        this.readObject(inputStream);
    }

    public int getQuality() {
        return this.quality;
    }

    public int getPosition() {
        return this.position;
    }

    public int getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public int getViewCount() {
        return this.viewCount;
    }

    public int getViewNumber() {
        return this.viewNumber;
    }

    public int getImpressionType() {
        return this.impressionType;
    }

    @Override
    protected void readObject(InputStream inputStream) throws IOException {
        DataInputStream dataIn = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        this.recordLength = (long)dataIn.readInt() & 0xFFFFFFFFL;
        this.position = dataIn.readUnsignedByte();
        this.viewCount = dataIn.readUnsignedByte();
        this.viewNumber = dataIn.readUnsignedByte();
        this.quality = dataIn.readUnsignedByte();
        this.impressionType = dataIn.readUnsignedByte();
        this.setWidth(dataIn.readUnsignedShort());
        this.setHeight(dataIn.readUnsignedShort());
        dataIn.readUnsignedByte();
        long imageLength = this.recordLength - 14L;
        this.readImage(inputStream, imageLength);
    }

    @Override
    protected void writeObject(OutputStream out) throws IOException {
        ByteArrayOutputStream imageOut = new ByteArrayOutputStream();
        this.writeImage(imageOut);
        imageOut.flush();
        byte[] imageBytes = imageOut.toByteArray();
        imageOut.close();
        long fingerDataBlockLength = (long)imageBytes.length + 14L;
        DataOutputStream dataOut = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
        dataOut.writeInt((int)(fingerDataBlockLength & 0xFFFFFFFFL));
        dataOut.writeByte(this.position);
        dataOut.writeByte(this.viewCount);
        dataOut.writeByte(this.viewNumber);
        dataOut.writeByte(this.quality);
        dataOut.writeByte(this.impressionType);
        dataOut.writeShort(this.getWidth());
        dataOut.writeShort(this.getHeight());
        dataOut.writeByte(0);
        dataOut.write(imageBytes);
        dataOut.flush();
    }

    @Override
    public long getRecordLength() {
        return this.recordLength;
    }

    public byte[] getFormatType() {
        return FORMAT_TYPE_VALUE;
    }

    public int getBiometricSubtype() {
        return FingerImageInfo.toBiometricSubtype(this.position);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.compressionAlgorithm;
        result2 = 31 * result2 + this.impressionType;
        result2 = 31 * result2 + this.position;
        result2 = 31 * result2 + this.quality;
        result2 = 31 * result2 + (int)(this.recordLength ^ this.recordLength >>> 32);
        result2 = 31 * result2 + this.viewCount;
        result2 = 31 * result2 + this.viewNumber;
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FingerImageInfo other = (FingerImageInfo)obj;
        return this.compressionAlgorithm == other.compressionAlgorithm && this.impressionType == other.impressionType && this.position == other.position && this.quality == other.quality && this.recordLength == other.recordLength && this.viewCount == other.viewCount && this.viewNumber == other.viewNumber;
    }

    @Override
    public String toString() {
        return "FingerImageInfo [quality: " + this.quality + ", position: " + FingerImageInfo.positionToString(this.position) + ", impression type: " + FingerImageInfo.impressionTypeToString(this.impressionType) + ", horizontal line length: " + this.getWidth() + ", vertical line length: " + this.getHeight() + ", image: " + this.getWidth() + " x " + this.getHeight() + " \"" + FingerInfo.toMimeType(this.compressionAlgorithm) + "\"]";
    }

    private static String positionToString(int position) {
        switch (position) {
            case 0: {
                return "Unknown finger";
            }
            case 1: {
                return "Right thumb";
            }
            case 2: {
                return "Right index finger";
            }
            case 3: {
                return "Right middle finger";
            }
            case 4: {
                return "Right ring finger";
            }
            case 5: {
                return "Right little finger";
            }
            case 6: {
                return "Left thumb";
            }
            case 7: {
                return "Left index finger";
            }
            case 8: {
                return "Left middle finger";
            }
            case 9: {
                return "Left ring finger";
            }
            case 10: {
                return "Left little finger";
            }
            case 13: {
                return "Right four fingers";
            }
            case 14: {
                return "Left four fingers";
            }
            case 15: {
                return "Plain thumbs";
            }
            case 20: {
                return "Unknown palm";
            }
            case 21: {
                return "Right full palm";
            }
            case 22: {
                return "Right writer's palm";
            }
            case 23: {
                return "Left full palm";
            }
            case 24: {
                return "Left writer's palm";
            }
            case 25: {
                return "Right lower palm";
            }
            case 26: {
                return "Right upper palm";
            }
            case 27: {
                return "Left lower palm";
            }
            case 28: {
                return "Left upper palm";
            }
            case 29: {
                return "Right other";
            }
            case 30: {
                return "Left other";
            }
            case 31: {
                return "Right interdigital";
            }
            case 32: {
                return "Right thenar";
            }
            case 33: {
                return "Right hypothenar";
            }
            case 34: {
                return "Left interdigital";
            }
            case 35: {
                return "Left thenar";
            }
            case 36: {
                return "Left hypothenar";
            }
        }
        return null;
    }

    private static String impressionTypeToString(int impressionType) {
        switch (impressionType) {
            case 0: {
                return "Live scan plain";
            }
            case 1: {
                return "Live scan rolled";
            }
            case 2: {
                return "Non-live scan plain";
            }
            case 3: {
                return "Non-live scan rolled";
            }
            case 7: {
                return "Latent";
            }
            case 8: {
                return "Swipe";
            }
            case 9: {
                return "Live scan contactless";
            }
        }
        return null;
    }

    private static int toBiometricSubtype(int position) {
        switch (position) {
            case 0: {
                return 0;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 9;
            }
            case 3: {
                return 13;
            }
            case 4: {
                return 17;
            }
            case 5: {
                return 21;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 10;
            }
            case 8: {
                return 14;
            }
            case 9: {
                return 18;
            }
            case 10: {
                return 22;
            }
            case 13: {
                return 1;
            }
            case 14: {
                return 2;
            }
            case 15: {
                return 4;
            }
            case 20: {
                return 0;
            }
            case 21: {
                return 1;
            }
            case 22: {
                return 0;
            }
            case 23: {
                return 2;
            }
            case 24: {
                return 2;
            }
            case 25: {
                return 1;
            }
            case 26: {
                return 1;
            }
            case 27: {
                return 2;
            }
            case 28: {
                return 2;
            }
            case 29: {
                return 1;
            }
            case 30: {
                return 2;
            }
            case 31: {
                return 1;
            }
            case 32: {
                return 1;
            }
            case 33: {
                return 1;
            }
            case 34: {
                return 2;
            }
            case 35: {
                return 2;
            }
            case 36: {
                return 2;
            }
        }
        return 0;
    }
}

