/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.lds.iso19794;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.AbstractImageInfo;

public class IrisImageInfo
extends AbstractImageInfo {
    private static final long serialVersionUID = 833541246115625112L;
    public static final int IMAGE_QUAL_UNDEF = 254;
    public static final int IMAGE_QUAL_LOW_LO = 26;
    public static final int IMAGE_QUAL_LOW_HI = 50;
    public static final int IMAGE_QUAL_MED_LO = 51;
    public static final int IMAGE_QUAL_MED_HI = 75;
    public static final int IMAGE_QUAL_HIGH_LO = 76;
    public static final int IMAGE_QUAL_HIGH_HI = 100;
    private static final int ROT_ANGLE_UNDEF = 65535;
    private static final int ROT_UNCERTAIN_UNDEF = 65535;
    private int imageFormat;
    private int imageNumber;
    private int quality;
    private int rotationAngle;
    private int rotationAngleUncertainty;

    public IrisImageInfo(int imageNumber, int quality, int rotationAngle, int rotationAngleUncertainty, int width, int height, InputStream imageBytes, int imageLength, int imageFormat) throws IOException {
        super(3, width, height, imageBytes, imageLength, IrisImageInfo.getMimeTypeFromImageFormat(imageFormat));
        if (imageBytes == null) {
            throw new IllegalArgumentException("Null image bytes");
        }
        this.imageNumber = imageNumber;
        this.quality = quality;
        this.rotationAngle = rotationAngle;
        this.rotationAngleUncertainty = rotationAngleUncertainty;
    }

    public IrisImageInfo(int imageNumber, int width, int height, InputStream imageBytes, int imageLength, int imageFormat) throws IOException {
        this(imageNumber, 254, 65535, 65535, width, height, imageBytes, imageLength, imageFormat);
    }

    IrisImageInfo(InputStream inputStream, int imageFormat) throws IOException {
        super(3);
        this.imageFormat = imageFormat;
        this.setMimeType(IrisImageInfo.getMimeTypeFromImageFormat(imageFormat));
        this.readObject(inputStream);
    }

    public int getImageFormat() {
        return this.imageFormat;
    }

    public int getImageNumber() {
        return this.imageNumber;
    }

    public int getQuality() {
        return this.quality;
    }

    public int getRotationAngle() {
        return this.rotationAngle;
    }

    public int getRotationAngleUncertainty() {
        return this.rotationAngleUncertainty;
    }

    @Override
    public long getRecordLength() {
        return 11L + (long)this.getImageLength();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.imageFormat;
        result2 = 31 * result2 + this.imageNumber;
        result2 = 31 * result2 + this.quality;
        result2 = 31 * result2 + this.rotationAngle;
        result2 = 31 * result2 + this.rotationAngleUncertainty;
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IrisImageInfo other = (IrisImageInfo)obj;
        return this.imageFormat == other.imageFormat && this.imageNumber == other.imageNumber && this.quality == other.quality && this.rotationAngle == other.rotationAngle && this.rotationAngleUncertainty == other.rotationAngleUncertainty;
    }

    @Override
    public String toString() {
        return "IrisImageInfo [image number: " + this.imageNumber + ", quality: " + this.quality + ", image: " + this.getWidth() + " x " + this.getHeight() + "mime-type: " + IrisImageInfo.getMimeTypeFromImageFormat(this.imageFormat) + "]";
    }

    @Override
    protected void readObject(InputStream inputStream) throws IOException {
        DataInputStream dataIn = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        this.imageNumber = dataIn.readUnsignedShort();
        this.quality = dataIn.readUnsignedByte();
        this.rotationAngle = dataIn.readShort();
        this.rotationAngleUncertainty = dataIn.readUnsignedShort();
        long imageLength = (long)dataIn.readInt() & 0xFFFFFFFFL;
        this.readImage(inputStream, imageLength);
    }

    @Override
    protected void writeObject(OutputStream out) throws IOException {
        DataOutputStream dataOut = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
        dataOut.writeShort(this.imageNumber);
        dataOut.writeByte(this.quality);
        dataOut.writeShort(this.rotationAngle);
        dataOut.writeShort(this.rotationAngleUncertainty);
        dataOut.writeInt(this.getImageLength());
        this.writeImage(dataOut);
    }

    private static String getMimeTypeFromImageFormat(int imageFormat) {
        switch (imageFormat) {
            case 2: 
            case 4: {
                return "image/x-wsq";
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                return "image/jpeg";
            }
            case 14: 
            case 16: {
                return "image/jp2";
            }
        }
        return null;
    }
}

