/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.protocol;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import nashid.verify.sdk.utils.id_card.jmrtd.Util;
import nashid.verify.sdk.utils.id_card.jmrtd.protocol.SecureMessagingWrapper;
import net.sf.scuba.util.Hex;

public class EACCAResult
implements Serializable {
    private static final long serialVersionUID = 4431711176589761513L;
    private final BigInteger keyId;
    private final PublicKey piccPublicKey;
    private final SecureMessagingWrapper wrapper;
    private final byte[] keyHash;
    private final PublicKey pcdPublicKey;
    private final PrivateKey pcdPrivateKey;

    public EACCAResult(BigInteger keyId, PublicKey piccPublicKey, byte[] keyHash, PublicKey pcdPublicKey, PrivateKey pcdPrivateKey, SecureMessagingWrapper wrapper) {
        this.keyId = keyId;
        this.piccPublicKey = piccPublicKey;
        this.keyHash = keyHash;
        this.pcdPublicKey = pcdPublicKey;
        this.pcdPrivateKey = pcdPrivateKey;
        this.wrapper = wrapper;
    }

    public BigInteger getKeyId() {
        return this.keyId;
    }

    public PublicKey getPublicKey() {
        return this.piccPublicKey;
    }

    public SecureMessagingWrapper getWrapper() {
        return this.wrapper;
    }

    public String toString() {
        return "CAResult [keyId: " + this.keyId + ", PICC public key: " + this.piccPublicKey + ", wrapper: " + this.wrapper + ", key hash: " + Hex.bytesToHexString((byte[])this.keyHash) + ", PCD public key: " + Util.getDetailedPublicKeyAlgorithm(this.pcdPublicKey) + ", PCD private key: " + Util.getDetailedPrivateKeyAlgorithm(this.pcdPrivateKey) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + Arrays.hashCode(this.keyHash);
        result2 = 31 * result2 + (this.keyId == null ? 0 : this.keyId.hashCode());
        result2 = 31 * result2 + (this.piccPublicKey == null ? 0 : this.piccPublicKey.hashCode());
        result2 = 31 * result2 + (this.pcdPublicKey == null ? 0 : this.pcdPublicKey.hashCode());
        result2 = 31 * result2 + (this.pcdPrivateKey == null ? 0 : this.pcdPrivateKey.hashCode());
        result2 = 31 * result2 + (this.wrapper == null ? 0 : this.wrapper.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EACCAResult other = (EACCAResult)obj;
        if (!Arrays.equals(this.keyHash, other.keyHash)) {
            return false;
        }
        if (this.keyId == null ? other.keyId != null : !this.keyId.equals(other.keyId)) {
            return false;
        }
        if (this.pcdPrivateKey == null ? other.pcdPrivateKey != null : !this.pcdPrivateKey.equals(other.pcdPrivateKey)) {
            return false;
        }
        if (this.pcdPublicKey == null ? other.pcdPublicKey != null : !this.pcdPublicKey.equals(other.pcdPublicKey)) {
            return false;
        }
        if (this.piccPublicKey == null ? other.piccPublicKey != null : !this.piccPublicKey.equals(other.piccPublicKey)) {
            return false;
        }
        if (this.wrapper == null) {
            return other.wrapper == null;
        }
        return this.wrapper.equals(other.wrapper);
    }

    public byte[] getKeyHash() {
        return this.keyHash;
    }

    public PublicKey getPCDPublicKey() {
        return this.pcdPublicKey;
    }

    public PrivateKey getPCDPrivateKey() {
        return this.pcdPrivateKey;
    }
}

