/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.omn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import nashid.verify.sdk.utils.id_card.omn.OmanCardDataInputStream;
import net.sf.scuba.util.Hex;

public class OmanCardDG6File {
    public static final Charset charset = StandardCharsets.UTF_16LE;
    public static final int TAG_DOB = 17935;
    public static final int TAG_COUNTRY_OF_BIRTH_ARABIC = 42512;
    public static final int TAG_PLACE_OF_BIRTH_ENGLISH = 42513;
    public static final int TAG_NATIONALITY_ARABIC = 42514;
    public static final int TAG_GENDER_ARABIC = 42515;
    public static final int TAG_NATIONALITY_ENGLISH = 58900;
    public static final int TAG_GENDER_ENGLISH = 58901;
    String dateOfBirth;
    String countryOfBirthArabic;
    String placeOfBirthEnglish;
    String nationalityArabic;
    String genderArabic;
    String nationalityEnglish;
    String genderEnglish;

    public OmanCardDG6File(byte[] buffer) throws IOException {
        OmanCardDataInputStream omanCardDataInputStream = new OmanCardDataInputStream(new ByteArrayInputStream(buffer));
        this.dateOfBirth = Hex.toHexString((byte[])omanCardDataInputStream.getTagValue(17935));
        this.countryOfBirthArabic = new String(omanCardDataInputStream.getTagValue(42512), charset);
        this.placeOfBirthEnglish = new String(omanCardDataInputStream.getTagValue(42513), charset);
        this.nationalityArabic = new String(omanCardDataInputStream.getTagValue(42514), charset);
        this.genderArabic = new String(omanCardDataInputStream.getTagValue(42515), charset);
        this.nationalityEnglish = new String(omanCardDataInputStream.getTagValue(58900), charset);
        this.genderEnglish = new String(omanCardDataInputStream.getTagValue(58901), charset);
    }

    public String getTagValue(int tag) {
        switch (tag) {
            case 17935: {
                return this.dateOfBirth;
            }
            case 42512: {
                return this.countryOfBirthArabic;
            }
            case 42513: {
                return this.placeOfBirthEnglish;
            }
            case 42514: {
                return this.nationalityArabic;
            }
            case 42515: {
                return this.genderArabic;
            }
            case 58900: {
                return this.nationalityEnglish;
            }
            case 58901: {
                return this.genderEnglish;
            }
        }
        return null;
    }

    public String toString() {
        return "OmanCardDG6File{17935='" + this.dateOfBirth + '\'' + ", " + 42512 + "='" + this.countryOfBirthArabic + '\'' + ", " + 42513 + "='" + this.placeOfBirthEnglish + '\'' + ", " + 42514 + "='" + this.nationalityArabic + '\'' + ", " + 42515 + "='" + this.genderArabic + '\'' + ", " + 58900 + "='" + this.nationalityEnglish + '\'' + ", " + 58901 + "='" + this.genderEnglish + '\'' + '}';
    }

    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public String getCountryOfBirthArabic() {
        return this.countryOfBirthArabic;
    }

    public void setCountryOfBirthArabic(String countryOfBirthArabic) {
        this.countryOfBirthArabic = countryOfBirthArabic;
    }

    public String getPlaceOfBirthEnglish() {
        return this.placeOfBirthEnglish;
    }

    public void setPlaceOfBirthEnglish(String placeOfBirthEnglish) {
        this.placeOfBirthEnglish = placeOfBirthEnglish;
    }

    public String getNationalityArabic() {
        return this.nationalityArabic;
    }

    public void setNationalityArabic(String nationalityArabic) {
        this.nationalityArabic = nationalityArabic;
    }

    public String getGenderArabic() {
        return this.genderArabic;
    }

    public void setGenderArabic(String genderArabic) {
        this.genderArabic = genderArabic;
    }

    public String getNationalityEnglish() {
        return this.nationalityEnglish;
    }

    public void setNationalityEnglish(String nationalityEnglish) {
        this.nationalityEnglish = nationalityEnglish;
    }

    public String getGenderEnglish() {
        return this.genderEnglish;
    }

    public void setGenderEnglish(String genderEnglish) {
        this.genderEnglish = genderEnglish;
    }
}

