package nashid.verify.sdk.utils.helpers

import android.annotation.SuppressLint
import android.app.Activity
import android.app.Dialog
import android.graphics.Bitmap
import android.util.Log
import android.util.TypedValue
import android.view.View
import android.widget.LinearLayout
import androidx.core.content.ContextCompat
import com.airbnb.lottie.LottieDrawable
import nashid.verify.sdk.model.IDCardNFCData
import nashid.verify.sdk.ui.NFCFragment
import nashid.verify.sdk.utils.ArtifactType
import nashid.verify.sdk.utils.Constants
import nashid.verify.sdk.utils.LivenessData
import nashid.verify.sdk.utils.SdkConfig
import nashid.verify.sdk.utils.Utility
import nashid.verify.sdk.utils.id_card.omn.OmanCardDG10File
import nashid.verify.sdk.utils.id_card.omn.OmanCardDG11File
import nashid.verify.sdk.utils.id_card.omn.OmanCardDG13File
import nashid.verify.sdk.utils.id_card.omn.OmanCardDG1File
import nashid.verify.sdk.utils.id_card.omn.OmanCardDG4File
import nashid.verify.sdk.utils.id_card.omn.OmanCardDG6File
import nashid.verify.sdk.viewmodel.NFCViewModel
import nashid.verify.sdk.viewmodel.ScanDocumentViewModel
import nashid.verify.sdkNew.R
import nashid.verify.sdkNew.databinding.ActivityWaitingForNfcBinding
import org.json.JSONException
import org.json.JSONObject
import java.text.DateFormat
import java.text.SimpleDateFormat
import java.util.Objects

class NfcLayoutAndTextSize(
    private val textSizeConverter: TextSizeConverter,
    private val binding: ActivityWaitingForNfcBinding,
    private val context: Activity,
    private val storage: Storage,
    private val viewModel: NFCViewModel,
    private val scanDocumentViewModel: ScanDocumentViewModel,
) {
    private var progressDialog: Dialog? = null
    private var errorDialog: Dialog? = null
    private val dateFormat = "yyyyMMdd"
    private var personalHashmap = JSONObject()
    private lateinit var idCardNFCData: IDCardNFCData

    fun setLayoutAndTextSize() {
        textSizeConverter.changeStatusBarColor(context)
        binding.layoutHeader.imgBack.setImageResource(R.drawable.back)
        if (storage.getPreferredLocale().equals("ar", ignoreCase = true)) {
            binding.layoutHeader.imgBack.rotation = 180f
        }
        var layoutParams2 = binding.layoutHeader.imgBack.layoutParams
        layoutParams2.width = textSizeConverter.getWidth(24)
        layoutParams2.height = textSizeConverter.getHeight(24)
        binding.layoutHeader.imgBack.layoutParams = layoutParams2
        var layoutParams = textSizeConverter.getLinearLayoutParam()
        layoutParams.setMargins(0, textSizeConverter.getPaddingOrMarginValue(4), 0, 0)
        binding.layoutHeader.lytHeaderMain.layoutParams = layoutParams
        binding.layoutHeader.txtHelp.text = context.getString(R.string.nfc_chip_rading)
        binding.layoutHeader.txtHelp.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(17).toFloat(),
        )
        var padding = textSizeConverter.getPaddingOrMarginValue(16)
        binding.layoutMainNfc.setPadding(padding, padding, padding, padding)
        layoutParams2 = binding.layoutStepMain.lytStep.layoutParams
        layoutParams2.width = LinearLayout.LayoutParams.MATCH_PARENT
        layoutParams2.height = textSizeConverter.getHeight(30)
        binding.layoutStepMain.lytStep.layoutParams = layoutParams2
        var marginLayoutParam =
            binding.layoutStepMain.lytStep.layoutParams as LinearLayout.LayoutParams
        marginLayoutParam.setMargins(0, textSizeConverter.getPaddingOrMarginValue(32), 0, 0)
        binding.layoutStepMain.lytStep.layoutParams = marginLayoutParam
        val stepIconSize = 22
        var stepLayoutParam = binding.layoutStepMain.txtStep1.layoutParams
        stepLayoutParam.width = textSizeConverter.getWidth(stepIconSize)
        stepLayoutParam.height = textSizeConverter.getHeight(stepIconSize)
        binding.layoutStepMain.txtStep1.layoutParams = stepLayoutParam
        stepLayoutParam = binding.layoutStepMain.txtStep2.layoutParams
        stepLayoutParam.width = textSizeConverter.getWidth(stepIconSize)
        stepLayoutParam.height = textSizeConverter.getHeight(stepIconSize)
        binding.layoutStepMain.txtStep2.layoutParams = stepLayoutParam
        stepLayoutParam = binding.layoutStepMain.txtStep3.layoutParams
        stepLayoutParam.width = textSizeConverter.getWidth(stepIconSize)
        stepLayoutParam.height = textSizeConverter.getHeight(stepIconSize)
        binding.layoutStepMain.txtStep3.layoutParams = stepLayoutParam
        stepLayoutParam = binding.layoutStepMain.viewStep1Divider.layoutParams
        stepLayoutParam.width = LinearLayout.LayoutParams.MATCH_PARENT
        stepLayoutParam.height = textSizeConverter.getHeight(2)
        binding.layoutStepMain.viewStep1Divider.layoutParams = stepLayoutParam
        binding.layoutStepMain.txtStep1.setImageResource(R.drawable.complete_step1)
        binding.layoutStepMain.txtStep2.setImageResource(R.drawable.scan_complete_step2)
        binding.layoutStepMain.txtStep3.imageTintList =
            ContextCompat.getColorStateList(context, R.color.dottedline_tint)
        binding.layoutStepMain.viewStep1Divider.setBackgroundResource(R.drawable.gradient_straight_line)
        binding.layoutStepMain.viewStep2Divider.backgroundTintList =
            ContextCompat.getColorStateList(context, R.color.dottedline_tint)
        marginLayoutParam = binding.txtTapHold.layoutParams as LinearLayout.LayoutParams
        marginLayoutParam.setMargins(0, textSizeConverter.getPaddingOrMarginValue(24), 0, 0)
        binding.txtTapHold.layoutParams = marginLayoutParam
        binding.txtTapHold.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(14).toFloat(),
        )
        marginLayoutParam = binding.txtTapHold.layoutParams as LinearLayout.LayoutParams
        marginLayoutParam.setMargins(0, textSizeConverter.getPaddingOrMarginValue(24), 0, 0)
        binding.txtTapHold.layoutParams = marginLayoutParam
        binding.txtTapHold.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(14).toFloat(),
        )
        viewModel.callNfcStatus()
        layoutParams2 = binding.nfcDialogTurnon.imgScanFailure.layoutParams
        layoutParams2.width = textSizeConverter.getWidth(56)
        layoutParams2.height = textSizeConverter.getHeight(56)
        binding.nfcDialogTurnon.imgScanFailure.layoutParams = layoutParams2
        layoutParams2 = binding.nfcDialogTurnon.imgInfo1.layoutParams
        layoutParams2.width = textSizeConverter.getWidth(20)
        layoutParams2.height = textSizeConverter.getHeight(20)
        binding.nfcDialogTurnon.imgInfo1.layoutParams = layoutParams2
        layoutParams2 = binding.nfcDialogTurnon.imgNfcFailed.layoutParams
        layoutParams2.width = textSizeConverter.getWidth(145)
        layoutParams2.height = textSizeConverter.getHeight(145)
        binding.nfcDialogTurnon.imgNfcFailed.layoutParams = layoutParams2
        val layoutParams1 =
            binding.nfcDialogTurnon.imgNfcFailed.layoutParams as LinearLayout.LayoutParams
        layoutParams1.setMargins(
            0,
            textSizeConverter.getPaddingOrMarginValue(24),
            0,
            textSizeConverter.getPaddingOrMarginValue(18),
        )
        binding.nfcDialogTurnon.imgNfcFailed.layoutParams = layoutParams1
        layoutParams2 = binding.nfcDialogTurnon.imgInfo2.layoutParams
        layoutParams2.width = textSizeConverter.getWidth(20)
        layoutParams2.height = textSizeConverter.getHeight(20)
        binding.nfcDialogTurnon.imgInfo2.layoutParams = layoutParams2
        layoutParams =
            binding.nfcDialogTurnon.imgScanFailure.layoutParams as LinearLayout.LayoutParams
        layoutParams.setMargins(0, textSizeConverter.getPaddingOrMarginValue(8), 0, 0)
        binding.nfcDialogTurnon.imgScanFailure.layoutParams = layoutParams
        binding.nfcDialogTurnon.txtScanCompleted.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(20).toFloat(),
        )
        layoutParams =
            binding.nfcDialogTurnon.txtScanCompleted.layoutParams as LinearLayout.LayoutParams
        layoutParams.setMargins(0, textSizeConverter.getPaddingOrMarginValue(24), 0, 0)
        binding.nfcDialogTurnon.txtScanCompleted.layoutParams = layoutParams
        binding.nfcDialogTurnon.txtScanNotCompleteDesc1.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(16).toFloat(),
        )
        layoutParams =
            binding.nfcDialogTurnon.txtScanNotCompleteDesc1.layoutParams as LinearLayout.LayoutParams
        layoutParams.setMargins(
            textSizeConverter.getPaddingOrMarginValue(6),
            textSizeConverter.getPaddingOrMarginValue(16),
            0,
            0,
        )
        binding.nfcDialogTurnon.txtScanNotCompleteDesc1.layoutParams = layoutParams
        binding.nfcDialogTurnon.txtScanNotCompleteDesc2.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(16).toFloat(),
        )
        binding.nfcDialogTurnon.imgNfcFailed.playAnimation()
        binding.nfcDialogTurnon.imgNfcFailed.repeatCount = LottieDrawable.INFINITE
        binding.nfcDialogTurnon.imgNfcFailed.setAnimation(R.raw.nfc_read_failed)
        layoutParams =
            binding.nfcDialogTurnon.txtScanNotCompleteDesc2.layoutParams as LinearLayout.LayoutParams
        layoutParams.setMargins(
            textSizeConverter.getPaddingOrMarginValue(6),
            textSizeConverter.getPaddingOrMarginValue(16),
            0,
            0,
        )
        binding.nfcDialogTurnon.txtScanNotCompleteDesc2.layoutParams = layoutParams
        layoutParams = binding.nfcDialogTurnon.imgInfo1.layoutParams as LinearLayout.LayoutParams
        layoutParams.setMargins(0, textSizeConverter.getPaddingOrMarginValue(16), 0, 0)
        binding.nfcDialogTurnon.imgInfo1.layoutParams = layoutParams
        layoutParams = binding.nfcDialogTurnon.imgInfo2.layoutParams as LinearLayout.LayoutParams
        layoutParams.setMargins(0, textSizeConverter.getPaddingOrMarginValue(16), 0, 0)
        binding.nfcDialogTurnon.imgInfo2.layoutParams = layoutParams
        layoutParams = binding.nfcDialogTurnon.btnRetry.layoutParams as LinearLayout.LayoutParams
        layoutParams.setMargins(
            0,
            textSizeConverter.getPaddingOrMarginValue(24),
            0,
            textSizeConverter.getPaddingOrMarginValue(28),
        )
        binding.nfcDialogTurnon.btnRetry.layoutParams = layoutParams
        padding = textSizeConverter.getPaddingOrMarginValue(12)
        binding.nfcDialogTurnon.txtBtnRetry.setPadding(0, padding, 0, padding)
        binding.nfcDialogTurnon.btnRetry.radius = textSizeConverter.calculateRadius(8).toFloat()
        binding.nfcDialogTurnon.lyoutError1.visibility = View.GONE
        binding.nfcDialogTurnon.txtBtnRetry.text = context.getString(R.string.turn_on_nfc)
        binding.nfcDialogTurnon.txtBtnRetry.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(16).toFloat(),
        )
        binding.logo.setImageResource(R.drawable.logo)
        binding.backbutton.setImageResource(R.drawable.arowback)
        binding.imgBackcrdScan.setAnimation(R.raw.nfc)
        binding.imgBackcrdScan.playAnimation()
        binding.imgBackcrdScan.repeatCount = LottieDrawable.INFINITE
    }

    fun handleSkipNFC(skipNFC: Boolean) {
        Log.d("NfcActivity", "handleSkipNFC: $skipNFC")
        if (skipNFC) {
            binding.txtSkip.visibility = View.VISIBLE
        } else {
            binding.txtSkip.visibility = View.GONE
        }
        if (skipNFC) {
            val margin: Int =
                if (viewModel.getNfcLiveData().maxTry.value == 0) {
                    textSizeConverter.getPaddingOrMarginValue(100)
                } else {
                    0
                }
            var marginLayoutParam = binding.txtBottomDesc.layoutParams as LinearLayout.LayoutParams
            marginLayoutParam.setMargins(0, 0, 0, margin)
            binding.txtBottomDesc.layoutParams = marginLayoutParam
            binding.txtBottomDesc.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter.getTextSize(16).toFloat(),
            )
            marginLayoutParam = binding.txtSkip.layoutParams as LinearLayout.LayoutParams
            marginLayoutParam.setMargins(
                0,
                textSizeConverter.getPaddingOrMarginValue(28),
                0,
                textSizeConverter.getPaddingOrMarginValue(68),
            )
            binding.txtSkip.layoutParams = marginLayoutParam
            binding.txtSkip.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter.getTextSize(14).toFloat(),
            )
        } else {
            var marginLayoutParam = binding.txtBottomDesc.layoutParams as LinearLayout.LayoutParams
            marginLayoutParam.setMargins(0, 0, 0, textSizeConverter.getPaddingOrMarginValue(100))
            binding.txtBottomDesc.layoutParams = marginLayoutParam
            binding.txtBottomDesc.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter.getTextSize(16).toFloat(),
            )
            marginLayoutParam = binding.txtSkip.layoutParams as LinearLayout.LayoutParams
            marginLayoutParam.setMargins(
                0,
                textSizeConverter.getPaddingOrMarginValue(28),
                0,
                textSizeConverter.getPaddingOrMarginValue(68),
            )
            binding.txtSkip.layoutParams = marginLayoutParam
            binding.txtSkip.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter.getTextSize(14).toFloat(),
            )
        }
    }

    private fun dismissDialog() {
        if (errorDialog != null) {
            errorDialog!!.dismiss()
        }
        if (progressDialog != null) {
            progressDialog!!.dismiss()
        }
    }

    fun storeNFCData() {
        if (Objects
                .requireNonNull(viewModel.getNfcLiveData().selectedDoc.value)
                .equals(context.getString(R.string.e_passport), ignoreCase = true)
        ) {
            val emptyString = context.getString(R.string.passemptyString)
            val eDocument = viewModel.getEDocument()
            LivenessData.getInstance().seteDocument(eDocument)
            val personDetails = eDocument.personDetails
            val additionalPersonDetails = eDocument.additionalPersonDetails
            val additionalDGFiles = eDocument.additionalDGFiles
            // dg1
            try {
                personalHashmap.put(context.getString(R.string.passdocumentType), eDocument.docType.name)
                personalHashmap.put(
                    context.getString(R.string.passdocumentNumber),
                    personDetails.serialNumber,
                )
                personalHashmap.put(
                    context.getString(R.string.passissuingAuthority),
                    personDetails.issuerAuthority,
                )
                personalHashmap.put(context.getString(R.string.passdateOfBirth), personDetails.birthDate)
                personalHashmap.put(context.getString(R.string.passgender), personDetails.gender)
                personalHashmap.put(
                    context.getString(R.string.passdocumentExpiryDate),
                    personDetails.expiryDate,
                )
                //        dg2
                personalHashmap.put(context.getString(R.string.passimage), personDetails.faceImage)
                if (additionalPersonDetails != null) {
                    personalHashmap.put(
                        context.getString(R.string.passfullName),
                        additionalPersonDetails.nameOfHolder,
                    )
                    personalHashmap.put(
                        context.getString(R.string.passpersonalNumber),
                        additionalPersonDetails.personalNumber,
                    )
                    if (additionalPersonDetails.placeOfBirth != null) {
                        personalHashmap.put(
                            context.getString(
                                R.string.passplaceOfBirth,
                            ),
                            additionalPersonDetails.placeOfBirth!![0],
                        )
                    } else {
                        personalHashmap.put(context.getString(R.string.passplaceOfBirth), emptyString)
                    }
                    personalHashmap.put(
                        context.getString(R.string.passnfcDateOfBirth),
                        additionalPersonDetails.fullDateOfBirth,
                    )
                    if (additionalPersonDetails.permanentAddress != null) {
                        personalHashmap.put(
                            context.getString(R.string.passaddress),
                            additionalPersonDetails.permanentAddress!![0],
                        )
                    } else {
                        personalHashmap.put(context.getString(R.string.passaddress), emptyString)
                    }
                    personalHashmap.put(
                        context.getString(R.string.passprofession),
                        additionalPersonDetails.profession,
                    )
                    personalHashmap.put(
                        context.getString(R.string.passtitle),
                        additionalPersonDetails.title,
                    )
                    personalHashmap.put(
                        context.getString(R.string.passpersonalSummary),
                        additionalPersonDetails.personalSummary,
                    )
                    if (additionalPersonDetails.otherValidTDNumbers != null) {
                        personalHashmap.put(
                            context.getString(R.string.passtdNumbers),
                            additionalPersonDetails.otherValidTDNumbers!![0],
                        )
                    } else {
                        personalHashmap.put(context.getString(R.string.passtdNumbers), emptyString)
                    }
                    personalHashmap.put(
                        context.getString(R.string.passcustodyInfo),
                        additionalPersonDetails.custodyInformation,
                    )
                    if (additionalPersonDetails.proofOfCitizenship != null) {
                        personalHashmap.put(
                            context.getString(R.string.passproofOfCitizenship),
                            additionalPersonDetails.proofOfCitizenship.toString(),
                        )
                    } else {
                        personalHashmap.put(
                            context.getString(R.string.passproofOfCitizenship),
                            emptyString,
                        )
                    }
                    personalHashmap.put(
                        context.getString(R.string.passtelephone),
                        additionalPersonDetails.telephone,
                    )
                }
                if (additionalDGFiles != null) {
                    //        dg12 and dg14
                    personalHashmap.put(
                        context.getString(R.string.passnfcissuingCountry),
                        additionalDGFiles.issueingAuthority,
                    )
                    if (additionalDGFiles.frontImage != null) {
                        personalHashmap.put(
                            context.getString(R.string.passfrontImage),
                            additionalDGFiles.frontImage,
                        )
                    } else {
                        personalHashmap.put(context.getString(R.string.passfrontImage), emptyString)
                    }
                    if (additionalDGFiles.backImage != null) {
                        personalHashmap.put(
                            context.getString(R.string.passrearImage),
                            additionalDGFiles.backImage,
                        )
                    } else {
                        personalHashmap.put(context.getString(R.string.passrearImage), emptyString)
                    }
                    if (additionalDGFiles.securityInfos != null) {
                        personalHashmap.put(
                            context.getString(R.string.passsecurityInfos),
                            additionalDGFiles.securityInfos,
                        )
                    } else {
                        personalHashmap.put(
                            context.getString(R.string.passsecurityInfos),
                            emptyString,
                        )
                    }
                }
                NFCFragment.nfcData = personalHashmap
                uploadArtifact(personDetails.faceImage)
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        } else {
            idCardNFCData = IDCardNFCData.getInstance()
            val documentHashmap = JSONObject()
            try {
                val dg1Parser = OmanCardDG1File(Utility.getInstance().dgFile1)
                val dg4Parser = OmanCardDG4File(Utility.getInstance().dgFile4)
                val dg6Parser = OmanCardDG6File(Utility.getInstance().dgFile6)
                documentHashmap.put(
                    context.getString(R.string.idcardphoto),
                    LivenessData.getInstance().nfcImage,
                )
                documentHashmap.put(context.getString(R.string.idcardidNumber), dg1Parser.idNumber)
                documentHashmap.put(
                    context.getString(R.string.idcardissueDate),
                    formattedFrosting(
                        dg1Parser.issueDate,
                    ),
                )
                documentHashmap.put(
                    context.getString(R.string.idcardexpiryDate),
                    formattedFrosting(
                        dg1Parser.expiryDate,
                    ),
                )
                documentHashmap.put(
                    context.getString(R.string.idcardplaceOfIssueArabic),
                    dg1Parser.placeOfIssueArabic,
                )
                documentHashmap.put(
                    context.getString(R.string.idcardplaceOfIssueEnglish),
                    dg1Parser.placeOfIssueEnglish,
                )
                idCardNFCData.identityNumber = dg1Parser.idNumber
                idCardNFCData.issueDate =
                    formattedFrosting(
                        dg1Parser.issueDate,
                    )
                idCardNFCData.expiryDate =
                    formattedFrosting(
                        dg1Parser.expiryDate,
                    )
                idCardNFCData.placeOfIssueArabic = dg1Parser.placeOfIssueArabic
                idCardNFCData.placeOfIssueEnglish = dg1Parser.placeOfIssueEnglish
                documentHashmap.put(
                    context.getString(R.string.idcardfullNameArabic),
                    dg4Parser.fullNameArabic,
                )
                documentHashmap.put(
                    context.getString(R.string.idcardfullNameEnglish),
                    dg4Parser.fullNameEnglish,
                )
                idCardNFCData.fullNameArabic = dg4Parser.fullNameArabic
                idCardNFCData.fullNameEnglish = dg4Parser.fullNameEnglish
                documentHashmap.put(
                    context.getString(R.string.idcarddateOfBirth),
                    formattedFrosting(
                        dg6Parser.dateOfBirth,
                    ),
                )
                documentHashmap.put(
                    context.getString(R.string.idcardcountryOfBirthArabic),
                    dg6Parser.countryOfBirthArabic,
                )
                documentHashmap.put(
                    context.getString(R.string.idcardplaceOfBirthEnglish),
                    dg6Parser.placeOfBirthEnglish,
                )
                documentHashmap.put(
                    context.getString(R.string.idcardnationalityArabic),
                    dg6Parser.nationalityArabic,
                )
                documentHashmap.put(
                    context.getString(R.string.idcardgenderArabic),
                    dg6Parser.genderArabic,
                )
                documentHashmap.put(
                    context.getString(R.string.idcardnationalityEnglish),
                    dg6Parser.nationalityEnglish,
                )
                documentHashmap.put(
                    context.getString(R.string.idcardgenderEnglish),
                    dg6Parser.genderEnglish,
                )
                idCardNFCData.dateOfBirth =
                    formattedFrosting(
                        dg6Parser.dateOfBirth,
                    )
                idCardNFCData.placeOfBirthArabic = dg6Parser.countryOfBirthArabic
                idCardNFCData.placeOfBirthEnglish = dg6Parser.placeOfBirthEnglish
                idCardNFCData.nationalityArabic = dg6Parser.nationalityArabic
                idCardNFCData.genderArabic = dg6Parser.genderArabic
                idCardNFCData.nationalityEnglish = dg6Parser.nationalityEnglish
                idCardNFCData.genderEnglish = dg6Parser.genderEnglish
                if (Utility.getInstance().dgFile13 != null) {
                    val dg13Parser = OmanCardDG13File(Utility.getInstance().dgFile13)
                    documentHashmap.put(
                        context.getString(R.string.idcardvisaNumber),
                        dg13Parser.sponsorNumber,
                    )
                    documentHashmap.put(
                        context.getString(R.string.idcardPermitType),
                        dg13Parser.sponsorRelationship,
                    )
                    idCardNFCData.visaNumber = dg13Parser.sponsorNumber
                    idCardNFCData.permitType = dg13Parser.sponsorRelationship
                }
                if (Utility.getInstance().dgFile10 != null) {
                    val dg10Parser = OmanCardDG10File(Utility.getInstance().dgFile10)
                    documentHashmap.put(
                        context.getString(R.string.idcardvisaExpiryDate),
                        formattedFrosting(
                            dg10Parser.visaExpiryDate,
                        ),
                    )
                    documentHashmap.put(
                        context.getString(R.string.idcardvisaPlaceOfIssueArabic),
                        dg10Parser.visaPlaceOfIssueArabic,
                    )
                    documentHashmap.put(
                        context.getString(R.string.idcardPermitNumber),
                        dg10Parser.visaNumber,
                    )
                    idCardNFCData.useByDate =
                        formattedFrosting(
                            dg10Parser.visaExpiryDate,
                        )
                    idCardNFCData.visaPlaceOfIssueArabic = dg10Parser.visaPlaceOfIssueArabic
                    idCardNFCData.permitNumber = dg10Parser.visaNumber
                }
                if (Utility.getInstance().dgFile13 != null) {
                    val dg13Parser = OmanCardDG13File(Utility.getInstance().dgFile13)
                    documentHashmap.put(
                        context.getString(R.string.idcardsponsorIssueDate),
                        formattedFrosting(
                            dg13Parser.sponsorIssueDate,
                        ),
                    )
                    documentHashmap.put(
                        context.getString(R.string.idcardsponsorExpiryDate),
                        formattedFrosting(
                            dg13Parser.sponsorExpiryDate,
                        ),
                    )
                    idCardNFCData.sponsorIssueDate =
                        formattedFrosting(
                            dg13Parser.sponsorIssueDate,
                        )
                    idCardNFCData.sponsorExpiryDate =
                        formattedFrosting(
                            dg13Parser.sponsorExpiryDate,
                        )
                }
                if (Utility.getInstance().dgFile11 != null) {
                    val dg11Parser = OmanCardDG11File(Utility.getInstance().dgFile11)
                    documentHashmap.put(
                        context.getString(R.string.idcardcompanyNameArabic),
                        dg11Parser.companyNameArabic,
                    )
                    documentHashmap.put(
                        context.getString(R.string.idcardcompanyNameEnglish),
                        dg11Parser.companyNameEnglish,
                    )
                    documentHashmap.put(
                        context.getString(R.string.idcardcompanyAddressArabic),
                        dg11Parser.companyAddressArabic,
                    )
                    idCardNFCData.companyNameArabic = dg11Parser.companyNameArabic
                    idCardNFCData.companyNameEnglish = dg11Parser.companyNameEnglish
                    idCardNFCData.companyAddressAraic = dg11Parser.companyAddressArabic
                }
                NFCFragment.nfcData = documentHashmap
                uploadArtifact(LivenessData.getInstance().nfcImage)
            } catch (e: Exception) {
                Log.d("TAG", "setIDCardDetail: $e")
            }
        }
    }

    private fun uploadArtifact(bitmap: Bitmap?) {
        bitmap?.let {
            uploadArtifacts(it)
        }
    }

    private fun uploadArtifacts(bitmap: Bitmap?) {
        val file = Utility.getInstance().bitmapToFile(bitmap!!, context)
        val filePart = Utility.getInstance().createMultipartBody(file)
        scanDocumentViewModel.uploadArtifact(
            SdkConfig.registerToken!!,
            Utility.getInstance().getAppKey(),
            filePart,
            ArtifactType.NFC_IMAGE.type,
        )
    }

    @SuppressLint("SimpleDateFormat")
    private fun formattedFrosting(inputDate: String): String {
        try {
            val sdf: DateFormat = SimpleDateFormat(dateFormat)
            val date = sdf.parse(inputDate)
            return SimpleDateFormat(Constants.DATE_FORMAT).format(date!!)
        } catch (_: Exception) {
        }
        return inputDate
    }
}
