package nashid.verify.sdk.utils

import nashid.verify.sdk.model.DocumentType
import nashid.verify.sdk.model.ExtraData
import nashid.verify.sdk.model.SDKStatus

object SdkConfig {
    var sandboxSdkKey: String? = null
    var sandboxSdkSecret: String? = null
    var sandboxLanguageType: String? = null
    var name: String? = null
    var description: String? = null
    var isNfcScanningEnabled: Boolean = false
    var isNfcMultiTriesEnabled: Boolean = false
    var isFaceMatchingEnabled: Boolean = false
    var isOcrEnabled: Boolean = false
    var isMrzEnabled: Boolean = false
    var callbackProtocol: String? = null
    var callbackHost: String? = null
    var showInstruction: Boolean = false
    var viewType: DocumentType = DocumentType.OMAN_ID
    var isNfcSkipable: Boolean? = false
    var nfcMaximumRetries: Int? = null
    var registerToken: String? = null
    var sdkStatus: SDKStatus = SDKStatus.NOT_INITIALIZED
    var isExtraData: ExtraData? = null
    var ipv4: String? = null
    var ipv6: String? = null

    fun updateConfig(
        sdkKey: String?,
        sdkSecret: String?,
        languageType: String?,
        sdkName: String?,
        sdkDescription: String?,
        nfcScanningEnabled: Boolean,
        nfcMultiTriesEnabled: Boolean,
        faceMatchingEnabled: Boolean,
        ocrEnabled: Boolean,
        mrzEnabled: Boolean,
        protocol: String?,
        host: String?,
        instructionsVisible: Boolean,
        nfcSkippable: Boolean,
        nfcRetries: Int,
        extraData: ExtraData?,
    ) {
        sandboxSdkKey = sdkKey
        sandboxSdkSecret = sdkSecret
        sandboxLanguageType = languageType
        name = sdkName
        description = sdkDescription
        isNfcScanningEnabled = nfcScanningEnabled
        isNfcMultiTriesEnabled = nfcMultiTriesEnabled
        isFaceMatchingEnabled = faceMatchingEnabled
        isOcrEnabled = ocrEnabled
        isMrzEnabled = mrzEnabled
        callbackProtocol = protocol
        callbackHost = host
        showInstruction = instructionsVisible
        isNfcSkipable = nfcSkippable
        nfcMaximumRetries = nfcRetries
        sdkStatus = SDKStatus.INITIALIZED
        isExtraData = extraData
    }

    fun clear() {
        sandboxSdkKey = null
        sandboxSdkSecret = null
        sandboxLanguageType = null
        name = null
        description = null
        isNfcScanningEnabled = false
        isNfcMultiTriesEnabled = false
        isFaceMatchingEnabled = false
        isOcrEnabled = false
        isMrzEnabled = false
        callbackProtocol = null
        callbackHost = null
        showInstruction = false
        viewType = DocumentType.OMAN_ID
        isNfcSkipable = false
        nfcMaximumRetries = null
        registerToken = null
        sdkStatus = SDKStatus.NOT_INITIALIZED
        isExtraData = null
        ipv4 = null
        ipv6 = null
    }
}
