package com.kyc.nashidmrz

import android.app.Activity
import android.content.Context
import android.content.Intent
import android.util.Log
import com.kyc.nashidmrz.mrtd2.activity.CameraXLivePreviewActivity
import com.kyc.nashidmrz.mrtd2.activity.InstructionScreenActivity
import com.kyc.nashidmrz.mrtd2.locale.LocaleUtil.Companion.applyLocalizedContext
import com.kyc.nashidmrz.mrtd2.locale.Storage
import com.kyc.nashidmrz.mrtd2.resultcallback.ResultListener
import com.kyc.nashidmrz.networking.APIClient
import com.kyc.nashidmrz.networking.APIInterface
import com.kyc.nashidmrz.utility.SharePreferenceUtility
import okhttp3.ResponseBody
import org.json.JSONObject
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response

class NashidSDK private constructor() {
    private lateinit var baseUrl: String

    private val logger: Logger = Logger.withTag(this.javaClass.simpleName)

    //    private lateinit var facematchBaseUrl: String
//    private lateinit var amlBaseUrl: String
//    private lateinit var autoCropBaseUrl: String
    private lateinit var companyUUID: String
    private lateinit var sdkToken: String
    private lateinit var registerToken: String
    private lateinit var email: String
    private var resultListener: ResultListener? = null
    private lateinit var sdkInitListner: SDKIntListener
    private lateinit var qrCode: String
//    private val loginFeatureList: ArrayList<String> = ArrayList()
//    private val featureList: ArrayList<String> = ArrayList()
//    private var appName = "NashidIDV"
//    private val featureCheckUrl = ""

    fun init(
        sdkToken: String,
        companyUUID: String,
        mainBaseUrl: String,
        email: String,
        sdkInitListner: SDKIntListener,
    ) {
        this.baseUrl = mainBaseUrl
        this.companyUUID = companyUUID
        this.sdkToken = sdkToken
        this.email = email
        registerToken = ""
        qrCode = ""
        this.sdkInitListner = sdkInitListner

        callGetEmployeeTokenAPI()
    }

    private fun callGetEmployeeTokenAPI() {
        APIClient.getEmployeeTkenClient(getInstance().baseUrl, getInstance().sdkToken)
            .create<APIInterface>(
                APIInterface::class.java,
            ).callGetEmployeeToken(getInstance().email).enqueue(
                object : Callback<ResponseBody> {
                    override fun onResponse(
                        call: Call<ResponseBody>,
                        response: Response<ResponseBody>,
                    ) {
                        try {
                            if (response.isSuccessful) {
                                logger.log("successfully initialize ")
                                val jsonResponse = response.body()!!.string()
                                val jsonObject = JSONObject(jsonResponse)
                                val jsonDataObject = jsonObject.getJSONObject("data")
                                registerToken = jsonDataObject.getString("token")
                                if (sdkInitListner != null) {
                                    sdkInitListner.onInitSuccess()
                                }
                                val isDealer = jsonDataObject.getBoolean("is_dealer")
                                val allowedFeatureManagement =
                                    jsonDataObject.getBoolean("allowed_feature_management")

                                Log.d(
                                    "TAG",
                                    "onResponse: " + isDealer + "   " + allowedFeatureManagement,
                                )

                                if (isDealer && allowedFeatureManagement) {
                                    OtherConstant.getInstance().needToShowSettingScreen = true
                                }

//                            Log.d("TAG", "getemployeetoken onResponse: " + registerToken)
                            } else {
                                logger.log("failed initialize ")
                                if (sdkInitListner != null) {
                                    sdkInitListner.onInitFail()
                                }
//                            Log.d("TAG", "Response not successful. Code: " + response.code())
                                //                     Handle other response codes if needed
                            }
                        } catch (e: Exception) {
                            logger.log("exception " + e.toString())
                        }
                    }

                    override fun onFailure(
                        call: Call<ResponseBody>,
                        t: Throwable,
                    ) {
                        Log.d("TAG", "onFailure: " + t.toString())
                        logger.log("initialization failed " + t)
                        if (sdkInitListner != null) {
                            sdkInitListner.onInitFail()
                        }
//                        Log.d("TAG", "openScanDocumentScreen onFailure: $t")
                    }
                },
            )
    }

    fun setQRCodeValue(qrCode: String) {
        this.qrCode = qrCode
    }

    fun getQRCodeValue(): String {
        return qrCode
    }

    fun setResultListener(listener: ResultListener?) {
        resultListener = listener
    }

    fun getResultListener(): ResultListener? {
        return resultListener
    }

    fun getBaseURL(): String {
        return baseUrl
    }

    fun getCompanyUUID(): String {
        return companyUUID
    }
    // Rest of the class remains the same...

    fun documentScan(activity: Activity) {
        if (registerToken.length != 0) {
            Utility.getInstance().cleanup()
            Utility.getInstance().selectedDoc = activity.getString(R.string.id_card)
            Log.d("TAG", "setResultData: " + Utility.getInstance().selectedDoc)
            if (isShowInstruction(activity)) {
                val i = Intent(activity, InstructionScreenActivity::class.java)
                i.putExtra(
                    activity.getResources().getString(R.string.doc_key),
                    activity.getResources().getString(R.string.doc_key),
                )
                activity.startActivity(i)
            } else {
                val i =
                    Intent(
                        activity,
                        CameraXLivePreviewActivity::class.java,
                    )
                i.putExtra(
                    activity.getResources().getString(R.string.doc_key),
                    activity.getString(R.string.id_card),
                )
                activity.startActivity(i)
            }

//            val i = Intent(activity, CameraXLivePreviewActivity::class.java)
//            i.putExtra(activity.resources.getString(R.string.doc_key), "ID Card")

//                        Intent i = new Intent(CameraXLivePreviewActivity.this, LivenessMainActivity.class);
//                        someActivityResultLauncher.launch(i);
//                        cameraProvider.shutdown();

//            activity.startActivity(i)
        }
    }

    fun passportScan(activity: Activity) {
        Utility.getInstance().cleanup()
        if (registerToken.length != 0) {
            Utility.getInstance().selectedDoc = activity.getString(R.string.e_passport)
            if (isShowInstruction(activity)) {
                val i = Intent(activity, InstructionScreenActivity::class.java)
                i.putExtra(
                    activity.getResources().getString(R.string.doc_key),
                    activity.getResources().getString(R.string.doc_key),
                )
                activity.startActivity(i)
            } else {
                val i =
                    Intent(
                        activity,
                        CameraXLivePreviewActivity::class.java,
                    )
                i.putExtra(
                    activity.getResources().getString(R.string.doc_key),
                    activity.getString(R.string.e_passport),
                )
                activity.startActivity(i)
            }

//            val i = Intent(activity, CameraXLivePreviewActivity::class.java)
//            i.putExtra(activity.resources.getString(R.string.doc_key), "E-Passport")
//            Utility.getInstance().selectedDoc = "E-Passport"
//            activity.startActivity(i)
        }
    }

    fun isShowInstruction(context: Context): Boolean {
        return SharePreferenceUtility.getSavePreferenceData(
            context,
            context.getString(R.string.sharepreference_verification_step),
        )
    }

    fun getRegisterToken(): String {
        return registerToken
    }

    fun setShowInstruction(
        context: Context,
        showInstruction: Boolean,
    ) {
        SharePreferenceUtility.savePreferenceValue(
            context,
            context.getString(R.string.sharepreference_verification_step),
            !SharePreferenceUtility.getSavePreferenceData(
                context,
                context.getString(R.string.sharepreference_verification_step),
            ),
        )
    }

    companion object {
        @Volatile
        private var instance: NashidSDK? = null

        @JvmStatic
        fun getInstance(): NashidSDK {
            return instance ?: synchronized(this) {
                instance ?: NashidSDK().also { instance = it }
            }
        }
    }

    /*  fun setLanguage(
         activity: Context,
         languageCode: String,
     ) {
         LocaleHelperData.setLocale(activity, languageCode)
 //        val locale = Locale(languageCode)
 //        Locale.setDefault(locale)
 //
 //        val config = Configuration(activity.resources.configuration)
 //        config.setLocale(locale)
 //
 //        activity.resources.updateConfiguration(config, activity.resources.displayMetrics)
 //        LocaleHelper.setLocale(activity, languageCode)
 //        activity.recreate()
     }*/

    public fun updateLocale(
        activity: Activity,
        locale: String,
    ) {
        var storage = Storage(activity)
        storage.setPreferredLocale(locale)
        applyLocalizedContext(activity, locale)
//         context.recreate()
    }

    public fun getLocale(activity: Activity): String {
        var storage = Storage(activity)
        return storage.getPreferredLocale()
    }
}
