package com.kyc.nashidmrz

import android.util.Log

internal class OtherConstant {
    var appName = "Overify"
    var needToShowResultScreen = false
    var needToShowSettingScreen = false
    var mainBaseUrl = ""
    var amlBaseUrl = ""
    var autoCropBaseUrl = ""
    var skipNFC = false

    fun setAppname() {
        appName = "NashidIDV"
        needToShowResultScreen = true
    }

    fun getEncodedString(unicodeString: String): String {
        val hexValues = unicodeString.split("\\\\u".toRegex()).drop(1)
        val decodedString = StringBuilder()

        for (hexValue in hexValues) {
            val codePoint = Integer.parseInt(hexValue, 16)
            decodedString.append(codePoint.toChar())
        }

        Log.d("TAG", "getEncodedString: " + decodedString.toString() + "---" + translateArabicToEnglish(decodedString.toString()))
        return decodedString.toString()
    }

    fun translateArabicToEnglish(arabicText: String): String {
        val arabicChars =
            arrayOf(
                'ا', 'أ', 'إ', 'آ', 'ب', 'ت', 'ث', 'ج', 'ح', 'خ', 'د', 'ذ', 'ر', 'ز', 'س', 'ش', 'ص', 'ض',
                'ط', 'ظ', 'ع', 'غ', 'ف', 'ق', 'ك', 'ل', 'م', 'ن', 'ه', 'و', 'ي', 'ء',
            )
        val englishChars =
            arrayOf(
                'a', 'a', 'a', 'a', 'b', 't',
                "th", 'j', 'h', "kh", 'd', "dh", 'r', 'z', 's', "sh", 's', 'd',
                't', 'z', 'a', "gh", 'f', 'q', 'k', 'l', 'm', 'n', 'h', 'w', 'y', 'a',
            )

//        val translationMap = arabicChars.zip(englishChars).toMap()
        val translationMap =
            mapOf(
                'ا' to 'a', 'أ' to 'a', 'إ' to 'a', 'آ' to 'a', 'ب' to 'b', 'ت' to 't', 'ث' to "th", 'ج' to 'j',
                'ح' to 'h', 'خ' to "kh", 'د' to 'd', 'ذ' to "dh", 'ر' to 'r', 'ز' to 'z', 'س' to 's', 'ش' to "sh",
                'ص' to 's', 'ض' to 'd', 'ط' to 't', 'ظ' to 'z', 'ع' to 'a', 'غ' to "gh", 'ف' to 'f', 'ق' to 'q',
                'ك' to 'k', 'ل' to 'l', 'م' to 'm', 'ن' to 'n', 'ه' to 'h', 'و' to 'w', 'ي' to 'y', 'ء' to 'a',
                'ة' to 'a',
            )
        val englishText = StringBuilder()

        for (char in arabicText) {
            val translatedChar = translationMap[char] ?: char
            englishText.append(translatedChar)
        }

        return englishText.toString()
    }

    companion object {
        @Volatile
        private var instance: OtherConstant? = null

        @JvmStatic
        fun getInstance(): OtherConstant {
            return instance ?: synchronized(this) {
                instance ?: OtherConstant().also { instance = it }
            }
        }
    }
}
