package com.kyc.nashidmrz.id_card.omn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class OmanCardDG4File {
    public static final Charset charset = StandardCharsets.UTF_16LE;
    public static final int TAG_FULL_NAME_ARABIC = 0xA40A;
    public static final int TAG_FULL_NAME_ENGLISH = 0xE40B;

    String fullNameArabic;
    String fullNameEnglish;

    public OmanCardDG4File(byte[] buffer) throws IOException {
        OmanCardDataInputStream omanCardDataInputStream = new OmanCardDataInputStream(new ByteArrayInputStream(buffer));

        fullNameArabic = new String(omanCardDataInputStream.getTagValue(TAG_FULL_NAME_ARABIC), charset);
        fullNameEnglish = new String(omanCardDataInputStream.getTagValue(TAG_FULL_NAME_ENGLISH), charset);
    }

    public String getTagValue(int tag) {
        switch (tag) {
            case TAG_FULL_NAME_ARABIC:
                return fullNameArabic;
            case TAG_FULL_NAME_ENGLISH:
                return fullNameEnglish;
            default:
                break;
        }
        return null;
    }
//    public String toString()
//    {
//        StringBuilder stringBuilder = new StringBuilder();
//        stringBuilder.append("DG4: ");
//        stringBuilder.append("{\"fullNameArabic\": \"");stringBuilder.append(fullNameArabic);
//        stringBuilder.append("\";\"fullNameEnglish\": \"");stringBuilder.append(fullNameEnglish);
//        stringBuilder.append("\"}");
//        return stringBuilder.toString();
//    }


    @Override
    public String toString() {
        return "OmanCardDG4File{" +
                "" + TAG_FULL_NAME_ARABIC + "='" + fullNameArabic + '\'' +
                ", " + TAG_FULL_NAME_ENGLISH + "='" + fullNameEnglish + '\'' +
                '}';
    }

    public String getFullNameEnglish() {
        return fullNameEnglish;
    }

    public void setFullNameEnglish(String fullNameEnglish) {
        this.fullNameEnglish = fullNameEnglish;
    }

    public String getFullNameArabic() {
        return fullNameArabic;
    }

    public void setFullNameArabic(String fullNameArabic) {
        this.fullNameArabic = fullNameArabic;
    }
}
