package com.kyc.nashidmrz.id_card.omn;

import net.sf.scuba.util.Hex;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class OmanCardDG6File {
    public static final Charset charset = StandardCharsets.UTF_16LE;
    public static final int TAG_DOB = 0x460F;
    public static final int TAG_COUNTRY_OF_BIRTH_ARABIC = 0xA610;
    public static final int TAG_PLACE_OF_BIRTH_ENGLISH = 0xA611;
    public static final int TAG_NATIONALITY_ARABIC = 0xA612;
    public static final int TAG_GENDER_ARABIC = 0xA613;
    public static final int TAG_NATIONALITY_ENGLISH = 0xE614;
    public static final int TAG_GENDER_ENGLISH = 0xE615;

    String dateOfBirth;
    String countryOfBirthArabic;
    String placeOfBirthEnglish;
    String nationalityArabic;
    String genderArabic;
    String nationalityEnglish;
    String genderEnglish;

    public OmanCardDG6File(byte[] buffer) throws IOException {
        OmanCardDataInputStream omanCardDataInputStream =  new OmanCardDataInputStream(new ByteArrayInputStream(buffer));

        dateOfBirth = Hex.toHexString(omanCardDataInputStream.getTagValue(TAG_DOB));
        countryOfBirthArabic = new String(omanCardDataInputStream.getTagValue(TAG_COUNTRY_OF_BIRTH_ARABIC),charset);
        placeOfBirthEnglish = new String(omanCardDataInputStream.getTagValue(TAG_PLACE_OF_BIRTH_ENGLISH),charset);
        nationalityArabic = new String(omanCardDataInputStream.getTagValue(TAG_NATIONALITY_ARABIC),charset);
        genderArabic = new String(omanCardDataInputStream.getTagValue(TAG_GENDER_ARABIC),charset);
        nationalityEnglish = new String(omanCardDataInputStream.getTagValue(TAG_NATIONALITY_ENGLISH),charset);
        genderEnglish = new String(omanCardDataInputStream.getTagValue(TAG_GENDER_ENGLISH),charset);
    }

    public String getTagValue(int tag)
    {
        switch (tag){
            case TAG_DOB: return dateOfBirth;
            case TAG_COUNTRY_OF_BIRTH_ARABIC: return countryOfBirthArabic;
            case TAG_PLACE_OF_BIRTH_ENGLISH: return placeOfBirthEnglish;
            case TAG_NATIONALITY_ARABIC: return nationalityArabic;
            case TAG_GENDER_ARABIC: return genderArabic;
            case TAG_NATIONALITY_ENGLISH: return nationalityEnglish;
            case TAG_GENDER_ENGLISH: return genderEnglish;
            default: break;
        }
        return null;
    }
   /* public String toString()
    {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DG6: ");
        stringBuilder.append("{\"dateOfBirth\": \"");stringBuilder.append(dateOfBirth);
        stringBuilder.append("\";\"countryOfBirthArabic\": \"");stringBuilder.append(countryOfBirthArabic);
        stringBuilder.append("\";\"placeOfBirthEnglish\": \"");stringBuilder.append(placeOfBirthEnglish);
        stringBuilder.append("\";\"nationalityArabic\": \"");stringBuilder.append(nationalityArabic);
        stringBuilder.append("\";\"genderArabic\": \"");stringBuilder.append(genderArabic);
        stringBuilder.append("\";\"nationalityEnglish\": \"");stringBuilder.append(nationalityEnglish);
        stringBuilder.append("\";\"genderEnglish\": \"");stringBuilder.append(genderEnglish);
        stringBuilder.append("\"}");
        return stringBuilder.toString();
    }*/

    @Override
    public String toString() {
        return "OmanCardDG6File{" +
                ""+TAG_DOB+"='" + dateOfBirth + '\'' +
                ", "+TAG_COUNTRY_OF_BIRTH_ARABIC+"='" + countryOfBirthArabic + '\'' +
                ", "+TAG_PLACE_OF_BIRTH_ENGLISH+"='" + placeOfBirthEnglish + '\'' +
                ", "+TAG_NATIONALITY_ARABIC+"='" + nationalityArabic + '\'' +
                ", "+TAG_GENDER_ARABIC+"='" + genderArabic + '\'' +
                ", "+TAG_NATIONALITY_ENGLISH+"='" + nationalityEnglish + '\'' +
                ", "+TAG_GENDER_ENGLISH+"='" + genderEnglish + '\'' +
                '}';
    }

    public String getDateOfBirth() {
        return dateOfBirth;
    }

    public void setDateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public String getCountryOfBirthArabic() {
        return countryOfBirthArabic;
    }

    public void setCountryOfBirthArabic(String countryOfBirthArabic) {
        this.countryOfBirthArabic = countryOfBirthArabic;
    }

    public String getPlaceOfBirthEnglish() {
        return placeOfBirthEnglish;
    }

    public void setPlaceOfBirthEnglish(String placeOfBirthEnglish) {
        this.placeOfBirthEnglish = placeOfBirthEnglish;
    }

    public String getNationalityArabic() {
        return nationalityArabic;
    }

    public void setNationalityArabic(String nationalityArabic) {
        this.nationalityArabic = nationalityArabic;
    }

    public String getGenderArabic() {
        return genderArabic;
    }

    public void setGenderArabic(String genderArabic) {
        this.genderArabic = genderArabic;
    }

    public String getNationalityEnglish() {
        return nationalityEnglish;
    }

    public void setNationalityEnglish(String nationalityEnglish) {
        this.nationalityEnglish = nationalityEnglish;
    }

    public String getGenderEnglish() {
        return genderEnglish;
    }

    public void setGenderEnglish(String genderEnglish) {
        this.genderEnglish = genderEnglish;
    }
}
