package com.kyc.nashidmrz.mrtd2.activity;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;

import com.kyc.nashidmrz.OtherConstant;
import com.kyc.nashidmrz.R;
import com.kyc.nashidmrz.Utility;
import com.kyc.nashidmrz.mrtd2.resultcallback.ApiResponseListner;
import com.kyc.nashidmrz.mrtd2.resultcallback.callbackclass.DocumentImages;
import com.kyc.nashidmrz.networking.APIClient;
import com.kyc.nashidmrz.networking.APIInterface;
import com.kyc.nashidmrz.networking.models.AutoCrop;
import com.kyc.nashidmrz.utility.DataUtils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class AMLAutoCrop {
    private static boolean isAutoCropCalled = false;
    private static boolean isAMLCalled = false;
    private static int count = 1;

    private static ApiResponseListner apiResponseListner;

    public static void setListner(ApiResponseListner apiResponseListner1) {

        apiResponseListner = apiResponseListner1;
    }

    public static void callAML(String name, String dob, String nationality, String docNumber, String country) {
        Log.d("TAG", "callapi: AML");
        isAMLCalled = false;
        String personData = "[{\"name\": \"" + name + "\", \"birthDate\": \"" + dob + "\", \"nationality\": \"" + nationality + "\", \"identifier\": \"" + docNumber + "\", \"country\": \"" + country + "\"}]";
//        String personData = "  [{\"name\": \"Osama bin Laden\", \"birthDate\": \"\", \"nationality\": \"\", \"identifier\": \"\", \"country\": \"\"}]";
        String checksData = "[\"role.oligarch\",\"role.pep\",\"role.rca\",\"sanction\",\"crime.terror\",\"crime\"]";
        Log.d("TAG", "callAML: " + personData + "   " + checksData);
        APIClient.getClient("AML", OtherConstant.getInstance().getAmlBaseUrl()).create(APIInterface.class).aml(personData, checksData).enqueue(new Callback<ResponseBody>() {
            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                try {
                    Log.d("TAG", "onResponse:AML-- " + response.isSuccessful() + "   " + response);
                    if (response.isSuccessful()) {
                        try {
                            String jsonResponse = response.body().string();
//                            Log.d("TAG", "onResponse:AML " + jsonResponse + "   ");
                            JSONObject jsonObject = new JSONObject(jsonResponse);
                            boolean status = jsonObject.getBoolean("status");
                            DocumentImages documentImages = DocumentImages.Companion.getInstance();
                            if (status) {
                                isAMLCalled = true;
                                JSONArray responseArray = jsonObject.getJSONArray("response");
                                Log.d("TAG", "callapi: AML success response" + jsonObject + "   " + (responseArray.length() > 0));
                                if (responseArray.length() > 0) {
                                    JSONArray innerArray = responseArray.getJSONArray(0); // Accessing the inner array
                                    // Loop through the inner array to access individual objects
                                    if (innerArray.length() > 0) {
                                        for (int i = 0; i < innerArray.length(); i++) {
                                            JSONObject object = innerArray.getJSONObject(i);
                                            // Access individual fields within each object
                                            String name = object.optString("name");
                                            String birthDate = object.optString("birthDate");
                                            String nationality = object.optString("nationality");
                                            String topics = object.optString("topics");
//                                        Log.d("TAG", "onResponse: " + topics);
                                            if (topics.equalsIgnoreCase("role.oligarch") ||
                                                    topics.equalsIgnoreCase("role.pep") ||
                                                    topics.equalsIgnoreCase("role.rca") ||
                                                    topics.equalsIgnoreCase("sanction") ||
                                                    topics.equalsIgnoreCase("crime.terror") ||
                                                    topics.equalsIgnoreCase("crime")) {
                                                documentImages.setAMLSucess(false);
                                                break;
                                            } else {
                                                documentImages.setAMLSucess(true);
                                            }

                                            // ... access other fields similarly
                                        }
                                    }else{
                                        documentImages.setAMLSucess(true);
                                    }
//                                    Log.d("TAG", "onCompleteSuccess:aml " + isAutoCropCalled);

                                } else {
                                    documentImages.setAMLSucess(true);
                                }

                            } else {
                                isAMLCalled = true;
                                documentImages.setAMLSucess(false);
                                // Handle case where status is false
                            }
                            if (isAutoCropCalled) {
                                if (apiResponseListner != null) {
                                    apiResponseListner.onCompleteSuccess();
                                }
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                            isAMLCalled = true;
                            Log.d("TAG", "callapi: AML fail response");
                            Log.d("TAG", "onResponse: " + isAutoCropCalled);
                            if (isAutoCropCalled) {
                                if (apiResponseListner != null) {
                                    apiResponseListner.onCompleteSuccess();
                                }
                            }
                            // Handle JSON parsing exceptions
                        }
                    } else {
                        isAMLCalled = true;
                        if (isAutoCropCalled) {
                            if (apiResponseListner != null) {
                                apiResponseListner.onCompleteSuccess();
                            }
                        }
                    }
                } catch (Exception e) {
                    isAMLCalled = true;
                    e.printStackTrace();
                    if (isAutoCropCalled) {
                        if (apiResponseListner != null) {
                            apiResponseListner.onCompleteSuccess();
                        }
                    }
                }
            }

            @Override
            public void onFailure(Call<ResponseBody> call, Throwable t) {
//                Log.d("TAG", "onResponse:onFailure: " + t);
                isAMLCalled = true;
                if (isAutoCropCalled) {
                    if (apiResponseListner != null) {
                        apiResponseListner.onCompleteSuccess();
                    }
                }
//                if (count == 1) {
//                    count++;
//                    callAML(name, dob, nationality, docNumber, country);
//                }
            }
        });
    }

    public static void callAutoCropAPI(Activity context) {
        Log.d("TAG", "callapi: autocrop");
        isAutoCropCalled = false;
        DocumentImages documentImages = DocumentImages.Companion.getInstance();
        Bitmap bitmap = BitmapFactory.decodeByteArray(Utility.Companion.getInstance().getScannedImage(), 0, Utility.Companion.getInstance().getScannedImage().length);
//        Bitmap bitmap = DataUtils.autoCropDocument(getActivity(), Utility.getInstance().scannedImage, false);
        if (bitmap != null) {
//            binding.imgFrontPage.setImageBitmap(bitmap);
        } else {
            bitmap.recycle();
            bitmap = DataUtils.getCropImageBitmap(context, Utility.Companion.getInstance().getScannedImage());
//            binding.imgFrontPage.setImageBitmap(bitmap);
        }

//        bitmap = BitmapFactory.decodeResource(getResources(), R.drawable.photo);
        Bitmap finalBitmap = bitmap;
        callAutoCrop(context, bitmap, new AutoCroppedCallbacks() {
            @Override
            public void onSuccess(String url) {
                Log.d("TAG", "callapi: get cropped image");
//                Log.d("TAG", "onSuccess:1 " + url);
                documentImages.setFrontCropPage(url);
                if (Utility.Companion.getInstance().getSelectedDoc() != null && !Utility.Companion.getInstance().getSelectedDoc().equalsIgnoreCase(context.getString(R.string.e_passport))) {
//            Bitmap bitmap = DataUtils.autoCropDocument(getActivity(), Utility.getInstance().scannedIdFrontView, true);
                    cropSecondImage(context);

                } else {
                    Log.d("TAG", "callapi: crop else");
                    isAutoCropCalled = true;
                    if (isAMLCalled) {
                        if (apiResponseListner != null) {
                            apiResponseListner.onCompleteSuccess();
                        }
                    }
                }

//                Log.d("TAG", "image:1 " + url);
            }

            @Override
            public void onFail() {
                Log.d("TAG", "callapi: crop fail");
                if (Utility.Companion.getInstance().getSelectedDoc() != null && Utility.Companion.getInstance().getSelectedDoc().equalsIgnoreCase(context.getString(R.string.e_passport))) {
                    isAutoCropCalled = true;
                    if (isAMLCalled) {
                        if (apiResponseListner != null) {
                            apiResponseListner.onCompleteSuccess();
                        }
                    }
                } else {
                    cropSecondImage(context);
                }
//                Log.d("TAG", "callAutoCroponFail: " + finalBitmap);
            }
        });
    }

    private static void cropSecondImage(Activity context) {
        Bitmap bitmap = BitmapFactory.decodeByteArray(Utility.Companion.getInstance().getScannedIdFrontView(), 0, Utility.Companion.getInstance().getScannedIdFrontView().length);
        callAutoCrop(context, bitmap, new AutoCroppedCallbacks() {
            @Override
            public void onSuccess(String url) {
                DocumentImages documentImages = DocumentImages.Companion.getInstance();
                documentImages.setBackCropPage(url);
                isAutoCropCalled = true;
//                Log.d("TAG", "onCompleteSuccess:crop " + isAMLCalled);
                if (isAMLCalled) {
                    if (apiResponseListner != null) {
                        apiResponseListner.onCompleteSuccess();
                    }
                }
//                Log.d("TAG", "image:2 " + url);
            }

            @Override
            public void onFail() {
                isAutoCropCalled = true;
                if (isAMLCalled) {
                    if (apiResponseListner != null) {
                        apiResponseListner.onCompleteSuccess();
                    }
                }
//                Log.d("TAG", "callAutoCroponFail:34 ");
            }
        });
    }

    private static void callAutoCrop(Activity activity, Bitmap bitmap, AutoCroppedCallbacks autoCroppedCallbacks) {
        final boolean[] isSuccess = {false};
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, stream);
        byte[] byteArray = stream.toByteArray();
        MediaType mediaType = MediaType.parse("image/png");
        File filename1 = new File(activity.getFilesDir(), "cropped.png");
//        Log.d("TAG", "callAutoCrop: " + filename1.exists());
        if (filename1.exists()) {
            filename1.delete();
        }
//        Log.d("TAG", "callAutoCrop:after delete " + filename1.exists());
        try (FileOutputStream fos = new FileOutputStream(filename1)) {
            fos.write(byteArray);
        } catch (IOException e) {
            e.printStackTrace();
        }
        RequestBody fileRequestBody = RequestBody.create(filename1, MediaType.parse("image/jpeg"));
// Create a MultipartBody.Part from the RequestBody
        MultipartBody.Part filePart = MultipartBody.Part.createFormData("file", "cropped", fileRequestBody);
//        Log.d("TAG", "callAutoCrop: ");
        RequestBody param1 = RequestBody.create(APIClient.autoCropApiKey(), MediaType.parse("text/plain"));
        RequestBody param2 = RequestBody.create(APIClient.autoCropApiSecretKey(), MediaType.parse("text/plain"));
        APIClient.getClient("image crop", OtherConstant.getInstance().getAutoCropBaseUrl()).create(APIInterface.class).
                callAutoCrop(param1, param2, filePart).enqueue(new Callback<AutoCrop>() {
                    @Override
                    public void onResponse(Call<AutoCrop> call, Response<AutoCrop> response) {
                        try {
                            if (response.code() == 200) {
//                            Log.d("TAG", "callAutoCrop: " + response.body());
                                if (autoCroppedCallbacks != null) {
                                    if (response.body() != null && response.body().getPresigned_url() != null)
                                        autoCroppedCallbacks.onSuccess(response.body().getPresigned_url());
                                    else
                                        autoCroppedCallbacks.onFail();
                                }
                            } else {
                                if (autoCroppedCallbacks != null) {
                                    autoCroppedCallbacks.onFail();
                                }
                            }

                        } catch (Exception e) {
                            Log.d("TAG", "callapi callAutoCrop onFailure:catch " + e.toString());
                            isSuccess[0] = false;
                            if (autoCroppedCallbacks != null) {
                                autoCroppedCallbacks.onFail();
                            }
//                            Log.d("TAG", "callAutoCrop: failur---" + e + "\n" + response.body());
                        }
                    }

                    @Override
                    public void onFailure(Call<AutoCrop> call, Throwable t) {
                        Log.d("TAG", "callapi callAutoCrop onFailure: " + t);
                        isSuccess[0] = false;
                        if (autoCroppedCallbacks != null) {
                            autoCroppedCallbacks.onFail();
                        }

                    }

                });

    }

    public interface AutoCroppedCallbacks {
        void onSuccess(String url);

        void onFail();
    }
}
