package com.kyc.nashidmrz.mrtd2.activity;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import com.kyc.nashidmrz.OtherConstant;
import com.kyc.nashidmrz.R;
import com.kyc.nashidmrz.databinding.ActivityInstructionBinding;
import com.kyc.nashidmrz.mrtd2.rooted.RootedCheck;

public class InstructionScreenActivity extends BaseActivity {

    private ActivityInstructionBinding helpBinding;
    private String selectedDocType;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        helpBinding = ActivityInstructionBinding.inflate(getLayoutInflater());
        setContentView(helpBinding.getRoot());
        RootedCheck.getInstance().setFlag(InstructionScreenActivity.this);
        if (RootedCheck.getInstance().isRootedDevice(getApplicationContext())) {
            RootedCheck.getInstance().showRootedDeviceDialog(this,getString(R.string.root_dialog),getString(R.string.root_desc),getString(R.string.root_btn));
        } else {
            intView();
            initClick();
        }
    }

    private void initClick() {
        helpBinding.layoutHeader.imgBack.setOnClickListener(view -> onBackPressed());
        helpBinding.btnNext.setOnClickListener(view -> {
            Intent i = new Intent(InstructionScreenActivity.this, StartScanningActivity.class);
            i.putExtra(getResources().getString(R.string.doc_key), selectedDocType);
            startActivity(i);
            finish();
            overridePendingTransition(android.R.anim.fade_in, android.R.anim.fade_out);
        });
        helpBinding.imgSetting.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent i = new Intent(InstructionScreenActivity.this, SDKSettingScreen.class);
                startActivity(i);
                overridePendingTransition(android.R.anim.fade_in, android.R.anim.fade_out);
            }
        });

    }

    private void intView() {

        if (getIntent().hasExtra(getResources().getString(R.string.doc_key))) {
            selectedDocType = getIntent().getStringExtra(getResources().getString(R.string.doc_key));
        }

        try {

            SVG back = SVG.getFromResource(getResources(), R.raw.back);
            helpBinding.layoutHeader.imgBack.setSVG(back);

            SVG svg1 = SVG.getFromResource(getResources(), R.raw.step1);
            helpBinding.imgStep1.setSVG(svg1);
            SVG svg2 = SVG.getFromResource(getResources(), R.raw.step2);
            helpBinding.imagStep2.setSVG(svg2);
            SVG svg3 = SVG.getFromResource(getResources(), R.raw.step3);
            helpBinding.imgStep3.setSVG(svg3);

        } catch (SVGParseException e) {

        }
        setLayoutAndTextSize();
        Log.d("TAG", "intView: "+OtherConstant.getInstance().getNeedToShowSettingScreen());
        if (OtherConstant.getInstance().getNeedToShowSettingScreen()){
            helpBinding.imgSetting.setVisibility(View.VISIBLE);
        }else{
            helpBinding.imgSetting.setVisibility(View.GONE);
        }
    }

    private void setLayoutAndTextSize() {

        if (getStorage().getPreferredLocale().equalsIgnoreCase("ar")) {
            helpBinding.layoutHeader.imgBack.setRotation(180);
        }

        TextSizeConverter textSizeConverter = new TextSizeConverter(getApplicationContext());
        textSizeConverter.changeStatusBarColor(InstructionScreenActivity.this);
        int padding = textSizeConverter.getPaddingORMarginValue(16);
        helpBinding.lytInstructionMain.setPadding(padding, padding, padding, padding);

        padding = textSizeConverter.getPaddingORMarginValue(4);
        helpBinding.imgStep1.setPadding(padding, padding, padding, padding);
        helpBinding.imagStep2.setPadding(padding, padding, padding, padding);
        helpBinding.imgStep3.setPadding(padding, padding, padding, padding);

        // Set the LayoutParams to the RelativeLayout
        LinearLayout.LayoutParams layoutParams = textSizeConverter.getLinearLayoutParam();
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(4), 0, 0);
        helpBinding.layoutHeader.lytHeaderMain.setLayoutParams(layoutParams);

        ViewGroup.LayoutParams layoutParams2 = helpBinding.layoutHeader.imgBack.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(24);
        layoutParams2.height = textSizeConverter.getHeight(24);
        helpBinding.layoutHeader.imgBack.setLayoutParams(layoutParams2);

        layoutParams2 = helpBinding.imgSetting.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(24);
        layoutParams2.height = textSizeConverter.getHeight(24);
        helpBinding.imgSetting.setLayoutParams(layoutParams2);

        helpBinding.layoutHeader.txtHelp.setText(getString(R.string.instruction));
        helpBinding.layoutHeader.txtHelp.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(17));

        LinearLayout.LayoutParams marginLyoutParam = (LinearLayout.LayoutParams) helpBinding.nestedScrollview.getLayoutParams();
        marginLyoutParam.setMargins(0, textSizeConverter.getPaddingORMarginValue(44), 0, 0);
        helpBinding.nestedScrollview.setLayoutParams(marginLyoutParam);

        ViewGroup.LayoutParams imageLayoutParams = helpBinding.imgLytStep1.getLayoutParams();
        imageLayoutParams.width = textSizeConverter.getWidth(80);
        imageLayoutParams.height = textSizeConverter.getHeight(80);
        helpBinding.imgLytStep1.setLayoutParams(imageLayoutParams);
        helpBinding.imgLytStep1.setRadius(textSizeConverter.calculateRadius(7));

        imageLayoutParams = helpBinding.imgLytStep2.getLayoutParams();
        imageLayoutParams.width = textSizeConverter.getWidth(80);
        imageLayoutParams.height = textSizeConverter.getHeight(80);
        helpBinding.imgLytStep2.setLayoutParams(imageLayoutParams);
        helpBinding.imgLytStep2.setRadius(textSizeConverter.calculateRadius(7));

        imageLayoutParams = helpBinding.imgLytStep3.getLayoutParams();
        imageLayoutParams.width = textSizeConverter.getWidth(80);
        imageLayoutParams.height = textSizeConverter.getHeight(80);
        helpBinding.imgLytStep3.setLayoutParams(imageLayoutParams);
        helpBinding.imgLytStep3.setRadius(textSizeConverter.calculateRadius(7));

        marginLyoutParam = (LinearLayout.LayoutParams) helpBinding.lyouStep2.getLayoutParams();
        marginLyoutParam.setMargins(0, textSizeConverter.getPaddingORMarginValue(20), 0, 0);
        helpBinding.lyouStep2.setLayoutParams(marginLyoutParam);
        marginLyoutParam = (LinearLayout.LayoutParams) helpBinding.lyouStep3.getLayoutParams();
        marginLyoutParam.setMargins(0, textSizeConverter.getPaddingORMarginValue(20), 0, 0);
        helpBinding.lyouStep3.setLayoutParams(marginLyoutParam);

        marginLyoutParam = (LinearLayout.LayoutParams) helpBinding.lytTxtStep1.getLayoutParams();
        marginLyoutParam.setMargins(textSizeConverter.getPaddingORMarginValue(16), 0, textSizeConverter.getPaddingORMarginValue(16), 0);
        helpBinding.lytTxtStep1.setLayoutParams(marginLyoutParam);
        marginLyoutParam = (LinearLayout.LayoutParams) helpBinding.lytTxtStep2.getLayoutParams();
        marginLyoutParam.setMargins(textSizeConverter.getPaddingORMarginValue(16), 0, textSizeConverter.getPaddingORMarginValue(16), 0);
        helpBinding.lytTxtStep2.setLayoutParams(marginLyoutParam);
        marginLyoutParam = (LinearLayout.LayoutParams) helpBinding.lytTxtStep3.getLayoutParams();
        marginLyoutParam.setMargins(textSizeConverter.getPaddingORMarginValue(16), 0, textSizeConverter.getPaddingORMarginValue(16), 0);
        helpBinding.lytTxtStep3.setLayoutParams(marginLyoutParam);

        padding = textSizeConverter.getPaddingORMarginValue(12);
        helpBinding.txtBtnNext.setPadding(0, padding, 0, padding);
        helpBinding.btnNext.setRadius(textSizeConverter.calculateRadius(8));

        helpBinding.txtBtnNext.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(16));

        helpBinding.txtStep1.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(14));
        helpBinding.txtStep2.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(14));
        helpBinding.txtStep3.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(14));

        helpBinding.txtStep1Desc.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(16));
        helpBinding.txtStep2Desc.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(16));
        helpBinding.txtStep3Desc.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(16));

    }

}
