package com.kyc.nashidmrz.mrtd2.activity;

import android.content.Context;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.ViewGroup;

import androidx.recyclerview.widget.RecyclerView;

import com.kyc.nashidmrz.Constant;
import com.kyc.nashidmrz.databinding.ItemNfcDetailBinding;

import java.util.HashMap;

public class NFCDetailAdapter extends RecyclerView.Adapter<NFCDetailAdapter.ViewHolder> {

    private final String[]  keys;
    private HashMap<String, String> list = new HashMap<>();
    private final Context context;

    public NFCDetailAdapter(Context context, HashMap<String, String> list) {
        this.context = context;
        this.list = list;
        keys = list.keySet().toArray(new String[0]);
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        LayoutInflater layoutInflater = LayoutInflater.from(parent.getContext());
        ItemNfcDetailBinding binding =ItemNfcDetailBinding.inflate(layoutInflater, parent, false);
        return new ViewHolder(binding);
    }

    @Override
    public void onBindViewHolder(ViewHolder holder, int position) {
//        Log.d("TAG", "setIDCardDetail:date ada "+keys[position]+"--"+list.get(keys[position]));
        holder.binding.txtFieldName.setText(keys[position]);
        holder.binding.txtFieldValue.setText(list.get(keys[position]));
    }

    @Override
    public int getItemCount() {
        return list.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private final ItemNfcDetailBinding binding;

        public ViewHolder(ItemNfcDetailBinding itemSelectDocumentBinding) {
            super(itemSelectDocumentBinding.getRoot());
            this.binding = itemSelectDocumentBinding;
            TextSizeConverter textSizeConverter = new TextSizeConverter(context);
            itemSelectDocumentBinding.txtFieldName.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(14));
            itemSelectDocumentBinding.txtFieldValue.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(14));


            int padding = textSizeConverter.getPaddingORMarginValue(12);
            itemSelectDocumentBinding.divider.setPadding(0, padding, 0, 0);

            padding = textSizeConverter.getPaddingORMarginValue(24);
            itemSelectDocumentBinding.lytNfcMain.setPadding(0, padding, 0, 0);

        }
    }
}