package com.kyc.nashidmrz.mrtd2.activity

import android.os.Bundle
import android.util.TypedValue
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import androidx.recyclerview.widget.LinearLayoutManager
import com.bumptech.glide.Glide
import com.kyc.nashidmrz.Constant
import com.kyc.nashidmrz.LivenessData
import com.kyc.nashidmrz.OtherConstant
import com.kyc.nashidmrz.R
import com.kyc.nashidmrz.Utility
import com.kyc.nashidmrz.databinding.FragmentNfcBinding
import com.kyc.nashidmrz.id_card.omn.OmanCardDG10File
import com.kyc.nashidmrz.id_card.omn.OmanCardDG11File
import com.kyc.nashidmrz.id_card.omn.OmanCardDG13File
import com.kyc.nashidmrz.id_card.omn.OmanCardDG1File
import com.kyc.nashidmrz.id_card.omn.OmanCardDG4File
import com.kyc.nashidmrz.id_card.omn.OmanCardDG6File
import org.json.JSONObject
import java.io.IOException
import java.text.DateFormat
import java.text.SimpleDateFormat
import java.util.GregorianCalendar
import java.util.Locale

class NFCFragment : Fragment() {
    private var binding: FragmentNfcBinding? = null
    private val personalHashmap: HashMap<String, String> = LinkedHashMap()
    private val documentHashmap: HashMap<String, String> = LinkedHashMap()
    private val visaHashmap: HashMap<String, String> = LinkedHashMap()
    private val sponsorHashmap: HashMap<String, String> = LinkedHashMap()
    private val companyHashmap: HashMap<String, String> = LinkedHashMap()

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?,
    ): View {
        binding = FragmentNfcBinding.inflate(inflater, container, false)
        initView()
        return binding!!.root
    }

    private fun initView() {
        val textSizeConverter = TextSizeConverter(activity)

//        topview
        val padding = textSizeConverter.getPaddingORMarginValue(16)
        binding!!.mainNfcFragmnent.setPadding(padding, padding, padding, padding)
        var layoutParams = textSizeConverter.linearLayoutParam
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(28), 0, 0)
        binding!!.mainPhotoLayout.layoutParams = layoutParams
        var layoutParams2 = binding!!.profileCard.layoutParams
        layoutParams2.width = textSizeConverter.getWidth(106)
        layoutParams2.height = textSizeConverter.getHeight(106)
        binding!!.profileCard.layoutParams = layoutParams2
        layoutParams2 = binding!!.imgSignature.layoutParams
        layoutParams2.width = textSizeConverter.getWidth(106)
        layoutParams2.height = textSizeConverter.getHeight(52)
        binding!!.imgSignature.layoutParams = layoutParams2
        //
        binding!!.txtUserName.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(14),
        )
        binding!!.txtDocNumber.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(12),
        )
        layoutParams = textSizeConverter.matchParentLinearLayoutParam
        layoutParams.setMargins(
            textSizeConverter.getPaddingORMarginValue(15),
            0,
            textSizeConverter.getPaddingORMarginValue(15),
            0,
        )
        binding!!.lytName.layoutParams = layoutParams
        val textSize = 20
        layoutParams = textSizeConverter.linearLayoutParam
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(32), 0, 0)
        binding!!.txtPersonalImfo.layoutParams = layoutParams
        layoutParams = textSizeConverter.linearLayoutParam
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(32), 0, 0)
        binding!!.txtPersonalInfoHeader.layoutParams = layoutParams
        binding!!.txtDocument.layoutParams = layoutParams
        binding!!.txtVisa.layoutParams = layoutParams
        binding!!.txtSponser.layoutParams = layoutParams
        binding!!.txtCompany.layoutParams = layoutParams
        binding!!.txtPersonalInfoHeader.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(textSize),
        )
        binding!!.txtPersonalImfo.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(textSize),
        )
        binding!!.txtDocument.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(textSize),
        )
        binding!!.txtVisa.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(textSize),
        )
        binding!!.txtSponser.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(textSize),
        )
        binding!!.txtCompany.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(textSize),
        )
        try {
            if (Utility.getInstance().selectedDoc != null && Utility.getInstance().selectedDoc ==
                getString(
                    R.string.e_passport,
                )
            ) {
                setPassportDetail()
                binding!!.imgSignature.visibility = View.VISIBLE
            } else {
                setIDCardDetail()
                binding!!.imgSignature.visibility = View.GONE
            }
        } catch (e: Exception) {
        }
        binding!!.recyclerviewPersonalInfo.layoutManager =
            LinearLayoutManager(context, LinearLayoutManager.VERTICAL, false)
        binding!!.rcyclerviewDocument.layoutManager =
            LinearLayoutManager(context, LinearLayoutManager.VERTICAL, false)
        binding!!.recyclerviewVisa.layoutManager =
            LinearLayoutManager(context, LinearLayoutManager.VERTICAL, false)
        binding!!.recyclerviewSponser.layoutManager =
            LinearLayoutManager(context, LinearLayoutManager.VERTICAL, false)
        binding!!.recyclerviewCompany.layoutManager =
            LinearLayoutManager(context, LinearLayoutManager.VERTICAL, false)
        var nfcDetailAdapter: NFCDetailAdapter
        if (Utility.getInstance().selectedDoc != null && Utility.getInstance().selectedDoc ==
            getString(
                R.string.e_passport,
            )
        ) {
            nfcDetailAdapter = NFCDetailAdapter(activity, personalHashmap)
            binding!!.rcyclerviewDocument.adapter = nfcDetailAdapter
            binding!!.txtPersonalImfo.visibility = View.GONE
            binding!!.recyclerviewPersonalInfo.visibility = View.GONE
            binding!!.txtVisa.visibility = View.GONE
            binding!!.recyclerviewVisa.visibility = View.GONE
            binding!!.txtCompany.visibility = View.GONE
            binding!!.recyclerviewCompany.visibility = View.GONE
            binding!!.txtSponser.visibility = View.GONE
            binding!!.recyclerviewSponser.visibility = View.GONE
        } else {
            nfcDetailAdapter = NFCDetailAdapter(activity, documentHashmap)
            binding!!.recyclerviewPersonalInfo.adapter = nfcDetailAdapter
            nfcDetailAdapter = NFCDetailAdapter(activity, personalHashmap)
            binding!!.rcyclerviewDocument.adapter = nfcDetailAdapter
            nfcDetailAdapter = NFCDetailAdapter(activity, visaHashmap)
            binding!!.recyclerviewVisa.adapter = nfcDetailAdapter
            nfcDetailAdapter = NFCDetailAdapter(activity, sponsorHashmap)
            binding!!.recyclerviewSponser.adapter = nfcDetailAdapter
            nfcDetailAdapter = NFCDetailAdapter(activity, companyHashmap)
            binding!!.recyclerviewCompany.adapter = nfcDetailAdapter
        }
    }

    private val emptyString = ""

    private fun setPassportDetail() {
        val eDocument = LivenessData.getInstance().geteDocument()
        val personDetails = eDocument.personDetails
        val additionalPersonDetails = eDocument.additionalPersonDetails
        val additionalDGFiles = eDocument.additionalDGFiles
        personalHashmap[getString(R.string.passdocumentType)] = eDocument.docType.name
        personalHashmap[getString(R.string.passdocumentNumber)] = personDetails.serialNumber
        personalHashmap[getString(R.string.passissuingAuthority)] = personDetails.issuerAuthority
        personalHashmap[getString(R.string.passdateOfBirth)] = personDetails.birthDate
        personalHashmap[getString(R.string.passgender)] = personDetails.gender
        personalHashmap[getString(R.string.passdocumentExpiryDate)] = personDetails.expiryDate
        binding!!.imgProfile.setImageBitmap(personDetails.faceImage)
        Glide.with(requireActivity()).load(personDetails.signature).into(binding!!.imgSignature)
        if (additionalPersonDetails != null) {
            personalHashmap[getString(R.string.passfullName)] =
                additionalPersonDetails.nameOfHolder.replace("null ", "")
        }
        personalHashmap[getString(R.string.passpersonalNumber)] = personDetails.personalNumber
        if (additionalPersonDetails != null) {
            if (additionalPersonDetails.placeOfBirth != null) {
                personalHashmap[getString(R.string.passplaceOfBirth)] =
                    additionalPersonDetails.placeOfBirth[0]
            } else {
                personalHashmap[getString(R.string.passplaceOfBirth)] =
                    emptyString
            }
            if (additionalPersonDetails.permanentAddress != null) {
                personalHashmap[getString(R.string.passaddress)] =
                    additionalPersonDetails.permanentAddress[0]
            } else {
                personalHashmap[getString(R.string.passaddress)] =
                    emptyString
            }
            if (!OtherConstant.getInstance().appName.equals(
                    getString(R.string.overify),
                    ignoreCase = true,
                )
            ) {
                personalHashmap[getString(R.string.passprofession)] =
                    additionalPersonDetails.profession
                personalHashmap[getString(R.string.passtitle)] = additionalPersonDetails.title
                personalHashmap[getString(R.string.passpersonalSummary)] =
                    additionalPersonDetails.personalSummary
                if (additionalPersonDetails.otherValidTDNumbers != null) {
                    personalHashmap[getString(R.string.passtdNumbers)] =
                        additionalPersonDetails.otherValidTDNumbers[0]
                } else {
                    personalHashmap[getString(R.string.passtdNumbers)] =
                        emptyString
                }
                personalHashmap[getString(R.string.passcustodyInfo)] =
                    additionalPersonDetails.custodyInformation
                if (additionalPersonDetails.proofOfCitizenship != null) {
                    personalHashmap[getString(R.string.passproofOfCitizenship)] =
                        additionalPersonDetails.proofOfCitizenship.toString()
                } else {
                    personalHashmap[
                        getString(
                            R.string.passproofOfCitizenship,
                        ),
                    ] = emptyString
                }
            }
            personalHashmap[getString(R.string.passtelephone)] = additionalPersonDetails.telephone
            binding!!.txtUserName.text = additionalPersonDetails.nameOfHolder
        } else {
            binding!!.txtUserName.text = personDetails.name
            personalHashmap[getString(R.string.passfullName)] =
                personDetails.name.replace("null ", "")
        }
        personalHashmap[getString(R.string.passnfcissuingCountry)] =
            additionalDGFiles.issueingAuthority
        if (!OtherConstant.getInstance().appName.equals(
                getString(R.string.overify),
                ignoreCase = true,
            )
        ) {
            if (additionalDGFiles.frontImage != null) {
                personalHashmap[getString(R.string.passfrontImage)] =
                    additionalDGFiles.frontImage.toString()
            } else {
                personalHashmap[getString(R.string.passfrontImage)] =
                    emptyString
            }
            if (additionalDGFiles.backImage != null) {
                personalHashmap[getString(R.string.passrearImage)] =
                    additionalDGFiles.backImage.toString()
            } else {
                personalHashmap[getString(R.string.passrearImage)] =
                    emptyString
            }
            personalHashmap[getString(R.string.passPersonalizationNumber)] =
                additionalDGFiles.personalizationDeviceSerialNumber
            personalHashmap[getString(R.string.passPersonalizationTime)] =
                additionalDGFiles.personalizationTime
            personalHashmap[getString(R.string.passsecurityInfos)] = additionalDGFiles.securityInfos
            personalHashmap[getString(R.string.passrsaPublicKey)] = eDocument.rsaPublicKey
            personalHashmap[getString(R.string.passecdsaPublicKey)] = eDocument.ecdsaPublicKey
        }
        personalHashmap[getString(R.string.passive_authentication)] =
            personDetails.isDigitalSigVerification.toString()
        binding!!.txtDocNumber.text = personDetails.nationality + " | " + personDetails.serialNumber
    }

    private val dateFormate = "yyyyMMdd"
    private val passportDateFormate = "yyMMdd"
    private val certificateDateFormate = "MMM dd, yyyy"

    @Throws(IOException::class)
    private fun setIDCardDetail() {
        binding!!.imgProfile.setImageBitmap(LivenessData.getInstance().nfcImage)
        val dg1Parser = OmanCardDG1File(Utility.getInstance().dgFile1)
        val dg4Parser = OmanCardDG4File(Utility.getInstance().dgFile4)
        val dg6Parser = OmanCardDG6File(Utility.getInstance().dgFile6)
        try {
            binding!!.txtUserName.text =
                nfcData!!.getString(getString(R.string.idcardfullNameEnglish))
            binding!!.txtDocNumber.text = dg6Parser.nationalityEnglish + " | " + dg1Parser.idNumber
            documentHashmap[getString(R.string.idcardidNumber)] = dg1Parser.idNumber
            documentHashmap[getString(R.string.idcardissueDate)] =
                formateDateFromstring(dateFormate, Constant.DATEFORMATE, dg1Parser.issueDate)
            documentHashmap[getString(R.string.idcardexpiryDate)] =
                formateDateFromstring(dateFormate, Constant.DATEFORMATE, dg1Parser.expiryDate)
            documentHashmap[getString(R.string.idcardplaceOfIssueArabic)] =
                dg1Parser.placeOfIssueArabic
            documentHashmap[getString(R.string.idcardplaceOfIssueEnglish)] =
                dg1Parser.placeOfIssueEnglish
            if (dg4Parser != null) {
                personalHashmap[getString(R.string.idcardfullNameArabic)] = dg4Parser.fullNameArabic
                personalHashmap[getString(R.string.idcardfullNameEnglish)] =
                    dg4Parser.fullNameEnglish
            }
            if (dg6Parser != null) {
                personalHashmap[getString(R.string.idcarddateOfBirth)] =
                    formateDateFromstring(dateFormate, Constant.DATEFORMATE, dg6Parser.dateOfBirth)
                personalHashmap[getString(R.string.idcardcountryOfBirthArabic)] =
                    dg6Parser.countryOfBirthArabic
                personalHashmap[getString(R.string.idcardplaceOfBirthEnglish)] =
                    dg6Parser.placeOfBirthEnglish
                personalHashmap[getString(R.string.idcardnationalityArabic)] =
                    dg6Parser.nationalityArabic
                personalHashmap[getString(R.string.idcardgenderArabic)] = dg6Parser.genderArabic
                personalHashmap[getString(R.string.idcardnationalityEnglish)] =
                    dg6Parser.nationalityEnglish
                personalHashmap[getString(R.string.idcardgenderEnglish)] = dg6Parser.genderEnglish
            }
            if (Utility.getInstance().dgFile13 != null) {
                val dg13Parser = OmanCardDG13File(Utility.getInstance().dgFile13)
                if (dg13Parser != null) {
                    visaHashmap[getString(R.string.idcardvisaNumber)] = dg13Parser.sponsorNumber
                    sponsorHashmap[getString(R.string.idcardPermitType)] =
                        dg13Parser.sponsorRelationship
                    binding!!.txtSponser.visibility = View.VISIBLE
                    binding!!.recyclerviewSponser.visibility = View.VISIBLE
                } else {
                    binding!!.txtSponser.visibility = View.GONE
                    binding!!.recyclerviewSponser.visibility = View.GONE
                }
            }
            if (Utility.getInstance().dgFile10 != null) {
                val dg10Parser = OmanCardDG10File(Utility.getInstance().dgFile10)
                if (dg10Parser != null) {
                    visaHashmap[getString(R.string.idcardvisaExpiryDate)] =
                        formateDateFromstring(
                            dateFormate,
                            Constant.DATEFORMATE,
                            dg10Parser.visaExpiryDate,
                        )
                    visaHashmap[getString(R.string.idcardvisaPlaceOfIssueArabic)] =
                        dg10Parser.visaPlaceOfIssueArabic
                    sponsorHashmap[getString(R.string.idcardPermitNumber)] = dg10Parser.visaNumber
                    binding!!.txtVisa.visibility = View.VISIBLE
                    binding!!.recyclerviewVisa.visibility = View.VISIBLE
                } else {
                    binding!!.txtVisa.visibility = View.GONE
                    binding!!.recyclerviewVisa.visibility = View.GONE
                }
            }
            if (Utility.getInstance().dgFile13 != null) {
                val dg13Parser = OmanCardDG13File(Utility.getInstance().dgFile13)
                if (dg13Parser != null) {
                    visaHashmap[getString(R.string.idcardsponsorIssueDate)] =
                        formateDateFromstring(
                            dateFormate,
                            Constant.DATEFORMATE,
                            dg13Parser.sponsorIssueDate,
                        )
                    visaHashmap[getString(R.string.idcardsponsorExpiryDate)] =
                        formateDateFromstring(
                            dateFormate,
                            Constant.DATEFORMATE,
                            dg13Parser.sponsorExpiryDate,
                        )
                    binding!!.txtSponser.visibility = View.VISIBLE
                    binding!!.recyclerviewSponser.visibility = View.VISIBLE
                } else {
                    binding!!.txtSponser.visibility = View.GONE
                    binding!!.recyclerviewSponser.visibility = View.GONE
                }
            }
            if (Utility.getInstance().dgFile11 != null) {
                val dg11Parser = OmanCardDG11File(Utility.getInstance().dgFile11)
                if (dg11Parser != null) {
                    companyHashmap[getString(R.string.idcardcompanyNameArabic)] =
                        dg11Parser.companyNameArabic
                    companyHashmap[getString(R.string.idcardcompanyNameEnglish)] =
                        dg11Parser.companyNameEnglish
                    companyHashmap[getString(R.string.idcardcompanyAddressArabic)] =
                        dg11Parser.companyAddressArabic
                    binding!!.txtCompany.visibility = View.VISIBLE
                    binding!!.recyclerviewCompany.visibility = View.VISIBLE
                } else {
                    binding!!.txtCompany.visibility = View.GONE
                    binding!!.recyclerviewCompany.visibility = View.GONE
                }
            }
        } catch (e: Exception) {
        }
    }

    private fun format6digitDate(
        mrtdDate: String,
        startingYear: Int,
    ): String {
        val simpleDateFormat = SimpleDateFormat("yyMMdd")
        simpleDateFormat.set2DigitYearStart(GregorianCalendar(startingYear, 1, 1).time)
        return try {
            val mrtdDateObject = simpleDateFormat.parse(mrtdDate)
            SimpleDateFormat(dateFormate).format(mrtdDateObject)
        } catch (e: Exception) {
            ""
        }
    }

    private fun formateDateFromstring(
        inputFormat: String,
        outputFormat: String,
        inputDate: String,
    ): String {
        try {
//            Log.d(TAG, "formateDateFromstring: "+Locale.getDefault());
            val sdf: DateFormat = SimpleDateFormat(inputFormat, Locale.ENGLISH)
            val date = sdf.parse(inputDate)
            return SimpleDateFormat(outputFormat, Locale.ENGLISH).format(date)
        } catch (e: Exception) {
        }
        return inputDate
    }

    companion object {
        var nfcData: JSONObject? = null
    }
}
