package com.kyc.nashidmrz.mrtd2.activity

import android.os.Bundle
import android.util.TypedValue
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import androidx.fragment.app.Fragment
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import com.kyc.nashidmrz.databinding.FragmentScanningBinding
import com.kyc.nashidmrz.mrtd2.activity.viewmodel.ScanningViewModel

class ScanningFragment : Fragment() {
    private lateinit var binding: FragmentScanningBinding
    private lateinit var viewModel: ScanningViewModel

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?,
    ): View {
        binding = FragmentScanningBinding.inflate(inflater, container, false)
        viewModel = ViewModelProvider(this).get(ScanningViewModel::class.java)

        initView()
        observeViewModel()

        return binding.root
    }

    private fun initView() {
        val textSizeConverter = TextSizeConverter(activity)
        val padding = textSizeConverter.getPaddingORMarginValue(16)
        binding.mainScanningFragmnent.setPadding(padding, padding, padding, padding)

        var layoutParams = textSizeConverter.linearLayoutParam
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(28), 0, 0)
        binding.mainPhotoLayout.layoutParams = layoutParams

        var layoutParams2 = binding.cardImage.layoutParams
        layoutParams2.width = textSizeConverter.getWidth(106)
        layoutParams2.height = textSizeConverter.getHeight(106)
        binding.cardImage.layoutParams = layoutParams2

        binding.txtName.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(14))
        binding.txtCountryCode.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(12),
        )

        layoutParams = textSizeConverter.matchParentLinearLayoutParam
        layoutParams.setMargins(
            textSizeConverter.getPaddingORMarginValue(15),
            0,
            textSizeConverter.getPaddingORMarginValue(15),
            0,
        )
        binding.lytName.layoutParams = layoutParams

        layoutParams = textSizeConverter.linearLayoutParam
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(32), 0, 0)
        binding.txtPersonalInfo.layoutParams = layoutParams
        binding.txtDocScan.layoutParams = layoutParams
        binding.txtPersonalInfo.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(20),
        )
        binding.txtDocScan.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(20),
        )

        layoutParams = textSizeConverter.linearLayoutParam
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(14), 0, 0)
        binding.imgBackPage.layoutParams = layoutParams

        layoutParams = textSizeConverter.linearLayoutParam
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(14), 0, 0)
        binding.imgBackPage.layoutParams = layoutParams

        layoutParams2 = binding.imgFrontPage.layoutParams
        layoutParams2.width = LinearLayout.LayoutParams.MATCH_PARENT
        layoutParams2.height = textSizeConverter.getHeight(226)
        binding.imgFrontPage.layoutParams = layoutParams2

        layoutParams2 = binding.imgBackPage.layoutParams
        layoutParams2.width = LinearLayout.LayoutParams.MATCH_PARENT
        layoutParams2.height = textSizeConverter.getHeight(226)
        binding.imgBackPage.layoutParams = layoutParams2

        viewModel.initData(requireActivity())
    }

    private fun observeViewModel() {
        viewModel.name.observe(viewLifecycleOwner) { name ->
            binding.txtName.text = name
        }

        viewModel.countryCode.observe(viewLifecycleOwner) { countryCode ->
            binding.txtCountryCode.text = countryCode
        }

        viewModel.frontPageImage.observe(viewLifecycleOwner) { bitmap ->
            binding.imgFrontPage.setImageBitmap(bitmap)
        }

        viewModel.backPageImage.observe(viewLifecycleOwner) { bitmap ->
            if (bitmap != null) {
                binding.imgBackPage.visibility = View.VISIBLE
                binding.imgBackPage.setImageBitmap(bitmap)
            }
        }

        viewModel.profileImage.observe(viewLifecycleOwner) { bitmap ->
            binding.profileImage.setImageBitmap(bitmap)
        }

        viewModel.personalHashmap.observe(viewLifecycleOwner) { hashmap ->
            val adapter = NFCDetailAdapter(activity, hashmap)
            binding.recyclerviewPersonalInfo.layoutManager =
                LinearLayoutManager(activity, LinearLayoutManager.VERTICAL, false)
            binding.recyclerviewPersonalInfo.adapter = adapter
        }
    }
}
