package com.kyc.nashidmrz.mrtd2.activity;

import android.content.Intent;
import android.os.Bundle;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.airbnb.lottie.LottieDrawable;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import com.kyc.nashidmrz.OtherConstant;
import com.kyc.nashidmrz.R;
import com.kyc.nashidmrz.Utility;
import com.kyc.nashidmrz.databinding.ActivityStartScanningBinding;
import com.kyc.nashidmrz.mrtd2.rooted.RootedCheck;
import com.kyc.nashidmrz.utility.PermissionHelper;
import com.kyc.nashidmrz.utility.SharePreferenceUtility;

import java.util.List;

public class StartScanningActivity extends BaseActivity {

    private ActivityStartScanningBinding activityStartScanningBinding;
    private String selectedDoc;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        activityStartScanningBinding = ActivityStartScanningBinding.inflate(getLayoutInflater());
        setContentView(activityStartScanningBinding.getRoot());
        RootedCheck.getInstance().setFlag(StartScanningActivity.this);
        if (RootedCheck.getInstance().isRootedDevice(getApplicationContext())) {
            RootedCheck.getInstance().showRootedDeviceDialog(this, getString(R.string.root_dialog), getString(R.string.root_desc), getString(R.string.root_btn));
        } else {
            initView();
            initClick();
        }

    }

    private void initClick() {
        activityStartScanningBinding.layoutHeader.imgBack.setOnClickListener(view -> finish());
        activityStartScanningBinding.btnStartScanning.setOnClickListener(view -> PermissionHelper.INSTANCE.requestPermissions(StartScanningActivity.this, new PermissionHelper.PermissionCallback() {
            @Override
            public void onResult(boolean allGranted, @NonNull List<String> grantedList, @NonNull List<String> deniedList) {
                if (allGranted && isInternetAvailable()) {
                    Intent i = new Intent(StartScanningActivity.this, CameraXLivePreviewActivity.class);
                    i.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
                    i.putExtra(getResources().getString(R.string.doc_key), selectedDoc);
                    startActivity(i);
                    if (!OtherConstant.getInstance().getAppName().equalsIgnoreCase(getString(R.string.overify))) {
                        Utility.Companion.getInstance().cleanup();
                    }
                    Utility.Companion.getInstance().setPassportNumber(null);
                    Utility.Companion.getInstance().setDateOfBirth(null);
                    Utility.Companion.getInstance().setExpiryDate(null);
                    finish();
                    overridePendingTransition(android.R.anim.fade_in, android.R.anim.fade_out);

                }
            }
        }));

        activityStartScanningBinding.imgSetting.setOnClickListener(view -> {
            Intent i = new Intent(StartScanningActivity.this, SDKSettingScreen.class);
            startActivity(i);
            overridePendingTransition(android.R.anim.fade_in, android.R.anim.fade_out);
        });
    }


    private void initView() {
        if (getIntent().hasExtra(getResources().getString(R.string.doc_key))) {
            selectedDoc = getIntent().getStringExtra(getResources().getString(R.string.doc_key));
        }

        SVG svg;
        try {
            svg = SVG.getFromResource(getResources(), R.raw.back);
            activityStartScanningBinding.layoutHeader.imgBack.setSVG(svg);
//            getPreferredLocale(getApplicationContext());
            if (storage.getPreferredLocale().equalsIgnoreCase("ar")) {
                activityStartScanningBinding.layoutHeader.imgBack.setRotation(180);
            }
        } catch (SVGParseException e) {
            e.printStackTrace();
        }
        setLayoutAndTextSize();
        if (OtherConstant.getInstance().getNeedToShowSettingScreen()) {
            if (SharePreferenceUtility.getSavePreferenceData(getApplicationContext(), getString(R.string.sharepreference_verification_step))) {
                activityStartScanningBinding.imgSetting.setVisibility(View.GONE);
            } else {
                activityStartScanningBinding.imgSetting.setVisibility(View.VISIBLE);
            }
        } else {
            activityStartScanningBinding.imgSetting.setVisibility(View.GONE);
        }
        if (selectedDoc.equalsIgnoreCase(getString(R.string.e_passport))) {
            activityStartScanningBinding.txtDesc.setText(getString(R.string.pass_scan_desc));
            activityStartScanningBinding.lottieAnimationView.setAnimation(R.raw.passportscan);
        } else {
            activityStartScanningBinding.txtDesc.setText(getString(R.string.doc_scan_desc));
            activityStartScanningBinding.lottieAnimationView.setAnimation(R.raw.idscan);
        }

    }


    private void setLayoutAndTextSize() {
        TextSizeConverter textSizeConverter = new TextSizeConverter(getApplicationContext());
        textSizeConverter.changeStatusBarColor(StartScanningActivity.this);

        ViewGroup.LayoutParams layoutParams2 = activityStartScanningBinding.layoutHeader.imgBack.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(24);
        layoutParams2.height = textSizeConverter.getHeight(24);
        activityStartScanningBinding.layoutHeader.imgBack.setLayoutParams(layoutParams2);

        layoutParams2 = activityStartScanningBinding.imgSetting.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(24);
        layoutParams2.height = textSizeConverter.getHeight(24);
        activityStartScanningBinding.imgSetting.setLayoutParams(layoutParams2);

        LinearLayout.LayoutParams layoutParams = textSizeConverter.getLinearLayoutParam();
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(4), 0, 0);
        activityStartScanningBinding.layoutHeader.lytHeaderMain.setLayoutParams(layoutParams);
        activityStartScanningBinding.layoutHeader.txtHelp.setText(getString(R.string.header_doc_scan));
        activityStartScanningBinding.layoutHeader.txtHelp.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(17));


        int padding = textSizeConverter.getPaddingORMarginValue(16);
        activityStartScanningBinding.layoutHeader.txtHelp.setPadding(padding, 0, 0, 0);
        activityStartScanningBinding.lytMainStartScanning.setPadding(padding, padding, padding, padding);

        padding = textSizeConverter.getPaddingORMarginValue(12);
        activityStartScanningBinding.txtBtnNext.setPadding(0, padding, 0, padding);
        activityStartScanningBinding.txtBtnNext.setText(getString(R.string.btn_start_verificaion));
        activityStartScanningBinding.txtBtnNext.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(16));
        activityStartScanningBinding.btnStartScanning.setRadius(textSizeConverter.calculateRadius(8));

        LinearLayout.LayoutParams marginLyoutParam = (LinearLayout.LayoutParams) activityStartScanningBinding.txtDesc.getLayoutParams();
        marginLyoutParam.setMargins(0, 0, 0, textSizeConverter.getPaddingORMarginValue(62));
        activityStartScanningBinding.txtDesc.setLayoutParams(marginLyoutParam);
        activityStartScanningBinding.txtDesc.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(16));

        activityStartScanningBinding.lottieAnimationView.playAnimation();
        activityStartScanningBinding.lottieAnimationView.setRepeatCount(LottieDrawable.INFINITE);
//        String dateOfBith = formateDateFromstring("yyyyMMdd", Constant.dateFormate);
//        Log.d("TAG", "setLayoutAndTextSize: "+dateOfBith);
    }


}
