package com.kyc.nashidmrz.mrtd2.activity

import android.os.Bundle
import android.util.TypedValue
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.content.ContextCompat
import androidx.fragment.app.Fragment
import androidx.lifecycle.ViewModelProvider
import com.kyc.nashidmrz.R
import com.kyc.nashidmrz.databinding.FragmentVerificationBinding
import com.kyc.nashidmrz.mrtd2.activity.viewmodel.VerificationViewModel

class VerificationFragment : Fragment() {
    private var _binding: FragmentVerificationBinding? = null
    val binding: FragmentVerificationBinding
        get() = _binding!!
    private lateinit var viewModel: VerificationViewModel

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?,
    ): View {
        _binding = FragmentVerificationBinding.inflate(inflater, container, false)
        viewModel = ViewModelProvider(this)[VerificationViewModel::class.java]

        initView()
        setData()

        return binding.root
    }

    private fun initView() {
        val textSizeConverter = TextSizeConverter(activity)

        val padding = textSizeConverter.getPaddingORMarginValue(16)
        binding.mainVerificationResult.setPadding(padding, padding, padding, padding)
        var layoutParams = textSizeConverter.linearLayoutParam
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(28), 0, 0)
        binding.imgProfileCard.layoutParams = layoutParams

        var layoutParams2 = binding.imgProfileCard.layoutParams
        layoutParams2.width = textSizeConverter.getWidth(106)
        layoutParams2.height = textSizeConverter.getHeight(106)
        binding.imgProfileCard.layoutParams = layoutParams2

        binding.txtVerification.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(16),
        )
        binding.txtSuccesVerify.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(16),
        )

        binding.imgProfileCard.radius = textSizeConverter.calculateRadius(7).toFloat()
        // bottom detail

        // bottom detail
        layoutParams = textSizeConverter.linearLayoutParam
        layoutParams.setMargins(
            0,
            textSizeConverter.getPaddingORMarginValue(36),
            0,
            textSizeConverter.getPaddingORMarginValue(16),
        )
        binding.lytMatchingLevel.layoutParams = layoutParams

        layoutParams = textSizeConverter.linearLayoutParam
        layoutParams.setMargins(0, 0, 0, textSizeConverter.getPaddingORMarginValue(16))
        binding.lytLivenessConfirm.layoutParams = layoutParams
        binding.lytAmlScreening.layoutParams = layoutParams
        binding.lytRopMatching.layoutParams = layoutParams
        binding.lytSignMatching.layoutParams = layoutParams

        binding.txtMatchingLevel.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(14),
        )
        binding.txtMatchingValue.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(14),
        )
        binding.txtLivenessConfirmValue.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(14),
        )
        binding.txtLivenessConfirm.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(14),
        )
        binding.txtAmlScreening.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(14),
        )
        binding.txtRopMatching.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(14),
        )
        binding.txtSignMatching.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(14),
        )

        val iconSize = 24
        layoutParams2 = binding.imgLivenessConfirm.layoutParams
        layoutParams2.width = textSizeConverter.getWidth(iconSize)
        layoutParams2.height = textSizeConverter.getHeight(iconSize)
        binding.imgLivenessConfirm.layoutParams = layoutParams2

        layoutParams2 = binding.imgAmlScreening.layoutParams
        layoutParams2.width = textSizeConverter.getWidth(iconSize)
        layoutParams2.height = textSizeConverter.getHeight(iconSize)
        binding.imgAmlScreening.layoutParams = layoutParams2

        layoutParams2 = binding.imgRopMatching.layoutParams
        layoutParams2.width = textSizeConverter.getWidth(iconSize)
        layoutParams2.height = textSizeConverter.getHeight(iconSize)
        binding.imgRopMatching.layoutParams = layoutParams2

        layoutParams2 = binding.imgSignMatching.layoutParams
        layoutParams2.width = textSizeConverter.getWidth(iconSize)
        layoutParams2.height = textSizeConverter.getHeight(iconSize)
        binding.imgSignMatching.layoutParams = layoutParams2

        layoutParams2 = binding.amlProgressbar.layoutParams
        layoutParams2.width = textSizeConverter.getWidth(iconSize)
        layoutParams2.height = textSizeConverter.getHeight(iconSize)
        binding.amlProgressbar.layoutParams = layoutParams2
    }

    private fun setData() {
        viewModel.setData()
        viewModel.matchingValue.observe(viewLifecycleOwner) { matchValue ->
            if (matchValue < 50) {
                binding.txtMatchingValue.text = getString(R.string.verification_low)
                binding.txtSuccesVerify.text = getString(R.string.identity_verified_fail)
                binding.imgLivenessConfirm.setImageResource(R.drawable.failed)
                binding.txtSuccesVerify.setTextColor(
                    ContextCompat.getColor(
                        requireActivity(),
                        R.color.failed_color,
                    ),
                )
            } else {
                binding.txtMatchingValue.text = getString(R.string.verification_high)
                binding.txtSuccesVerify.setText(R.string.identity_verified_success)
                binding.imgLivenessConfirm.setImageResource(R.drawable.success)
                binding.txtSuccesVerify.setTextColor(
                    ContextCompat.getColor(
                        requireActivity(),
                        R.color.completed_step_line,
                    ),
                )
            }
        }

        viewModel.profileImage.observe(viewLifecycleOwner) { profileImage ->
            binding.verificationProfile.setImageBitmap(profileImage)
        }

        viewModel.amlStatus.observe(viewLifecycleOwner) { isSuccessful ->
            if (isSuccessful) {
                binding.imgAmlScreening.visibility = View.VISIBLE
                binding.amlProgressbar.visibility = View.GONE
            } else {
                binding.imgAmlScreening.visibility = View.GONE
                binding.amlProgressbar.visibility = View.VISIBLE
            }

            binding.imgAmlScreening.setImageResource(
                if (isSuccessful) R.drawable.success else R.drawable.failed,
            )
        }

        viewModel.callAML()
    }

    override fun onDestroyView() {
        super.onDestroyView()
        _binding = null
    }
}
