package com.kyc.nashidmrz.mrtd2.activity;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.viewpager2.adapter.FragmentStateAdapter;

import java.util.ArrayList;
import java.util.List;

public class ViewPagerAdapter extends FragmentStateAdapter {
    private final Fragment[] fragments;
    private final String[] fragmentTitles;

    public ViewPagerAdapter(@NonNull FragmentActivity fragmentActivity, Fragment[] fragments, String[] fragmentTitles) {
        super(fragmentActivity);
        this.fragments = fragments;
        this.fragmentTitles = fragmentTitles;
    }

    @NonNull
    @Override
    public Fragment createFragment(int position) {
        return fragments[position];
    }

    @Override
    public int getItemCount() {
        return fragments.length;
    }
}