package com.kyc.nashidmrz.mrtd2.activity

import android.animation.Animator
import android.animation.AnimatorListenerAdapter
import android.annotation.SuppressLint
import android.app.Activity
import android.app.Dialog
import android.app.PendingIntent
import android.content.Intent
import android.content.res.ColorStateList
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.graphics.Color
import android.graphics.Matrix
import android.graphics.drawable.ColorDrawable
import android.nfc.NfcAdapter
import android.nfc.Tag
import android.nfc.tech.IsoDep
import android.os.Build
import android.os.Bundle
import android.provider.Settings
import android.util.Log
import android.util.TypedValue
import android.view.Gravity
import android.view.View
import android.view.ViewGroup
import android.view.Window
import android.view.animation.AnimationUtils
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.ProgressBar
import android.widget.TextView
import androidx.activity.result.contract.ActivityResultContracts
import androidx.core.content.ContextCompat
import androidx.core.content.res.ResourcesCompat
import androidx.lifecycle.ViewModelProvider
import com.airbnb.lottie.LottieDrawable
import com.caverock.androidsvg.SVG
import com.caverock.androidsvg.SVGParseException
import com.kyc.nashidmrz.Constant
import com.kyc.nashidmrz.LivenessData
import com.kyc.nashidmrz.NashidSDK
import com.kyc.nashidmrz.OtherConstant
import com.kyc.nashidmrz.R
import com.kyc.nashidmrz.Utility
import com.kyc.nashidmrz.databinding.ActivityWaitingForNfcBinding
import com.kyc.nashidmrz.databinding.BottomSheetDialogBinding
import com.kyc.nashidmrz.databinding.DialogBackBinding
import com.kyc.nashidmrz.databinding.DialogFailureNfcBinding
import com.kyc.nashidmrz.databinding.DialogSuccessBinding
import com.kyc.nashidmrz.id_card.jmrtd.BACKey
import com.kyc.nashidmrz.id_card.jmrtd.BACKeySpec
import com.kyc.nashidmrz.id_card.omn.OmanCardDG10File
import com.kyc.nashidmrz.id_card.omn.OmanCardDG11File
import com.kyc.nashidmrz.id_card.omn.OmanCardDG13File
import com.kyc.nashidmrz.id_card.omn.OmanCardDG1File
import com.kyc.nashidmrz.id_card.omn.OmanCardDG4File
import com.kyc.nashidmrz.id_card.omn.OmanCardDG6File
import com.kyc.nashidmrz.internetutility.ErrorUtility
import com.kyc.nashidmrz.mrtd2.BitiAndroid.TagProvider
import com.kyc.nashidmrz.mrtd2.CallCompanyScanAPI
import com.kyc.nashidmrz.mrtd2.CompleteCallingCompanyScanListner
import com.kyc.nashidmrz.mrtd2.activity.viewmodel.WaitingForNFCViewModel
import com.kyc.nashidmrz.mrtd2.resultcallback.Result
import com.kyc.nashidmrz.mrtd2.resultcallback.callbackclass.IDCardNFCData
import com.kyc.nashidmrz.mrtd2.rooted.RootedCheck
import org.json.JSONException
import org.json.JSONObject
import java.text.DateFormat
import java.text.SimpleDateFormat
import java.util.Objects

class WaitingForNfcActivity : BaseActivity() {
    private var binding: ActivityWaitingForNfcBinding? = null
    private var isActivityRunning = false
    private var textSizeConverter: TextSizeConverter? = null
    private lateinit var idCardNFCData: IDCardNFCData
    protected var mNfcAdapter: NfcAdapter? = null
    protected var pendingIntent: PendingIntent? = null
    private var viewModel: WaitingForNFCViewModel? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityWaitingForNfcBinding.inflate(layoutInflater)
        setContentView(binding!!.root)
        viewModel = ViewModelProvider(this).get(WaitingForNFCViewModel::class.java)
        RootedCheck.getInstance().setFlag(this@WaitingForNfcActivity)
        if (RootedCheck.getInstance().isRootedDevice(applicationContext)) {
            RootedCheck.getInstance().showRootedDeviceDialog(
                this,
                getString(R.string.root_dialog),
                getString(R.string.root_desc),
                getString(R.string.root_btn),
            )
        } else {
            initView()
        }
    }

    private fun setLayoutAndTextSize() {
        textSizeConverter = TextSizeConverter(applicationContext)
        textSizeConverter!!.changeStatusBarColor(this@WaitingForNfcActivity)
        val back: SVG?
        try {
            back = SVG.getFromResource(resources, R.raw.back)
            binding!!.layoutHeader.imgBack.setSVG(back)
            if (storage.getPreferredLocale().equals("ar", ignoreCase = true)) {
                binding!!.layoutHeader.imgBack.rotation = 180f
            }
        } catch (e: SVGParseException) {
            e.printStackTrace()
        }
        var layoutParams2 = binding!!.layoutHeader.imgBack.layoutParams
        layoutParams2.width = textSizeConverter!!.getWidth(24)
        layoutParams2.height = textSizeConverter!!.getHeight(24)
        binding!!.layoutHeader.imgBack.layoutParams = layoutParams2
        var layoutParams = textSizeConverter!!.linearLayoutParam
        layoutParams.setMargins(0, textSizeConverter!!.getPaddingORMarginValue(4), 0, 0)
        binding!!.layoutHeader.lytHeaderMain.layoutParams = layoutParams
        binding!!.layoutHeader.txtHelp.text = getString(R.string.nfc_chip_rading)
        binding!!.layoutHeader.txtHelp.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter!!.getTextSize(17),
        )
        var padding = textSizeConverter!!.getPaddingORMarginValue(16)
        binding!!.layoutMainNfc.setPadding(padding, padding, padding, padding)
        layoutParams2 = binding!!.layoutStepMain.lytStep.layoutParams
        layoutParams2.width = LinearLayout.LayoutParams.MATCH_PARENT
        layoutParams2.height = textSizeConverter!!.getHeight(30)
        binding!!.layoutStepMain.lytStep.layoutParams = layoutParams2
        var marginLayoutParam =
            binding!!.layoutStepMain.lytStep.layoutParams as LinearLayout.LayoutParams
        marginLayoutParam.setMargins(0, textSizeConverter!!.getPaddingORMarginValue(32), 0, 0)
        binding!!.layoutStepMain.lytStep.layoutParams = marginLayoutParam
        val stepIconSize = 22
        var stepLayoutParam = binding!!.layoutStepMain.txtStep1.layoutParams
        stepLayoutParam.width = textSizeConverter!!.getWidth(stepIconSize)
        stepLayoutParam.height = textSizeConverter!!.getHeight(stepIconSize)
        binding!!.layoutStepMain.txtStep1.layoutParams = stepLayoutParam
        stepLayoutParam = binding!!.layoutStepMain.txtStep2.layoutParams
        stepLayoutParam.width = textSizeConverter!!.getWidth(stepIconSize)
        stepLayoutParam.height = textSizeConverter!!.getHeight(stepIconSize)
        binding!!.layoutStepMain.txtStep2.layoutParams = stepLayoutParam
        stepLayoutParam = binding!!.layoutStepMain.txtStep3.layoutParams
        stepLayoutParam.width = textSizeConverter!!.getWidth(stepIconSize)
        stepLayoutParam.height = textSizeConverter!!.getHeight(stepIconSize)
        binding!!.layoutStepMain.txtStep3.layoutParams = stepLayoutParam
        stepLayoutParam = binding!!.layoutStepMain.viewStep1Divider.layoutParams
        stepLayoutParam.width = LinearLayout.LayoutParams.MATCH_PARENT
        stepLayoutParam.height = textSizeConverter!!.getHeight(2)
        binding!!.layoutStepMain.viewStep1Divider.layoutParams = stepLayoutParam
        binding!!.layoutStepMain.txtStep1.setImageResource(R.drawable.complete_step1)
        binding!!.layoutStepMain.txtStep2.setImageResource(R.drawable.scan_complete_step2)
        binding!!.layoutStepMain.txtStep3.imageTintList =
            ContextCompat.getColorStateList(this, R.color.dottedline_tint)
        binding!!.layoutStepMain.viewStep1Divider.setBackgroundResource(R.drawable.gradient_straight_line)
        binding!!.layoutStepMain.viewStep2Divider.backgroundTintList =
            ContextCompat.getColorStateList(this, R.color.dottedline_tint)
        marginLayoutParam = binding!!.txtTapHold.layoutParams as LinearLayout.LayoutParams
        marginLayoutParam.setMargins(0, textSizeConverter!!.getPaddingORMarginValue(24), 0, 0)
        binding!!.txtTapHold.layoutParams = marginLayoutParam
        binding!!.txtTapHold.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter!!.getTextSize(14),
        )
        marginLayoutParam = binding!!.txtTapHold.layoutParams as LinearLayout.LayoutParams
        marginLayoutParam.setMargins(0, textSizeConverter!!.getPaddingORMarginValue(24), 0, 0)
        binding!!.txtTapHold.layoutParams = marginLayoutParam
        binding!!.txtTapHold.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter!!.getTextSize(14),
        )
        if (!OtherConstant.getInstance().appName.equals(
                getString(R.string.default_name),
                ignoreCase = true,
            )
        ) {
            viewModel!!.callNFCStatus()
        } else {
            viewModel!!.setSkipNFC(false)
            //            binding.txtSkip.setVisibility(View.GONE);
            marginLayoutParam = binding!!.txtBottomDesc.layoutParams as LinearLayout.LayoutParams
            marginLayoutParam.setMargins(0, 0, 0, textSizeConverter!!.getPaddingORMarginValue(100))
            binding!!.txtBottomDesc.layoutParams = marginLayoutParam
            binding!!.txtBottomDesc.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter!!.getTextSize(16),
            )
            marginLayoutParam = binding!!.txtSkip.layoutParams as LinearLayout.LayoutParams
            marginLayoutParam.setMargins(
                0,
                textSizeConverter!!.getPaddingORMarginValue(28),
                0,
                textSizeConverter!!.getPaddingORMarginValue(68),
            )
            binding!!.txtSkip.layoutParams = marginLayoutParam
            binding!!.txtSkip.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter!!.getTextSize(14),
            )
        }
        layoutParams2 = binding!!.nfcDialogTurnon.imgScanFailure.layoutParams
        layoutParams2.width = textSizeConverter!!.getWidth(56)
        layoutParams2.height = textSizeConverter!!.getHeight(56)
        binding!!.nfcDialogTurnon.imgScanFailure.layoutParams = layoutParams2
        layoutParams2 = binding!!.nfcDialogTurnon.imgInfo1.layoutParams
        layoutParams2.width = textSizeConverter!!.getWidth(20)
        layoutParams2.height = textSizeConverter!!.getHeight(20)
        binding!!.nfcDialogTurnon.imgInfo1.layoutParams = layoutParams2
        layoutParams2 = binding!!.nfcDialogTurnon.imgNfcFailed.layoutParams
        layoutParams2.width = textSizeConverter!!.getWidth(145)
        layoutParams2.height = textSizeConverter!!.getHeight(145)
        binding!!.nfcDialogTurnon.imgNfcFailed.layoutParams = layoutParams2
        val layoutParams1 =
            binding!!.nfcDialogTurnon.imgNfcFailed.layoutParams as LinearLayout.LayoutParams
        layoutParams1.setMargins(
            0,
            textSizeConverter!!.getPaddingORMarginValue(24),
            0,
            textSizeConverter!!.getPaddingORMarginValue(18),
        )
        binding!!.nfcDialogTurnon.imgNfcFailed.layoutParams = layoutParams1
        layoutParams2 = binding!!.nfcDialogTurnon.imgInfo2.layoutParams
        layoutParams2.width = textSizeConverter!!.getWidth(20)
        layoutParams2.height = textSizeConverter!!.getHeight(20)
        binding!!.nfcDialogTurnon.imgInfo2.layoutParams = layoutParams2
        layoutParams =
            binding!!.nfcDialogTurnon.imgScanFailure.layoutParams as LinearLayout.LayoutParams
        layoutParams.setMargins(0, textSizeConverter!!.getPaddingORMarginValue(8), 0, 0)
        binding!!.nfcDialogTurnon.imgScanFailure.layoutParams = layoutParams
        binding!!.nfcDialogTurnon.txtScanCompleted.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter!!.getTextSize(20),
        )
        layoutParams =
            binding!!.nfcDialogTurnon.txtScanCompleted.layoutParams as LinearLayout.LayoutParams
        layoutParams.setMargins(0, textSizeConverter!!.getPaddingORMarginValue(24), 0, 0)
        binding!!.nfcDialogTurnon.txtScanCompleted.layoutParams = layoutParams
        binding!!.nfcDialogTurnon.txtScanNotCompleteDesc1.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter!!.getTextSize(16),
        )
        layoutParams =
            binding!!.nfcDialogTurnon.txtScanNotCompleteDesc1.layoutParams as LinearLayout.LayoutParams
        layoutParams.setMargins(
            textSizeConverter!!.getPaddingORMarginValue(6),
            textSizeConverter!!.getPaddingORMarginValue(16),
            0,
            0,
        )
        binding!!.nfcDialogTurnon.txtScanNotCompleteDesc1.layoutParams = layoutParams
        binding!!.nfcDialogTurnon.txtScanNotCompleteDesc2.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter!!.getTextSize(16),
        )
        binding!!.nfcDialogTurnon.imgNfcFailed.playAnimation()
        binding!!.nfcDialogTurnon.imgNfcFailed.repeatCount = LottieDrawable.INFINITE
        binding!!.nfcDialogTurnon.imgNfcFailed.setAnimation(R.raw.nfc_read_failed)
        layoutParams =
            binding!!.nfcDialogTurnon.txtScanNotCompleteDesc2.layoutParams as LinearLayout.LayoutParams
        layoutParams.setMargins(
            textSizeConverter!!.getPaddingORMarginValue(6),
            textSizeConverter!!.getPaddingORMarginValue(16),
            0,
            0,
        )
        binding!!.nfcDialogTurnon.txtScanNotCompleteDesc2.layoutParams = layoutParams
        layoutParams = binding!!.nfcDialogTurnon.imgInfo1.layoutParams as LinearLayout.LayoutParams
        layoutParams.setMargins(0, textSizeConverter!!.getPaddingORMarginValue(16), 0, 0)
        binding!!.nfcDialogTurnon.imgInfo1.layoutParams = layoutParams
        layoutParams = binding!!.nfcDialogTurnon.imgInfo2.layoutParams as LinearLayout.LayoutParams
        layoutParams.setMargins(0, textSizeConverter!!.getPaddingORMarginValue(16), 0, 0)
        binding!!.nfcDialogTurnon.imgInfo2.layoutParams = layoutParams
        layoutParams = binding!!.nfcDialogTurnon.btnRetry.layoutParams as LinearLayout.LayoutParams
        layoutParams.setMargins(
            0,
            textSizeConverter!!.getPaddingORMarginValue(24),
            0,
            textSizeConverter!!.getPaddingORMarginValue(28),
        )
        binding!!.nfcDialogTurnon.btnRetry.layoutParams = layoutParams
        padding = textSizeConverter!!.getPaddingORMarginValue(12)
        binding!!.nfcDialogTurnon.txtBtnRetry.setPadding(0, padding, 0, padding)
        binding!!.nfcDialogTurnon.btnRetry.radius = textSizeConverter!!.calculateRadius(8).toFloat()
        binding!!.nfcDialogTurnon.lyoutError1.visibility = View.GONE
        binding!!.nfcDialogTurnon.txtBtnRetry.text = getString(R.string.turn_on_nfc)
        binding!!.nfcDialogTurnon.txtBtnRetry.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter!!.getTextSize(16),
        )
    }

    private fun initView() {
        isActivityRunning = true
        handleIntentData()
        setLayoutAndTextSize()
        try {
            val svg = SVG.getFromResource(resources, R.raw.logo)
            binding!!.logo.setSVG(svg)
            val back1 = SVG.getFromResource(resources, R.raw.arowback)
            binding!!.backbutton.setSVG(back1)
            val nfc = SVG.getFromResource(resources, R.raw.nfc_logo)
            binding!!.nfclogo.setSVG(nfc)
        } catch (e: Exception) {
            e.printStackTrace()
        }
        binding!!.layoutHeader.imgBack.setOnClickListener { v: View? -> onBackPressedDispatcher.onBackPressed() }
        binding!!.imgBackcrdScan.setAnimation(R.raw.nfc)
        binding!!.imgBackcrdScan.playAnimation()
        binding!!.imgBackcrdScan.repeatCount = LottieDrawable.INFINITE
        try {
            val matrix = Matrix()
            matrix.postRotate(90f)
            val bmp =
                BitmapFactory.decodeByteArray(
                    Utility.getInstance().scannedImage,
                    0,
                    Utility.getInstance().scannedImage!!.size,
                )
            val scaledBitmap = Bitmap.createScaledBitmap(bmp, 2048, 2048, true)
            val rotatedBitmap =
                Bitmap.createBitmap(
                    scaledBitmap,
                    0,
                    0,
                    scaledBitmap.width,
                    scaledBitmap.height,
                    matrix,
                    true,
                )
            val image = findViewById<ImageView>(R.id.imageview)
            image.setImageBitmap(rotatedBitmap)
        } catch (e: Exception) {
            e.printStackTrace()
        }
        binding!!.txtSkip.setOnClickListener {
            OtherConstant.getInstance().skipNFC = true
            dismissDialog()
            viewModel!!.validateLivenessUser(this@WaitingForNfcActivity)
        }
        handleInternetConnection()
        setObservable()
    }

    private fun handleIntentData() {
        if (intent.hasExtra(resources.getString(R.string.doc_key))) {
            val selectedDoc = intent.getStringExtra(resources.getString(R.string.doc_key))
            if (selectedDoc != null) {
                viewModel!!.setSelectedDoc(selectedDoc)
            }
        }
    }

    private fun dismissDialog() {
        if (errorDialog != null) {
            errorDialog!!.dismiss()
        }
        if (progressDialog != null) {
            progressDialog!!.dismiss()
        }
    }

    private fun setObservable() {
        viewModel!!.skipNFC.observe(this) { skipNFC: Boolean -> handleSkipNFC(skipNFC) }
        viewModel!!.isInternetAvailable.observe(this) { isAvailable: Boolean ->
            handleInternetConnectionData(
                isAvailable,
            )
        }
        viewModel!!.mrtdPercentage.observe(this) { progress: Int ->
            setMrtdProgressBarPercentage(
                progress,
            )
        }
        viewModel!!.showError.observe(this) { message: String? -> showError(message) }
        viewModel!!.showResult.observe(this) { isDisplaying: Boolean -> displayResult(isDisplaying) }
    }

    private fun displayResult(isDisplaying: Boolean) {
        Log.d(Companion.TAG, "displayResult: $isDisplaying")
        if (isDisplaying) showResult()
    }

    private fun handleInternetConnectionData(isAvailable: Boolean) {
        Log.d(Companion.TAG, "handleInternetConnectionData: $isAvailable")
        if (!isAvailable) {
            ErrorUtility.getInstance()
                .showNoInternetDialog(this, !this.isFinishing && !this.isDestroyed)
        }
    }

    private fun handleSkipNFC(skipNFC: Boolean) {
        Log.d(Companion.TAG, "handleSkipNFC: $skipNFC")
        if (skipNFC) {
            binding!!.txtSkip.visibility = View.VISIBLE
        } else {
            binding!!.txtSkip.visibility = View.GONE
        }
        if (skipNFC) {
            val margin: Int
            margin =
                if (viewModel!!.maxTry.value == 0) {
//                binding.txtSkip.setVisibility(View.GONE);
//                viewModel.setSkipNFC(false);
                    textSizeConverter!!.getPaddingORMarginValue(100)
                } else {
                    0
                    //                viewModel.setSkipNFC(true);
//                binding.txtSkip.setVisibility(View.VISIBLE);
                }
            var marginLayoutParam = binding!!.txtBottomDesc.layoutParams as LinearLayout.LayoutParams
            marginLayoutParam.setMargins(0, 0, 0, margin)
            binding!!.txtBottomDesc.layoutParams = marginLayoutParam
            binding!!.txtBottomDesc.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter!!.getTextSize(16),
            )
            marginLayoutParam = binding!!.txtSkip.layoutParams as LinearLayout.LayoutParams
            marginLayoutParam.setMargins(
                0,
                textSizeConverter!!.getPaddingORMarginValue(28),
                0,
                textSizeConverter!!.getPaddingORMarginValue(68),
            )
            binding!!.txtSkip.layoutParams = marginLayoutParam
            binding!!.txtSkip.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter!!.getTextSize(14),
            )
        } else {
//            viewModel.setSkipNFC(false);
//            binding.txtSkip.setVisibility(View.GONE);
            var marginLayoutParam = binding!!.txtBottomDesc.layoutParams as LinearLayout.LayoutParams
            marginLayoutParam.setMargins(0, 0, 0, textSizeConverter!!.getPaddingORMarginValue(100))
            binding!!.txtBottomDesc.layoutParams = marginLayoutParam
            binding!!.txtBottomDesc.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter!!.getTextSize(16),
            )
            marginLayoutParam = binding!!.txtSkip.layoutParams as LinearLayout.LayoutParams
            marginLayoutParam.setMargins(
                0,
                textSizeConverter!!.getPaddingORMarginValue(28),
                0,
                textSizeConverter!!.getPaddingORMarginValue(68),
            )
            binding!!.txtSkip.layoutParams = marginLayoutParam
            binding!!.txtSkip.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter!!.getTextSize(14),
            )
        }
    }

    private fun handleInternetConnection() {
        Log.d(Companion.TAG, "handleInternetConnection: ")
        viewModel!!.setInternetConnection(isInternetAvailable)
        if (java.lang.Boolean.TRUE == viewModel!!.isInternetAvailable.value) {
//            isApiCalled = true;
            viewModel!!.setIsApiCalled(true)
            initAdapter()
            if (errorDialog != null) {
                errorDialog!!.dismiss()
            }
            if (progressDialog != null) {
                progressDialog!!.dismiss()
            }
            viewModel!!.validateUser(this@WaitingForNfcActivity)
        }
    }

    private fun initAdapter() {
        mNfcAdapter = NfcAdapter.getDefaultAdapter(this)
        if (mNfcAdapter != null && mNfcAdapter!!.isEnabled) {
            // Yes NFC available
            pendingIntent =
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                    val intent =
                        Intent(
                            this@WaitingForNfcActivity,
                            this@WaitingForNfcActivity.javaClass,
                        ).addFlags(
                            Intent.FLAG_ACTIVITY_SINGLE_TOP,
                        )
                    PendingIntent.getActivity(
                        this@WaitingForNfcActivity, 0, intent, PendingIntent.FLAG_MUTABLE,
                    )
                } else {
                    PendingIntent.getActivity(
                        this, 0, Intent(this, javaClass).addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP), 0,
                    )
                }
        } else if (mNfcAdapter != null && !mNfcAdapter!!.isEnabled) {
            showNfcNotEnabledDialog()
        } else {
            showNfcNotSupportedDialog()
        }
    }

    private fun showNfcNotSupportedDialog() {
        binding!!.nfcDialogTurnon.mainDialogLyt.visibility = View.VISIBLE
        binding!!.nfcDialogTurnon.lyoutError1.visibility = View.VISIBLE
        binding!!.nfcDialogTurnon.txtScanNotCompleteDesc1.text =
            getString(R.string.nfc_not_supported_desc)
        binding!!.nfcDialogTurnon.txtBtnRetry.text = getString(R.string.nfc_not_enabled_btn_ok)
        binding!!.nfcDialogTurnon.btnRetry.setOnClickListener {
            binding!!.nfcDialogTurnon.mainDialogLyt.visibility = View.GONE
        }
    }

    private fun showNfcNotEnabledDialog() {
        binding!!.nfcDialogTurnon.mainDialogLyt.visibility = View.VISIBLE
        binding!!.nfcDialogTurnon.btnRetry.setOnClickListener {
            val nfcIntent = Intent(Settings.ACTION_NFC_SETTINGS)
            someActivityResultLauncher.launch(nfcIntent)
//            startActivityForResult(nfcIntent, 0)
            binding!!.nfcDialogTurnon.mainDialogLyt.visibility = View.GONE
        }
    }

    private val someActivityResultLauncher =
        registerForActivityResult(
            ActivityResultContracts.StartActivityForResult(),
        ) { result ->
            if (result.resultCode == Activity.RESULT_OK) {
                mNfcAdapter = NfcAdapter.getDefaultAdapter(this)
                if (mNfcAdapter != null && mNfcAdapter!!.isEnabled) {

                    // Yes NFC available
                    pendingIntent =
                        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                            val intent =
                                Intent(
                                    this@WaitingForNfcActivity,
                                    this@WaitingForNfcActivity.javaClass,
                                ).addFlags(
                                    Intent.FLAG_ACTIVITY_SINGLE_TOP,
                                )
                            PendingIntent.getActivity(
                                this@WaitingForNfcActivity, 0, intent, PendingIntent.FLAG_MUTABLE,
                            )
                        } else {
                            PendingIntent.getActivity(
                                this,
                                0,
                                Intent(this, javaClass).addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP),
                                0,
                            )
                        }
                } else if (mNfcAdapter != null && !mNfcAdapter!!.isEnabled) {
                    showNfcNotEnabledDialog()
                } else {
                    showNfcNotSupportedDialog()
                }
            }
        }

    @Deprecated("Deprecated in Java")
    override fun onBackPressed() {
        if (binding!!.customLoader.root.visibility != View.VISIBLE) {
            showBackpressDialog(this, false, false)
        }
    }

    fun showBackpressDialog(
        activity: Activity,
        isNFc: Boolean,
        isLiveness: Boolean,
    ) {
        val dialog = Dialog(this)
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE)
        val dialogBackBinding = DialogBackBinding.inflate(dialog.layoutInflater)
        dialog.setContentView(dialogBackBinding.root)
        var layoutParams = dialogBackBinding.dialogHeader.layoutParams as LinearLayout.LayoutParams
        var padding = textSizeConverter!!.getPaddingORMarginValue(16)
        layoutParams.setMargins(padding, padding, padding, 0)
        dialogBackBinding.dialogHeader.layoutParams = layoutParams
        val layoutParams2 = dialogBackBinding.cardConfirmation.layoutParams
        layoutParams2.width = textSizeConverter!!.getWidth(280)
        dialogBackBinding.cardConfirmation.layoutParams = layoutParams2
        dialogBackBinding.cardConfirmation.radius =
            textSizeConverter!!.calculateRadius(14).toFloat()
        dialogBackBinding.dialogHeader.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter!!.getTextSize(18),
        )
        dialogBackBinding.dialogSubtitle.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter!!.getTextSize(14),
        )
        dialogBackBinding.btnNo.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter!!.getTextSize(16),
        )
        dialogBackBinding.btnYes.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter!!.getTextSize(16),
        )
        layoutParams = dialogBackBinding.dialogSubtitle.layoutParams as LinearLayout.LayoutParams
        layoutParams.setMargins(padding, padding, padding, padding)
        dialogBackBinding.dialogSubtitle.layoutParams = layoutParams
        padding = textSizeConverter!!.getPaddingORMarginValue(12)
        layoutParams = dialogBackBinding.btnNo.layoutParams as LinearLayout.LayoutParams
        layoutParams.setMargins(0, padding, 0, padding)
        dialogBackBinding.btnNo.layoutParams = layoutParams
        layoutParams = dialogBackBinding.btnYes.layoutParams as LinearLayout.LayoutParams
        layoutParams.setMargins(
            textSizeConverter!!.getPaddingORMarginValue(24),
            padding,
            textSizeConverter!!.getPaddingORMarginValue(16),
            padding,
        )
        dialogBackBinding.btnYes.layoutParams = layoutParams
        dialogBackBinding.dialogHeader.typeface =
            ResourcesCompat.getFont(applicationContext, R.font.pingmedium)
        dialogBackBinding.dialogSubtitle.typeface =
            ResourcesCompat.getFont(applicationContext, R.font.regular)
        dialogBackBinding.dialogHeader.text = getString(R.string.liveness_back_dialog_header)
        dialogBackBinding.dialogSubtitle.text = getString(R.string.liveness_back_dialog_title)
        dialogBackBinding.btnNo.text = getString(R.string.liveness_back_dialog_cotionue)
        dialogBackBinding.btnYes.text = getString(R.string.liveness_back_dialog_leave)
        dialogBackBinding.btnYes.setOnClickListener {
            dialog.dismiss()
            binding!!.customLoader.loaderContainer.setBackgroundColor(Color.WHITE)
            val layoutParams2 = binding!!.customLoader.imgLoader.layoutParams
            layoutParams2.width = textSizeConverter!!.getWidth(24)
            layoutParams2.height = textSizeConverter!!.getHeight(24)
            binding!!.customLoader.imgLoader.layoutParams = layoutParams2
            val marginLayoutParam =
                binding!!.customLoader.txtValidating.layoutParams as LinearLayout.LayoutParams
            marginLayoutParam.setMargins(0, textSizeConverter!!.getPaddingORMarginValue(32), 0, 0)
            binding!!.customLoader.txtValidating.layoutParams = marginLayoutParam
            binding!!.customLoader.txtValidating.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter!!.getTextSize(20),
            )
            val rotation = AnimationUtils.loadAnimation(this@WaitingForNfcActivity, R.anim.rotate)
            rotation.fillAfter = true
            binding!!.customLoader.imgLoader.startAnimation(rotation)
            binding!!.customLoader.root.visibility = View.VISIBLE
            if (OtherConstant.getInstance().appName.equals(
                    activity.getString(R.string.overify),
                    ignoreCase = true,
                )
            ) {
                AMLAutoCrop.setListner {
                    val jsonObject = Result.setResultData(activity, isNFc, isLiveness, false)
                    Log.d("TAG", "callAMLCrop:onback nfc $jsonObject")
                    if (jsonObject != null) {
                        val callCompanyScanAPI = CallCompanyScanAPI()
                        callCompanyScanAPI.uploadAllImages(
                            activity,
                            jsonObject,
                            viewModel!!.selectedDoc.value!!,
                            0,
                            object : CompleteCallingCompanyScanListner {
                                override fun onFailure() {
                                    if (NashidSDK.getInstance().getResultListener() != null) {
                                        NashidSDK.getInstance().getResultListener()!!.onFailure()
                                    }
                                    openStartScanning(
                                        activity,
                                        viewModel!!.selectedDoc.value,
                                        isNFc,
                                        isLiveness,
                                    )
                                }

                                override fun onSuccess() {
                                    if (NashidSDK.getInstance().getResultListener() != null) {
                                        NashidSDK.getInstance().getResultListener()!!
                                            .onResultData(jsonObject, viewModel!!.selectedDoc.value)
                                    }
                                    openStartScanning(
                                        activity,
                                        viewModel!!.selectedDoc.value,
                                        isNFc,
                                        isLiveness,
                                    )
                                }
                            },
                        )
                    } else {
                        if (NashidSDK.getInstance().getResultListener() != null) {
                            NashidSDK.getInstance().getResultListener()!!.onFailure()
                        }
                        openStartScanning(
                            activity,
                            viewModel!!.selectedDoc.value,
                            isNFc,
                            isLiveness,
                        )
                    }
                }
                AMLAutoCrop.callAML(
                    Utility.getInstance().name,
                    Utility.getInstance().dateOfBirth,
                    Utility.getInstance().nationality,
                    Utility.getInstance().passportNumber,
                    Utility.getInstance().country,
                )
                AMLAutoCrop.callAutoCropAPI(activity)
            } else {
                activity.finish()
            }
        }
        dialogBackBinding.btnNo.setOnClickListener { dialog.dismiss() }
        dialog.show()
        dialog.setCancelable(false)
        dialog.window?.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
        dialog.window!!.attributes.windowAnimations = R.style.DialogAnimation
    }

    private fun openStartScanning(
        activity: Activity,
        selectedDoc: String?,
        isNFC: Boolean,
        isLiveness: Boolean,
    ) {
        val i = Intent(activity, StartScanningActivity::class.java)
        i.putExtra(activity.resources.getString(R.string.doc_key), selectedDoc)
        i.putExtra("needTocallCompanyScan", true)
        i.putExtra("isNFC", isNFC)
        i.putExtra("isLiveness", isLiveness)
        activity.startActivity(i)
        activity.finish()
    }

    public override fun onNewIntent(intent: Intent) {
        super.onNewIntent(intent)
        Log.d(Companion.TAG, "onNewIntent: ")
        TagProvider.closeTag()
        val tagFromIntent: Tag? =
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
                intent.getParcelableExtra(NfcAdapter.EXTRA_TAG, Tag::class.java)
            } else {
                @Suppress("DEPRECATION")
                intent.getParcelableExtra(NfcAdapter.EXTRA_TAG)
            }
        if (tagFromIntent != null) {
            TagProvider.setTag(IsoDep.get(tagFromIntent))
        }
        println("Got new intent!")
        if (errorDialog != null) {
            errorDialog!!.dismiss()
        }
        if (progressDialog != null) {
            progressDialog!!.dismiss()
        }
        readPassport(tagFromIntent)
    }

    private fun readPassport(tagFromIntent: Tag?) {
        if (java.lang.Boolean.TRUE == viewModel!!.isApiCalled.value) {
            showDialog()
            if (Objects.requireNonNull(viewModel!!.selectedDoc.value)
                    .equals(getString(R.string.e_passport), ignoreCase = true)
            ) {
                viewModel!!.readPassportNfc(tagFromIntent)
            } else {
                Log.d(Companion.TAG, "readPassport: ")
                if (viewModel!!.passportNumber.value!!.isNotEmpty() &&
                    viewModel!!.dateOfExpiration.value!!.isNotEmpty() &&
                    viewModel!!.dateOfBirth.value!!.isNotEmpty()
                ) {
                    Log.d(Companion.TAG, "readPassport: tag found")
                    if (TagProvider.getTag() != null) {
                        val bacKey: BACKeySpec =
                            BACKey(
                                viewModel!!.passportNumber.value,
                                viewModel!!.dateOfBirth.value,
                                viewModel!!.dateOfExpiration.value,
                            )
                        Log.d(Companion.TAG, "readPassport: $bacKey")
                        viewModel!!.cancelNfcRead()
                        viewModel!!.readData(TagProvider.getTag(), bacKey)
                        //                        if (readTask != null) {
//                            readTask.cancel(true);
//                        }
//                        if (bacKey != null) {
//                            readTask = new ReadTask(TagProvider.getTag(), bacKey, WaitingForNfcActivity.this);
//                            readTask.execute();
//                        }
                    }
                }
            }
        }
    }

    override fun onAvailable() {
        if (java.lang.Boolean.FALSE == viewModel!!.isApiCalled.value) handleInternetConnection()
    }

    @SuppressLint("SetTextI18n")
    private fun setMrtdProgressBarPercentage(progress: Int) {
        Log.d(Companion.TAG, "setMrtdProgressBarPercentage: $progress")
        if (progress != 0) {
            runOnUiThread {
                if (progressBar != null && progressText != null) {
                    progressBar!!.progress = progress
                    progressText!!.text = "$progress%"
                }
            }
        }
    }

    private fun showError(message: String?) {
        Log.d(Companion.TAG, "showError: $message")
        if (message != null) {
            runOnUiThread {
                Log.d("TAG", "showError: $message")
                showFailureDialog(message)
            }
        }
    }

    public override fun onPause() {
        super.onPause()
        if (mNfcAdapter != null) {
            mNfcAdapter!!.disableForegroundDispatch(this)
        }
        if (this.isFinishing) {
            isActivityRunning = false
            //            if (readTask != null) {
//                readTask.cancel(true);
//            }
//            if (readPassportTask != null) {
//                readPassportTask.cancel(true);
//            }
            viewModel!!.cancelNfcRead()
            if (progressDialog != null && progressDialog!!.isShowing) {
                progressDialog!!.dismiss()
            }
        }
    }

    public override fun onResume() {
        super.onResume()
        try {
            if (mNfcAdapter != null && pendingIntent != null) {
                mNfcAdapter!!.enableForegroundDispatch(this, pendingIntent, null, null)
            }
        } catch (e: Exception) {
            println("onResume error")
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        ErrorUtility.getInstance().unregisterConnectivityManager(this)
        val disposable = viewModel!!.getDisposable()
        if (!disposable.isDisposed) {
            disposable.dispose()
            disposable.clear()
        }
        isActivityRunning = false
        //        Log.d("TAG", "called:onDestroy: ");
        viewModel!!.cancelNfcRead()
    }

    override fun onStop() {
        super.onStop()
        //        Log.d("TAG", "called:onStop: ");
        isActivityRunning = false
        viewModel!!.cancelNfcRead()
    }

    private fun showResult() {
        storeNFCData()
        if (progressDialog != null) {
            progressDialog!!.dismiss()
        }
        setMrtdProgressBarPercentage(96)
        setMrtdProgressBarPercentage(100)
        if (progressBar != null) {
            progressBar!!.progressTintList =
                ColorStateList.valueOf(
                    ContextCompat.getColor(
                        applicationContext, R.color.progress_complete,
                    ),
                )
        }
        showSuccessDialog()
    }

    private val dateFormate = "yyyyMMdd"
    var personalHashmap = JSONObject()

    private fun storeNFCData() {
        if (Objects.requireNonNull(viewModel!!.selectedDoc.value)
                .equals(getString(R.string.e_passport), ignoreCase = true)
        ) {
            val emptyString = getString(R.string.passemptyString)
            val eDocument = viewModel!!.getEDocument()
            LivenessData.getInstance().seteDocument(eDocument)
            val personDetails = eDocument.personDetails
            val additionalPersonDetails = eDocument.additionalPersonDetails
            val additionalDGFiles = eDocument.additionalDGFiles
            // dg1
            try {
                personalHashmap.put(getString(R.string.passdocumentType), eDocument.docType.name)
                personalHashmap.put(
                    getString(R.string.passdocumentNumber),
                    personDetails.serialNumber,
                )
                personalHashmap.put(
                    getString(R.string.passissuingAuthority),
                    personDetails.issuerAuthority,
                )
                personalHashmap.put(getString(R.string.passdateOfBirth), personDetails.birthDate)
                personalHashmap.put(getString(R.string.passgender), personDetails.gender)
                //        personalHashmap.put("passportMRZ", personDetails.getDocumentCode());
                personalHashmap.put(
                    getString(R.string.passdocumentExpiryDate),
                    personDetails.expiryDate,
                )
                //        dg2
                personalHashmap.put(getString(R.string.passimage), personDetails.faceImage)
                //        personalHashmap.put("Document type", dg1Parser.getDocumentCode());
//        dg7
//                personalHashmap.put(getString(R.string.passsignatureImage), personDetails.getPortraitImage());

//        dg11
                if (additionalPersonDetails != null) {
                    personalHashmap.put(
                        getString(R.string.passfullName),
                        additionalPersonDetails.nameOfHolder,
                    )
                    personalHashmap.put(
                        getString(R.string.passpersonalNumber),
                        additionalPersonDetails.personalNumber,
                    )
                    if (additionalPersonDetails.placeOfBirth != null) {
                        personalHashmap.put(
                            getString(
                                R.string.passplaceOfBirth,
                            ),
                            additionalPersonDetails.placeOfBirth[0],
                        )
                    } else {
                        personalHashmap.put(getString(R.string.passplaceOfBirth), emptyString)
                    }
                    personalHashmap.put(
                        getString(R.string.passnfcDateOfBirth),
                        additionalPersonDetails.fullDateOfBirth,
                    )
                    if (additionalPersonDetails.permanentAddress != null) {
                        personalHashmap.put(
                            getString(R.string.passaddress),
                            additionalPersonDetails.permanentAddress[0],
                        )
                    } else {
                        personalHashmap.put(getString(R.string.passaddress), emptyString)
                    }
                    if (!OtherConstant.getInstance().appName.equals(
                            getString(R.string.overify),
                            ignoreCase = true,
                        )
                    ) {
                        personalHashmap.put(
                            getString(R.string.passprofession),
                            additionalPersonDetails.profession,
                        )
                        personalHashmap.put(
                            getString(R.string.passtitle),
                            additionalPersonDetails.title,
                        )
                        personalHashmap.put(
                            getString(R.string.passpersonalSummary),
                            additionalPersonDetails.personalSummary,
                        )
                        if (additionalPersonDetails.otherValidTDNumbers != null) {
                            personalHashmap.put(
                                getString(R.string.passtdNumbers),
                                additionalPersonDetails.otherValidTDNumbers[0],
                            )
                        } else {
                            personalHashmap.put(getString(R.string.passtdNumbers), emptyString)
                        }
                        personalHashmap.put(
                            getString(R.string.passcustodyInfo),
                            additionalPersonDetails.custodyInformation,
                        )
                        if (additionalPersonDetails.proofOfCitizenship != null) {
                            personalHashmap.put(
                                getString(R.string.passproofOfCitizenship),
                                additionalPersonDetails.proofOfCitizenship.toString(),
                            )
                        } else {
                            personalHashmap.put(
                                getString(R.string.passproofOfCitizenship),
                                emptyString,
                            )
                        }
                    }
                    personalHashmap.put(
                        getString(R.string.passtelephone),
                        additionalPersonDetails.telephone,
                    )
                }
                if (additionalDGFiles != null) {
                    //        dg12 and dg14
                    personalHashmap.put(
                        getString(R.string.passnfcissuingCountry),
                        additionalDGFiles.issueingAuthority,
                    )
                    //                if (additionalDGFiles.getDateOfIssue() != null)
//                    personalHashmap.put(getString(R.string.passdateOfIssue), additionalDGFiles.getDateOfIssue());
//                else
//                    personalHashmap.put(getString(R.string.passdateOfIssue), emptyString);
                    if (!OtherConstant.getInstance().appName.equals(
                            getString(R.string.overify),
                            ignoreCase = true,
                        )
                    ) {
                        if (additionalDGFiles.frontImage != null) {
                            personalHashmap.put(
                                getString(R.string.passfrontImage),
                                additionalDGFiles.frontImage,
                            )
                        } else {
                            personalHashmap.put(getString(R.string.passfrontImage), emptyString)
                        }
                        if (additionalDGFiles.backImage != null) {
                            personalHashmap.put(
                                getString(R.string.passrearImage),
                                additionalDGFiles.backImage,
                            )
                        } else {
                            personalHashmap.put(getString(R.string.passrearImage), emptyString)
                        }
                        if (additionalDGFiles.securityInfos != null) {
                            personalHashmap.put(
                                getString(R.string.passsecurityInfos),
                                additionalDGFiles.securityInfos,
                            )
                        } else {
                            personalHashmap.put(
                                getString(R.string.passsecurityInfos),
                                emptyString,
                            )
                        }
                    }
                }
                NFCFragment.nfcData = personalHashmap
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        } else {
            idCardNFCData = IDCardNFCData.getInstance()
            val documentHashmap = JSONObject()
            try {
                val dg1Parser = OmanCardDG1File(Utility.getInstance().dgFile1)
                val dg4Parser = OmanCardDG4File(Utility.getInstance().dgFile4)
                val dg6Parser = OmanCardDG6File(Utility.getInstance().dgFile6)
                documentHashmap.put(
                    getString(R.string.idcardphoto),
                    LivenessData.getInstance().nfcImage,
                )
                if (dg1Parser != null) {
                    documentHashmap.put(getString(R.string.idcardidNumber), dg1Parser.idNumber)
                    documentHashmap.put(
                        getString(R.string.idcardissueDate),
                        formateDateFromstring(
                            dateFormate,
                            Constant.DATEFORMATE,
                            dg1Parser.issueDate,
                        ),
                    )
                    //                documentHashmap.put("Expiry Date", format6digitDate(dg1Parser.getExpiryDate(), 2000));
                    documentHashmap.put(
                        getString(R.string.idcardexpiryDate),
                        formateDateFromstring(
                            dateFormate,
                            Constant.DATEFORMATE,
                            dg1Parser.expiryDate,
                        ),
                    )
                    documentHashmap.put(
                        getString(R.string.idcardplaceOfIssueArabic),
                        dg1Parser.placeOfIssueArabic,
                    )
                    documentHashmap.put(
                        getString(R.string.idcardplaceOfIssueEnglish),
                        dg1Parser.placeOfIssueEnglish,
                    )
                    idCardNFCData.identityNumber = dg1Parser.idNumber
                    idCardNFCData.issueDate =
                        formateDateFromstring(
                            dateFormate,
                            Constant.DATEFORMATE,
                            dg1Parser.issueDate,
                        )
                    idCardNFCData.expiryDate =
                        formateDateFromstring(
                            dateFormate,
                            Constant.DATEFORMATE,
                            dg1Parser.expiryDate,
                        )
                    idCardNFCData.placeOfIssueArabic = dg1Parser.placeOfIssueArabic
                    idCardNFCData.placeOfIssueEnglish = dg1Parser.placeOfIssueEnglish
                }
                if (dg4Parser != null) {
                    documentHashmap.put(
                        getString(R.string.idcardfullNameArabic),
                        dg4Parser.fullNameArabic,
                    )
                    documentHashmap.put(
                        getString(R.string.idcardfullNameEnglish),
                        dg4Parser.fullNameEnglish,
                    )
                    idCardNFCData.fullNameArabic = dg4Parser.fullNameArabic
                    idCardNFCData.fullNameEnglish = dg4Parser.fullNameEnglish
                }
                if (dg6Parser != null) {
                    documentHashmap.put(
                        getString(R.string.idcarddateOfBirth),
                        formateDateFromstring(
                            dateFormate,
                            Constant.DATEFORMATE,
                            dg6Parser.dateOfBirth,
                        ),
                    )
                    documentHashmap.put(
                        getString(R.string.idcardcountryOfBirthArabic),
                        dg6Parser.countryOfBirthArabic,
                    )
                    documentHashmap.put(
                        getString(R.string.idcardplaceOfBirthEnglish),
                        dg6Parser.placeOfBirthEnglish,
                    )
                    documentHashmap.put(
                        getString(R.string.idcardnationalityArabic),
                        dg6Parser.nationalityArabic,
                    )
                    documentHashmap.put(
                        getString(R.string.idcardgenderArabic),
                        dg6Parser.genderArabic,
                    )
                    documentHashmap.put(
                        getString(R.string.idcardnationalityEnglish),
                        dg6Parser.nationalityEnglish,
                    )
                    documentHashmap.put(
                        getString(R.string.idcardgenderEnglish),
                        dg6Parser.genderEnglish,
                    )
                    idCardNFCData.dateOfBirth =
                        formateDateFromstring(
                            dateFormate,
                            Constant.DATEFORMATE,
                            dg6Parser.dateOfBirth,
                        )
                    idCardNFCData.placeOfBirthArabic = dg6Parser.countryOfBirthArabic
                    idCardNFCData.placeOfBirthEnglish = dg6Parser.placeOfBirthEnglish
                    idCardNFCData.nationalityArabic = dg6Parser.nationalityArabic
                    idCardNFCData.genderArabic = dg6Parser.genderArabic
                    idCardNFCData.nationalityEnglish = dg6Parser.nationalityEnglish
                    idCardNFCData.genderEnglish = dg6Parser.genderEnglish
                }
                if (Utility.getInstance().dgFile13 != null) {
                    val dg13Parser = OmanCardDG13File(Utility.getInstance().dgFile13)
                    if (dg13Parser != null) {
                        documentHashmap.put(
                            getString(R.string.idcardvisaNumber),
                            dg13Parser.sponsorNumber,
                        )
                        //                    sponsorHashmap.put("Sponsor Number", dg13Parser.getSponsorNumber());
//                    sponsorHashmap.put("Issue Date", formateDateFromstring(dateFormate,Constant.dateFormate,dg13Parser.getSponsorRelationship()));
//                    sponsorHashmap.put("Expiry Date",formateDateFromstring(dateFormate,Constant.dateFormate,dg13Parser.getSponsorExpiryDate()) );
                        documentHashmap.put(
                            getString(R.string.idcardPermitType),
                            dg13Parser.sponsorRelationship,
                        )
                        idCardNFCData.visaNumber = dg13Parser.sponsorNumber
                        idCardNFCData.permitType = dg13Parser.sponsorRelationship
                    }
                }
                if (Utility.getInstance().dgFile10 != null) {
                    val dg10Parser = OmanCardDG10File(Utility.getInstance().dgFile10)
                    if (dg10Parser != null) {
                        documentHashmap.put(
                            getString(R.string.idcardvisaExpiryDate),
                            formateDateFromstring(
                                dateFormate,
                                Constant.DATEFORMATE,
                                dg10Parser.visaExpiryDate,
                            ),
                        )
                        documentHashmap.put(
                            getString(R.string.idcardvisaPlaceOfIssueArabic),
                            dg10Parser.visaPlaceOfIssueArabic,
                        )
                        documentHashmap.put(
                            getString(R.string.idcardPermitNumber),
                            dg10Parser.visaNumber,
                        )
                        idCardNFCData.useByDate =
                            formateDateFromstring(
                                dateFormate,
                                Constant.DATEFORMATE,
                                dg10Parser.visaExpiryDate,
                            )
                        idCardNFCData.visaPlaceOfIssueArabic = dg10Parser.visaPlaceOfIssueArabic
                        idCardNFCData.permitNumber = dg10Parser.visaNumber
                    }
                }
                if (Utility.getInstance().dgFile13 != null) {
                    val dg13Parser = OmanCardDG13File(Utility.getInstance().dgFile13)
                    if (dg13Parser != null) {
                        documentHashmap.put(
                            getString(R.string.idcardsponsorIssueDate),
                            formateDateFromstring(
                                dateFormate,
                                Constant.DATEFORMATE,
                                dg13Parser.sponsorIssueDate,
                            ),
                        )
                        documentHashmap.put(
                            getString(R.string.idcardsponsorExpiryDate),
                            formateDateFromstring(
                                dateFormate,
                                Constant.DATEFORMATE,
                                dg13Parser.sponsorExpiryDate,
                            ),
                        )
                        idCardNFCData.sponserIssueDate =
                            formateDateFromstring(
                                dateFormate,
                                Constant.DATEFORMATE,
                                dg13Parser.sponsorIssueDate,
                            )
                        idCardNFCData.sponserExpirtDate =
                            formateDateFromstring(
                                dateFormate,
                                Constant.DATEFORMATE,
                                dg13Parser.sponsorExpiryDate,
                            )
                    }
                }
                //                Log.d("TAG", "setIDCardDetail: " +Utility.Companion.getInstance().getDgFile11());
                if (Utility.getInstance().dgFile11 != null) {
                    val dg11Parser = OmanCardDG11File(Utility.getInstance().dgFile11)
                    //                    Log.d("TAG", "setIDCardDetail: " + dg11Parser.getCompanyAddressEnglish());
                    if (dg11Parser != null) {
                        documentHashmap.put(
                            getString(R.string.idcardcompanyNameArabic),
                            dg11Parser.companyNameArabic,
                        )
                        documentHashmap.put(
                            getString(R.string.idcardcompanyNameEnglish),
                            dg11Parser.companyNameEnglish,
                        )
                        documentHashmap.put(
                            getString(R.string.idcardcompanyAddressArabic),
                            dg11Parser.companyAddressArabic,
                        )
                        idCardNFCData.companyNameArabic = dg11Parser.companyNameArabic
                        idCardNFCData.companyNameEnglish = dg11Parser.companyNameEnglish
                        idCardNFCData.companyAddressAraic = dg11Parser.companyAddressArabic
                    }
                }
                NFCFragment.nfcData = documentHashmap
            } catch (e: Exception) {
                Log.d("TAG", "setIDCardDetail: $e")
            }
        }
    }

    private fun formateDateFromstring(
        inputFormat: String,
        outputFormat: String,
        inputDate: String,
    ): String {
        try {
            val sdf: DateFormat = SimpleDateFormat(inputFormat)
            val date = sdf.parse(inputDate)
            return SimpleDateFormat(outputFormat).format(date)
        } catch (e: Exception) {
        }
        return inputDate
    }

    private var progressBar: ProgressBar? = null
    private var progressText: TextView? = null
    private var progressDialog: Dialog? = null

    private fun showDialog() {
        if (isActivityRunning) {
            progressDialog = Dialog(this)
            progressDialog!!.requestWindowFeature(Window.FEATURE_NO_TITLE)
            val binding =
                BottomSheetDialogBinding.inflate(
                    progressDialog!!.layoutInflater,
                )
            progressDialog!!.setContentView(binding.root)
            if (storage.getPreferredLocale().equals("ar", ignoreCase = true)) {
                binding.progressBar.rotation = 180f
            }
            progressBar = binding.progressBar
            progressText = binding.txtDialogPercentage
            val padding = textSizeConverter!!.getPaddingORMarginValue(16)
            binding.mainDialogLyt.setPadding(padding, padding, padding, padding)
            val layoutParams2 = binding.progressBar.layoutParams
            layoutParams2.width = textSizeConverter!!.getWidth(200)
            layoutParams2.height = ViewGroup.LayoutParams.WRAP_CONTENT
            binding.progressBar.layoutParams = layoutParams2
            var layoutParams = binding.progressBar.layoutParams as LinearLayout.LayoutParams
            layoutParams.setMargins(0, textSizeConverter!!.getPaddingORMarginValue(8), 0, 0)
            binding.progressBar.layoutParams = layoutParams
            binding.txtDialogPercentage.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter!!.getTextSize(16),
            )
            binding.txtScanning.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter!!.getTextSize(20),
            )
            binding.txtDialogDesc.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter!!.getTextSize(16),
            )
            layoutParams = binding.txtScanning.layoutParams as LinearLayout.LayoutParams
            layoutParams.setMargins(0, textSizeConverter!!.getPaddingORMarginValue(24), 0, 0)
            binding.txtScanning.layoutParams = layoutParams
            layoutParams = binding.txtDialogDesc.layoutParams as LinearLayout.LayoutParams
            layoutParams.setMargins(
                0,
                textSizeConverter!!.getPaddingORMarginValue(16),
                0,
                textSizeConverter!!.getPaddingORMarginValue(28),
            )
            binding.txtDialogDesc.layoutParams = layoutParams
            if (Objects.requireNonNull<String?>(viewModel!!.selectedDoc.value)
                    .equals(getString(R.string.e_passport), ignoreCase = true)
            ) {
                binding.txtDialogDesc.text = getString(R.string.dialog_dontmove_pass)
            } else {
                binding.txtDialogDesc.text = getString(R.string.dialog_dontmove)
            }
            progressDialog!!.show()
            progressDialog!!.setCancelable(false)
            progressDialog!!.window!!.setLayout(
                ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.WRAP_CONTENT,
            )
            progressDialog!!.window!!.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
            progressDialog!!.window!!.attributes.windowAnimations = R.style.DialogAnimation
            progressDialog!!.window!!.setGravity(Gravity.BOTTOM)
        }
    }

    private fun showSuccessDialog() {
        if (isActivityRunning) {
            val dialog = Dialog(this)
            dialog.requestWindowFeature(Window.FEATURE_NO_TITLE)
            val binding = DialogSuccessBinding.inflate(dialog.layoutInflater)
            dialog.setContentView(binding.root)
            val padding = textSizeConverter!!.getPaddingORMarginValue(16)
            binding.mainDialogLyt.setPadding(padding, padding, padding, padding)
            val layoutParams2 = binding.imgScanComplete.layoutParams
            layoutParams2.width = textSizeConverter!!.getWidth(56)
            layoutParams2.height = textSizeConverter!!.getHeight(56)
            binding.imgScanComplete.layoutParams = layoutParams2
            var layoutParams = binding.imgScanComplete.layoutParams as LinearLayout.LayoutParams
            layoutParams.setMargins(0, textSizeConverter!!.getPaddingORMarginValue(8), 0, 0)
            binding.imgScanComplete.layoutParams = layoutParams
            binding.txtScanCompleted.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter!!.getTextSize(24),
            )
            layoutParams = binding.txtScanCompleted.layoutParams as LinearLayout.LayoutParams
            layoutParams.setMargins(
                0,
                textSizeConverter!!.getPaddingORMarginValue(16),
                0,
                textSizeConverter!!.getPaddingORMarginValue(28),
            )
            binding.txtScanCompleted.layoutParams = layoutParams
            binding.imgScanComplete.playAnimation()
            binding.imgScanComplete.setAnimation(R.raw.scan_completed)
            //            binding.imgScanComplete.setRepeatCount(LottieDrawable.INFINITE);
            binding.imgScanComplete.addAnimatorListener(
                object : AnimatorListenerAdapter() {
                    override fun onAnimationEnd(animation: Animator) {
                        super.onAnimationEnd(animation)
                        dialog.dismiss()
                        TagProvider.closeTag()
                        dismissDialog()
                        viewModel!!.validateLivenessUser(this@WaitingForNfcActivity)
                    }
                },
            )
            dialog.show()
            dialog.setCancelable(false)
            dialog.window?.setLayout(
                ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.WRAP_CONTENT,
            )
            dialog.window!!.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
            dialog.window!!.attributes.windowAnimations = R.style.DialogAnimation
            dialog.window!!.setGravity(Gravity.BOTTOM)
        }
    }

    private var errorDialog: Dialog? = null
    private var maxRetryCount = 0

    private fun showFailureDialog(message: String) {
        Log.d("TAG", "showError:ac $isActivityRunning")
        if (isActivityRunning) {
            if (errorDialog != null) {
                errorDialog!!.dismiss()
            }
            if (java.lang.Boolean.TRUE == viewModel!!.skipNFC.value) {
                if (maxRetryCount >= viewModel!!.maxTry.value!! && viewModel!!.maxTry.value != 0) {
                    OtherConstant.getInstance().skipNFC = true
                    dismissDialog()
                    viewModel!!.validateLivenessUser(this@WaitingForNfcActivity)
                }
            }
            maxRetryCount = maxRetryCount + 1
            errorDialog = Dialog(this)
            errorDialog!!.requestWindowFeature(Window.FEATURE_NO_TITLE)
            val binding =
                DialogFailureNfcBinding.inflate(
                    errorDialog!!.layoutInflater,
                )
            errorDialog!!.setContentView(binding.root)
            var padding = textSizeConverter!!.getPaddingORMarginValue(16)
            binding.mainDialogLyt.setPadding(padding, padding, padding, padding)
            var layoutParams2 = binding.imgScanFailure.layoutParams
            layoutParams2.width = textSizeConverter!!.getWidth(56)
            layoutParams2.height = textSizeConverter!!.getHeight(56)
            binding.imgScanFailure.layoutParams = layoutParams2
            layoutParams2 = binding.imgInfo1.layoutParams
            layoutParams2.width = textSizeConverter!!.getWidth(20)
            layoutParams2.height = textSizeConverter!!.getHeight(20)
            binding.imgInfo1.layoutParams = layoutParams2
            layoutParams2 = binding.imgNfcFailed.layoutParams
            layoutParams2.width = textSizeConverter!!.getWidth(145)
            layoutParams2.height = textSizeConverter!!.getHeight(145)
            binding.imgNfcFailed.layoutParams = layoutParams2
            val layoutParams1 = binding.imgNfcFailed.layoutParams as LinearLayout.LayoutParams
            layoutParams1.setMargins(
                0,
                textSizeConverter!!.getPaddingORMarginValue(24),
                0,
                textSizeConverter!!.getPaddingORMarginValue(18),
            )
            binding.imgNfcFailed.layoutParams = layoutParams1
            layoutParams2 = binding.imgInfo2.layoutParams
            layoutParams2.width = textSizeConverter!!.getWidth(20)
            layoutParams2.height = textSizeConverter!!.getHeight(20)
            binding.imgInfo2.layoutParams = layoutParams2
            var layoutParams = binding.imgScanFailure.layoutParams as LinearLayout.LayoutParams
            layoutParams.setMargins(0, textSizeConverter!!.getPaddingORMarginValue(8), 0, 0)
            binding.imgScanFailure.layoutParams = layoutParams
            binding.txtScanCompleted.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter!!.getTextSize(20),
            )
            layoutParams = binding.txtScanCompleted.layoutParams as LinearLayout.LayoutParams
            layoutParams.setMargins(0, textSizeConverter!!.getPaddingORMarginValue(24), 0, 0)
            binding.txtScanCompleted.layoutParams = layoutParams
            binding.txtScanNotCompleteDesc1.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter!!.getTextSize(16),
            )
            layoutParams = binding.txtScanNotCompleteDesc1.layoutParams as LinearLayout.LayoutParams
            layoutParams.setMargins(
                textSizeConverter!!.getPaddingORMarginValue(6),
                textSizeConverter!!.getPaddingORMarginValue(16),
                0,
                0,
            )
            binding.txtScanNotCompleteDesc1.layoutParams = layoutParams
            binding.txtScanNotCompleteDesc2.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter!!.getTextSize(16),
            )
            binding.imgNfcFailed.playAnimation()
            binding.imgNfcFailed.repeatCount = LottieDrawable.INFINITE
            binding.imgNfcFailed.setAnimation(R.raw.nfc_read_failed)

//            Log.d("TAG", "showFailureDialog: " + message);
            if (message.equals("card", ignoreCase = true)) {
                binding.txtScanCompleted.visibility = View.GONE
                binding.imgNfcFailed.visibility = View.GONE
                binding.txtScanNotCompleteDesc1.text = resources.getString(R.string.mrz_wrong)
            } else {
                if (Objects.requireNonNull<String?>(viewModel!!.selectedDoc.value)
                        .equals(getString(R.string.e_passport), ignoreCase = true)
                ) {
                    binding.txtScanNotCompleteDesc1.text =
                        resources.getString(R.string.passport_scan_not_complete_desc)
                } else {
                    binding.txtScanNotCompleteDesc1.text =
                        resources.getString(R.string.scan_not_complete_desc2)
                }
            }
            layoutParams = binding.txtScanNotCompleteDesc2.layoutParams as LinearLayout.LayoutParams
            layoutParams.setMargins(
                textSizeConverter!!.getPaddingORMarginValue(6),
                textSizeConverter!!.getPaddingORMarginValue(16),
                0,
                0,
            )
            binding.txtScanNotCompleteDesc2.layoutParams = layoutParams
            layoutParams = binding.imgInfo1.layoutParams as LinearLayout.LayoutParams
            layoutParams.setMargins(0, textSizeConverter!!.getPaddingORMarginValue(16), 0, 0)
            binding.imgInfo1.layoutParams = layoutParams
            layoutParams = binding.imgInfo2.layoutParams as LinearLayout.LayoutParams
            layoutParams.setMargins(0, textSizeConverter!!.getPaddingORMarginValue(16), 0, 0)
            binding.imgInfo2.layoutParams = layoutParams
            layoutParams = binding.btnRetry.layoutParams as LinearLayout.LayoutParams
            layoutParams.setMargins(
                0,
                textSizeConverter!!.getPaddingORMarginValue(16),
                0,
                textSizeConverter!!.getPaddingORMarginValue(12),
            )
            binding.btnRetry.layoutParams = layoutParams
            padding = textSizeConverter!!.getPaddingORMarginValue(12)
            binding.txtBtnRetry.setPadding(0, padding, 0, padding)
            binding.btnRetry.radius = textSizeConverter!!.calculateRadius(8).toFloat()
            binding.txtBtnRetry.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter!!.getTextSize(16),
            )
            binding.btnRetry.setOnClickListener { view: View? ->
//                if (NashidSDK.getNfcResultListener() != null) {
//                    NashidSDK.getNfcResultListener().onFailure();
//                }
                errorDialog!!.dismiss()
                progressDialog!!.dismiss()
                //                TagProvider.closeTag();
                viewModel!!.cancelNfcRead()
            }
            errorDialog!!.show()
            errorDialog!!.setCancelable(false)
            errorDialog!!.window!!.setLayout(
                ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.WRAP_CONTENT,
            )
            errorDialog!!.window!!.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
            errorDialog!!.window!!.attributes.windowAnimations = R.style.DialogAnimation
            errorDialog!!.window!!.setGravity(Gravity.BOTTOM)
            if (progressDialog != null) progressDialog!!.dismiss()
        }
    }

    companion object {
        private const val TAG = "WaitingForNfcActivity"
    }
}
