package com.kyc.nashidmrz.mrtd2.activity.viewmodel

import android.content.Context
import androidx.fragment.app.Fragment
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.kyc.nashidmrz.R
import com.kyc.nashidmrz.mrtd2.activity.NFCFragment
import com.kyc.nashidmrz.mrtd2.activity.ScanningFragment
import com.kyc.nashidmrz.mrtd2.activity.VerificationFragment
import com.kyc.nashidmrz.mrtd2.rooted.RootedCheck

class ComparisonViewModel : ViewModel() {
    private val _isRooted = MutableLiveData<Boolean>()
    val isRooted: LiveData<Boolean> get() = _isRooted

    private val _fragments = MutableLiveData<Array<Fragment>>()
    val fragments: LiveData<Array<Fragment>> get() = _fragments

    private val _fragmentTitles = MutableLiveData<Array<String>>()
    val fragmentTitles: LiveData<Array<String>> get() = _fragmentTitles

    fun checkRootedStatus(context: Context) {
        _isRooted.value = RootedCheck.getInstance().isRootedDevice(context)
    }

    fun setFragments(
        liveness: Boolean,
        nfc: Boolean,
        preferredLocale: String,
        context: Context,
    ) {
        val fragments: Array<Fragment>
        val fragmentTitles: Array<String>

        if (preferredLocale.equals("ar", ignoreCase = true)) {
            when {
                !liveness && !nfc -> {
                    fragments = arrayOf(ScanningFragment())
                    fragmentTitles = arrayOf(context.getString(R.string.scanning))
                }
                !nfc -> {
                    fragments = arrayOf(ScanningFragment(), VerificationFragment())
                    fragmentTitles = arrayOf(context.getString(R.string.scanning), context.getString(R.string.verification))
                }
                !liveness -> {
                    fragments = arrayOf(ScanningFragment(), NFCFragment())
                    fragmentTitles = arrayOf(context.getString(R.string.scanning), context.getString(R.string.nfc))
                }
                else -> {
                    fragments = arrayOf(ScanningFragment(), NFCFragment(), VerificationFragment())
                    fragmentTitles = arrayOf(context.getString(R.string.scanning), context.getString(R.string.nfc), context.getString(R.string.verification))
                }
            }
        } else {
            when {
                !liveness && !nfc -> {
                    fragments = arrayOf(ScanningFragment())
                    fragmentTitles = arrayOf(context.getString(R.string.scanning))
                }
                !nfc -> {
                    fragments = arrayOf(VerificationFragment(), ScanningFragment())
                    fragmentTitles = arrayOf(context.getString(R.string.verification), context.getString(R.string.scanning))
                }
                !liveness -> {
                    fragments = arrayOf(NFCFragment(), ScanningFragment())
                    fragmentTitles = arrayOf(context.getString(R.string.nfc), context.getString(R.string.scanning))
                }
                else -> {
                    fragments = arrayOf(VerificationFragment(), NFCFragment(), ScanningFragment())
                    fragmentTitles = arrayOf(context.getString(R.string.verification), context.getString(R.string.nfc), context.getString(R.string.scanning))
                }
            }
        }
        _fragments.value = fragments
        _fragmentTitles.value = fragmentTitles
    }
}
