package com.kyc.nashidmrz.mrtd2.activity.viewmodel

import android.app.Activity
import android.app.Application
import android.content.Intent
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.graphics.Matrix
import android.graphics.Rect
import android.os.Handler
import android.os.Looper
import android.util.Base64
import android.util.Log
import androidx.lifecycle.AndroidViewModel
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import com.kyc.nashidmrz.NashidSDK
import com.kyc.nashidmrz.OtherConstant
import com.kyc.nashidmrz.R
import com.kyc.nashidmrz.Utility
import com.kyc.nashidmrz.facematches.FaceMatchApi
import com.kyc.nashidmrz.id_card.omn.OmanCardDG2File
import com.kyc.nashidmrz.mrtd2.CallCompanyScanAPI
import com.kyc.nashidmrz.mrtd2.CompleteCallingCompanyScanListner
import com.kyc.nashidmrz.mrtd2.activity.AMLAutoCrop
import com.kyc.nashidmrz.mrtd2.activity.ComparisionSuccessful
import com.kyc.nashidmrz.mrtd2.activity.NFCFragment
import com.kyc.nashidmrz.mrtd2.activity.SelectDocumentActivity
import com.kyc.nashidmrz.mrtd2.activity.StartScanningActivity
import com.kyc.nashidmrz.mrtd2.interfaceClass.RequestResponse
import com.kyc.nashidmrz.mrtd2.resultcallback.FeatureCheckCallback
import com.kyc.nashidmrz.mrtd2.resultcallback.Result
import com.kyc.nashidmrz.mrtd2.resultcallback.callbackclass.DocumentImages
import com.kyc.nashidmrz.networking.APIClient
import com.kyc.nashidmrz.networking.APIInterface
import com.kyc.nashidmrz.networking.models.ValidationResponse
import com.kyc.nashidmrz.utility.FeatureCheckApi
import com.kyc.nashidmrz.utility.SharePreferenceUtility
import com.mv.engine.FaceDetector
import org.json.JSONException
import org.json.JSONObject
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import java.io.ByteArrayOutputStream
import java.io.IOException

class SkipNFCLivenessViewModel(
    application: Application,
) : AndroidViewModel(application) {
    private val isLiveness = MutableLiveData(false)
    private val livenessBitmap = MutableLiveData<Bitmap?>(null)
    private val scanBitmap = MutableLiveData<Bitmap?>(null)
    private val isApiCalled = MutableLiveData(false)
    private val finishActivity = MutableLiveData(false)
    private val openActivity = MutableLiveData<Class<*>?>(null)
    private val isInternetAvailable = MutableLiveData(false)
    private val callLocationData = MutableLiveData(false)
    private val selectedDoc = MutableLiveData("")
    private val faceMatchApiFail = MutableLiveData("")

    fun getOpenActivity(): MutableLiveData<Class<*>?> = openActivity

    fun setOpenActivity(activityClass: Class<*>) {
        openActivity.value = activityClass
    }

    private fun setInternetConnection(isAvailable: Boolean) {
        isInternetAvailable.value = isAvailable
    }

    fun getHandleLocationData(): LiveData<Boolean> = callLocationData

    private fun setHandleLocationData(isAvailable: Boolean) {
        callLocationData.value = isAvailable
    }

    fun getInternetConnection(): LiveData<Boolean> = isInternetAvailable

    fun getIsApiCalled(): LiveData<Boolean> = isApiCalled

    fun getFaceMatchApiFail(): LiveData<String> = faceMatchApiFail

    private fun setIsApiCalled(apiCalled: Boolean) {
        isApiCalled.value = apiCalled
    }

    fun getLivenessBitmap(): LiveData<Bitmap?> = livenessBitmap

    private fun setLivenessBitmap(bitmap: Bitmap?) {
        livenessBitmap.value = bitmap
    }

    fun getScanBitmap(): LiveData<Bitmap?> = scanBitmap

    private fun setScanBitmap(bitmap: Bitmap?) {
        scanBitmap.value = bitmap
    }

    fun getFinishActivity(): LiveData<Boolean> = finishActivity

    fun requestFinishActivity() {
        finishActivity.value = true
    }

    fun getSelectedDoc(): LiveData<String> = selectedDoc

    fun setSelectedDoc(doc: String) {
        selectedDoc.value = doc
    }

    fun getIsLiveness(): LiveData<Boolean> = isLiveness

    fun setIsLiveness(liveness: Boolean) {
        isLiveness.value = liveness
    }

    fun handleInternetConnectionData(isInternetAvailable: Boolean) {
        setInternetConnection(isInternetAvailable)
        if (!isInternetAvailable) {
            setInternetConnection(false)
        } else {
            setIsApiCalled(true)
            if (OtherConstant.getInstance().appName.equals(
                    getApplication<Application>().getString(
                        R.string.overify,
                    ),
                    true,
                )
            ) {
                callFeatureCheck()
            } else {
                if (!SharePreferenceUtility.getSavePreferenceData(
                        getApplication(),
                        getApplication<Application>().getString(R.string.sharepreference_facila_matching),
                    )
                ) {
                    validateJustCompletion()
                } else {
                    setIsLiveness(true)
                }
            }
        }
    }

    private fun callFeatureCheck() {
        val featureCheckApi = FeatureCheckApi()
        featureCheckApi.callFeatureCheck(
            object : FeatureCheckCallback {
                override fun onFeatureCheckSuccess(features: ArrayList<String>) {
                    if (features.contains("Liveness") || features.contains("Face Match")) {
                        SharePreferenceUtility.savePreferenceValue(
                            getApplication(),
                            getApplication<Application>().getString(R.string.sharepreference_facila_matching),
                            true,
                        )
                        setIsLiveness(true)
                    } else {
                        SharePreferenceUtility.savePreferenceValue(
                            getApplication(),
                            getApplication<Application>().getString(R.string.sharepreference_facila_matching),
                            false,
                        )
                        setIsLiveness(false)
                        validateJustCompletion()
                    }
                }

                override fun onFeatureCheckFailure(errorMessage: String) {
                    finishActivity.value = true
                }
            },
        )
    }

    fun validateFaceMatchAction() {
        APIClient
            .getClient("validationKey", OtherConstant.getInstance().mainBaseUrl)
            .create(
                APIInterface::class.java,
            ).validateKey(getApplication<Application>().resources.getString(R.string.face_match_action))
            .enqueue(
                object : Callback<ValidationResponse> {
                    override fun onResponse(
                        call: Call<ValidationResponse>,
                        response: Response<ValidationResponse>,
                    ) {
                        if (response.code() != 200) {
                            setOpenActivity(SelectDocumentActivity::class.java)
                        } else {
                            extractFacesFromPhoto()
                        }
                    }

                    override fun onFailure(
                        call: Call<ValidationResponse>,
                        t: Throwable,
                    ) {
                        // Handle failure
                    }
                },
            )
    }

    fun extractFacesFromPhoto() {
        val matrix = Matrix().apply { postRotate(270f) }
        val liveImage =
            BitmapFactory.decodeByteArray(
                Utility.getInstance().liveImage,
                0,
                Utility.getInstance().liveImage?.size ?: 0,
            )
        val rotatedBitmap =
            Bitmap.createBitmap(liveImage, 0, 0, liveImage.width, liveImage.height, matrix, true)
        val liveImageByte =
            ByteArrayOutputStream().apply {
                rotatedBitmap.compress(
                    Bitmap.CompressFormat.JPEG,
                    100,
                    this,
                )
            }
        val scanImage: Bitmap? =
            if (!SharePreferenceUtility.getSavePreferenceData(
                    getApplication(),
                    getApplication<Application>().getString(R.string.sharepreference_nfc),
                )
            ) {
                DocumentImages.instance.scanPhoto
            } else {
                if (!OtherConstant.getInstance().skipNFC) {
                    if (getSelectedDoc().value.equals(
                            getApplication<Application>().getString(R.string.e_passport),
                            true,
                        )
                    ) {
                        try {
                            NFCFragment.nfcData?.get(getApplication<Application>().getString(R.string.passimage)) as Bitmap
                        } catch (e: JSONException) {
                            e.printStackTrace()
                            null
                        }
                    } else {
                        val dgFile2 =
                            try {
                                OmanCardDG2File(Utility.getInstance().dgFile2)
                            } catch (e: IOException) {
                                e.printStackTrace()
                                null
                            }
                        dgFile2?.let {
                            val decodedString =
                                Base64.decode(it.getTagValue(OmanCardDG2File.TAG_PHOTO), Base64.DEFAULT)
                            BitmapFactory.decodeByteArray(decodedString, 0, decodedString.size)
                        }
                    }
                } else {
                    DocumentImages.instance.scanPhoto
                }
            }

        val liveImageInByte = liveImageByte.toByteArray()
        val scanImageByte =
            ByteArrayOutputStream().apply {
                scanImage?.compress(
                    Bitmap.CompressFormat.JPEG,
                    100,
                    this,
                )
            }

        val scanImageInByte = scanImageByte.toByteArray()

        val faceDetector = FaceDetector()
        val assetManager = getApplication<Application>().assets
        if (faceDetector.loadModel(assetManager) != 0) {
            Log.e("FaceDetector", "Failed to load model")
        }

        val liveFaceImage =
            faceDetector.detect(rotatedBitmap).firstOrNull()?.let { face ->
                val rect = Rect(face.left, face.top, face.right, face.bottom)
                Bitmap.createBitmap(rotatedBitmap, rect.left, rect.top, rect.width(), rect.height())
            } ?: rotatedBitmap

        val scanFaceImage =
            runCatching {
                scanImage?.let { image ->
                    faceDetector.detect(image).firstOrNull()?.let { face ->
                        val rect = Rect(face.left, face.top, face.right, face.bottom)
                        Bitmap.createBitmap(image, rect.left, rect.top, rect.width(), rect.height())
                    }
                }
            }.getOrElse { e ->
                scanImage
            }

        setScanBitmap(scanFaceImage)
        setLivenessBitmap(liveFaceImage)
        callFaceMatchApi(scanImageInByte, liveImageInByte)
    }

    private fun callFaceMatchApi(
        scanImageInByte: ByteArray,
        liveImageInByte: ByteArray,
    ) {
        val faceMatchApi = FaceMatchApi()
        faceMatchApi.matchFaces(
            getApplication(),
            scanImageInByte,
            liveImageInByte,
            object : RequestResponse {
                override fun successResponse(matchedValue: String) {
                    var intValue = 0
                    try {
                        intValue = matchedValue.toInt()
                    } catch (e: NumberFormatException) {
                        e.printStackTrace()
                        Handler(Looper.getMainLooper()).post {
                            faceMatchApiFail.value = matchedValue
                            Log.d("callFaceMatchApi", "successResponse: $matchedValue")
                        }
                    }
                    Log.d("callFaceMatchApi", "successResponse: $intValue")
                    getImageMatchedResult(intValue.toString())
                }

                override fun failureResponse(error: String) {
                    Log.d("callFaceMatchApi", "successResponse: $error")
                    getImageMatchedResult(0.toString())
                    Handler(Looper.getMainLooper()).post { faceMatchApiFail.value = error }
                }
            },
        )
    }

    fun getImageMatchedResult(jsonObject: String) {
        Handler(Looper.getMainLooper()).post {
            val value =
                try {
                    jsonObject.toInt().takeIf { it != -1 } ?: 0
                } catch (e: NumberFormatException) {
                    0
                }
            Utility.getInstance().matchPercentage = value

            val livenessImageBitmap =
                Utility.getInstance().liveImage?.let {
                    BitmapFactory.decodeByteArray(it, 0, it.size)?.let { bmp ->
                        Bitmap.createScaledBitmap(bmp, bmp.width / 4, bmp.height / 4, false)
                    }
                }

            val livenessImageByteArray =
                ByteArrayOutputStream().apply {
                    livenessImageBitmap?.compress(Bitmap.CompressFormat.JPEG, 100, this)
                }

            Utility.getInstance().livenessScannedImage = livenessImageByteArray.toByteArray()
            validateJustCompletion()
        }
    }

    fun validateJustCompletion() {
        APIClient
            .getClient("validationKey", OtherConstant.getInstance().mainBaseUrl)
            .create(APIInterface::class.java)
            .validateKey(getApplication<Application>().resources.getString(R.string.just_completion_action))
            .enqueue(
                object : Callback<ValidationResponse> {
                    override fun onResponse(
                        call: Call<ValidationResponse>,
                        response: Response<ValidationResponse>,
                    ) {
                        if (response.code() != 200) {
                            setOpenActivity(SelectDocumentActivity::class.java)
                        } else {
                            callToComparison()
                        }
                    }

                    override fun onFailure(
                        call: Call<ValidationResponse>,
                        t: Throwable,
                    ) {
                        // Handle failure
                    }
                },
            )
    }

    private fun callToComparison() {
        if (OtherConstant.getInstance().needToShowResultScreen) {
            setOpenActivity(ComparisionSuccessful::class.java)
        } else {
            setHandleLocationData(true)
        }
    }

    fun callAMLCrop(
        activity: Activity,
        latitude: Double,
        longitude: Double,
        address: String,
        isShowStartScanning: Boolean,
    ) {
        AMLAutoCrop.setListner {
            val jsonObject =
                prepareResultData(activity, latitude, longitude, address, isShowStartScanning)
            if (jsonObject != null) {
                uploadImages(activity, jsonObject, isShowStartScanning)
            } else {
                uploadFailure()
            }
        }
        AMLAutoCrop.callAML(
            Utility.getInstance().name,
            Utility.getInstance().dateOfBirth,
            Utility.getInstance().nationality,
            Utility.getInstance().passportNumber,
            Utility.getInstance().country,
        )
        AMLAutoCrop.callAutoCropAPI(activity)
    }

    private fun prepareResultData(
        activity: Activity,
        latitude: Double,
        longitude: Double,
        address: String,
        isShowStartScanning: Boolean,
    ): JSONObject? {
        var isFlowCompleted = true
        if (isShowStartScanning) {
            setIsLiveness(false)
            isFlowCompleted = false
        }
        val isNFCEnabled: Boolean =
            if (!SharePreferenceUtility.getSavePreferenceData(
                    getApplication(),
                    getApplication<Application>().getString(R.string.sharepreference_nfc),
                )
            ) {
                false
            } else {
                !OtherConstant.getInstance().skipNFC
            }
        val jsonObject =
            Result.setResultData(
                activity,
                isNFCEnabled,
                isLiveness.value!!,
                isFlowCompleted,
            )
        val location = JSONObject()
        try {
            location.put(getApplication<Application>().getString(R.string.location_lat), latitude)
            location.put(
                getApplication<Application>().getString(R.string.location_longi),
                longitude,
            )
            location.put(getApplication<Application>().getString(R.string.location_name), address)
            jsonObject?.put(
                getApplication<Application>().getString(R.string.locationjson_title),
                location,
            )
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return jsonObject
    }

    private fun uploadFailure() {
        if (NashidSDK.getInstance().getResultListener() != null) {
            NashidSDK.getInstance().getResultListener()!!.onFailure()
        }
        requestFinishActivity()
    }

    private fun uploadImages(
        activity: Activity,
        jsonObject: JSONObject,
        isShowStartScanning: Boolean,
    ) {
        var completed = 1
        if (isShowStartScanning) {
            completed = 0
        }
        val callCompanyScanAPI = CallCompanyScanAPI()
        selectedDoc.value?.let {
            callCompanyScanAPI.uploadAllImages(
                activity,
                jsonObject,
                it,
                completed,
                object : CompleteCallingCompanyScanListner {
                    override fun onFailure() {
                        if (NashidSDK.getInstance().getResultListener() != null) {
                            NashidSDK.getInstance().getResultListener()!!.onFailure()
                        }
                        requestFinishActivity()
                    }

                    override fun onSuccess() {
                        if (NashidSDK.getInstance().getResultListener() != null) {
                            NashidSDK
                                .getInstance()
                                .getResultListener()!!
                                .onResultData(jsonObject, getSelectedDoc().value)
                            if (isShowStartScanning) {
                                openStartScanningScreen(activity)
                            } else {
                                requestFinishActivity()
                            }
                        } else {
                            requestFinishActivity()
                        }
                    }
                },
            )
        }
    }

    private fun openStartScanningScreen(activity: Activity) {
        val i = Intent(activity, StartScanningActivity::class.java)
        i.putExtra(
            getApplication<Application>().resources.getString(R.string.doc_key),
            getSelectedDoc().value,
        )
        activity.startActivity(i)
        activity.finish()
    }
}
