package com.kyc.nashidmrz.mrtd2.activity.viewmodel

import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.graphics.Matrix
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.kyc.nashidmrz.OtherConstant
import com.kyc.nashidmrz.Utility
import com.kyc.nashidmrz.networking.APIClient.getClient
import com.kyc.nashidmrz.networking.APIInterface
import okhttp3.ResponseBody
import org.json.JSONException
import org.json.JSONObject
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response

class VerificationViewModel : ViewModel() {
    private val _matchingValue = MutableLiveData<Int>()
    val matchingValue: LiveData<Int> get() = _matchingValue

    private val _profileImage = MutableLiveData<Bitmap>()
    val profileImage: LiveData<Bitmap> get() = _profileImage

    private val _amlStatus = MutableLiveData<Boolean>(false)
    val amlStatus: LiveData<Boolean> get() = _amlStatus

    fun setData() {
        _matchingValue.value = Utility.getInstance().matchPercentage

        try {
            val liveImage =
                BitmapFactory.decodeByteArray(
                    Utility.getInstance().liveImage,
                    0,
                    Utility.getInstance().liveImage!!.size,
                )
            val matrix = Matrix().apply { postRotate(270f) }
            val rotatedBitmap =
                Bitmap.createBitmap(
                    liveImage,
                    0,
                    0,
                    liveImage.width,
                    liveImage.height,
                    matrix,
                    true,
                )
            _profileImage.value = rotatedBitmap
        } catch (e: Exception) {
            // Handle exception
        }
    }

    fun callAML() {
        val name = Utility.getInstance().name
        val dob = Utility.getInstance().dateOfBirth
        val nationality = Utility.getInstance().nationality
        val docNumber = Utility.getInstance().passportNumber
        val country = Utility.getInstance().country

        val personData =
            "[{\"name\": \"$name\", \"birthDate\": \"$dob\", \"nationality\": \"$nationality\", \"identifier\": \"$docNumber\", \"country\": \"$country\"}]"
        val checksData =
            "[\"role.oligarch\",\"role.pep\",\"role.rca\",\"sanction\",\"crime.terror\",\"crime\"]"

        getClient("AML", OtherConstant.getInstance().amlBaseUrl).create(
            APIInterface::class.java,
        ).aml(personData, checksData).enqueue(
            object : Callback<ResponseBody> {
                override fun onResponse(
                    call: Call<ResponseBody>,
                    response: Response<ResponseBody>,
                ) {
                    if (response.isSuccessful) {
                        try {
                            val jsonResponse = response.body()!!.string()
                            val jsonObject = JSONObject(jsonResponse)
                            val status = jsonObject.getBoolean("status")
                            if (status) {
                                val responseArray = jsonObject.getJSONArray("response")
                                if (responseArray.length() > 0) {
                                    val innerArray = responseArray.getJSONArray(0)
                                    for (i in 0 until innerArray.length()) {
                                        val jsonObject = innerArray.getJSONObject(i)
                                        val topics = jsonObject.optString("topics")
                                        if (topics.equals("role.oligarch", ignoreCase = true) ||
                                            topics.equals("role.pep", ignoreCase = true) ||
                                            topics.equals("role.rca", ignoreCase = true) ||
                                            topics.equals("sanction", ignoreCase = true) ||
                                            topics.equals("crime.terror", ignoreCase = true) ||
                                            topics.equals("crime", ignoreCase = true)
                                        ) {
                                            _amlStatus.value = false
                                            return
                                        }
                                    }
                                    _amlStatus.value = true
                                } else {
                                    _amlStatus.value = true
                                }
                            } else {
                                _amlStatus.value = false
                            }
                        } catch (e: JSONException) {
                            e.printStackTrace()
                            _amlStatus.value = false
                        }
                    } else {
                        _amlStatus.value = false
                    }
                }

                override fun onFailure(
                    call: Call<ResponseBody>,
                    t: Throwable,
                ) {
                    _amlStatus.value = false
                }
            },
        )
    }
}
