package com.kyc.nashidmrz.mrtd2.activity.viewmodel

import android.app.Activity
import android.app.Application
import android.content.Intent
import android.graphics.BitmapFactory
import android.nfc.Tag
import android.nfc.tech.IsoDep
import android.util.Base64
import android.util.Log
import androidx.lifecycle.AndroidViewModel
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import com.kyc.nashidmrz.LivenessData
import com.kyc.nashidmrz.NashidSDK
import com.kyc.nashidmrz.OtherConstant
import com.kyc.nashidmrz.OtherConstant.Companion.getInstance
import com.kyc.nashidmrz.R
import com.kyc.nashidmrz.Utility
import com.kyc.nashidmrz.id_card.jmrtd.BACKey
import com.kyc.nashidmrz.id_card.jmrtd.BACKeySpec
import com.kyc.nashidmrz.id_card.jmrtd.PassportService.DEFAULT_MAX_BLOCKSIZE
import com.kyc.nashidmrz.id_card.omn.OmanCardDG2File
import com.kyc.nashidmrz.id_card.omn.OmanCardService
import com.kyc.nashidmrz.id_card.omn.OmanCardService.NORMAL_MAX_TRANCEIVE_LENGTH
import com.kyc.nashidmrz.mrtd2.BitiAndroid.TagProvider
import com.kyc.nashidmrz.mrtd2.activity.SelectDocumentActivity
import com.kyc.nashidmrz.mrtd2.activity.SkipNFCLivenessActivity
import com.kyc.nashidmrz.mrtd2.activity.passportNFC.NFCDocumentTag
import com.kyc.nashidmrz.mrtd2.activity.passportNFC.NFCDocumentTag.PassportCallback
import com.kyc.nashidmrz.mrtd2.activity.passportNFC.data.Passport
import com.kyc.nashidmrz.mrtd2.activity.passportNFC.jmrtd.MRTDTrustStore
import com.kyc.nashidmrz.mrtd2.activity.passportNFC.jmrtd.VerificationStatus
import com.kyc.nashidmrz.mrtd2.passportutils.AdditionalDGFiles
import com.kyc.nashidmrz.mrtd2.passportutils.AdditionalPersonDetails
import com.kyc.nashidmrz.mrtd2.passportutils.DateUtil
import com.kyc.nashidmrz.mrtd2.passportutils.DocType
import com.kyc.nashidmrz.mrtd2.passportutils.EDocument
import com.kyc.nashidmrz.mrtd2.passportutils.PersonDetails
import com.kyc.nashidmrz.mrtd2.resultcallback.callbackclass.DocumentImages
import com.kyc.nashidmrz.networking.APIClient
import com.kyc.nashidmrz.networking.APIInterface
import com.kyc.nashidmrz.networking.models.ValidationResponse
import io.reactivex.disposables.CompositeDisposable
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.SupervisorJob
import kotlinx.coroutines.cancel
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext
import net.sf.scuba.data.Gender
import net.sf.scuba.smartcards.CardService
import net.sf.scuba.smartcards.CardServiceException
import okhttp3.ResponseBody
import org.jmrtd.CardServiceProtocolException
import org.jmrtd.lds.icao.MRZInfo.createTD3MRZInfo
import org.json.JSONObject
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import java.util.Objects

class WaitingForNFCViewModel(application: Application) : AndroidViewModel(application) {
    val tag: String = "WaitingForNFCViewModel1"
    private val _selectedDoc = MutableLiveData("")
    val selectedDoc: LiveData<String> get() = _selectedDoc

    private val _passportNumber = MutableLiveData("")
    val passportNumber: LiveData<String> get() = _passportNumber

    private val _dateOfBirth = MutableLiveData("")
    val dateOfBirth: LiveData<String> get() = _dateOfBirth

    private val _dateOfExpiration = MutableLiveData("")
    val dateOfExpiration: LiveData<String> get() = _dateOfExpiration

    private val _skipNFC = MutableLiveData(false)
    val skipNFC: LiveData<Boolean> get() = _skipNFC

    private val _maxTry = MutableLiveData(0)
    val maxTry: LiveData<Int> get() = _maxTry

    private val _isInternetAvailable = MutableLiveData(false)
    val isInternetAvailable: LiveData<Boolean> get() = _isInternetAvailable

    private val _isApiCalled = MutableLiveData(false)
    val isApiCalled: LiveData<Boolean> get() = _isApiCalled

    private val _isNfcEnabled = MutableLiveData(false)
    val isNfcEnabled: LiveData<Boolean> get() = _isNfcEnabled

    private val showDialogEvent = MutableLiveData<Boolean>()

    private val _showError = MutableLiveData<String>(null)
    val showError: LiveData<String> get() = _showError

    private val _mrtdPercentage = MutableLiveData(0)

    private val _showResult = MutableLiveData(false)
    val showResult: LiveData<Boolean> get() = _showResult
    val mrtdPercentage: LiveData<Int> get() = _mrtdPercentage
    private var eDocument = EDocument()
    private var disposable = CompositeDisposable()

    init {
        OtherConstant.getInstance().skipNFC = false
        _passportNumber.value = Utility.getInstance().passportNumber
        _dateOfBirth.value = Utility.getInstance().dateOfBirth
        _dateOfExpiration.value = Utility.getInstance().expiryDate
    }

    // Setters
    fun setSelectedDoc(doc: String) {
        _selectedDoc.value = doc
    }

    fun setDateOfBirth(doc: String) {
        _dateOfBirth.value = doc
    }

    fun setSkipNFC(skipNFC: Boolean) {
        _skipNFC.value = skipNFC
    }

    fun setInternetConnection(isAvailable: Boolean) {
        _isInternetAvailable.value = isAvailable
    }

    fun setIsApiCalled(isApiCalled: Boolean) {
        _isApiCalled.value = isApiCalled
    }

    fun callNFCStatus() {
        Log.d("WaitingForNFCViewModel1", "callNFCStatus: ")
        try {
            NashidSDK.getInstance().getBaseURL()
        } catch (e: UninitializedPropertyAccessException) {
            e.printStackTrace()
            return
        }
        APIClient.getEmployeeTkenClient(
            NashidSDK.getInstance().getBaseURL(),
            NashidSDK.getInstance().getRegisterToken(),
        ).create(
            APIInterface::class.java,
        ).callNFCStatus(NashidSDK.getInstance().getCompanyUUID())
            .enqueue(
                object : Callback<ResponseBody> {
                    override fun onResponse(
                        call: Call<ResponseBody>,
                        response: Response<ResponseBody>,
                    ) {
                        try {
                            val jsonResponse = response.body()!!.string()
                            val jsonObject = JSONObject(jsonResponse)
                            if (response.isSuccessful) {
                                val data = jsonObject.getJSONObject("data")
                                val skipNFCValue = data.getBoolean("skip_nfc")
                                val maxTryValue = data.getInt("max_try")
                                _maxTry.value = maxTryValue
                                _skipNFC.value = skipNFCValue
                            }
                        } catch (e: java.lang.Exception) {
                            e.printStackTrace()
                        }
                    }

                    override fun onFailure(
                        call: Call<ResponseBody>,
                        t: Throwable,
                    ) {}
                },
            )
    }

    fun validateUser(activity: Activity) {
        APIClient.getClient("validationKey", OtherConstant.getInstance().mainBaseUrl)
            .create(
                APIInterface::class.java,
            ).validateKey(getApplication<Application>().resources.getString(R.string.nfc_action))
            .enqueue(
                object : Callback<ValidationResponse?> {
                    override fun onResponse(
                        call: Call<ValidationResponse?>,
                        response: Response<ValidationResponse?>,
                    ) {
                        if (response.code() != 200) {
                            val i = Intent(activity, SelectDocumentActivity::class.java)
                            i.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_CLEAR_TASK
                            activity.startActivity(i)
                        } else {
                            _isApiCalled.value = true
                            if (java.lang.Boolean.TRUE == isNfcEnabled.value) {
                                showDialogEvent.value = true
                                if (Objects.requireNonNull<String>(selectedDoc.value).equals(
                                        getApplication<Application>().getString(R.string.e_passport),
                                        ignoreCase = true,
                                    )
                                ) {
                                    readPassportNfc(Objects.requireNonNull<IsoDep>(TagProvider.getTag()).tag)
                                } else {
                                    if (Objects.requireNonNull<String>(passportNumber.value)
                                            .isNotEmpty() &&
                                        Objects.requireNonNull<String>(dateOfExpiration.value)
                                            .isNotEmpty() &&
                                        Objects.requireNonNull<String>(dateOfBirth.value)
                                            .isNotEmpty()
                                    ) {
                                        if (TagProvider.getTag() != null) {
                                            val bacKey: BACKeySpec =
                                                BACKey(
                                                    passportNumber.value,
                                                    dateOfBirth.value,
                                                    dateOfExpiration.value,
                                                )

                                            coroutineScope.cancel()

                                            if (bacKey != null) {
                                                readData(
                                                    Objects.requireNonNull(
                                                        TagProvider.getTag(),
                                                    ),
                                                    bacKey,
                                                )
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }

                    override fun onFailure(
                        call: Call<ValidationResponse?>,
                        t: Throwable,
                    ) {
                    }
                },
            )
    }

    fun cancelNfcRead() {
        coroutineScope.cancel()
    }

    fun getEDocument(): EDocument {
        return eDocument
    }

    fun getDisposable(): CompositeDisposable {
        return disposable
    }

    fun readPassportNfc(tagFromIntent: Tag?) {
        val mrtdTrustStore = MRTDTrustStore()
        val mrzInfo =
            createTD3MRZInfo(
                "P",
                "ESP",
                "DUMMY",
                "DUMMY",
                passportNumber.value,
                "ESP",
                dateOfBirth.value,
                Gender.MALE,
                dateOfExpiration.value,
                "DUMMY",
            )
        val nfcDocumentTag = NFCDocumentTag()
        val disposable1 =
            nfcDocumentTag.handleTag(
                getApplication<Application>(),
                tagFromIntent!!,
                mrzInfo,
                mrtdTrustStore,
                object : PassportCallback {
                    override fun onProgresUpdate(progress: Int?) {
                        _mrtdPercentage.value = progress
                    }

                    override fun onPassportReadStart() {}

                    override fun onPassportReadFinish() {}

                    override fun onPassportRead(passport: Passport?) {
                        var docType = DocType.OTHER
                        val personDetails = PersonDetails()
                        val additionalPersonDetails = AdditionalPersonDetails()
                        val additionalDGFiles = AdditionalDGFiles()
                        personDetails.name =
                            passport!!.personDetails!!.secondaryIdentifier!!.replace("<", " ")
                                .trim { it <= ' ' }
                        personDetails.surname =
                            passport.personDetails!!.primaryIdentifier!!.replace("<", " ")
                                .trim { it <= ' ' }
                        personDetails.personalNumber = passport.personDetails!!.optionalData1
                        personDetails.gender = passport.personDetails!!.gender.toString()
                        personDetails.birthDate =
                            DateUtil.convertFromMrzDate(
                                passport.personDetails!!.dateOfBirth,
                            )
                        personDetails.expiryDate =
                            DateUtil.convertFromMrzDate(
                                passport.personDetails!!.dateOfExpiry,
                            )
                        personDetails.serialNumber = passport.personDetails!!.documentNumber
                        personDetails.nationality = passport.personDetails!!.nationality
                        personDetails.issuerAuthority = passport.personDetails!!.issuingState
                        personDetails.isDigitalSigVerification =
                            passport.verificationStatus!!.ca === VerificationStatus.Verdict.SUCCEEDED
                        if ("I" == mrzInfo.documentCode) {
                            docType = DocType.ID_CARD
                        } else if ("P" == mrzInfo.documentCode) {
                            docType = DocType.PASSPORT
                        }
                        personDetails.faceImage = passport.face
                        personDetails.signature = passport.signature
                        if (passport.additionalPersonDetails != null) {
                            additionalPersonDetails.custodyInformation =
                                passport.additionalPersonDetails!!.custodyInformation
                            additionalPersonDetails.nameOfHolder =
                                passport.additionalPersonDetails!!.nameOfHolder!!.replace("null ", "")
                            additionalPersonDetails.fullDateOfBirth =
                                DateUtil.convertFromMrzDateDG12(
                                    passport.additionalPersonDetails!!.fullDateOfBirth,
                                )
                            additionalPersonDetails.otherNames =
                                passport.additionalPersonDetails!!.otherNames
                            additionalPersonDetails.otherValidTDNumbers =
                                passport.additionalPersonDetails!!.otherValidTDNumbers
                            additionalPersonDetails.permanentAddress =
                                passport.additionalPersonDetails!!.permanentAddress
                            additionalPersonDetails.personalNumber =
                                passport.additionalPersonDetails!!.personalNumber
                            additionalPersonDetails.personalSummary =
                                passport.additionalPersonDetails!!.personalSummary
                            additionalPersonDetails.placeOfBirth =
                                passport.additionalPersonDetails!!.placeOfBirth
                            additionalPersonDetails.profession =
                                passport.additionalPersonDetails!!.profession
                            additionalPersonDetails.proofOfCitizenship =
                                passport.additionalPersonDetails!!.proofOfCitizenship
                            additionalPersonDetails.tag = passport.additionalPersonDetails!!.tag
                            additionalPersonDetails.tagPresenceList =
                                passport.additionalPersonDetails!!.tagPresenceList
                            additionalPersonDetails.telephone =
                                passport.additionalPersonDetails!!.telephone
                            additionalPersonDetails.title = passport.additionalPersonDetails!!.title
                            eDocument.additionalPersonDetails = additionalPersonDetails
                        } else {
                            personDetails.name =
                                passport.personDetails!!.primaryIdentifier + " " + passport.personDetails!!.secondaryIdentifier
                        }
                        if (passport.dg14File != null) {
                            additionalDGFiles.securityInfos =
                                passport.dg14File!!.securityInfos.toString()
                        }
                        if (passport.additionalDocumentDetails != null) {
                            additionalDGFiles.issueingAuthority =
                                passport.additionalDocumentDetails!!.issuingAuthority
                            additionalDGFiles.dateOfIssue =
                                DateUtil.convertFromMrzDateDG12(
                                    passport.additionalDocumentDetails!!.dateOfIssue,
                                )
                            additionalDGFiles.personalizationDeviceSerialNumber =
                                passport.additionalDocumentDetails!!.personalizationSystemSerialNumber
                            additionalDGFiles.personalizationTime =
                                passport.additionalDocumentDetails!!.dateAndTimeOfPersonalization
                            eDocument.additionalDGFiles = additionalDGFiles
                        }
                        eDocument.rsaPublicKey = passport.rasPublicKey
                        eDocument.ecdsaPublicKey = passport.ecdsaPublicKey
                        eDocument.docType = docType
                        eDocument.personDetails = personDetails
                        _showResult.value = true
                    }

                    override fun onAccessDeniedException(exception: CardServiceProtocolException) {
                        _showError.value = ""
                    }

                    override fun onBACDeniedException(exception: CardServiceProtocolException) {
                        _showError.value = ""
                    }

                    override fun onPACEException(exception: CardServiceProtocolException) {
                        _showError.value = ""
                    }

                    override fun onCardException(exception: CardServiceException) {
                        _showError.value = "card"
                    }

                    override fun onGeneralException(exception: Exception?) {
                        _showError.value = ""
                    }
                },
            )
        disposable.add(disposable1)
    }

    private var coroutineScope = CoroutineScope(Dispatchers.Main + SupervisorJob())
    private val readDataCoroutineScope = CoroutineScope(Dispatchers.Main)

    fun readData(
        isoDep: IsoDep,
        bacKey: BACKeySpec,
    ) {
        readDataCoroutineScope.launch {
            try {
                readIdCardNfcData(isoDep, bacKey)
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
    }

    private suspend fun readIdCardNfcData(
        isoDep: IsoDep,
        bacKey: BACKeySpec,
    ) {
        coroutineScope = CoroutineScope(Dispatchers.Main + SupervisorJob())
        coroutineScope.launch {
            val result =
                withContext(Dispatchers.IO) {
                    performNfcRead(isoDep, bacKey)
                }
            result?.let {
                Log.d(tag, "readIdCardNfcData: " + it.percentage)
                if (it.percentage == 100) {
                    _showResult.value = true
                }
                _mrtdPercentage.value = it.percentage
                it.error?.let { error -> _showError.value = error }
            }
        }
    }

    private fun performNfcRead(
        isoDep: IsoDep,
        bacKey: BACKeySpec,
    ): ReadResult? {
        Log.d(tag, "performNfcRead: ")
        return try {
            val cardService = CardService.getInstance(isoDep)
            cardService.open()

            val service =
                OmanCardService(
                    cardService,
                    NORMAL_MAX_TRANCEIVE_LENGTH,
                    DEFAULT_MAX_BLOCKSIZE,
                    false,
                    false,
                )
            service.open()
            service.sendSelectApplet(false)
            service.doBAC(bacKey)

            _mrtdPercentage.postValue(5)

            val dgFile1 = service.readFile(OmanCardService.SFI_DG1.toShort())
            if (dgFile1 == null) {
                _showError.postValue(getApplication<Application>().resources.getString(R.string.error_dg1_is_null))
            }
            Utility.getInstance().dgFile1 = (dgFile1)
            _mrtdPercentage.postValue(20)

            val dgFile2 = service.readFile(OmanCardService.SFI_DG2.toShort())
            if (dgFile2 == null) {
                _showError.postValue(getApplication<Application>().resources.getString(R.string.error_dg2_is_null))
            }

            Utility.getInstance().dgFile2 = (dgFile2)
            val dgFile2Obj = OmanCardDG2File(Utility.getInstance().dgFile2)

            val decodedString =
                Base64.decode(dgFile2Obj.getTagValue(OmanCardDG2File.TAG_PHOTO), Base64.DEFAULT)
            LivenessData.getInstance()
                .setNfcBitmap(BitmapFactory.decodeByteArray(decodedString, 0, decodedString.size))
            DocumentImages.instance.nfcPhoto =
                (BitmapFactory.decodeByteArray(decodedString, 0, decodedString.size))
            _mrtdPercentage.postValue(35)

            val dgFile4 = service.readFile(OmanCardService.SFI_DG4.toShort())
            if (dgFile4 == null) {
                _showError.postValue(getApplication<Application>().resources.getString(R.string.error_dg4_is_null))
            }
            Utility.getInstance().dgFile4 = (dgFile4)
            _mrtdPercentage.postValue(50)

            val dgFile6 = service.readFile(OmanCardService.SFI_DG6.toShort())
            if (dgFile6 == null) {
                _showError.postValue(getApplication<Application>().resources.getString(R.string.error_dg6_is_null))
            }
            Utility.getInstance().dgFile6 = (dgFile6)
            _mrtdPercentage.postValue(65)

            try {
                val dgFile10 = service.readFile(OmanCardService.SFI_DG10.toShort())
                if (dgFile10 == null) {
                    _showError.postValue(getApplication<Application>().resources.getString(R.string.error_dg10_is_null))
                }
                Utility.getInstance().dgFile10 = (dgFile10)
            } catch (e: Exception) {
                e.printStackTrace()
            }
            _mrtdPercentage.postValue(75)

            try {
                val dgFile11 = service.readFile(OmanCardService.SFI_DG11.toShort())
                if (dgFile11 == null) {
                    _showError.postValue(getApplication<Application>().resources.getString(R.string.error_dg11_is_null))
                }
                Utility.getInstance().dgFile11 = (dgFile11)
            } catch (e: Exception) {
                e.printStackTrace()
            }
            _mrtdPercentage.postValue(85)

            try {
                val dgFile13 = service.readFile(OmanCardService.SFI_DG13.toShort())
                if (dgFile13 == null) {
                    _showError.postValue(getApplication<Application>().resources.getString(R.string.error_dg13_is_null))
                }
                Utility.getInstance().dgFile13 = (dgFile13)
            } catch (e: Exception) {
                e.printStackTrace()
            }

            ReadResult(100) // Return result with the final percentage
        } catch (e: Exception) {
            e.printStackTrace()
            _showError.postValue("An error occurred: ${e.message}")
            null
        }
    }

    data class ReadResult(val percentage: Int, val error: String? = null)

    fun validateLivenessUser(activity: Activity) {
        APIClient.getClient("validationKey", getInstance().mainBaseUrl).create<APIInterface>(
            APIInterface::class.java,
        ).validateKey(getApplication<Application>().resources.getString(R.string.liveness_action))
            .enqueue(
                object : Callback<ValidationResponse?> {
                    override fun onResponse(
                        call: Call<ValidationResponse?>,
                        response: Response<ValidationResponse?>,
                    ) {
                        if (response.code() != 200) {
                            val i =
                                Intent(activity, SelectDocumentActivity::class.java)
                            i.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_CLEAR_TASK
                            activity.startActivity(i)
                        } else {
                            if (getInstance().skipNFC) {
                                val intent =
                                    Intent(
                                        activity,
                                        SkipNFCLivenessActivity::class.java,
                                    )
                                intent.putExtra(
                                    getApplication<Application>().resources.getString(R.string.doc_key),
                                    selectedDoc.value,
                                )
                                activity.startActivity(intent)
                                activity.finish()
                            } else {
                                if (Objects.requireNonNull<String>(selectedDoc.value)
                                        .equals(
                                            getApplication<Application>().resources.getString(R.string.e_passport),
                                            ignoreCase = true,
                                        )
                                ) {
                                    LivenessData.getInstance().passportNumber =
                                        passportNumber.value
                                    val intent =
                                        Intent(
                                            activity,
                                            SkipNFCLivenessActivity::class.java,
                                        )
                                    intent.putExtra(
                                        getApplication<Application>().resources.getString(R.string.doc_key),
                                        selectedDoc.value,
                                    )
                                    activity.startActivity(intent)
                                } else {
                                    LivenessData.getInstance().passportNumber =
                                        passportNumber.value

                                    val intent =
                                        Intent(
                                            activity,
                                            SkipNFCLivenessActivity::class.java,
                                        )
                                    intent.putExtra(
                                        getApplication<Application>().resources.getString(R.string.doc_key),
                                        selectedDoc.value,
                                    )
                                    activity.startActivity(intent)
                                }
                                activity.finish()
                            }
                        }
                    }

                    override fun onFailure(
                        call: Call<ValidationResponse?>,
                        t: Throwable,
                    ) {
                    }
                },
            )
    }
}
