package com.kyc.nashidmrz.mrtd2.activity.viewmodel.scan

import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData

class CameraXLiveData {
    private val isInternetAvailable = MutableLiveData(false)
    private val isSuccess = MutableLiveData(false)
    private val isFrontView = MutableLiveData(false)
    private val closeImageProxy = MutableLiveData(false)
    private val selectedDoc = MutableLiveData("")
    private val statusText = MutableLiveData<String>()
    private val bottomText = MutableLiveData<String>()
    private val idNo = MutableLiveData<String?>(null)
    private val dob = MutableLiveData<String?>(null)
    private val expiryDate = MutableLiveData<String?>(null)
    private val captureAnImage = MutableLiveData(false)
    private val cTimer = MutableLiveData(false)
    private val closeAnalysisUseCase = MutableLiveData(false)
    private val isScanVisible = MutableLiveData(false)
    private val isScanFailVisible = MutableLiveData(false)
    private val isTransparentVisible = MutableLiveData(false)
    private val isScanCompleteVisible = MutableLiveData(false)
    private val isLayoutBottomVisible = MutableLiveData(true)
    private val isBackCardScanVisible = MutableLiveData(false)
    private val isFrontViewScanned = MutableLiveData(false)
    private val isOverlayVisible = MutableLiveData(true)
    private val flag = MutableLiveData(true)
    private val algoHeaderDetect = MutableLiveData(false)
    private val isIdLine1 = MutableLiveData(true)
    private val isIdLine2 = MutableLiveData(true)
    private val isIdLine3 = MutableLiveData(true)
    private val glareTextVisibility = MutableLiveData(false)
    private val glareText = MutableLiveData("")
    private val updateCustomLoader = MutableLiveData(false)
    private val unbindCameraProvider = MutableLiveData(false)

    // Getters
    fun getIsInternetAvailable(): LiveData<Boolean> {
        return isInternetAvailable
    }

    fun getIsSuccess(): LiveData<Boolean> {
        return isSuccess
    }

    fun getIsFrontView(): LiveData<Boolean> {
        return isFrontView
    }

    fun getCloseImageProxy(): LiveData<Boolean> {
        return closeImageProxy
    }

    fun getSelectedDoc(): LiveData<String> {
        return selectedDoc
    }

    fun getStatusText(): LiveData<String> {
        return statusText
    }

    fun getBottomText(): LiveData<String> {
        return bottomText
    }

    fun getIdNo(): LiveData<String?> {
        return idNo
    }

    val dOB: LiveData<String?>
        get() = dob

    fun getExpiryDate(): LiveData<String?> {
        return expiryDate
    }

    fun getCaptureAnImage(): LiveData<Boolean> {
        return captureAnImage
    }

    fun getCTimer(): LiveData<Boolean> {
        return cTimer
    }

    fun getCloseAnalysisUseCase(): LiveData<Boolean> {
        return closeAnalysisUseCase
    }

    fun getIsScanVisible(): LiveData<Boolean> {
        return isScanVisible
    }

    fun getIsScanFailVisible(): LiveData<Boolean> {
        return isScanFailVisible
    }

    fun getIsTransparentVisible(): LiveData<Boolean> {
        return isTransparentVisible
    }

    fun getIsScanCompleteVisible(): LiveData<Boolean> {
        return isScanCompleteVisible
    }

    fun getIsLayoutBottomVisible(): LiveData<Boolean> {
        return isLayoutBottomVisible
    }

    fun getIsBackCardScanVisible(): LiveData<Boolean> {
        return isBackCardScanVisible
    }

    fun getIsFrontViewScanned(): LiveData<Boolean> {
        return isFrontViewScanned
    }

    fun getIsOverlayVisible(): LiveData<Boolean> {
        return isOverlayVisible
    }

    fun getFlag(): LiveData<Boolean> {
        return flag
    }

    fun getAlgoHeaderDetect(): LiveData<Boolean> {
        return algoHeaderDetect
    }

    fun getIdLine1(): LiveData<Boolean> {
        return isIdLine1
    }

    fun getIdLine2(): LiveData<Boolean> {
        return isIdLine2
    }

    fun getIdLine3(): LiveData<Boolean> {
        return isIdLine3
    }

    fun getGlareTextVisibility(): LiveData<Boolean> {
        return glareTextVisibility
    }

    fun getGlareText(): LiveData<String> {
        return glareText
    }

    fun getUpdateCustomLoader(): LiveData<Boolean> {
        return updateCustomLoader
    }

    fun getUnbindCameraProvider(): LiveData<Boolean> {
        return unbindCameraProvider
    }

    // Setters
    fun setIsInternetAvailable(isAvailable: Boolean) {
        isInternetAvailable.value = isAvailable
    }

    fun setIsSuccess(isSuccess: Boolean) {
        this.isSuccess.value = isSuccess
    }

    fun setIsFrontView(isFrontView: Boolean) {
        this.isFrontView.value = isFrontView
    }

    fun setCloseImageProxy(needToCloseImageProxy: Boolean) {
        closeImageProxy.value = needToCloseImageProxy
    }

    fun setSelectedDoc(doc: String) {
        selectedDoc.value = doc
    }

    fun setStatusText(status: String) {
        statusText.value = status
    }

    fun setBottomText(bottom: String) {
        bottomText.value = bottom
    }

    fun setIdNo(value: String?) {
        idNo.value = value
    }

    fun setDOB(value: String?) {
        dob.value = value
    }

    fun setExpiryDate(value: String?) {
        expiryDate.value = value
    }

    fun setCaptureAnImage(capture: Boolean) {
        captureAnImage.value = capture
    }

    fun setCTimer(cTimer: Boolean) {
        this.cTimer.value = cTimer
    }

    fun setCloseAnalysisUseCase(close: Boolean) {
        closeAnalysisUseCase.value = close
    }

    fun setIsScanVisible(isVisible: Boolean) {
        isScanVisible.value = isVisible
    }

    fun setIsScanFailVisible(isVisible: Boolean) {
        isScanFailVisible.value = isVisible
    }

    fun setIsTransparentVisible(isVisible: Boolean) {
        isTransparentVisible.value = isVisible
    }

    fun setIsScanCompleteVisible(isVisible: Boolean) {
        isScanCompleteVisible.value = isVisible
    }

    fun setIsLayoutBottomVisible(visible: Boolean) {
        isLayoutBottomVisible.value = visible
    }

    fun setIsBackCardScanVisible(isVisible: Boolean) {
        isBackCardScanVisible.value = isVisible
    }

    fun setIsFrontViewScanned(isScanned: Boolean) {
        isFrontViewScanned.value = isScanned
    }

    fun setIsOverlayVisible(visibility: Boolean) {
        isOverlayVisible.value = visibility
    }

    fun setFlag(flag: Boolean) {
        this.flag.value = flag
    }

    fun setAlgoHeaderDetect(detect: Boolean) {
        algoHeaderDetect.value = detect
    }

    fun setIdLine1(idLine1: Boolean) {
        isIdLine1.value = idLine1
    }

    fun setIdLine2(idLine2: Boolean) {
        isIdLine2.value = idLine2
    }

    fun setIdLine3(idLine3: Boolean) {
        isIdLine3.value = idLine3
    }

    fun setGlareTextVisibility(visibility: Boolean) {
        glareTextVisibility.value = visibility
    }

    fun setGlareText(text: String) {
        glareText.value = text
    }

    fun setUpdateCustomLoader(needToUpdate: Boolean) {
        updateCustomLoader.value = needToUpdate
    }

    fun setUnbindCameraProvider(isUnbind: Boolean) {
        unbindCameraProvider.value = isUnbind
    }
}
