package com.kyc.nashidmrz.mrtd2.activity.viewmodel.scan

import android.app.Activity
import android.app.Application
import android.content.Intent
import android.content.res.Resources
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.util.Log
import androidx.camera.lifecycle.ProcessCameraProvider
import androidx.core.content.ContextCompat
import androidx.fragment.app.FragmentActivity
import androidx.lifecycle.AndroidViewModel
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import com.google.mlkit.vision.common.InputImage
import com.google.mlkit.vision.text.Text
import com.google.mlkit.vision.text.Text.TextBlock
import com.google.mlkit.vision.text.TextRecognition
import com.google.mlkit.vision.text.TextRecognizer
import com.google.mlkit.vision.text.latin.TextRecognizerOptions
import com.kyc.nashidmrz.Constant.ID_CARD_REGEX1
import com.kyc.nashidmrz.Constant.ID_CARD_REGEX2
import com.kyc.nashidmrz.Constant.ID_CARD_REGEX3
import com.kyc.nashidmrz.Constant.PASSPORT_TD_3_LINE_1_REGEX
import com.kyc.nashidmrz.Constant.PASSPORT_TD_3_LINE_2_REGEX
import com.kyc.nashidmrz.NashidSDK
import com.kyc.nashidmrz.OtherConstant
import com.kyc.nashidmrz.R
import com.kyc.nashidmrz.Utility
import com.kyc.nashidmrz.facematches.FaceDetectionUtil
import com.kyc.nashidmrz.mrtd2.CallCompanyScanAPI
import com.kyc.nashidmrz.mrtd2.CompleteCallingCompanyScanListner
import com.kyc.nashidmrz.mrtd2.activity.AMLAutoCrop
import com.kyc.nashidmrz.mrtd2.activity.SelectDocumentActivity
import com.kyc.nashidmrz.mrtd2.activity.SkipNFCLivenessActivity
import com.kyc.nashidmrz.mrtd2.activity.WaitingForNfcActivity
import com.kyc.nashidmrz.mrtd2.helpers.OmanIdCardReaderHelper.Companion.cleanString
import com.kyc.nashidmrz.mrtd2.helpers.OmanIdCardReaderHelper.Companion.isSimilarEnough
import com.kyc.nashidmrz.mrtd2.helpers.OmanIdCardReaderHelper.Companion.replaceAlfaWithNumber
import com.kyc.nashidmrz.mrtd2.helpers.OmanIdCardReaderHelper.Companion.replaceNumberWithAlfa
import com.kyc.nashidmrz.mrtd2.resultcallback.FeatureCheckCallback
import com.kyc.nashidmrz.mrtd2.resultcallback.Result
import com.kyc.nashidmrz.mrtd2.resultcallback.callbackclass.DocumentImages.Companion.instance
import com.kyc.nashidmrz.mrtd2.resultcallback.callbackclass.ScanDocument
import com.kyc.nashidmrz.networking.APIClient
import com.kyc.nashidmrz.networking.APIInterface
import com.kyc.nashidmrz.networking.models.ValidationResponse
import com.kyc.nashidmrz.utility.FeatureCheckApi
import com.kyc.nashidmrz.utility.PermissionAndLocationHelper
import com.kyc.nashidmrz.utility.PermissionAndLocationHelper.requestPermissionAndLocation
import com.kyc.nashidmrz.utility.SharePreferenceUtility
import com.mv.engine.FaceDetector
import org.json.JSONException
import org.json.JSONObject
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import java.text.SimpleDateFormat
import java.util.Date
import java.util.Locale
import java.util.Objects
import java.util.concurrent.ExecutionException
import java.util.regex.Pattern
import kotlin.Array
import kotlin.Double
import kotlin.Exception
import kotlin.Int
import kotlin.String
import kotlin.Throwable

class CameraXLivePreviewViewModel(
    application: Application,
) : AndroidViewModel(application) {
    private val textRecognizer: TextRecognizer = TextRecognition.getClient(TextRecognizerOptions.DEFAULT_OPTIONS)
    private val scanDocument: ScanDocument = ScanDocument.getInstance()

    @JvmField
    val cameraXLiveData: CameraXLiveData = CameraXLiveData()
    private var passportMRZ = ""
    private var name = ""
    private var cameraProviderLiveData: MutableLiveData<ProcessCameraProvider>? = null

    fun setSelectedDoc(
        selectedDoc: String,
        resources: Resources,
    ) {
        cameraXLiveData.setSelectedDoc(selectedDoc)
        if (selectedDoc.equals(resources.getString(R.string.e_passport), ignoreCase = true)) {
            cameraXLiveData.setStatusText(resources.getString(R.string.scan_passport_top_text))
            cameraXLiveData.setBottomText(resources.getString(R.string.scan_passport_bottom))
        } else {
            cameraXLiveData.setStatusText(resources.getString(R.string.scan_id_top_text))
            cameraXLiveData.setBottomText(resources.getString(R.string.scan_id_bottom))
        }
    }

    fun processTextFromBitmap(bitmap: Bitmap?) {
        textRecognizer
            .process(InputImage.fromBitmap(bitmap!!, 0))
            .addOnSuccessListener { text1: Text ->
                val blocks = text1.textBlocks
                readPassportData(blocks)
                val text = text1.text
                readTextFromString(text)
            }.addOnFailureListener { cameraXLiveData.setIsSuccess(false) }
            .addOnCompleteListener {
                try {
                    if (cameraXLiveData.getIsSuccess().value == false) {
                        cameraXLiveData.setCloseImageProxy(
                            true,
                        )
                    }
                } catch (e: Exception) {
                    cameraXLiveData.setCloseImageProxy(true)
                }
            }
    }

    private fun readPassportData(blocks: List<TextBlock>) {
        if (Objects.requireNonNull<String?>(cameraXLiveData.getSelectedDoc().value).equals(
                getApplication<Application>().getString(R.string.e_passport),
                ignoreCase = true,
            )
        ) {
            for (i in blocks.indices) {
                val lines = blocks[i].lines
                for (j in lines.indices) {
                    val elements = lines[j].elements
                    for (k in elements.indices) {
                        if (elements[k].text.length > 30) {
                            try {
                                val countrySubstring =
                                    elements[k].text.substring(
                                        10,
                                        13,
                                    ) // Adjust the indices based on the actual MRZ format
                                val newCountryCode =
                                    countrySubstring.replace(
                                        "0",
                                        "O",
                                    ) // Replace with the desired new country code
                                var modifiedMRZText =
                                    elements[k].text.replace(countrySubstring, newCountryCode)
                                modifiedMRZText = modifiedMRZText.replace("«", "<")
                                val patternPassportTD3Line2 =
                                    Pattern.compile(PASSPORT_TD_3_LINE_2_REGEX)
                                val patternPassportTD3Line1 =
                                    Pattern.compile(PASSPORT_TD_3_LINE_1_REGEX)
                                val matcherPassportTD3Line2 =
                                    patternPassportTD3Line2.matcher(modifiedMRZText)
                                val matcherPassportTD3Line1 =
                                    patternPassportTD3Line1.matcher(modifiedMRZText)
                                if (matcherPassportTD3Line2.find() && passportMRZ.isEmpty()) {
                                    passportMRZ = elements[k].text
                                    Utility.getInstance().mrzLine2 = passportMRZ.replace("«", "<")
                                }
                                if (matcherPassportTD3Line1.matches() && name.isEmpty()) {
                                    val latest = removeKValueFromString(modifiedMRZText)
                                    Utility.getInstance().mrzLine1 = latest
                                    name = latest.substring(5, latest.length - 1).replace("<", " ")
                                    Utility.getInstance().name = name.trim { it <= ' ' }
                                    Utility.getInstance().country = latest.substring(2, 5)
                                    Utility.getInstance().documentType = latest.substring(0, 1)
                                }
                            } catch (e: Exception) {
                                e.printStackTrace()
                            }
                        }
                    }
                }
            }
        }
    }

    private fun readTextFromString(text: String) {
        try {
            val textAll = text.split("\n".toRegex()).dropLastWhile { it.isEmpty() }.toTypedArray()
            if (Objects.requireNonNull(cameraXLiveData.getSelectedDoc().value).equals(
                    getApplication<Application>().getString(R.string.e_passport),
                    ignoreCase = true,
                )
            ) {
                readAllDetailOfPassport()
            } else {
                if (cameraXLiveData.getIsFrontView().value == false) {
                    readIdCardFrontView(text)
                } else {
                    readIdCardBackView(textAll)
                }
            }
        } catch (e: Exception) {
            e.printStackTrace()
            cameraXLiveData.setIsSuccess(false)
            //            isSuccess = false;
        }
    }

    private fun readIdCardFrontView(originalText: String) {
        var text = originalText
        text = text.replace(" ", "").uppercase(Locale.getDefault())
        text = text.replace("\n", " ").uppercase(Locale.getDefault())
        if (text.contains("SULTANATEOFOMAN") && (text.contains("IDENTITY CARD") || text.contains("RESIDENT CARD"))) {
            cameraXLiveData.setIdNo(null)
            cameraXLiveData.setDOB(null)
            cameraXLiveData.setExpiryDate(null)
            cameraXLiveData.setIsFrontView(true)
            cameraXLiveData.setIdLine1(true)
            cameraXLiveData.setIdLine2(true)
            cameraXLiveData.setCaptureAnImage(true)
            cameraXLiveData.setIsSuccess(true)
        } else {
            cameraXLiveData.setIsSuccess(false)
        }
        cameraXLiveData.setCTimer(false)
    }

    private fun readIdCardBackView(textAll: Array<String>) {
        var gender = ""
        val pattern1 = Pattern.compile(ID_CARD_REGEX1)
        val pattern2 = Pattern.compile(ID_CARD_REGEX2)
        val pattern3 = Pattern.compile(ID_CARD_REGEX3)
        // reading text 'ROYAL OMAN POLICE D.G. OF CIVIL STATUS'
        if (cameraXLiveData.getAlgoHeaderDetect().value == false) {
            if (isSimilarEnough(java.lang.String.join(" ", *textAll))) {
                cameraXLiveData.setAlgoHeaderDetect(true)
            }
        }
        //        after reading text 'ROYAL OMAN POLICE D.G. OF CIVIL STATUS' successfully, allow to read MRZ value
        if (cameraXLiveData.getAlgoHeaderDetect().value == true) {
            if (cameraXLiveData.getIdLine1().value == true || cameraXLiveData.getIdLine2().value == true || cameraXLiveData.getIdLine3().value == true) {
                for (data in textAll) {
                    var updatedString = StringBuilder(data.replace(" ", ""))
                    val removeKString = removeKValueFromString(updatedString.toString())
                    updatedString = StringBuilder(removeKString.replace("«", "<"))
                    val matcher3 = pattern3.matcher(updatedString.toString())
                    val name = StringBuilder(data.replace("NAME ", "").replace(" ", "<"))

                    // reading person name MRZ
                    if (matcher3.matches() && cameraXLiveData.getIdLine3().value == true) {
                        Utility.getInstance().name =
                            updatedString
                                .toString()
                                .replace("<", " ")
                                .replace("«", " ")
                                .trim { it <= ' ' }
                        val length = 30 - name.length
                        for (i in 0 until length) {
                            name.append("<")
                        }
                        val updatedName = removeKValueFromString(name.toString())
                        Utility.getInstance().mrzLine3 = updatedName.replace("«", "<")
                        cameraXLiveData.setIdLine3(false)
                    }
                    val index = updatedString.indexOf("MN")
                    var replacedString = updatedString.toString()
                    // Replace the 0 with O if MRZ contain MN(OMN) string
                    if (index > 1 && updatedString[index - 1] == '0') {
                        val firstPart =
                            updatedString.substring(
                                0,
                                index - 1,
                            ) // Exclude the character before "MN"
                        var secondPart =
                            updatedString.substring(index - 1) // Include "MN" and the rest of the string
                        if (secondPart.startsWith("0")) {
                            secondPart = secondPart.replace("0", "O") // Replace "O0" with "00"
                        }
                        replacedString =
                            firstPart + secondPart // Concatenate the two parts back together
                    }
                    // replace the text at last position of string if last letter is char instead of digit
                    val lastChar = replacedString[replacedString.length - 1]
                    if (Character.isLetter(lastChar)) {
                        if (lastChar == 'O' || lastChar == 'o') {
                            replacedString =
                                replacedString.substring(0, replacedString.length - 1) + '0'
                        }
                    }
                    if (replacedString.length >= 25) {
                        replacedString = addCharactersToReachLength(replacedString, 30)
                    }
                    val matcher2 = pattern2.matcher(cleanString(replacedString))
                    var matcherString: String? = updatedString.toString()
                    if (updatedString.length > 15) {
                        matcherString = updatedString.substring(0, 15)
                    }

                    // Reading the MRZ1 line
                    val matcher1 = pattern1.matcher(matcherString.toString())
                    if (matcher1.matches() && cameraXLiveData.getIdLine1().value == true) {
                        val length = 30 - updatedString.length
                        for (i in 0 until length) {
                            updatedString.append("<")
                        }
                        Utility.getInstance().mrzLine1 = updatedString.toString()
                        cameraXLiveData.setIdNo(
                            replaceAlfaWithNumber(
                                Objects.requireNonNull(
                                    matcher1.group(3),
                                ),
                            ),
                        )
                        val country =
                            replaceNumberWithAlfa(Objects.requireNonNull(matcher1.group(2)))
                        Utility.getInstance().country = country
                        Utility.getInstance().documentType = matcher1.group(1)
                        cameraXLiveData.setIdLine1(false)
                    }
                    // Reading MRZLine 2
                    if (replacedString.length == 30 && matcher2.matches() && cameraXLiveData.getIdLine2().value == true) {
                        updatedString = StringBuilder(cleanString(replacedString))
                        Utility.getInstance().mrzLine2 = updatedString.toString()
                        cameraXLiveData.setDOB(matcher2.group(1))
                        cameraXLiveData.setExpiryDate(matcher2.group(4))
                        gender = matcher2.group(3)?.toString() ?: ""
                        val nationality = matcher2.group(6)
                        Utility.getInstance().nationality = nationality
                        cameraXLiveData.setIdLine2(false)
                    }
                    if (cameraXLiveData.getIdLine1().value == false && cameraXLiveData.getIdLine2().value == false && cameraXLiveData.getIdLine3().value == false) {
                        break
                    }
                }
            }
        }
        //        will call this line when successfully read all MRZLines
        if (Utility.getInstance().mrzLine1 != null && Utility.getInstance().mrzLine2 != null && Utility.getInstance().mrzLine3 != null) {
            if (cameraXLiveData.getIsFrontViewScanned().value == false) {
                cameraXLiveData.setIdNo(null)
                cameraXLiveData.setDOB(null)
                cameraXLiveData.setExpiryDate(null)
                cameraXLiveData.setIdLine1(true)
                cameraXLiveData.setIdLine2(true)
                cameraXLiveData.setIdLine3(true)
                cameraXLiveData.setIsSuccess(false)
                //                isSuccess = false;
            } else if (cameraXLiveData.getExpiryDate().value != null && cameraXLiveData.getExpiryDate().value!!.isNotEmpty()
            ) {
                if (cameraXLiveData.getIsFrontViewScanned().value == true &&
                    Objects
                        .requireNonNull<String?>(
                            cameraXLiveData.getIdNo().value,
                        ).isNotEmpty() &&
                    Objects
                        .requireNonNull<String?>(
                            cameraXLiveData.dOB.value,
                        ).isNotEmpty()
                ) {
                    val documentNumber = cameraXLiveData.getIdNo().value
                    val dateOfBirthDay = cameraXLiveData.dOB.value
                    val expiryDate = cameraXLiveData.getExpiryDate().value
                    try {
                        if (expiryDate!!.isNotEmpty()) {
                            scanDocument.docuemntNo = documentNumber
                            scanDocument.dateOfBirth = dateOfBirthDay
                            scanDocument.expiryDate = expiryDate
                            Utility.getInstance().passportNumber = documentNumber
                            Utility.getInstance().dateOfBirth = dateOfBirthDay
                            Utility.getInstance().expiryDate = expiryDate
                            Utility.getInstance().gender = gender
                            cameraXLiveData.setFlag(false)
                            cameraXLiveData.setCloseAnalysisUseCase(true)
                            cameraXLiveData.setIsSuccess(true)
                            cameraXLiveData.setCTimer(true)
                            cameraXLiveData.setCaptureAnImage(true)
                        } else {
                            cameraXLiveData.setIsSuccess(false)
                        }
                    } catch (e: Exception) {
                        e.printStackTrace()
                        cameraXLiveData.setIsSuccess(false)
                    }
                } else {
                    cameraXLiveData.setIsSuccess(false)
                }
            } else {
                cameraXLiveData.setIsSuccess(false)
            }
        } else {
            cameraXLiveData.setIsSuccess(false)
        }
    }

    private fun readAllDetailOfPassport() =
        if (passportMRZ.isNotEmpty() && name.isNotEmpty()) {
            val line = passportMRZ
            var documentNumber = line.substring(0, 9)
            var nationality = line.substring(10, 13)
            var dateOfBirthDay = line.substring(13, 19)
            var gender = line.substring(20, 21)
            cameraXLiveData.setExpiryDate(line.substring(21, 27))
            nationality = replaceNumberWithAlfa(nationality)
            dateOfBirthDay = replaceAlfaWithNumber(dateOfBirthDay)
            gender = replaceNumberWithAlfa(gender)
            cameraXLiveData.setExpiryDate(
                replaceAlfaWithNumber(
                    cameraXLiveData.getExpiryDate().value.toString(),
                ),
            )
            documentNumber = documentNumber.replace("O", "0")
            if (documentNumber.isNotEmpty() &&
                dateOfBirthDay.isNotEmpty() &&
                cameraXLiveData.getExpiryDate().value!!.isNotEmpty() &&
                nationality.isNotEmpty() &&
                gender.isNotEmpty()
            ) {
                scanDocument.docuemntNo = documentNumber
                scanDocument.dateOfBirth = dateOfBirthDay
                scanDocument.expiryDate = cameraXLiveData.getExpiryDate().value
                Utility.getInstance().passportNumber = documentNumber
                Utility.getInstance().dateOfBirth = dateOfBirthDay
                Utility.getInstance().expiryDate = cameraXLiveData.getExpiryDate().value
                Utility.getInstance().nationality = nationality
                Utility.getInstance().gender = gender
                cameraXLiveData.setFlag(false)
                cameraXLiveData.setCloseAnalysisUseCase(true)
                cameraXLiveData.setIsSuccess(true)
                cameraXLiveData.setCaptureAnImage(true)
            } else {
                cameraXLiveData.setIsSuccess(false)
            }
        } else {
            cameraXLiveData.setIsSuccess(false)
        }

    private fun removeKValueFromString(modifiedMRZText: String): String {
        val latest = StringBuilder()
        for (l in modifiedMRZText.indices) {
            if (l != 0) {
                if (modifiedMRZText[l] == 'K') {
                    if (l == modifiedMRZText.length - 1) {
                        if (modifiedMRZText[l] != 'K') {
                            latest.append(modifiedMRZText[l])
                        }
                    } else {
                        if (modifiedMRZText[l - 1] != '<' &&
                            modifiedMRZText[l + 1] != '<'
                        ) {
                            latest.append(modifiedMRZText[l])
                        } else {
                            if (modifiedMRZText[l - 1] != '<' || modifiedMRZText[l + 1] != '<') {
                                latest.append(modifiedMRZText[l])
                            }
                        }
                    }
                } else {
                    latest.append(modifiedMRZText[l])
                }
            } else {
                latest.append(modifiedMRZText[l])
            }
        }
        return latest.toString().replace("\\bK+\\b".toRegex(), "")
    }

    private fun addCharactersToReachLength(
        input: String,
        desiredLength: Int,
    ): String {
        if (input.length >= desiredLength) {
            return input
        }
        val lastChar = input[input.length - 1]
        if (Character.isDigit(lastChar)) {
            val additionalChars = desiredLength - input.length
            val sb = StringBuilder(input)
            for (i in 0 until additionalChars) {
                sb.insert(sb.length - 1, '<')
            }
            return sb.toString()
        }
        return input
    }

    fun printCurrentTimeInLogs(): String {
        // Get the current time
        val sdf = SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault())
        val currentTime = sdf.format(Date())

        // Log the current time
        Log.d(CameraXLivePreviewViewModel::class.java.name, "Current Time: $currentTime")
        return currentTime
    }

    fun handleAnimationCompleted(activity: Activity) {
        cameraXLiveData.setCTimer(true)
        Utility.getInstance().selectedDoc = cameraXLiveData.getSelectedDoc().value
        val fullBitmap =
            BitmapFactory.decodeByteArray(
                Utility.getInstance().scannedImage,
                0,
                Utility.getInstance().scannedImage?.size ?: 0,
            )
        if (fullBitmap != null) {
            detectAndCropFace(
                activity,
                fullBitmap,
                object : OnImageProcessedListener {
                    override fun onImageProcessed(croppedBitmap: Bitmap?) {
                        instance.scanPhoto = croppedBitmap
                        if (OtherConstant.getInstance().appName.equals(
                                activity.getString(R.string.overify),
                                ignoreCase = true,
                            )
                        ) {
                            callFeatureCheck(activity)
                        } else {
                            if (SharePreferenceUtility.getSavePreferenceData(
                                    activity,
                                    activity.getString(R.string.sharepreference_nfc),
                                )
                            ) {
                                val intent = Intent(activity, WaitingForNfcActivity::class.java)
                                intent.putExtra(
                                    activity.resources.getString(R.string.doc_key),
                                    cameraXLiveData.getSelectedDoc().value,
                                )
                                activity.startActivity(intent)
                                activity.finish()
                            } else {
                                openLivenessScreen(activity)
                            }
                        }
                    }
                },
            )
        }
    }

    private fun callFeatureCheck(activity: Activity) {
        cameraXLiveData.setUpdateCustomLoader(true)
        val featureCheckApi = FeatureCheckApi()
        featureCheckApi.callFeatureCheck(
            object : FeatureCheckCallback {
                override fun onFeatureCheckSuccess(features: ArrayList<String>) {
                    if (features.contains("NFC")) {
                        SharePreferenceUtility.savePreferenceValue(
                            activity,
                            activity.getString(R.string.sharepreference_nfc),
                            true,
                        )
                        val intent = Intent(activity, WaitingForNfcActivity::class.java)
                        intent.putExtra(
                            activity.resources.getString(R.string.doc_key),
                            cameraXLiveData.getSelectedDoc().value,
                        )
                        activity.startActivity(intent)
                        activity.finish()
                    } else if (features.contains("Liveness") || features.contains("Face-Match")) {
                        SharePreferenceUtility.savePreferenceValue(
                            activity.applicationContext,
                            activity.getString(R.string.sharepreference_nfc),
                            false,
                        )
                        SharePreferenceUtility.savePreferenceValue(
                            activity.applicationContext,
                            activity.getString(R.string.sharepreference_facila_matching),
                            true,
                        )
                        openLivenessScreen(activity)
                    } else {
                        requestPermissionAndLocation(
                            (activity as FragmentActivity),
                            object : PermissionAndLocationHelper.ResultCallback {
                                override fun onResult(
                                    latitude: Double,
                                    longitude: Double,
                                    address: String,
                                ) {
                                    callResultCallback(
                                        activity,
                                        latitude,
                                        longitude,
                                        address,
                                    )
                                }
                            },
                        )
                    }
                }

                override fun onFeatureCheckFailure(errorMessage: String) {
                    activity.finish()
                }
            },
        )
    }

    private fun detectAndCropFace(
        activity: Activity,
        bitmap: Bitmap,
        listener: OnImageProcessedListener?,
    ) {
        val failureBitmap =
            BitmapFactory.decodeResource(activity.resources, R.drawable.face_not_found)
        val faceDetector = FaceDetector()
        val assetManager = activity.assets
        val loadResult = faceDetector.loadModel(assetManager)
        if (loadResult != 0) {
            Log.e("FaceDetector", "Failed to load model")
        }
        val detectedIdFace = FaceDetectionUtil.cropFaceFromIDCard(bitmap)
        if (detectedIdFace != null) {
            listener?.onImageProcessed(detectedIdFace)
        } else {
            listener?.onImageProcessed(failureBitmap)
            Log.d("FaceDetector", "No faces detected")
        }
    }

    private fun callResultCallback(
        activity: Activity,
        latitude: Double,
        longitude: Double,
        address: String,
    ) {
        AMLAutoCrop.setListner {
            SharePreferenceUtility.savePreferenceValue(
                activity.applicationContext,
                activity.getString(R.string.sharepreference_nfc),
                false,
            )
            SharePreferenceUtility.savePreferenceValue(
                activity.applicationContext,
                activity.getString(R.string.sharepreference_facila_matching),
                false,
            )
            val jsonObject = Result.setResultData(activity, false, false, true)
            val location = JSONObject()
            try {
                location.put(activity.getString(R.string.location_lat), latitude)
                location.put(activity.getString(R.string.location_longi), longitude)
                location.put(activity.getString(R.string.location_name), address)
                jsonObject?.put(activity.getString(R.string.locationjson_title), location)
            } catch (e: JSONException) {
                e.printStackTrace()
            }
            Log.d(CameraXLivePreviewViewModel::class.java.name, "callAMLCrop:camerax $jsonObject")
            if (jsonObject != null) {
                val callCompanyScanAPI = CallCompanyScanAPI()
                callCompanyScanAPI.uploadAllImages(
                    activity,
                    jsonObject,
                    Objects.requireNonNull<String?>(
                        cameraXLiveData.getSelectedDoc().value,
                    ),
                    1,
                    object : CompleteCallingCompanyScanListner {
                        override fun onFailure() {
                            if (NashidSDK.getInstance().getResultListener() != null) {
                                NashidSDK.getInstance().getResultListener()!!.onFailure()
                            }
                            activity.finish()
                        }

                        override fun onSuccess() {
                            if (NashidSDK.getInstance().getResultListener() != null) {
                                NashidSDK
                                    .getInstance()
                                    .getResultListener()!!
                                    .onResultData(
                                        jsonObject,
                                        cameraXLiveData.getSelectedDoc().value,
                                    )
                            }
                            activity.finish()
                        }
                    },
                )
            } else {
                if (NashidSDK.getInstance().getResultListener() != null) {
                    NashidSDK.getInstance().getResultListener()!!.onFailure()
                }
                activity.finish()
            }
        }
        AMLAutoCrop.callAML(
            Utility.getInstance().name,
            Utility.getInstance().dateOfBirth,
            Utility.getInstance().nationality,
            Utility.getInstance().passportNumber,
            Utility.getInstance().country,
        )
        AMLAutoCrop.callAutoCropAPI(activity)
    }

    private fun openLivenessScreen(activity: Activity) {
        cameraXLiveData.setUnbindCameraProvider(true)
        Utility.getInstance().selectedDoc = cameraXLiveData.getSelectedDoc().value
        validateLivenessUser(activity)
    }

    private fun validateLivenessUser(activity: Activity) {
        APIClient
            .getClient("validationKey", OtherConstant.getInstance().mainBaseUrl)
            .create(
                APIInterface::class.java,
            ).validateKey(activity.resources.getString(R.string.liveness_action))
            .enqueue(
                object : Callback<ValidationResponse?> {
                    override fun onResponse(
                        call: Call<ValidationResponse?>,
                        response: Response<ValidationResponse?>,
                    ) {
                        if (response.code() != 200) {
                            val i = Intent(activity, SelectDocumentActivity::class.java)
                            i.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_CLEAR_TASK
                            activity.startActivity(i)
                        } else {
                            val intent = Intent(activity, SkipNFCLivenessActivity::class.java)
                            intent.putExtra(
                                activity.resources.getString(R.string.doc_key),
                                cameraXLiveData.getSelectedDoc().value,
                            )
                            activity.startActivity(intent)
                            activity.finish()
                        }
                    }

                    override fun onFailure(
                        call: Call<ValidationResponse?>,
                        t: Throwable,
                    ) {
                    }
                },
            )
    }

    val processCameraProvider: LiveData<ProcessCameraProvider>
        get() {
            if (cameraProviderLiveData == null) {
                cameraProviderLiveData = MutableLiveData()
                val cameraProviderFuture = ProcessCameraProvider.getInstance(getApplication())
                cameraProviderFuture.addListener(
                    {
                        try {
                            cameraProviderLiveData!!.setValue(cameraProviderFuture.get())
                        } catch (e: ExecutionException) {
                            // Handle any errors (including cancellation) here.
//              Log.e(TAG, "Unhandled exception", e);
                        } catch (e: InterruptedException) {
                            e.printStackTrace()
                        }
                    },
                    ContextCompat.getMainExecutor(getApplication()),
                )
            }
            return cameraProviderLiveData!!
        }

    internal interface OnImageProcessedListener {
        fun onImageProcessed(croppedBitmap: Bitmap?)
    }
}
