package com.kyc.nashidmrz.mrtd2.helpers

class GeneralHelper {
    companion object {
        fun fuzzyMapping(
            a: String,
            b: String,
        ): Int {
            val dp = Array(a.length + 1) { IntArray(b.length + 1) }

            for (i in 0..a.length) {
                for (j in 0..b.length) {
                    when {
                        i == 0 -> dp[i][j] = j
                        j == 0 -> dp[i][j] = i
                        else -> {
                            dp[i][j] =
                                minOf(
                                    dp[i - 1][j] + 1,
                                    dp[i][j - 1] + 1,
                                    dp[i - 1][j - 1] + if (a[i - 1] == b[j - 1]) 0 else 1,
                                )
                        }
                    }
                }
            }
            return dp[a.length][b.length]
        }
    }
}
