package com.kyc.nashidmrz.mrtd2.locale

import android.content.Context
import com.kyc.nashidmrz.utility.SharePreferenceUtility
import java.util.Locale

object LocaleHelper {
    private const val PREF_LOCALE = "pref_locale"

    fun onAttach(context: Context): Context {
        val locale = getPersistedLocale(context)
        return setLocale(context, locale)
    }

    fun getPersistedLocale(context: Context): String {
        return SharePreferenceUtility.getLocalSavePreferenceData(context)
//        val preferences = PreferenceManager.getDefaultSharedPreferences(context)
//        return preferences.getString(PREF_LOCALE, "") ?: ""
    }

    fun setLocale(
        context: Context,
        localeSpec: String,
    ): Context {
        val locale =
            if (localeSpec.isEmpty()) {
                getDefaultLocale()
            } else {
                Locale(localeSpec)
            }
        Locale.setDefault(locale)
        return updateResources(context, locale)
    }

    private fun getDefaultLocale(): Locale {
        // Set your default locale here
        return Locale.getDefault()
    }

    private fun updateResources(
        context: Context,
        locale: Locale,
    ): Context {
        val configuration = context.resources.configuration
        configuration.setLocale(locale)
        return context.createConfigurationContext(configuration)
    }

    fun persistLocale(
        context: Context,
        locale: String,
    ) {
        SharePreferenceUtility.saveLocalPreferenceValue(context, locale)
//        val preferences = PreferenceManager.getDefaultSharedPreferences(context)
//        preferences.edit().putString(PREF_LOCALE, locale).apply()
    }
}
