package com.kyc.nashidmrz.mrtd2.resultcallback;


import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.util.Log;

import com.kyc.nashidmrz.Constant;
import com.kyc.nashidmrz.LivenessData;
import com.kyc.nashidmrz.OtherConstant;
import com.kyc.nashidmrz.R;
import com.kyc.nashidmrz.Utility;
import com.kyc.nashidmrz.id_card.omn.OmanCardDG10File;
import com.kyc.nashidmrz.id_card.omn.OmanCardDG11File;
import com.kyc.nashidmrz.id_card.omn.OmanCardDG13File;
import com.kyc.nashidmrz.id_card.omn.OmanCardDG1File;
import com.kyc.nashidmrz.id_card.omn.OmanCardDG4File;
import com.kyc.nashidmrz.id_card.omn.OmanCardDG6File;
import com.kyc.nashidmrz.mrtd2.passportutils.AdditionalDGFiles;
import com.kyc.nashidmrz.mrtd2.passportutils.AdditionalPersonDetails;
import com.kyc.nashidmrz.mrtd2.passportutils.EDocument;
import com.kyc.nashidmrz.mrtd2.passportutils.PersonDetails;
import com.kyc.nashidmrz.mrtd2.resultcallback.callbackclass.DocumentImages;
import com.kyc.nashidmrz.utility.NFCDialogUtility;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.ByteArrayOutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Result {

    public static JSONObject setResultData(Activity activity, boolean isNfc, boolean isLiveness, boolean isFlowCompleted) {
        if (OtherConstant.getInstance().getAppName().equalsIgnoreCase(activity.getString(R.string.overify))) {
//            Log.d("TAG", "setResultData: " + isNfc + "  " + isLiveness);
            NFCDialogUtility dialogUtility = new NFCDialogUtility();
            int isNFCAvailable = dialogUtility.isNFCAvailable(activity);
            try {
                JSONObject scan = new JSONObject();
                JSONObject jsonObject = new JSONObject();
                try {

                    if (Utility.Companion.getInstance().getSelectedDoc().equalsIgnoreCase(activity.getString(R.string.e_passport))) {
                        scan.put(activity.getString(R.string.pass_result_doctype), Utility.Companion.getInstance().getDocumentType());
                        scan.put(activity.getString(R.string.pass_result_document_no), Utility.Companion.getInstance().getPassportNumber().replace("<", ""));
                        scan.put(activity.getString(R.string.pass_result_date_birth), formateDateFromstring("yyMMdd", Constant.DATEFORMATE, Utility.Companion.getInstance().getDateOfBirth()));
                        scan.put(activity.getString(R.string.pass_result_date_expirt), formateDateFromstring("yyMMdd", Constant.DATEFORMATE, Utility.Companion.getInstance().getExpiryDate()));

                        scan.put(activity.getString(R.string.pass_result_name), Utility.Companion.getInstance().getName());
                        scan.put(activity.getString(R.string.pass_result_nationality), Utility.Companion.getInstance().getNationality());
                        scan.put(activity.getString(R.string.pass_result_coutry), Utility.Companion.getInstance().getCountry());
                        if (Utility.Companion.getInstance().getGender().equalsIgnoreCase("f")) {
                            scan.put(activity.getString(R.string.pass_result_gender), "Female");
                        } else {
                            scan.put(activity.getString(R.string.pass_result_gender), "Male");
                        }
                        scan.put(activity.getString(R.string.pass_result_mrz), Utility.Companion.getInstance().getMrzLine1() + "\n" + Utility.Companion.getInstance().getMrzLine2());
                    } else {
                        scan.put(activity.getString(R.string.result_doctype), Utility.Companion.getInstance().getDocumentType());
                        scan.put(activity.getString(R.string.result_document_no), Utility.Companion.getInstance().getPassportNumber().replace("<", ""));
                        scan.put(activity.getString(R.string.result_date_birth), formateDateFromstring("yyMMdd", Constant.DATEFORMATE, Utility.Companion.getInstance().getDateOfBirth()));
                        scan.put(activity.getString(R.string.result_date_expirt), formateDateFromstring("yyMMdd", Constant.DATEFORMATE, Utility.Companion.getInstance().getExpiryDate()));

                        scan.put(activity.getString(R.string.result_name), Utility.Companion.getInstance().getName());
                        scan.put(activity.getString(R.string.result_nationality), Utility.Companion.getInstance().getNationality());
                        scan.put(activity.getString(R.string.result_coutry), Utility.Companion.getInstance().getCountry());
                        if (Utility.Companion.getInstance().getGender().equalsIgnoreCase("f")) {
                            scan.put(activity.getString(R.string.result_gender), "Female");
                        } else {
                            scan.put(activity.getString(R.string.result_gender), "Male");
                        }
                        scan.put(activity.getString(R.string.result_mrz), Utility.Companion.getInstance().getMrzLine1() + "\n" + Utility.Companion.getInstance().getMrzLine2() + "\n" + Utility.Companion.getInstance().getMrzLine3());
                    }
                    jsonObject.put("scan", scan);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                if (isNfc && !OtherConstant.getInstance().getSkipNFC()) {
                    JSONObject nfc = new JSONObject();

                    if (Utility.Companion.getInstance().getSelectedDoc().equalsIgnoreCase(activity.getString(R.string.e_passport))) {
                        EDocument eDocument = LivenessData.getInstance().geteDocument();
                        PersonDetails personDetails = eDocument.getPersonDetails();
                        AdditionalPersonDetails additionalPersonDetails = eDocument.getAdditionalPersonDetails();
                        AdditionalDGFiles additionalDGFiles = eDocument.getAdditionalDGFiles();
                        String emptyString = "";
                        try {
                            nfc.put(activity.getString(R.string.passdocumentType), eDocument.getDocType().name());
                            nfc.put(activity.getString(R.string.passdocumentNumber), personDetails.getSerialNumber());
                            nfc.put(activity.getString(R.string.passissuingAuthority), personDetails.getIssuerAuthority());
                            nfc.put(activity.getString(R.string.passdateOfBirth), personDetails.getBirthDate());
                            nfc.put(activity.getString(R.string.passgender), personDetails.getGender());
                            nfc.put(activity.getString(R.string.passdocumentExpiryDate), personDetails.getExpiryDate());
                            nfc.put(activity.getString(R.string.passfullName), additionalPersonDetails.getNameOfHolder().replace("null ", ""));
                            nfc.put(activity.getString(R.string.passpersonalNumber), personDetails.getPersonalNumber());

                            if (additionalPersonDetails.getPlaceOfBirth() != null)
                                nfc.put(activity.getString(R.string.passplaceOfBirth), additionalPersonDetails.getPlaceOfBirth().get(0));
                            else
                                nfc.put(activity.getString(R.string.passplaceOfBirth), emptyString);

                            if (additionalPersonDetails.getPermanentAddress() != null)
                                nfc.put(activity.getString(R.string.passaddress), additionalPersonDetails.getPermanentAddress().get(0));
                            else
                                nfc.put(activity.getString(R.string.passaddress), emptyString);

                            if (!OtherConstant.getInstance().getAppName().equalsIgnoreCase(activity.getString(R.string.overify))) {
                                nfc.put(activity.getString(R.string.passprofession), additionalPersonDetails.getProfession());
                                nfc.put(activity.getString(R.string.passtitle), additionalPersonDetails.getTitle());
                                nfc.put(activity.getString(R.string.passpersonalSummary), additionalPersonDetails.getPersonalSummary());

                                if (additionalPersonDetails.getOtherValidTDNumbers() != null)
                                    nfc.put(activity.getString(R.string.passtdNumbers), additionalPersonDetails.getOtherValidTDNumbers().get(0));
                                else
                                    nfc.put(activity.getString(R.string.passtdNumbers), emptyString);

                                nfc.put(activity.getString(R.string.passcustodyInfo), additionalPersonDetails.getCustodyInformation());

                                if (additionalPersonDetails.getProofOfCitizenship() != null)
                                    nfc.put(activity.getString(R.string.passproofOfCitizenship), additionalPersonDetails.getProofOfCitizenship().toString());
                                else
                                    nfc.put(activity.getString(R.string.passproofOfCitizenship), emptyString);
                            }
                            nfc.put(activity.getString(R.string.passtelephone), additionalPersonDetails.getTelephone());
                            nfc.put(activity.getString(R.string.passnfcissuingCountry), additionalDGFiles.getIssueingAuthority());
                            if (!OtherConstant.getInstance().getAppName().equalsIgnoreCase(activity.getString(R.string.overify))) {
                                if (additionalDGFiles.getFrontImage() != null)
                                    nfc.put(activity.getString(R.string.passfrontImage), additionalDGFiles.getFrontImage().toString());
                                else
                                    nfc.put(activity.getString(R.string.passfrontImage), emptyString);
                                if (additionalDGFiles.getBackImage() != null)
                                    nfc.put(activity.getString(R.string.passrearImage), additionalDGFiles.getBackImage().toString());
                                else
                                    nfc.put(activity.getString(R.string.passrearImage), emptyString);

                                if (additionalDGFiles.getSecurityInfos() != null) {
                                    nfc.put(activity.getString(R.string.passsecurityInfos), additionalDGFiles.getSecurityInfos());
                                } else
                                    nfc.put(activity.getString(R.string.passsecurityInfos), emptyString);
                            }
                            jsonObject.put("nfc", nfc);
                        } catch (JSONException e) {

                        }
                    } else {
                        String dateFormate = "yyyyMMdd";
                        try {
                            OmanCardDG1File dg1Parser = new OmanCardDG1File(Utility.Companion.getInstance().getDgFile1());
                            OmanCardDG4File dg4Parser = new OmanCardDG4File(Utility.Companion.getInstance().getDgFile4());
                            OmanCardDG6File dg6Parser = new OmanCardDG6File(Utility.Companion.getInstance().getDgFile6());
                            nfc.put(activity.getString(R.string.result_idcardidNumber), dg1Parser.getIdNumber());
                            nfc.put(activity.getString(R.string.result_idcardissueDate), formateDateFromstring(dateFormate, Constant.DATEFORMATE, dg1Parser.getIssueDate()));
                            nfc.put(activity.getString(R.string.result_idcardexpiryDate), formateDateFromstring(dateFormate, Constant.DATEFORMATE, dg1Parser.getExpiryDate()));
                            String placeofissue = dg1Parser.getPlaceOfIssueArabic();
//                            String placeofissue="\\u0068\\u0065\\u006C\\u006C\\u006F";
                            if (placeofissue.startsWith("\\u")) {
//                                placeofissue = OtherConstant.getInstance().getEncodedString("\\u0068\\u0065\\u006C\\u006C\\u006F");
                                placeofissue = OtherConstant.getInstance().getEncodedString(dg1Parser.getPlaceOfIssueArabic());
                            }
                            Log.d("TAG", "setResultData:plaxc " + placeofissue + "  " + nfc);
                            nfc.put(activity.getString(R.string.result_idcardplaceOfIssueArabic), placeofissue);
                            Log.d("TAG", "setResultData:plaxc " + placeofissue + "  " + nfc);
                            nfc.put(activity.getString(R.string.result_idcardplaceOfIssueEnglish), dg1Parser.getPlaceOfIssueEnglish());
//            }
                            if (dg4Parser != null) {
                                String fullName = dg4Parser.getFullNameArabic();
                                if (fullName.startsWith("\\u")) {
                                    fullName = OtherConstant.getInstance().getEncodedString(dg4Parser.getFullNameArabic());
                                }
                                nfc.put(activity.getString(R.string.result_idcardfullNameArabic), fullName);
                                nfc.put(activity.getString(R.string.result_idcardfullNameEnglish), dg4Parser.getFullNameEnglish());
                            }
                            if (dg6Parser != null) {
                                nfc.put(activity.getString(R.string.result_idcarddateOfBirth), formateDateFromstring(dateFormate, Constant.DATEFORMATE, dg6Parser.getDateOfBirth()));
                                String countryOfBirthArabic = dg6Parser.getCountryOfBirthArabic();
                                if (countryOfBirthArabic.startsWith("\\u")) {
                                    countryOfBirthArabic = OtherConstant.getInstance().getEncodedString(dg6Parser.getCountryOfBirthArabic());
                                }
                                nfc.put(activity.getString(R.string.result_idcardcountryOfBirthArabic), countryOfBirthArabic);
                                String countryOfBirthEnglish = dg6Parser.getPlaceOfBirthEnglish();
                                if (countryOfBirthEnglish.startsWith("\\u")) {
                                    countryOfBirthEnglish = OtherConstant.getInstance().getEncodedString(dg6Parser.getPlaceOfBirthEnglish());
                                }
                                nfc.put(activity.getString(R.string.result_idcardplaceOfBirthEnglish), countryOfBirthEnglish);
                                String nationalty = dg6Parser.getNationalityArabic();
                                if (nationalty.startsWith("\\u")) {
                                    nationalty = OtherConstant.getInstance().getEncodedString(dg6Parser.getNationalityArabic());
                                }
                                nfc.put(activity.getString(R.string.result_idcardnationalityArabic), nationalty);
                                String gender = dg6Parser.getGenderArabic();
                                if (gender.startsWith("\\u")) {
                                    gender = OtherConstant.getInstance().getEncodedString(dg6Parser.getGenderArabic());
                                }
                                nfc.put(activity.getString(R.string.result_idcardgenderArabic), gender);

                                nfc.put(activity.getString(R.string.result_idcardnationalityEnglish), dg6Parser.getNationalityEnglish());
                                nfc.put(activity.getString(R.string.result_idcardgenderEnglish), dg6Parser.getGenderEnglish());
                            }
                            if (Utility.Companion.getInstance().getDgFile13() != null) {
                                OmanCardDG13File dg13Parser = new OmanCardDG13File(Utility.Companion.getInstance().getDgFile13());
                                if (dg13Parser != null) {
                                    nfc.put(activity.getString(R.string.result_idcardvisaNumber), dg13Parser.getSponsorNumber());
                                    nfc.put(activity.getString(R.string.result_idcardPermitType), dg13Parser.getSponsorRelationship());
                                }
                            }
                            if (Utility.Companion.getInstance().getDgFile10() != null) {
                                OmanCardDG10File dg10Parser = new OmanCardDG10File(Utility.Companion.getInstance().getDgFile10());
                                if (dg10Parser != null) {
                                    nfc.put(activity.getString(R.string.result_idcardvisaExpiryDate), formateDateFromstring(dateFormate, Constant.DATEFORMATE, dg10Parser.getVisaExpiryDate()));
                                    nfc.put(activity.getString(R.string.result_idcardvisaPlaceOfIssueArabic), dg10Parser.getVisaPlaceOfIssueArabic());

                                    nfc.put(activity.getString(R.string.result_idcardPermitNumber), dg10Parser.getVisaNumber());
                                }
                            }
                            if (Utility.Companion.getInstance().getDgFile13() != null) {
                                OmanCardDG13File dg13Parser = new OmanCardDG13File(Utility.Companion.getInstance().getDgFile13());
                                if (dg13Parser != null) {

                                    nfc.put(activity.getString(R.string.result_idcardsponsorIssueDate), formateDateFromstring(dateFormate, Constant.DATEFORMATE, dg13Parser.getSponsorIssueDate()));
                                    nfc.put(activity.getString(R.string.result_idcardsponsorExpiryDate), formateDateFromstring(dateFormate, Constant.DATEFORMATE, dg13Parser.getSponsorExpiryDate()));
                                }
                            }
                            if (Utility.Companion.getInstance().getDgFile11() != null) {
                                OmanCardDG11File dg11Parser = new OmanCardDG11File(Utility.Companion.getInstance().getDgFile11());
                                if (dg11Parser != null) {

                                    nfc.put(activity.getString(R.string.result_idcardcompanyNameArabic), dg11Parser.getCompanyNameArabic());
                                    nfc.put(activity.getString(R.string.result_idcardcompanyNameEnglish), dg11Parser.getCompanyNameEnglish());
                                    nfc.put(activity.getString(R.string.result_idcardcompanyAddressArabic), dg11Parser.getCompanyAddressArabic());
                                }
                            }
                            Log.d("TAG", "setResultData:plaxc " + nfc);
                            jsonObject.put("nfc", nfc);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                }
//                Log.d("TAG", "setResultData:liveness "+isLiveness);
                DocumentImages documentImages = DocumentImages.Companion.getInstance();
                Log.d("TAG", "setResultData:amldata " + documentImages.isAMLSucess());
                JSONObject aml = new JSONObject();

                aml.put("AML screening", documentImages.isAMLSucess());
                jsonObject.put("aml", aml);
                if (isLiveness) {
                    JSONObject liveness = new JSONObject();
                    try {
                        int matchValue = Utility.Companion.getInstance().getMatchPercentage();
                        if (matchValue >= 50) {
                            liveness.put("Liveness Confirmed", true);
                        } else {
                            liveness.put("Liveness Confirmed", false);
                        }

                        liveness.put("Match value", Utility.Companion.getInstance().getMatchPercentage() + " %");
                    } catch (Exception e) {

                    }
                    jsonObject.put("liveness", liveness);
                }
                try {
//                    DocumentImages documentImages = DocumentImages.Companion.getInstance();
                    JSONObject images = new JSONObject();
                    Bitmap bitmap = BitmapFactory.decodeByteArray(Utility.Companion.getInstance().getScannedImage(), 0, Utility.Companion.getInstance().getScannedImage().length);
                    images.put("before-crop-front", bitmap);
                    Log.d("TAG", "setResultData:before-crop-front " + bitmap.getWidth() + "   " + bitmap.getHeight());
                    Log.d("TAG", "setResultData: " + Utility.Companion.getInstance().getSelectedDoc());
                    if (!Utility.Companion.getInstance().getSelectedDoc().equals(activity.getString(R.string.e_passport))) {
                        bitmap = BitmapFactory.decodeByteArray(Utility.Companion.getInstance().getScannedIdFrontView(), 0, Utility.Companion.getInstance().getScannedIdFrontView().length);
                        images.put("before-crop-back", bitmap);
                    }

                    images.put("after-crop-front", documentImages.getFrontCropPage());
                    if (!Utility.Companion.getInstance().getSelectedDoc().equals(activity.getString(R.string.e_passport))) {
                        images.put("after-crop-back", documentImages.getBackCropPage());
                    }
                    if (isNfc && !OtherConstant.getInstance().getSkipNFC()) {
                        if (Utility.Companion.getInstance().getSelectedDoc().equalsIgnoreCase(activity.getString(R.string.e_passport))) {
                            EDocument eDocument = LivenessData.getInstance().geteDocument();
                            PersonDetails personDetails = eDocument.getPersonDetails();
                            images.put("nfc-image", personDetails.getFaceImage());
                            images.put("signature", personDetails.getSignature());
                        } else {
                            images.put("nfc-image", documentImages.getNfcPhoto());
                        }
                    }
                    images.put("scan-image", documentImages.getScanPhoto());
                    if (isLiveness) {
                        Bitmap liveImage = BitmapFactory.decodeByteArray(Utility.Companion.getInstance().getLivenessScannedImage(), 0, Utility.Companion.getInstance().getLivenessScannedImage().length);
                        Matrix matrix = new Matrix();
                        matrix.postRotate(270);
                        Bitmap rotatedBitmap = Bitmap.createBitmap(liveImage, 0, 0, liveImage.getWidth(), liveImage.getHeight(), matrix, true);
                        ByteArrayOutputStream liveImageByte = new ByteArrayOutputStream();
                        rotatedBitmap.compress(Bitmap.CompressFormat.JPEG, 100, liveImageByte);
                        images.put("liveness-image", rotatedBitmap);
                    }
                    jsonObject.put("images", images);
                    Log.d("TAG", "handleUploadFileData:result " + jsonObject);

                } catch (Exception e) {
                    e.printStackTrace();
                }
                if (isNFCAvailable == 2) {
                    jsonObject.put("nfc ", "Not Supported");
                } else {
                    jsonObject.put("nfc ", "Supported");
                }
//                jsonObject.put("verification time", getCurrentFormattedDateTime());
                if (!isFlowCompleted) {
                    jsonObject.put("process status", "Process not completed");
                }
                if (isFlowCompleted)
                    Utility.Companion.getInstance().cleanup();
//                Log.d("TAG", "setResultData: " + jsonObject);
               /* CallCompanyScanAPI callCompanyScanAPI = new CallCompanyScanAPI();
                callCompanyScanAPI.uploadAllImages(activity, jsonObject, selectedDoc,new CompleteCallingCompanyScanListner(){

                    @Override
                    public void onFailure() {

                    }

                    @Override
                    public void onSuccess() {

                    }
                });*/
                return jsonObject;

            } catch (Exception e) {
                e.printStackTrace();
//                Log.d("TAG", "setResultData: " + e);
                return null;
            }
        } else {
            return null;
        }
    }

    private static String formateDateFromstring(String inputFormat, String outputFormat, String inputDate) {
        try {
            DateFormat sdf = new SimpleDateFormat(inputFormat, Locale.ENGLISH);
            Date date = sdf.parse(inputDate);
            return new SimpleDateFormat(outputFormat, Locale.ENGLISH).format(date);
        } catch (Exception e) {
        }
        return inputDate;

    }
}
