package com.kyc.nashidmrz.mrtd2.resultcallback.callbackclass;

public class PassportNFCData {
    private String documentType;
    private String issueBy;
    private String documentNumber;
    private String expirtDate;
    private String gender;
    private String nationality;
    private String surname;
    private String givenName;
    private String dateOfBirth;
    private String issuerCountry;
    private String certificationAutority;
    private String issuerOrganization;
    private String organizationalUnit;
    private String signatureAlgorith;
    private String LEDHashAlgorithm;
    private String certificateValideFrom;
    private String certificateValideUntil;

    public String getDocumentType() {
        return documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public String getIssueBy() {
        return issueBy;
    }

    public void setIssueBy(String issueBy) {
        this.issueBy = issueBy;
    }

    public String getDocumentNumber() {
        return documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getExpirtDate() {
        return expirtDate;
    }

    public void setExpirtDate(String expirtDate) {
        this.expirtDate = expirtDate;
    }

    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getNationality() {
        return nationality;
    }

    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    public String getSurname() {
        return surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public String getGivenName() {
        return givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public String getDateOfBirth() {
        return dateOfBirth;
    }

    public void setDateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public String getIssuerCountry() {
        return issuerCountry;
    }

    public void setIssuerCountry(String issuerCountry) {
        this.issuerCountry = issuerCountry;
    }

    public String getCertificationAutority() {
        return certificationAutority;
    }

    public void setCertificationAutority(String certificationAutority) {
        this.certificationAutority = certificationAutority;
    }

    public String getIssuerOrganization() {
        return issuerOrganization;
    }

    public void setIssuerOrganization(String issuerOrganization) {
        this.issuerOrganization = issuerOrganization;
    }

    public String getOrganizationalUnit() {
        return organizationalUnit;
    }

    public void setOrganizationalUnit(String organizationalUnit) {
        this.organizationalUnit = organizationalUnit;
    }

    public String getSignatureAlgorith() {
        return signatureAlgorith;
    }

    public void setSignatureAlgorith(String signatureAlgorith) {
        this.signatureAlgorith = signatureAlgorith;
    }

    public String getLEDHashAlgorithm() {
        return LEDHashAlgorithm;
    }

    public void setLEDHashAlgorithm(String LEDHashAlgorithm) {
        this.LEDHashAlgorithm = LEDHashAlgorithm;
    }

    public String getCertificateValideFrom() {
        return certificateValideFrom;
    }

    public void setCertificateValideFrom(String certificateValideFrom) {
        this.certificateValideFrom = certificateValideFrom;
    }

    public String getCertificateValideUntil() {
        return certificateValideUntil;
    }

    public void setCertificateValideUntil(String certificateValideUntil) {
        this.certificateValideUntil = certificateValideUntil;
    }
    private static volatile PassportNFCData INSTANCE = null;
    public static PassportNFCData getInstance() {
        // Check if the instance is already created
        if(INSTANCE == null) {
            // synchronize the block to ensure only one thread can execute at a time
            synchronized (PassportNFCData.class) {
                // check again if the instance is already created
                if (INSTANCE == null) {
                    // create the singleton instance
                    INSTANCE = new PassportNFCData();
                }
            }
        }
        // return the singleton instance
        return INSTANCE;
    }

    @Override
    public String toString() {
        return "PassportNFCData{" +
                "documentType='" + documentType + '\'' +
                ", issueBy='" + issueBy + '\'' +
                ", documentNumber='" + documentNumber + '\'' +
                ", expirtDate='" + expirtDate + '\'' +
                ", gender='" + gender + '\'' +
                ", nationality='" + nationality + '\'' +
                ", surname='" + surname + '\'' +
                ", givenName='" + givenName + '\'' +
                ", dateOfBirth='" + dateOfBirth + '\'' +
                ", issuerCountry='" + issuerCountry + '\'' +
                ", certificationAutority='" + certificationAutority + '\'' +
                ", issuerOrganization='" + issuerOrganization + '\'' +
                ", organizationalUnit='" + organizationalUnit + '\'' +
                ", signatureAlgorith='" + signatureAlgorith + '\'' +
                ", LEDHashAlgorithm='" + LEDHashAlgorithm + '\'' +
                ", certificateValideFrom='" + certificateValideFrom + '\'' +
                ", certificateValideUntil='" + certificateValideUntil + '\'' +
                '}';
    }
}
