package com.kyc.nashidmrz.utility;

import android.util.Log;

import com.kyc.nashidmrz.NashidSDK;
import com.kyc.nashidmrz.networking.APIClient;
import com.kyc.nashidmrz.mrtd2.resultcallback.FeatureCheckCallback;
import com.kyc.nashidmrz.networking.APIInterface;
import com.kyc.nashidmrz.networking.models.featurecheck.FeatureCheck;

import java.util.ArrayList;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class FeatureCheckApi {


    public void callFeatureCheck(FeatureCheckCallback featureCheckCallback) {
        final ArrayList<String>[] strings = new ArrayList[]{new ArrayList<>()};
        /*strings[0]=NashidSDK.getFeatureList();
        Log.d("TAG", "callFeatureCheckIDC: "+strings[0]+"\n"+NashidSDK.getFeatureList());
        if (featureCheckCallback!=null){
            featureCheckCallback.onFeatureCheckSuccess(strings[0]);
        }
*/
//        strings[0] =NashidSDK.getFeatureList();
        if (!NashidSDK.getInstance().getBaseURL().equalsIgnoreCase("")&&!NashidSDK.getInstance().getRegisterToken().equalsIgnoreCase("")) {
            APIClient.getFeatureCheckClient(NashidSDK.getInstance().getBaseURL(), NashidSDK.getInstance().getRegisterToken()).create(APIInterface.class).callFeatureCheck(NashidSDK.getInstance().getCompanyUUID()).enqueue(new Callback<FeatureCheck>() {
                @Override
                public void onResponse(Call<FeatureCheck> call, Response<FeatureCheck> response) {
                    Log.d("TAG", "openScanDocumentScreen onResponse: " + response.isSuccessful() + "\n" + response.body());
                    try {
                        if (response.isSuccessful()) {
                            FeatureCheck featureCheck = response.body();
                            strings[0] = featureCheck.getData().getFeatures();
                            if (featureCheckCallback != null) {
                                featureCheckCallback.onFeatureCheckSuccess(strings[0]);
                            }
//                        Log.d("TAG", "openScanDocumentScreen onResponse: " + strings[0]);
//                    try {
//                        ResponseBody responseBody = response.body();
//                        if (responseBody != null) {
//                            String responseBodyString = responseBody.string();
//                            Log.d("TAG", "onResponse: " + responseBodyString);
//                            JSONObject jsonObject = new JSONObject(responseBodyString);
//                            // Handle the JSONObject
//                        } else {
//                            Log.d("TAG", "Response body is null");
//                        }
//                    } catch (IOException | JSONException e) {
//                        e.printStackTrace();
//                    }

                        } else {
//                        Log.d("TAG", "Response not successful. Code: " + response.code());
//                     Handle other response codes if needed
                            if (featureCheckCallback != null) {
                                featureCheckCallback.onFeatureCheckFailure("Fail");
                            }
                        }
                    }catch (Exception e){
                        if (featureCheckCallback != null) {
                            featureCheckCallback.onFeatureCheckFailure("Fail");
                        }
                    }
                }

                @Override
                public void onFailure(Call<FeatureCheck> call, Throwable t) {
//                    Log.d("TAG", "openScanDocumentScreen onFailure: " + t);
                    if (featureCheckCallback != null) {
                        featureCheckCallback.onFeatureCheckFailure("Fail");
                    }
                }

            });
        }
        else{
            if (featureCheckCallback != null) {
                featureCheckCallback.onFeatureCheckFailure("Fail");
            }
        }
    }
}
