package com.kyc.nashidmrz.utility

import androidx.fragment.app.FragmentActivity
import com.kyc.nashidmrz.locationdata.LocationHelper

internal object PermissionAndLocationHelper {
    interface ResultCallback {
        fun onResult(
            latitude: Double,
            longitude: Double,
            address: String,
        )
    }

    fun requestPermissionAndLocation(
        activity: FragmentActivity,
        callback: ResultCallback,
    ) {
        PermissionHelper.requestPermissions(
            activity,
            object : PermissionHelper.PermissionCallback {
                override fun onResult(
                    allGranted: Boolean,
                    grantedList: List<String>,
                    deniedList: List<String>,
                ) {
                    if (allGranted) {
                        val locationHelper = LocationHelper(activity)
                        locationHelper.getLastLocation(
                            object : LocationHelper.LocationCallback {
                                override fun onLocationResult(
                                    location: android.location.Location?,
                                    address: String,
                                ) {
                                    if (location != null) {
                                        val latitude = location.latitude
                                        val longitude = location.longitude
                                        callback.onResult(latitude, longitude, address)
                                    } else {
                                        callback.onResult(0.0, 0.0, "")
                                    }
                                }
                            },
                        )
                    } else {
                        callback.onResult(0.0, 0.0, "")
                    }
                }
            },
        )
    }
}
