/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.id_card.jmrtd;

import com.kyc.nashidmrz.id_card.jmrtd.BACKeySpec;
import com.kyc.nashidmrz.id_card.jmrtd.Util;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BACKey
implements BACKeySpec {
    private static final long serialVersionUID = -1059774581180524710L;
    private static final String SDF = "yyMMdd";
    private String documentNumber;
    private String dateOfBirth;
    private String dateOfExpiry;

    protected BACKey() {
    }

    public BACKey(String documentNumber, Date dateOfBirth, Date dateOfExpiry) {
        this(documentNumber, BACKey.toString(dateOfBirth), BACKey.toString(dateOfExpiry));
    }

    public BACKey(String documentNumber, String dateOfBirth, String dateOfExpiry) {
        if (documentNumber == null) {
            throw new IllegalArgumentException("Illegal document number");
        }
        if (dateOfBirth == null || dateOfBirth.length() != 6) {
            throw new IllegalArgumentException("Illegal date: " + dateOfBirth);
        }
        if (dateOfExpiry == null || dateOfExpiry.length() != 6) {
            throw new IllegalArgumentException("Illegal date: " + dateOfExpiry);
        }
        StringBuilder documentNumberBuilder = new StringBuilder(documentNumber);
        while (documentNumberBuilder.length() < 9) {
            documentNumberBuilder.append('<');
        }
        this.documentNumber = documentNumberBuilder.toString().trim();
        this.dateOfBirth = dateOfBirth;
        this.dateOfExpiry = dateOfExpiry;
    }

    @Override
    public String getDocumentNumber() {
        return this.documentNumber;
    }

    @Override
    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    @Override
    public String getDateOfExpiry() {
        return this.dateOfExpiry;
    }

    public String toString() {
        return this.documentNumber + ", " + this.dateOfBirth + ", " + this.dateOfExpiry;
    }

    public int hashCode() {
        int result2 = 5;
        result2 = 61 * result2 + (this.documentNumber == null ? 0 : this.documentNumber.hashCode());
        result2 = 61 * result2 + (this.dateOfBirth == null ? 0 : this.dateOfBirth.hashCode());
        result2 = 61 * result2 + (this.dateOfExpiry == null ? 0 : this.dateOfExpiry.hashCode());
        return result2;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        if (o == this) {
            return true;
        }
        BACKey previous = (BACKey)o;
        return this.documentNumber.equals(previous.documentNumber) && this.dateOfBirth.equals(previous.dateOfBirth) && this.dateOfExpiry.equals(previous.dateOfExpiry);
    }

    @Override
    public String getAlgorithm() {
        return "BAC";
    }

    @Override
    public byte[] getKey() {
        try {
            return Util.computeKeySeed(this.documentNumber, this.dateOfBirth, this.dateOfExpiry, "SHA-1", true);
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalArgumentException("Unexpected exception", gse);
        }
    }

    protected void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    protected void setDateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    protected void setDateOfExpiry(String dateOfExpiry) {
        this.dateOfExpiry = dateOfExpiry;
    }

    private static synchronized String toString(Date date) {
        return new SimpleDateFormat(SDF).format(date);
    }
}

