/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.id_card.jmrtd;

import com.kyc.nashidmrz.id_card.jmrtd.AccessKeySpec;
import com.kyc.nashidmrz.id_card.jmrtd.BACKeySpec;
import com.kyc.nashidmrz.id_card.jmrtd.Util;
import com.kyc.nashidmrz.id_card.jmrtd.protocol.PACEProtocol;
import java.security.GeneralSecurityException;

public class PACEKeySpec
implements AccessKeySpec {
    private static final long serialVersionUID = -7113246293247012560L;
    private final byte[] key;
    private final byte keyReference;

    public PACEKeySpec(String key, byte keyReference) {
        this(Util.getBytes(key), keyReference);
    }

    public PACEKeySpec(byte[] key, byte keyReference) {
        this.keyReference = keyReference;
        this.key = key;
    }

    public static PACEKeySpec createMRZKey(BACKeySpec mrz) throws GeneralSecurityException {
        return new PACEKeySpec(PACEProtocol.computeKeySeedForPACE(mrz), 1);
    }

    public static PACEKeySpec createCANKey(String can) {
        return new PACEKeySpec(can, 2);
    }

    public static PACEKeySpec createPINKey(String pin) {
        return new PACEKeySpec(pin, 3);
    }

    public static PACEKeySpec createPUKKey(String puk) {
        return new PACEKeySpec(puk, 4);
    }

    @Override
    public String getAlgorithm() {
        return "PACE";
    }

    public byte getKeyReference() {
        return this.keyReference;
    }

    @Override
    public byte[] getKey() {
        return this.key;
    }
}

