/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.id_card.jmrtd.cert;

import com.kyc.nashidmrz.id_card.jmrtd.cert.CVCAuthorizationTemplate;
import com.kyc.nashidmrz.id_card.jmrtd.cert.CVCPrincipal;
import com.kyc.nashidmrz.id_card.jmrtd.cert.CardVerifiableCertificate;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Date;
import org.ejbca.cvc.AccessRightEnum;
import org.ejbca.cvc.AuthorizationRoleEnum;
import org.ejbca.cvc.CAReferenceField;
import org.ejbca.cvc.CertificateGenerator;
import org.ejbca.cvc.HolderReferenceField;
import org.ejbca.cvc.exception.ConstructionException;

public class CVCertificateBuilder {
    private CVCertificateBuilder() {
    }

    public static CardVerifiableCertificate createCertificate(PublicKey publicKey, PrivateKey signerKey, String algorithmName, CVCPrincipal caRef, CVCPrincipal holderRef, CVCAuthorizationTemplate authZTemplate, Date validFrom, Date validTo, String provider) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException, ConstructionException {
        return new CardVerifiableCertificate(CertificateGenerator.createCertificate((PublicKey)publicKey, (PrivateKey)signerKey, (String)algorithmName, (CAReferenceField)new CAReferenceField(caRef.getCountry().toAlpha2Code(), caRef.getMnemonic(), caRef.getSeqNumber()), (HolderReferenceField)new HolderReferenceField(holderRef.getCountry().toAlpha2Code(), holderRef.getMnemonic(), holderRef.getSeqNumber()), (AuthorizationRoleEnum)CVCertificateBuilder.getRole(authZTemplate.getRole()), (AccessRightEnum)CVCertificateBuilder.getAccessRight(authZTemplate.getAccessRight()), (Date)validFrom, (Date)validTo, (String)provider));
    }

    private static AuthorizationRoleEnum getRole(CVCAuthorizationTemplate.Role role) {
        switch (role) {
            case CVCA: {
                return AuthorizationRoleEnum.CVCA;
            }
            case DV_D: {
                return AuthorizationRoleEnum.DV_D;
            }
            case DV_F: {
                return AuthorizationRoleEnum.DV_F;
            }
            case IS: {
                return AuthorizationRoleEnum.IS;
            }
        }
        throw new NumberFormatException("Cannot decode role " + (Object)((Object)role));
    }

    private static AccessRightEnum getAccessRight(CVCAuthorizationTemplate.Permission accessRight) {
        switch (accessRight) {
            case READ_ACCESS_NONE: {
                return AccessRightEnum.READ_ACCESS_NONE;
            }
            case READ_ACCESS_DG3: {
                return AccessRightEnum.READ_ACCESS_DG3;
            }
            case READ_ACCESS_DG4: {
                return AccessRightEnum.READ_ACCESS_DG4;
            }
            case READ_ACCESS_DG3_AND_DG4: {
                return AccessRightEnum.READ_ACCESS_DG3_AND_DG4;
            }
        }
        throw new NumberFormatException("Cannot decode access right " + (Object)((Object)accessRight));
    }
}

