/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.id_card.jmrtd.lds;

import com.kyc.nashidmrz.id_card.jmrtd.lds.SecurityInfo;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DLSequence;

public class ActiveAuthenticationInfo
extends SecurityInfo {
    private static final long serialVersionUID = 6830847342039845308L;
    public static final int VERSION_1 = 1;
    public static final String ECDSA_PLAIN_SIGNATURES = "0.4.0.127.0.7.1.1.4.1";
    public static final String ECDSA_PLAIN_SHA1_OID = "0.4.0.127.0.7.1.1.4.1.1";
    public static final String ECDSA_PLAIN_SHA224_OID = "0.4.0.127.0.7.1.1.4.1.2";
    public static final String ECDSA_PLAIN_SHA256_OID = "0.4.0.127.0.7.1.1.4.1.3";
    public static final String ECDSA_PLAIN_SHA384_OID = "0.4.0.127.0.7.1.1.4.1.4";
    public static final String ECDSA_PLAIN_SHA512_OID = "0.4.0.127.0.7.1.1.4.1.5";
    public static final String ECDSA_PLAIN_RIPEMD160_OID = "0.4.0.127.0.7.1.1.4.1.6";
    private final String oid;
    private final int version;
    private final String signatureAlgorithmOID;

    ActiveAuthenticationInfo(String oid, int version, String signatureAlgorithmOID) {
        this.oid = oid;
        this.version = version;
        this.signatureAlgorithmOID = signatureAlgorithmOID;
        this.checkFields();
    }

    public ActiveAuthenticationInfo(String signatureAlgorithmOID) {
        this("2.23.136.1.1.5", 1, signatureAlgorithmOID);
    }

    @Override
    @Deprecated
    public ASN1Primitive getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1ObjectIdentifier(this.oid));
        v.add((ASN1Encodable)new ASN1Integer((long)this.version));
        if (this.signatureAlgorithmOID != null) {
            v.add((ASN1Encodable)new ASN1ObjectIdentifier(this.signatureAlgorithmOID));
        }
        return new DLSequence(v);
    }

    @Override
    public String getObjectIdentifier() {
        return this.oid;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public String getProtocolOIDString() {
        return this.toProtocolOIDString(this.oid);
    }

    public String getSignatureAlgorithmOID() {
        return this.signatureAlgorithmOID;
    }

    public String toString() {
        String result2 = "ActiveAuthenticationInfo [protocol: " + this.toProtocolOIDString(this.oid) + ", version: " + this.version + ", signatureAlgorithmOID: " + ActiveAuthenticationInfo.toSignatureAlgorithmOIDString(this.getSignatureAlgorithmOID()) + "]";
        return result2;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!ActiveAuthenticationInfo.class.equals(other.getClass())) {
            return false;
        }
        ActiveAuthenticationInfo otherActiveAuthenticationInfo = (ActiveAuthenticationInfo)other;
        return this.getDERObject().equals(otherActiveAuthenticationInfo.getDERObject());
    }

    public int hashCode() {
        return 12345 + 3 * (this.oid == null ? 0 : this.oid.hashCode()) + 5 * this.version + 11 * (this.signatureAlgorithmOID == null ? 1 : this.signatureAlgorithmOID.hashCode());
    }

    public static String lookupMnemonicByOID(String oid) throws NoSuchAlgorithmException {
        if (ECDSA_PLAIN_SHA1_OID.equals(oid)) {
            return "SHA1withECDSA";
        }
        if (ECDSA_PLAIN_SHA224_OID.equals(oid)) {
            return "SHA224withECDSA";
        }
        if (ECDSA_PLAIN_SHA256_OID.equals(oid)) {
            return "SHA256withECDSA";
        }
        if (ECDSA_PLAIN_SHA384_OID.equals(oid)) {
            return "SHA384withECDSA";
        }
        if (ECDSA_PLAIN_SHA512_OID.equals(oid)) {
            return "SHA512withECDSA";
        }
        if (ECDSA_PLAIN_RIPEMD160_OID.equals(oid)) {
            return "RIPEMD160withECDSA";
        }
        throw new NoSuchAlgorithmException("Unknown OID " + oid);
    }

    static boolean checkRequiredIdentifier(String id2) {
        return "2.23.136.1.1.5".equals(id2);
    }

    private void checkFields() {
        try {
            if (!ActiveAuthenticationInfo.checkRequiredIdentifier(this.oid)) {
                throw new IllegalArgumentException("Wrong identifier: " + this.oid);
            }
            if (this.version != 1) {
                throw new IllegalArgumentException("Wrong version: " + this.version);
            }
            if (!(ECDSA_PLAIN_SHA1_OID.equals(this.signatureAlgorithmOID) || ECDSA_PLAIN_SHA224_OID.equals(this.signatureAlgorithmOID) || ECDSA_PLAIN_SHA256_OID.equals(this.signatureAlgorithmOID) || ECDSA_PLAIN_SHA384_OID.equals(this.signatureAlgorithmOID) || ECDSA_PLAIN_SHA512_OID.equals(this.signatureAlgorithmOID) || ECDSA_PLAIN_RIPEMD160_OID.equals(this.signatureAlgorithmOID))) {
                throw new IllegalArgumentException("Wrong signature algorithm OID: " + this.signatureAlgorithmOID);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Malformed ActiveAuthenticationInfo", e);
        }
    }

    private String toProtocolOIDString(String oid) {
        if ("2.23.136.1.1.5".equals(oid)) {
            return "id-AA";
        }
        return oid;
    }

    public static String toSignatureAlgorithmOIDString(String oid) {
        if (ECDSA_PLAIN_SHA1_OID.equals(oid)) {
            return "ecdsa-plain-SHA224";
        }
        if (ECDSA_PLAIN_SHA224_OID.equals(oid)) {
            return "ecdsa-plain-SHA224";
        }
        if (ECDSA_PLAIN_SHA256_OID.equals(oid)) {
            return "ecdsa-plain-SHA256";
        }
        if (ECDSA_PLAIN_SHA384_OID.equals(oid)) {
            return "ecdsa-plain-SHA384";
        }
        if (ECDSA_PLAIN_SHA512_OID.equals(oid)) {
            return "ecdsa-plain-SHA512";
        }
        if (ECDSA_PLAIN_RIPEMD160_OID.equals(oid)) {
            return "ecdsa-plain-RIPEMD160";
        }
        return oid;
    }
}

